package cn.gtmap.realestate.supervise.server.sftp;

import cn.gtmap.realestate.supervise.server.entity.SftpClientInfo;
import cn.gtmap.realestate.supervise.server.utils.XmlUtil;
import com.gtis.config.AppConfig;
import com.jcraft.jsch.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjain</a>
 * @version 1.0, 2017/7/21
 * @description sftp服务
 */
@Service
public class SftpService {

    private static final Logger LOGGER = LoggerFactory.getLogger(SftpService.class);

    private static long sleep = 3;

    private static int maxCount = 2;

    private static List<SftpClientInfo> sftps = new ArrayList<>();

    private static SftpClientInfo sftpProvice = new SftpClientInfo();

    //文件及文件夹
    public static final String FILTER_FILE_ALL = "ALL";
    //文件
    public static final String FILTER_FILE_FILE = "FILE";
    //文件夹
    public static final String FILTER_FILE_DIR = "DIR";


    static {
        String countString = AppConfig.getProperty("supervise.maxCount");
        if (countString != null) {
            maxCount = Integer.valueOf(countString);
        }
        String sleepString = AppConfig.getProperty("supervise.sleep");
        if (sleepString != null) {
            sleep = Integer.valueOf(sleepString);
        }
        Map<String, String> properties = AppConfig.getProperties();
        Iterator<String> keys = properties.keySet().iterator();
        int sftpNumber = 0;
        while (keys.hasNext()) {
            String key = keys.next();
            if (key.contains("supervise.sftp.info.sftpid")) {
                int startNumber = key.indexOf('[');
                int endNumber = key.indexOf(']');
                int number = Integer.parseInt(key.substring(startNumber + 1, endNumber));
                if (number > sftpNumber) {
                    sftpNumber = number;
                }
            }
        }

        //报省sftp信息-------begin---
        String sftpProviceIp = AppConfig.getProperty("supersive.sftp.province.info.ip");
        String sftpProviceUsername = AppConfig.getProperty("supervise.sftp.province.info.username");
        String sftpProvicePassword = AppConfig.getProperty("supersive.sftp.province.info.password");
        String sftpProvicePort = AppConfig.getProperty("supersive.sftp.province.info.port");
        String sftpProviceMessagePath = AppConfig.getProperty("supersive.sftp.province.info.messagePath");
        String sftpProviceReceiveMessagePath = AppConfig.getProperty("supersive.sftp.province.info.receiveMessagePath");
        sftpProvice.setIp(sftpProviceIp);
        sftpProvice.setUserName(sftpProviceUsername);
        sftpProvice.setPassWord(sftpProvicePassword);
        sftpProvice.setPort(Integer.parseInt(sftpProvicePort));
        sftpProvice.setMessagePath(sftpProviceMessagePath);
        sftpProvice.setReciveMessagePath(sftpProviceReceiveMessagePath);
        //报省sftp信息-------end---


        for (int i = 0; i <= sftpNumber; i++) {
            SftpClientInfo sftpClientInfo = new SftpClientInfo();
            String userName = properties.get("supervise.sftp.info.username[" + i + "]");
            String ip = properties.get("supersive.sftp.info.ip[" + i + "]");
            String messagePath = properties.get("supersive.sftp.info.messagePath[" + i + "]");
            String receivedMessagePath = properties.get("supersive.sftp.info.receiveMessagePath[" + i + "]");
            int port = Integer.parseInt(properties.get("supersive.sftp.info.port[" + i + "]"));
            String password = properties.get("supersive.sftp.info.password[" + i + "]");
            if (ip == null || port == 0 || password == null) {
                continue;
            }
            sftpClientInfo.setUserName(userName);
            sftpClientInfo.setIp(ip);
            sftpClientInfo.setPort(port);
            sftpClientInfo.setPassWord(password);
            sftpClientInfo.setMessagePath(messagePath);
            sftpClientInfo.setReciveMessagePath(receivedMessagePath);
            sftps.add(sftpClientInfo);
        }
    }

    /**
     * 获取SFTP信息
     *
     * @param client
     * @return
     * @throws JSchException
     */
    private Session getSftpSession(SftpClientInfo client) throws Exception {
        Session session = null;
        int port = client.getPort();
        JSch jsch = new JSch();
        String userName = client.getUserName();
        String ip = client.getIp();
        String passphrase = client.getPassWord();
        try {
            if (port <= 0) {
                session = jsch.getSession(userName, ip);
            } else {
                session = jsch.getSession(userName, ip, port);
            }
            if (session == null) {
                LOGGER.info("getSftpSession.session is null,ip:{},port:{},userName:{},password:{}", ip, port, userName, passphrase);
            } else {
                java.util.Properties config = new java.util.Properties();
                config.put("StrictHostKeyChecking", "no");
                session.setConfig(config);
                session.setPassword(passphrase);
                session.connect(3000);//30000
            }

        } catch (Exception e) {
            LOGGER.error("getSftpSession.JSchException!{}", e);
            if (port <= 0) {
                session = jsch.getSession(userName, ip);
            } else {
                session = jsch.getSession(userName, ip, port);
            }
            if (session == null) {
                LOGGER.error("getSftpSession-session is null!");
            } else {
                java.util.Properties config = new java.util.Properties();
                config.put("StrictHostKeyChecking", "no");
                session.setConfig(config);
                session.setPassword(passphrase);
                session.connect(3000);
            }
        }
        return session;
    }


    /**
     * 获取某个文件
     *
     * @param fileName
     * @return
     * @throws InterruptedException
     * @throws SftpException
     * @throws IOException
     * @throws JSchException
     */
    public String sshSftp2RecFile(String fileName) throws Exception {
        LOGGER.info("sftp获取报部响应报文开始,报文名称:{}", fileName);
        String xml = null;
        for (SftpClientInfo client : sftps) {
            Channel channel = null;
            Session session = getSftpSession(client);
            String dst = client.getReciveMessagePath();
            InputStream inputStream = null;
            try {
                if (null == session) {
                    continue;
                }
                channel = session.openChannel("sftp");
                channel.connect(3000);
                ChannelSftp sftp = (ChannelSftp) channel;
                sftp.cd(dst);
                String respFileName = fileName.replace("Biz", "Rep");
                for (int count = 0; count < maxCount; count++) {
                    try {
                        String filePath = dst + "/" + respFileName;
                        LOGGER.info("获取部里面的响应报文路径:{}", filePath);
                        inputStream = sftp.get(dst + "/" + respFileName);
                    } catch (SftpException e) {
                        LOGGER.error("获取报部响应报文信息异常 SftpException，异常信息:{},响应报文名称:{}", e, respFileName);
                        try {
                            Thread.sleep(1000 * sleep);
                        } catch (Exception e1) {
                            LOGGER.error("获取报部响应报文信息异常 InterruptedException1，异常信息:{},响应报文名称:{}", e1, respFileName);
                        }
                        continue;
                    }
                    if (inputStream != null) {
                        xml = XmlUtil.convertStreamToString(inputStream);
                    }
                    if (inputStream == null) {
                        try {
                            Thread.sleep(1000 * sleep);
                        } catch (Exception e) {
                            LOGGER.error("获取报部响应报文信息异常 InterruptedException2，异常信息:{},响应报文名称:{}", e, respFileName);
                        }
                        continue;
                    }
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            } catch (JSchException e) {
                LOGGER.error("获取报部响应报文信息异常 InterruptedException2，异常信息:{},报文名称:{}", e, fileName);
            } finally {
                if (null != session) {
                    session.disconnect();
                }
                if (null != channel) {
                    channel.disconnect();
                }
            }
        }
        LOGGER.info("sftp获取报部响应报文结束,报文名称:{}，响应信息:{}", fileName, xml);
        return xml;
    }


    /**
     * 上报文件
     *
     * @param fileName
     * @param content
     * @return
     * @throws SftpException
     * @throws IOException
     * @throws JSchException
     */
    public boolean sftpUploadXmlFile(String fileName, String content){

        boolean resFlag = true;
        for (SftpClientInfo client : sftps) {
            LOGGER.info("sftp推送开始,报文名称:{}", fileName);
            Channel channel = null;
            OutputStream outstream = null;
            InputStream instream = null;
            Session session = null;
            try {
                session = getSftpSession(client);
                String dst = client.getMessagePath();
                if (null == session) {
                    continue;
                }
                channel = session.openChannel("sftp");
                channel.connect(2000);
                ChannelSftp sftp = (ChannelSftp) channel;
                sftp.cd(dst);
                outstream = sftp.put(dst + fileName + ".tmp");
                instream = new ByteArrayInputStream(content.getBytes("UTF-8"));
                byte b[] = new byte[1024];
                int n;
                while ((n = instream.read(b)) != -1) {
                    outstream.write(b, 0, n);
                }
                outstream.flush();
                outstream.close();
                instream.close();
                sftp.rename(dst + fileName + ".tmp", dst + fileName);
            } catch (Exception e) {
                LOGGER.error("SftpService.sftpUploadFile.JSchException error in!{},fileName:{}", e, fileName);
                resFlag = false;
                return resFlag;
            } finally {
                try {
                    if (null != outstream) {
                        outstream.close();
                    }
                    if (null != instream) {
                        instream.close();
                    }
                    if (null != session) {
                        session.disconnect();
                    }
                    if (null != channel) {
                        channel.disconnect();
                    }
                } catch (IOException e) {
                    LOGGER.error("SftpService.sftpUploadFile.IOException error in!{},fileName:{}", e, fileName);
                    resFlag = false;
                }
            }
            LOGGER.info("sftp推送上报结束，文件名称:{}", fileName);
        }
        return resFlag;
    }


    /**
     * 获取失败报文信息
     *
     * @param filePath
     * @return
     * @throws JSchException
     */
    public String[] sftpReciveFileNames(String filePath) throws Exception {
        String[] files = null;
        for (SftpClientInfo client : sftps) {
            Channel channel = null;
            Session session = getSftpSession(client);
            try {
                if (null == session) {
                    continue;
                }
                channel = session.openChannel("sftp");
                channel.connect(3000);
                ChannelSftp channelSftp = (ChannelSftp) channel;
                files = lsFiles(channelSftp, filePath, FILTER_FILE_FILE);
            } catch (JSchException e) {
                LOGGER.error("SftpService.sftpUploadFile.JSchException error in!{},filePath:{}", e, filePath);
            } finally {
                if (null != session) {
                    session.disconnect();
                }
                if (null != channel) {
                    channel.disconnect();
                }
            }
        }

        return files;
    }

    /**
     * 获取文件夹下面所有文件名字
     *
     * @param channelSftp
     * @param path
     * @param type
     * @return
     */
    private static String[] lsFiles(ChannelSftp channelSftp, String path, String type) {
        List<ChannelSftp.LsEntry> list = null;
        List<String> resultList = new ArrayList<>();
        try {
            //ls方法会返回两个特殊的目录，当前目录(.)和父目录(..)
            list = channelSftp.ls(path);
            for (ChannelSftp.LsEntry entry : list) {
                if (filter(entry, type)) {
                    resultList.add(entry.getFilename());
                }
            }
        } catch (SftpException e) {
            LOGGER.error("SftpException can not list directory!:{}", e);
            return new String[0];
        }
        return resultList.toArray(new String[0]);
    }

    /**
     * 判断是否是否过滤条件
     *
     * @param entry LsEntry
     * @param type  过滤参数
     * @return boolean
     */
    private static boolean filter(ChannelSftp.LsEntry entry, String type) {
        if (type.equals(FILTER_FILE_ALL)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..");
        } else if (type.equals(FILTER_FILE_FILE)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..") && !entry.getAttrs().isDir();
        } else if (type.equals(FILTER_FILE_DIR)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..") && entry.getAttrs().isDir();
        }
        return false;
    }


    /**
     * 获取某个文件内容
     *
     * @param fileName
     * @param filePath
     * @return
     * @throws JSchException
     */
    public String sftpReciveFileContent(String fileName, String filePath) throws Exception {
        LOGGER.info("sftp获取响应报文开始，文件名称:{},路径:{}", fileName, filePath);
        String xml = null;
        String filePathStr = "";
        InputStream inputStream = null;
        for (SftpClientInfo client : sftps) {
            Channel channel = null;
            Session session = getSftpSession(client);
            try {
                if (null == session) {
                    continue;
                }
                channel = session.openChannel("sftp");
                channel.connect(3000);//10000
                ChannelSftp sftp = (ChannelSftp) channel;
                sftp.cd(filePath);
                filePathStr = filePath + "/" + fileName;
                inputStream = sftp.get(filePathStr);
                sftp.rm(filePathStr);
                if (inputStream != null) {
                    xml = XmlUtil.convertStreamToString(inputStream);
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            } catch (Exception e) {
                LOGGER.error("sshSftp2RecFile.Exception session is null!{}", e);
            } finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    } catch (IOException e) {
                        LOGGER.error("sshSftp2RecFile.IOException!{}", e);
                    }
                }
                if (null != session) {
                    session.disconnect();
                }
                if (null != channel) {
                    channel.disconnect();
                }
            }
        }
        LOGGER.info("sftp获取响应报文结束,响应信息:{}", xml);
        return xml;
    }


    /**
     * 上报文件
     *
     * @param fileName
     * @param content
     * @return
     * @throws SftpException
     * @throws IOException
     * @throws JSchException
     */
    public boolean uploadProvinceSftpXml(String fileName, String content) throws Exception {
        LOGGER.info("sftp推送报省开始,报文名称:{}", fileName);
        boolean resFlag = true;
        Channel channel = null;
        Session session = getSftpSession(sftpProvice);
        String dst = sftpProvice.getMessagePath();
        OutputStream outstream = null;
        InputStream instream = null;
        try {
            if (null != session) {

                channel = session.openChannel("sftp");
                channel.connect(2000);
                ChannelSftp sftp = (ChannelSftp) channel;
                sftp.cd(dst);
                outstream = sftp.put(dst + fileName + ".tmp");
                instream = new ByteArrayInputStream(content.getBytes("UTF-8"));
                byte b[] = new byte[1024];
                int n;
                while ((n = instream.read(b)) != -1) {
                    outstream.write(b, 0, n);
                }
                outstream.flush();
                outstream.close();
                instream.close();
                sftp.rename(dst + fileName + ".tmp", dst + fileName);
            }
        } catch (JSchException e) {
            LOGGER.error("SftpService.uploadProvinceSftpXml.JSchException error in!{},fileName:{}", e, fileName);
            resFlag = false;
        } finally {
            if (null != instream) {
                instream.close();
            }
            if (null != outstream) {
                outstream.close();
            }
            if (null != session) {
                session.disconnect();
            }
            if (null != channel) {
                channel.disconnect();
            }
        }
        LOGGER.info("上报省结束，文件名称:{}", fileName);
        return resFlag;
    }

}
