package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.common.SystemLogService;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaRzjlMapper;
import cn.gtmap.realestate.supervise.server.entity.Count;
import cn.gtmap.realestate.supervise.server.entity.Error;
import cn.gtmap.realestate.supervise.server.entity.ErrorDetail;
import cn.gtmap.realestate.supervise.server.entity.Zlbg;
import cn.gtmap.realestate.supervise.server.service.ZlbgService;
import cn.gtmap.realestate.supervise.server.utils.ExportExcelUtils;
import cn.gtmap.realestate.supervise.utils.OperationalLogUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/10
 * @description 质量报告接口实现类
 */
@Service
public class ZlbgServiceImpl  implements ZlbgService {

    @Autowired
    private BaRzjlMapper baRzjlMapper;

    @Override
    public List<Count> getCountByJRDM(Map<String, Object> map) {
       List<Count> countList =  baRzjlMapper.getCountByJRDM(map);
        return countList;
    }

    @Override
    public List<Error> getCountErrorByJRDM(Map<String, Object> map) {

        List<Error> errorList =  baRzjlMapper.getCountErrorByJRDM(map);
        return errorList;
    }

    @Override
    public List<ErrorDetail> getCountErrorDetailByJRDM(Map<String, Object> map) {
        List<ErrorDetail> errorDetailList = baRzjlMapper.getCountErrorDetailByJRDM(map);
        return errorDetailList;
    }

  /**
     * 导出excel
     * @param param
     * @param response
     * @param userInfos
     */
    @Override
    @SystemLogService(description = "质量报告导出", czlx = "质量报告导出")
    public void export(Map<String, Object> param, HttpServletResponse response, HttpServletRequest request, UserAuthDTO userInfos) {
        List<Count> counts = getCountByJRDM(param);
        List<Error> errors = getCountErrorByJRDM(param);
        List<ErrorDetail> errorDetails = getCountErrorDetailByJRDM(param);
        List<Zlbg> countList = new ArrayList<>();
        int sn = 0;//序号
        for (Count count : counts) {
            Zlbg tempCount = new Zlbg();
            tempCount.setXh(++sn);
            tempCount.setYwbm(count.getYwbm());
            tempCount.setYwmc(count.getYwmc());
            String zsl = count.getZsl();
            String cgsl = count.getCgsl();
            double tempCgl = Double.valueOf(Double.parseDouble(cgsl) / Double.parseDouble(zsl)) * 100;
            String cgl = String.format("%.2f", tempCgl);
            tempCount.setZsl(zsl);
            tempCount.setCgsl(cgsl);
            tempCount.setCgl(cgl + "%");
            tempCount.setQxdmmc(count.getQxdmmc());
            countList.add(tempCount);
        }
        OperationalLogUtil.log(request, "1", "质量报告导出", "接入系统");
        ExportExcelUtils.exportExcel(countList,errors,errorDetails,response);
    }

}
