package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.BaYydj;
import cn.gtmap.realestate.supervise.entity.BaYydjLs;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.impl.InsertSingleTableDaoImpl;
import cn.gtmap.realestate.supervise.server.dao.mapper.DjqlMapper;
import cn.gtmap.realestate.supervise.server.model.SimpleTableResult;
import cn.gtmap.realestate.supervise.server.service.ServeLog;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/18
 * @description 异议登记
 */
@Service
public class YydjAbstractServe extends AbstractServeDetail {

    private static final Logger LOGGER = LoggerFactory.getLogger(YydjAbstractServe.class);

    @Autowired
    InsertSingleTableDaoImpl insertSingleTableDao;

    @Autowired
    EntityMapper entityMapper;

    @Autowired
    LogServiceImpl logService;

    @Autowired
    CheckRepeatService checkRepeatService;

    @Autowired
    DjqlMapper djqlMapper;


    @Override
    @Transactional
    public ServeLog serveDetail(FileMessage fileMessage) {

        SimpleTableResult simpleTableResult = new SimpleTableResult();


        try {
            init(fileMessage);
//            List<Object> objects = getList(content, recType, fileMessage.getFileName(), areaCode, bdcdyh);
            boolean flagTemp = false;
            //异议登记
            for (int i = 0; i < objects.size(); i++) {
                Object obj = objects.get(i);
                if (obj instanceof BaYydj && !flagTemp) {
                    flagTemp = true;
                    String qszt = ((BaYydj) obj).getQszt();
                    //新增
                    if (StringUtils.isNotBlank(qszt) && Constant.QSZT1.equals(qszt) || StringUtils.isNotBlank(qszt) && Constant.QSZT0.equals(qszt)) {
                        simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                    }
                    //注销
                    if (StringUtils.isNotBlank(qszt) && !Constant.QSZT1.equals(qszt) && !Constant.QSZT0.equals(qszt)) {
                        //注销上一手
                        String zxyyywh = ((BaYydj) obj).getZxyyywh();
                        String ywh = ((BaYydj) obj).getYwh();
                        Map<String, Object> param = new HashMap<>();
                        param.put("ywh", ywh);
                        ExampleUtil example = new ExampleUtil(BaYydj.class, param);
                        List<BaYydj> yydjList = entityMapper.selectByExample(example);
                        //用 bdcdyh 和 bdcqzh查询记录
                        if (null != yydjList && !yydjList.isEmpty()) {
                            String dbr = ((BaYydj) obj).getZxyydbr();
                            String zxyyyy = ((BaYydj) obj).getZxyyyy();
                            Date djsj = ((BaYydj) obj).getDjsj();
                            String fj = ((BaYydj) obj).getFj();
                            BaYydj baYydj = yydjList.get(0);
                            checkRepeatService.copySingleData(baYydj,BaYydjLs.class);//入历史库
                            baYydj.setQszt(Constant.QSZT2);
                            baYydj.setZxyyywh(zxyyywh);
                            baYydj.setZxyydbr(dbr);
                            baYydj.setZxyyyy(zxyyyy);
                            baYydj.setZxyydjsj(djsj);
                            baYydj.setFj(fj);
                            baYydj.setSjgxsj(new Date());
                            entityMapper.updateByPrimaryKeySelective(baYydj);
                            objects.remove(obj);
                            simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                        } else {
                            simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                            String flag = fileMessage.getCxrkbj();
                            logService.insertLog("系统", flag, recType, ywh, areaCode);
                        }
                    }
                }
            }
        } catch (Exception e) {
            LOGGER.error("YydjAbstractServe.Exception!{}:", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            simpleTableResult.setResult(false);
            simpleTableResult.setResultInfo(e.getCause().toString());
            super.getServeLog().setError(e.getCause().toString());
            return super.getServeLog();
        }
        simpleTableResult.setResult(true);
        return super.getServeLog();
    }
}
