package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.BaYgdj;
import cn.gtmap.realestate.supervise.entity.BaYgdjLs;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.common.impl.ObjectServiceImpl;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.impl.InsertSingleTableDaoImpl;
import cn.gtmap.realestate.supervise.server.dao.mapper.DjqlMapper;
import cn.gtmap.realestate.supervise.server.model.SimpleTableResult;
import cn.gtmap.realestate.supervise.server.service.ServeLog;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/18
 * @description 预告登记
 */
@Service
public class YgdjAbstractServe extends AbstractServeDetail {

    private static final Logger LOGGER = LoggerFactory.getLogger(YgdjAbstractServe.class);

    @Autowired
    EntityMapper entityMapper;

    @Autowired
    InsertSingleTableDaoImpl insertSingleTableDao;

    @Autowired
    LogServiceImpl logService;

    @Autowired
    ObjectServiceImpl objectService;

    @Autowired
    CheckRepeatService checkRepeatService;

    @Autowired
    DjqlMapper djqlMapper;

    @Override
    @Transactional
    public ServeLog serveDetail(FileMessage fileMessage) {

        SimpleTableResult result = new SimpleTableResult();

        try {
            init(fileMessage);
//            List<Object> objects = getList(content, recType, fileMessage.getFileName(), areaCode, bdcdyh);
            String flag = fileMessage.getCxrkbj();
            boolean flagTemp = false;
            //预告登记
            for (int i = 0; i < objects.size(); i++) {
                Object obj = objects.get(i);
                if (obj instanceof BaYgdj && !flagTemp) {
                    flagTemp = true;
                    String qszt = ((BaYgdj) obj).getQszt();
                    if (StringUtils.isNotBlank(qszt) && StringUtils.equals(Constant.QSZT0, qszt)) {
                        result = insertSingleTableDao.insertSingleTable(objects);
                    }
                    if (!qszt.isEmpty() && Constant.QSZT1.equals(qszt)) {
                        result = insertSingleTableDao.insertSingleTable(objects);
                        String scywh = ((BaYgdj) obj).getSsywh();
                        String ywh = ((BaYgdj) obj).getYwh();
                        String qxdm = ((BaYgdj) obj).getQxdm();
                        String scywhStr = qxdm + "_" + "0";
                        if (null != scywh && !scywh.isEmpty() && !scywhStr.equals(scywh)) {
                            Map<String, Object> param = new HashMap<>();
                            String ygdjzl = ((BaYgdj) obj).getYgdjzl();
                            param.put("ywh", scywh);
                            param.put("ygdjzl", ygdjzl);
                            List<BaYgdj> baYgdjList = djqlMapper.getYgdjList(param);
                            if (null != baYgdjList && !baYgdjList.isEmpty()) {
                                BaYgdj baYgdj = baYgdjList.get(0);
                                String qsztStr = baYgdj.getQszt();
                                if (!StringUtils.equals(Constant.QSZT2, qsztStr)) {
                                    checkRepeatService.copySingleData(baYgdj, BaYgdjLs.class);//入历史库
                                    baYgdj.setQszt(Constant.QSZT2);
                                    baYgdj.setSjgxsj(new Date());
                                    entityMapper.updateByPrimaryKeySelective(baYgdj);
                                }
                            } else {
                                logService.insertLog("系统", flag, recType, ywh, areaCode);
                            }
                        }
                    }
                    if (!qszt.isEmpty() && Constant.QSZT2.equals(qszt)) {
                        String bdcdyh = ((BaYgdj) obj).getBdcdyh();
                        String ywh = ((BaYgdj) obj).getYwh();
                        String ygdjzl = ((BaYgdj) obj).getYgdjzl();
                        Map<String, Object> param = new HashMap<>();
                        param.put("bdcdyh", bdcdyh);
                        param.put("ygdjzl", ygdjzl);
                        param.put("ywh", ywh);
                        List<BaYgdj> baYgdjList = djqlMapper.getYgdjList(param);
                        if (null != baYgdjList && !baYgdjList.isEmpty()) {
                            String fj = ((BaYgdj) obj).getFj();
                            String zxygywh = ((BaYgdj) obj).getZxygywh();
                            String zxygyy = ((BaYgdj) obj).getZxygyy();
                            Date zxsj = ((BaYgdj) obj).getZxsj();
                            BaYgdj baYgdj = baYgdjList.get(0);
                            checkRepeatService.copySingleData(baYgdj, BaYgdjLs.class);//入历史库
                            baYgdj.setZxygywh(zxygywh);
                            baYgdj.setZxygyy(zxygyy);
                            baYgdj.setZxsj(zxsj);
                            baYgdj.setQszt(Constant.QSZT2);
                            baYgdj.setFj(fj);
                            baYgdj.setSjgxsj(new Date());
                            entityMapper.updateByPrimaryKeySelective(baYgdj);
                            objects.remove(obj);
                            result = insertSingleTableDao.insertSingleTable(objects);
                        } else {
                            result = insertSingleTableDao.insertSingleTable(objects);
                            logService.insertLog("系统", flag, recType, ywh, areaCode);
                        }
                    }
                }
            }
        } catch (Exception e) {
            LOGGER.error("YgdjAbstractServe.Exception in!{}", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            result.setResult(false);
            result.setResultInfo(e.getCause().toString());
            super.getServeLog().setError(e.getCause().toString());
            return super.getServeLog();
        }
        result.setResult(true);
        return super.getServeLog();
    }
}
