package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaRzjlMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaSftpMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaXzqhMapper;
import cn.gtmap.realestate.supervise.server.entity.Qxtjxx;
import cn.gtmap.realestate.supervise.server.service.XzqhInfoService;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.util.*;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/5/26
 * @description 行政区划查询业务类
 */
@Service
public class XzqhInfoServiceImpl implements XzqhInfoService {

    private static final Logger LOGGER = LoggerFactory.getLogger(XzqhInfoServiceImpl.class);

    @Autowired
    private BaXzqhMapper baXzqhMapper;

    @Autowired
    EntityMapper entityMapper;

    @Autowired
    BaSftpMapper baSftpMapper;


    @Autowired
    BaRzjlMapper baRzjlMapper;


    @Override
    public List<Map<String, String>> getXzqhDatas(Map<String, String> map) {
        return baXzqhMapper.getXzqhDatas(map);
    }

    @Override
    public List<Map<String, Object>> getGeocoord(Map<String, Object> param) {
        return baXzqhMapper.getGeocoord(param);
    }


    @Override
    public List<Map<String, Object>> getHztjxx(String qhmc) {
        //系统上线时间（年月日）
        String xtsxsj = AppConfig.getProperty("supersive.run.time");
        //系统地区代码
        String qhdm = AppConfig.getProperty("region.qhdm");
        Date systemRunTime = TimeUtils.strToDate(xtsxsj);//系统上线时间
        int totalDays = baRzjlMapper.getTotalDays(systemRunTime);//统计系统上线总天数
//        int totalDays = TimeUtils.differentDays(systemRunTime, new Date()) + 1;
        List<Map<String, Object>> zlInfos = baXzqhMapper.getZlInfos();
        String zlOne = "0";
        String zlTwo = "0";
        if (null != zlInfos && !zlInfos.isEmpty()) {
            for (int i = 0; i < zlInfos.size(); i++) {
                Map<String, Object> temp = zlInfos.get(i);
                String zlbm = temp.get("ZLBM").toString();
                if ("1".equals(zlbm)) {
                    zlOne = temp.get("ZLSJ").toString();
                }
                if ("2".equals(zlbm)) {
                    zlTwo = temp.get("ZLSJ").toString();
                }
            }
        }

        //查询市级信息
        List<Map<String, Object>> dsxxList = Lists.newArrayList();
        if (StringUtils.isNotBlank(qhmc)) {
            dsxxList = baXzqhMapper.getDsxxByQhmc(qhmc);
        } else {
            dsxxList = baXzqhMapper.getDsxx(qhdm);
        }


        //查询统计信息
        List<Map<String, Object>> qxtjxx = baXzqhMapper.getDqtjxx(qhmc);

        //最终输出List
        List<Map<String, Object>> resList = Lists.newArrayList();

        //省级平台数据统计、
        if (CollectionUtils.isNotEmpty(dsxxList)) {
            List<Map<String, Object>> dsxxListTemp = Lists.newArrayList();
            for (int i = 0; i < dsxxList.size(); i++) {
                int zjrl = 0;
                int dtjrl = 0;
                int cgjrl = 0;
                String zjrlStr = "0";
                String dtjrlStr = "0";
                String cgjrlStr = "0";
                Map<String, Object> temp = dsxxList.get(i);
                String dsqhdmStr = (String) temp.get("QHDM");
                boolean flag = false;
                for (int j = 0; j < qxtjxx.size(); j++) {
                    Map<String, Object> qxtjxxMap = qxtjxx.get(j);
                    String fdm = (String) qxtjxxMap.get("FDM");
                    String qxdm = (String) qxtjxxMap.get("QHDM");
                    String sjgxsj = (String) qxtjxxMap.get("SJGXSJ");
                    String nowDate = TimeUtils.dateToStr(new Date(), "yyyyMMdd");
                    if (dsqhdmStr.equals(fdm) || dsqhdmStr.equals(qxdm)) {//区县
                        flag = true;
                        if (qxtjxxMap.containsKey("ZJRL")) {
                            zjrlStr = (String) qxtjxxMap.get("ZJRL");
                        }
                        if (qxtjxxMap.containsKey("DTJRL") && StringUtils.equals(sjgxsj, nowDate)) {
                            dtjrlStr = (String) qxtjxxMap.get("DTJRL");
                        }
                        if (qxtjxxMap.containsKey("DTJRL") && !StringUtils.equals(sjgxsj, nowDate)) {
                            dtjrlStr = "0";
                        }
                        if (qxtjxxMap.containsKey("CGJRL")) {
                            cgjrlStr = (String) qxtjxxMap.get("CGJRL");
                        }
                        int tempZjrl = StringUtils.isNotBlank(zjrlStr) ? Integer.parseInt(zjrlStr) : 0;
                        int tempDtjrl = StringUtils.isNotBlank(dtjrlStr) ? Integer.parseInt(dtjrlStr) : 0;
                        int tempCgjrl = StringUtils.isNotBlank(cgjrlStr) ? Integer.parseInt(cgjrlStr) : 0;
                        zjrl = zjrl + tempZjrl;
                        dtjrl = dtjrl + tempDtjrl;
                        cgjrl = cgjrl + tempCgjrl;
                    }
                }
                if (flag) {
                    if (zjrl != 0) {
                        DecimalFormat df = new DecimalFormat("0.00");//格式化小数
                        String num = df.format((double) cgjrl / zjrl);//返回的是String类型
                        int avgData = (int) Math.floor((double) zjrl / totalDays);
                        int ztzl = (int) Math.floor(Double.parseDouble(num) * 100);
                        temp.put("PJJRL", avgData >= 1 ? String.valueOf(avgData) : "1");//平均接入量
                        temp.put("ZTZL", ztzl >= 1 ? ztzl : 1);//总体质量
                        temp.put("ZJRL", String.valueOf(zjrl));//总接入量
                        temp.put("DTJRL", String.valueOf(dtjrl));//当天接入量
                    }
                    dsxxListTemp.add(temp);
                }
            }

            //排序
            if (CollectionUtils.isNotEmpty(dsxxListTemp)) {
                for (int i = 0; i < dsxxListTemp.size(); i++) {
                    Map<String, Object> temp = dsxxListTemp.get(i);
                    String qhdmStr = (String) temp.get("QHDM");
                    resList.add(temp);
                    for (int j = 0; j < qxtjxx.size(); j++) {
                        Map<String, Object> qxtjxxMap = qxtjxx.get(j);
                        String fdm = (String) qxtjxxMap.get("FDM");
                        String sjgxsj = (String) qxtjxxMap.get("SJGXSJ");
                        String nowDate = TimeUtils.dateToStr(new Date(), "yyyyMMdd");
                        if (qhdmStr.equals(fdm)) {
                            String dtjrlStr = "";
                            if (qxtjxxMap.containsKey("DTJRL") && StringUtils.equals(sjgxsj, nowDate)) {
                                dtjrlStr = (String) qxtjxxMap.get("DTJRL");
                            }
                            String tempDtjrl = StringUtils.isNotBlank(dtjrlStr) ? dtjrlStr : "0";
                            qxtjxxMap.put("DTJRL", tempDtjrl);
                            resList.add(qxtjxxMap);
                        }
                    }
                }
                Map<String, Object> firstMap = dataHandle(qxtjxx, totalDays, zlOne, zlTwo, qhdm, qhmc);
                if (CollectionUtils.isNotEmpty(resList)) {
                    Map<String, Object> first = resList.get(0);
                    first.put("ALLPJJRL", firstMap.get("ALLPJJRL"));
                    first.put("ALLZTZL", firstMap.get("ALLZTZL"));
                    first.put("ALLZJRL", firstMap.get("ALLZJRL"));
                    first.put("ALLDTJRL", firstMap.get("ALLDTJRL"));
                    first.put("ONE", zlOne);
                    first.put("TWO", zlTwo);
                    first.put("QHDM", qhdm);//系统平台代码
                }
                return resList;
            }
        }

        //市级平台统计总体数据
        dataHandle(qxtjxx, totalDays, zlOne, zlTwo, qhdm, qhmc);
        return qxtjxx;
    }

    /**
     * @param qxtjxx
     * @param totalDays
     * @param zlOne
     * @param zlTwo
     * @param qhdm
     * @return
     */
    public Map<String, Object> dataHandle(List<Map<String, Object>> qxtjxx, int totalDays, String zlOne, String zlTwo, String qhdm, String qhmc) {
        int zjrl = 0;
        int dtjrl = 0;
        int cgjrl = 0;
        for (int i = 0; i < qxtjxx.size(); i++) {
            String zjrlStr = "0";
            String dtjrlStr = "0";
            String cgjrlStr = "0";
            Map<String, Object> temp = qxtjxx.get(i);
            String sjgxsj = (String) temp.get("SJGXSJ");
            String nowDate = TimeUtils.dateToStr(new Date(), "yyyyMMdd");
            if (temp.containsKey("ZTZL")) {
                String ztzlStr = (String) temp.get("ZTZL");
                if (StringUtils.isNotBlank(ztzlStr)) {
                    int ztzl = Integer.parseInt(ztzlStr);
                    temp.put("ZTZL", ztzl);
                } else {
                    temp.put("ZTZL", 0);
                }
            }
            if (temp.containsKey("ZJRL")) {
                zjrlStr = (String) temp.get("ZJRL");
            }
            if (temp.containsKey("DTJRL") && StringUtils.equals(sjgxsj, nowDate)) {
                dtjrlStr = (String) temp.get("DTJRL");
            }
            if (temp.containsKey("DTJRL") && !StringUtils.equals(sjgxsj, nowDate)) {
                temp.put("DTJRL", 0);
                dtjrlStr = "0";
            }
            if (temp.containsKey("CGJRL")) {
                cgjrlStr = (String) temp.get("CGJRL");
            }
            int tempZjrl = StringUtils.isNotBlank(zjrlStr) ? Integer.parseInt(zjrlStr) : 0;
            int tempDtjrl = StringUtils.isNotBlank(dtjrlStr) ? Integer.parseInt(dtjrlStr) : 0;
            int tempCgjrl = StringUtils.isNotBlank(cgjrlStr) ? Integer.parseInt(cgjrlStr) : 0;
            zjrl = zjrl + tempZjrl;
            dtjrl = dtjrl + tempDtjrl;
            cgjrl = cgjrl + tempCgjrl;
        }
        if (CollectionUtils.isNotEmpty(qxtjxx)) {
            Map<String, Object> firstData = qxtjxx.get(0);
            int zjrsl = baXzqhMapper.getZjrl(qhmc);
            int avgData = (int) Math.floor(zjrsl / (double) totalDays);
            DecimalFormat df = new DecimalFormat("0.00");//格式化小数
            String num = zjrl == 0 ? "0" : df.format((double) cgjrl / zjrl);//返回的是String类型
            int ztzl = (int) Math.floor(Double.parseDouble(num) <= 1 ? Double.parseDouble(num) * 100 : 100);
            firstData.put("ALLPJJRL", avgData >= 1 ? String.valueOf(avgData) : String.valueOf(0));//平均接入量
            firstData.put("ALLZTZL", ztzl >= 1 ? ztzl : 1);//总体质量
            firstData.put("ALLZJRL", String.valueOf(zjrl));//总接入量
            firstData.put("ALLDTJRL", String.valueOf(dtjrl));//当天接入量
            firstData.put("ONE", zlOne);
            firstData.put("TWO", zlTwo);
            firstData.put("QHDM", qhdm);//系统平台代码
            return firstData;
        }
        return Maps.newHashMap();
    }


    @Override
    public boolean dataSynchronization(Map<String, Object> param) {
        try {
            //根据行政区代码查询统计信息
            Qxtjxx dqtjxx = baXzqhMapper.getQxtjxx(param);
            String respCode = (String) param.get("respCode");
            //没找到对应记录、进行新增
            if (null == dqtjxx) {
                //数据初始化
                dqtjxx = new Qxtjxx();
                Date date = new Date();
                dqtjxx.setJrsj(date);
                dqtjxx.setSjgxsj(date);
                dqtjxx.setBwxzqdm((String) param.get("bwxzqdm"));
                dqtjxx.setDtjrl("1");//数据库可以设置默认值
                dqtjxx.setZjrl("1");
                dqtjxx.setDays("1");//数据库可以设置默认1
                dqtjxx.setPjjrl("1");//平均接入量
                if (StringUtils.equals(respCode, "0000")) {
                    dqtjxx.setZtzl("100");//总体质量
                    dqtjxx.setCgjrl("1");
                    dqtjxx.setSbsl("0");
                } else {
                    dqtjxx.setZtzl("0");//总体质量
                    dqtjxx.setCgjrl("0");
                    dqtjxx.setSbsl("1");
                }
                Qxtjxx temp = baXzqhMapper.getQxtjxx(param);
                if (null != temp) {
                    updateQxtjxx(temp, respCode, param);
                } else {
                    baXzqhMapper.insertQxtjxx(dqtjxx);
                }
            } else {//找到记录、进行更新
                updateQxtjxx(dqtjxx, respCode, param);
            }
        } catch (Exception e) {
            LOGGER.info("dataSynchronization.Exception:{}", e);
            dataSynchronization(param);
        }
        return true;
    }

    private void updateQxtjxx(Qxtjxx dqtjxx, String respCode, Map<String, Object> param) {
        try {
            Date sjgxsj = dqtjxx.getSjgxsj();
            Date jrsj = dqtjxx.getJrsj();
            int totalDays = TimeUtils.differentDays(jrsj, new Date()) + 1;
            String sjgxsjStr = TimeUtils.dateToStr(sjgxsj, "yyyyMMdd");
            String sysDateStr = TimeUtils.dateToStr(new Date(), "yyyyMMdd");
            int dtjrl = Integer.parseInt(StringUtils.isEmpty(dqtjxx.getDtjrl())?"0":dqtjxx.getDtjrl());//当天接入量
            int zjrl = Integer.parseInt(StringUtils.isEmpty(dqtjxx.getZjrl())?"0":dqtjxx.getZjrl());//总接入量
            int cgjrl = Integer.parseInt(StringUtils.isEmpty(dqtjxx.getCgjrl())?"0":dqtjxx.getCgjrl());//成功接入量
            int zjrlData = zjrl + 1;
            int sbsl = Integer.parseInt(StringUtils.isEmpty(dqtjxx.getSbsl())?"0":dqtjxx.getSbsl());//失败数量
            String zjrlTemp = String.valueOf(zjrlData);
            dqtjxx.setZjrl(zjrlTemp);
            dqtjxx.setSjgxsj(new Date());
            dqtjxx.setDays(String.valueOf(totalDays));
            boolean flag = false;
            if (sjgxsjStr.equals(sysDateStr)) {//如果最后数据更新时间等于系统当前时间，则更新当天，否则重置当天数据
                String dtjrlTemp = String.valueOf(dtjrl + 1);
                dqtjxx.setDtjrl(dtjrlTemp);
                int pjjrl = (int) Math.rint((double) zjrlData / totalDays);
                dqtjxx.setPjjrl(String.valueOf(pjjrl >= 1 ? pjjrl : 1));
                if (StringUtils.equals(respCode, "0000")) {
                    int cgslTemp = baRzjlMapper.getCgsl(param);
                    if (cgslTemp <=1) {
                        flag = true;
                        double cgjrlData = (double) cgjrl + 1;
                        String cgjrlTemp = String.valueOf((int) cgjrlData);
                        dqtjxx.setCgjrl(cgjrlTemp);
                        double ztzl = (int) Math.rint((cgjrlData / zjrlData) * 100);
                        dqtjxx.setZtzl(String.valueOf((int) ztzl >= 1 ? (int) ztzl : 1));//总体质量
                    }
                }
                if (!StringUtils.equals(respCode, "0000")) {
                    int sbslTemp = baRzjlMapper.getSbsl(param);
                    if (sbslTemp <=1) {
                        flag = true;
                        DecimalFormat df = new DecimalFormat("0.00");//格式化小数
                        String num = df.format((double) cgjrl / zjrlData);//返回的是String类型
                        int ztzl = (int) Math.rint(Double.parseDouble(num) * 100);
                        dqtjxx.setZtzl(String.valueOf((int) ztzl >= 1 ? (int) ztzl : 1));//总体质量
                        int sbzsl = sbsl + 1;
                        String sbzslTemp = String.valueOf(sbzsl);
                        dqtjxx.setSbsl(sbzslTemp);
                    }
                }
            } else {
                int pjjrl = (int) Math.rint((double) zjrlData / totalDays);
                dqtjxx.setPjjrl(String.valueOf(pjjrl >= 1 ? pjjrl : 1));
                dqtjxx.setDtjrl("1");
                if (StringUtils.equals(respCode, "0000")) {
                    int cgslTemp = baRzjlMapper.getCgsl(param);
                    if (cgslTemp <=1) {
                        flag = true;
                        double cgjrlData = (double) cgjrl + 1;
                        String cgjrlTemp = String.valueOf((int) cgjrlData);
                        dqtjxx.setCgjrl(cgjrlTemp);
                        int ztzl = (int) Math.rint(cgjrlData / zjrlData * 100);
                        dqtjxx.setZtzl(String.valueOf(ztzl >= 1 ? ztzl : 1));//总体质量
                    }
                }
                if (!StringUtils.equals(respCode, "0000")) {
                    int sbslTemp = baRzjlMapper.getSbsl(param);
                    if (sbslTemp <=1) {
                        flag = true;
                        DecimalFormat df = new DecimalFormat("0.00");//格式化小数
                        String num = df.format((double) cgjrl / zjrlData);//返回的是String类型
                        int ztzl = (int) Math.rint(Double.parseDouble(num) * 100);
                        dqtjxx.setZtzl(String.valueOf(ztzl >= 1 ? ztzl : 1));//总体质量
                        int sbzsl = sbsl + 1;
                        String sbzslTemp = String.valueOf(sbzsl);
                        dqtjxx.setSbsl(sbzslTemp);
                    }
                }
            }
            if (flag) {
                baXzqhMapper.updateQxtjxx(dqtjxx);
            }
        } catch (Exception e) {
            LOGGER.info("updateQxtjxx.Exception!:{}", e);
        }

    }

    @Override
    public List<Map<String, Object>> getQxxxByFdm(String fdm) {
        return baXzqhMapper.getQxxxByFdm(fdm);
    }

    @Override
    public List<Map<String, Object>> getCityInfos(Map param) {
        return baXzqhMapper.getCityInfos(param);
    }

    @Override
    public List<Map<String, String>> getJrdxx() {
        return baXzqhMapper.getJrdxx();
    }

    /**
     * 获取大市列表
     *
     * @param qhdm
     * @return
     */
    public List<Map<String, Object>> getDsxx(String qhdm) {
        return baXzqhMapper.getDsxx(qhdm);
    }


    /**
     * 上报概况统计
     *
     * @return
     */
    @Override
    public Map<String, Object> getSbqkData(String qhmc) {
        Map<String, Object> resMap = baSftpMapper.getSbgkData(qhmc);
        int cgsl = Integer.parseInt(String.valueOf(resMap.get("CGSL")));
        int zsl = Integer.parseInt(String.valueOf(resMap.get("ZSL")));
        int dtsl = Integer.parseInt(String.valueOf(resMap.get("DTSL")));
        int sbsl = dtsl - cgsl > 0 ? dtsl - cgsl : 0;
        DecimalFormat df = new DecimalFormat("0.00");//格式化小数
        String num = df.format(((double) cgsl / zsl) > 0 ? (double) cgsl / zsl : 0);//返回的是String类型
        int ztzl = (int) Math.floor(Double.parseDouble(num) > 0 ? Double.parseDouble(num) * 100 : 0 * 100);
        ztzl = ztzl >= 1 ? ztzl : 0;
        resMap.put("ZTZL", ztzl);
        resMap.put("SBSL", sbsl);
        return resMap;
    }

    public List<Map<String, Object>> getSbData() {
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String, Object>> dsxxList = baXzqhMapper.getDsxx(qhdm);
        List<Map<String, Object>> resList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(dsxxList)) {//省级平台
            int zslNum = 0;
            for (int i = 0; i < dsxxList.size(); i++) {
                Map<String, Object> temp = dsxxList.get(i);
                String qhmc = (String) temp.get("QHMC");
                String qhdmStr = (String) temp.get("QHDM");
                Map<String, Object> resMap = baSftpMapper.getSbgkData(qhmc);
                int cgsl = Integer.parseInt(String.valueOf(resMap.get("CGSL")));
                int zsl = Integer.parseInt(String.valueOf(resMap.get("ZSL")));
                int dtsl = Integer.parseInt(String.valueOf(resMap.get("DTSL")));
                zslNum += dtsl;
                int sbsl = dtsl - cgsl > 0 ? dtsl - cgsl : 0;
                DecimalFormat df = new DecimalFormat("0.00");//格式化小数
                String num = df.format(((double) cgsl / zsl) > 0 ? (double) cgsl / zsl : 0);//返回的是String类型
                int ztzl = (int) Math.floor(Double.parseDouble(num) > 0 ? Double.parseDouble(num) * 100 : 0 * 100);
                ztzl = ztzl >= 1 ? ztzl : 0;
                resMap.put("ZTZL", ztzl);
                resMap.put("SBSL", sbsl);
                resMap.put("QHMC", qhmc);
                resMap.put("QHDM", qhdmStr);
                resList.add(resMap);
            }
            Map<String, Object> tempMap = Maps.newHashMap();
            tempMap.put("DTZSL", zslNum);
            tempMap.put("QHDM", qhdm);
            resList.add(tempMap);
        } else {
            List<Map<String, Object>> qxxxList = baXzqhMapper.getQxxxByFdm(qhdm);
            if (CollectionUtils.isNotEmpty(qxxxList)) {//市级平台
                int zslNum = 0;
                for (int i = 0; i < qxxxList.size(); i++) {
                    Map<String, Object> temp = qxxxList.get(i);
                    String qhmc = (String) temp.get("QHMC");
                    String qhdmStr = (String) temp.get("QHDM");
                    Map<String, Object> resMap = baSftpMapper.getSbgkData(qhmc);
                    int cgsl = Integer.parseInt(String.valueOf(resMap.get("CGSL")));
                    int zsl = Integer.parseInt(String.valueOf(resMap.get("ZSL")));
                    int dtsl = Integer.parseInt(String.valueOf(resMap.get("DTSL")));
                    zslNum += dtsl;
                    int sbsl = dtsl - cgsl > 0 ? dtsl - cgsl : 0;
                    DecimalFormat df = new DecimalFormat("0.00");//格式化小数
                    String num = df.format(((double) cgsl / zsl) > 0 ? (double) cgsl / zsl : 0);//返回的是String类型
                    int ztzl = (int) Math.floor(Double.parseDouble(num) > 0 ? Double.parseDouble(num) * 100 : 0 * 100);
                    ztzl = ztzl >= 1 ? ztzl : 0;
                    resMap.put("ZTZL", ztzl);
                    resMap.put("SBSL", sbsl);
                    resMap.put("QHMC", qhmc);
                    resMap.put("QHDM", qhdmStr);
                    resList.add(resMap);
                }

                Map<String, Object> tempMap = Maps.newHashMap();
                tempMap.put("DTZSL", zslNum);
                tempMap.put("QHDM", qhdm);
                resList.add(tempMap);
            }
        }
        return resList;
    }

    @Override
    public Map<String, Object> getIndexSx(String QHJB,String ParamQhdm) {
        //分开计算 省和地级市 分开计算
        //系统级别
         //省级
         //计算接入总量
         Map<String,Object> resultMap =new HashMap<>();

          Map<String,String> paramMap = new HashMap();
          Map<String,String> paramCGMap = new HashMap<>();
          String sumjrzl = null;
          String dtjrzl  =null ;
          int avgData = 0;
          int ztzl =0;

        if(ParamQhdm == ""){
            ParamQhdm = null;
        }

        Calendar now = Calendar.getInstance();
        String year =  String.valueOf(now.get(Calendar.YEAR));
        Integer month =(now.get(Calendar.MONTH) + 1);
        Integer day =  now.get(Calendar.DAY_OF_MONTH);
        checkfiled(String.valueOf(month));





        String xtsxsj = AppConfig.getProperty("supersive.run.time");
        Date systemRunTime = TimeUtils.strToDate(xtsxsj);
        int totalDays = baRzjlMapper.getTotalDays(systemRunTime);


        if(StringUtils.equals("省级",QHJB)&&ParamQhdm==null){ //计算陕西省级 接入概况

             paramMap.put("qhjb","sj");
             sumjrzl = baXzqhMapper.getSumJrzl(paramMap);//接入总量

            paramMap.put("year",year);
            paramMap.put("month",checkfiled(String.valueOf(month)));
            paramMap.put("day",checkfiled(String.valueOf(day)));

             dtjrzl =  baXzqhMapper.getSumJrzl(paramMap); //当天接入量


              avgData = (int) Math.floor(Double.valueOf(sumjrzl)/ totalDays);//日均接入量
            //总体质量
            //获得接入成功量
            paramCGMap.put("qhjb","sj");
            String cgjrl = baXzqhMapper.getCgjrsl(paramCGMap);
            DecimalFormat df = new DecimalFormat("0.00");//格式化小数
            String num = Integer.valueOf(sumjrzl) == 0 ? "0" : df.format(Double.valueOf(cgjrl) / Integer.valueOf(sumjrzl) );//返回的是String类型
             ztzl = (int) Math.floor(Double.parseDouble(num) <= 1 ? Double.parseDouble(num) * 100 : 100);

        }else{
            if(StringUtils.equals("省级",QHJB)&&ParamQhdm!=null){
                ParamQhdm =baXzqhMapper.getQhdmByMc(ParamQhdm);//区划名称获得区划代码
            }
            if(StringUtils.equals("市级",QHJB)&&ParamQhdm==null){
                ParamQhdm = AppConfig.getProperty("region.qhdm");
            }
            if(StringUtils.equals("市级",QHJB)&&ParamQhdm!=null){
                ParamQhdm =baXzqhMapper.getQhdmByMc(ParamQhdm);
            }

            paramMap.put("qhjb","xj");
            if(StringUtils.isNotBlank(ParamQhdm)&&ParamQhdm.length() > 4) {
                paramMap.put("xzqdm",CommonUtil.formatEmptyValue(ParamQhdm.subSequence(0,4)));
            }
            sumjrzl = baXzqhMapper.getSumJrzl(paramMap);  //地级市接入总量

            paramMap.put("year",year);
            paramMap.put("month",checkfiled(String.valueOf(month)));
            paramMap.put("day",checkfiled(String.valueOf(day)));
            dtjrzl =  baXzqhMapper.getSumJrzl(paramMap); //d地级市当天接入量

            avgData = (int) Math.floor(Double.valueOf(sumjrzl)/ totalDays);//地级市日均接入量
            paramCGMap.put("qhjb","xj");
            if(StringUtils.isNotBlank(ParamQhdm)&&ParamQhdm.length() > 4) {
                paramCGMap.put("xzqdm",CommonUtil.formatEmptyValue(ParamQhdm.subSequence(0,4)));
            }
            String cgjrl = baXzqhMapper.getCgjrsl(paramCGMap);
            DecimalFormat df = new DecimalFormat("0.00");//格式化小数
            String num = Integer.valueOf(sumjrzl) == 0 ? "0" : df.format(Double.valueOf(cgjrl) / Integer.valueOf(sumjrzl) );//返回的是String类型
            ztzl = (int) Math.floor(Double.parseDouble(num) <= 1 ? Double.parseDouble(num) * 100 : 100);
        }


        resultMap.put("ZSL", sumjrzl); //总数量
        resultMap.put("AVGSL",avgData); //日均数量
        resultMap.put("DTSL",dtjrzl);  //当天数量
        resultMap.put("ZTZL",ztzl);  //总体质量
        return resultMap;
    }

    public   String   checkfiled(String date){
        String  resultfiled = null;
         if(date.length() ==2){
             resultfiled = date;
         }else{
             resultfiled ="0"+date;
         }


       return   resultfiled;
    }



    @Override
    public List<Map<String, Object>> getJrqkList(String qhmc, String dateTime) {
        return baRzjlMapper.getJrqkList(qhmc, dateTime);
    }

    @Override
    public List<Map<String, String>> getJrdxxByQhdm(String qhdm) {
        return baXzqhMapper.getJrdxxByQhdm(qhdm);
    }

    @Override
    public List<Map<String, String>> getJrdQxxxByQhdm(String qhdm) {
        return baXzqhMapper.getJrdQxxxByQhdm(qhdm);
    }

    @Override
    public List<Map<String, String>> getXtregion() {

        List<Map<String, String>> resList = baXzqhMapper.getXtregion();
        return resList;
    }

}
