package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaKxtjMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaXzqhMapper;
import cn.gtmap.realestate.supervise.server.entity.Rzjl;
import cn.gtmap.realestate.supervise.server.service.TszdkxlService;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2018/12/20
 * @description 特殊字段空项率统计
 */
@Service(value = "TszdkxlServiceImpl")
public class TszdkxlServiceImpl implements TszdkxlService, ApplicationContextAware {

    private static final Logger LOGGER = LoggerFactory.getLogger(TszdkxlServiceImpl.class);

    //方法初始化Map
    private static final Map<String, String> methodMap = Maps.newHashMap();

    @Autowired
    private BaXzqhMapper baXzqhMapper;

    @Autowired
    @Qualifier(value = "TszdkxlServiceImpl")
    private TszdkxlServiceImpl tszdkxlService;

    @Autowired
    private BaKxtjMapper baKxtjMapper;

    @Override
    public List<Map<String, Object>> getCxxx(Date startDate, Date endDate, boolean flag) {

        String qhdm = AppConfig.getProperty("region.qhdm");

        if (null == startDate && null == endDate) {
            Date curDate = new Date();
            endDate = TimeUtils.getBeforeDate(curDate, -1);//昨天
            startDate = TimeUtils.getBeforeDate(curDate, -7);//往前推第七天
        }
        List<Map<String, Object>> dsxxList = baXzqhMapper.getDsxx(qhdm);//大市信息
        List<Map<String, Object>> resList = Lists.newArrayList();//输出结果
        List<Map<String, Object>> dsResList = Lists.newArrayList();//临时存放每个大市汇总信息
        Map<String, Object> params = Maps.newHashMap();
        params.put("startDate", TimeUtils.dateToStr(startDate, "yyyyMMdd"));
        params.put("endDate", TimeUtils.dateToStr(endDate, "yyyyMMdd"));
        List<Map<String, Object>> resKxtjList = baKxtjMapper.getKxtjList(params);
        if (CollectionUtils.isNotEmpty(dsxxList)) {
            //省级平台逻辑
            for (int i = 0; i < dsxxList.size(); i++) {
                Map<String, Object> temp = dsxxList.get(i);
                String dsQhdm = (String) temp.get("QHDM");//大市区划代码
                String dsQhmc = (String) temp.get("QHMC");//大市区划名称
                List<Map<String, Object>> qxxxList = baXzqhMapper.getQxxxByFdm(dsQhdm);//区县信息
                List<Map<String, Object>> tempQxtjxxList = Lists.newArrayList();//临时存放大市对应每个区县统计信息
                if (CollectionUtils.isNotEmpty(qxxxList)) {
//            // 创建多个有返回值的任务
                    for (int j = 0; j < qxxxList.size(); j++) {
                        Map<String, Object> qxxx = qxxxList.get(j);
                        String qhdmStr = (String) qxxx.get("QHDM");
                        for (int k = 0; k < resKxtjList.size(); k++) {
                            Map<String, Object> kxtjMap = resKxtjList.get(k);
                            String tempQhdm = (String) kxtjMap.get("QHDM");
                            if (StringUtils.equals(qhdmStr, tempQhdm)) {
                                kxtjMap.put("qhmc", qxxx.get("QHMC"));
                                kxtjMap.put("parent", i);
                                kxtjMap.put("expanded", false);
                                kxtjMap.put("isLeaf", true);
                                kxtjMap.put("level", 1);
                                tempQxtjxxList.add(kxtjMap);//记录每个区县统计信息
                            }
                        }
                    }
                }
                Map<String, Object> dsResMap = getCountInfo(dsQhdm, dsQhmc, tempQxtjxxList);//大市统计结果
                dsResMap.put("expanded", false);
                dsResMap.put("isLeaf", false);
                dsResMap.put("level", 0);
                resList.add(dsResMap);
                dsResList.add(dsResMap);
                if (!flag) {
                    for (int j = 0; j < tempQxtjxxList.size(); j++) {
                        resList.add(tempQxtjxxList.get(j));//大市下面加入区县信息
                    }
                }
            }
            Map<String, Object> countInfo = getSxCountInfo(dsResList);//纵向合计
            resList.add(countInfo);
        } else {
            //市级平台逻辑
            List<Map<String, Object>> qxxxList = baXzqhMapper.getQxxxByFdm(qhdm);//区县信息
            if (CollectionUtils.isNotEmpty(qxxxList)) {
                for (int i = 0; i < qxxxList.size(); i++) {
                    Map<String, Object> qxxx = qxxxList.get(i);
                    String qhdmStr = (String) qxxx.get("QHDM");
                    for (int k = 0; k < resKxtjList.size(); k++) {
                        Map<String, Object> kxtjMap = resKxtjList.get(k);
                        String tempQhdm = (String) kxtjMap.get("QHDM");
                        if (StringUtils.equals(qhdmStr, tempQhdm)) {
                            kxtjMap.put("parent", i);
                            kxtjMap.put("expanded", false);
                            kxtjMap.put("isLeaf", true);
                            kxtjMap.put("level", 1);
                            resList.add(kxtjMap);//记录每个区县统计信息
                        }
                    }
                }
                Map<String, Object> countInfo = getSxCountInfo(resList);//纵向合计
                resList.add(countInfo);
            }
        }
        return resList;
    }


    /**
     * 查询区县统计信息
     *
     * @param qhdm
     * @param qhmc
     * @return
     */
    public Map<String, Object> getQxtjxx(String qhdm, String qhmc, List<Rzjl> ywhList, List<Map<String, Object>> fdcqList,
                                         List<Map<String, Object>> dyaqList) {

        Map<String, Object> resMap = Maps.newHashMap();
        List<Map<String, Object>> tempList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(fdcqList)) {
            BigDecimal zsl = BigDecimal.valueOf(0);
            for (Map<String, Object> temp : fdcqList) {
                String tempQhdm = (String) temp.get("QHDM");
                if (StringUtils.isNotBlank(tempQhdm) && StringUtils.equals(tempQhdm, qhdm)) {
                    BigDecimal tempZsl = BigDecimal.valueOf(Long.parseLong(temp.get("ZSL").toString()));
                    zsl = zsl.add(tempZsl);
                }
            }
            Map<String, Object> tempMap = Maps.newHashMap();
            tempMap.put(Constant.FDCJYJG, zsl.toString());
            tempList.add(tempMap);
        }
        if (CollectionUtils.isNotEmpty(dyaqList)) {
            BigDecimal zsl = BigDecimal.valueOf(0);
            for (Map<String, Object> temp : dyaqList) {
                String tempQhdm = (String) temp.get("QHDM");
                if (StringUtils.isNotBlank(tempQhdm) && StringUtils.equals(tempQhdm, qhdm)) {
                    BigDecimal tempZsl = BigDecimal.valueOf(Long.parseLong(temp.get("ZSL").toString()));
                    zsl = zsl.add(tempZsl);
                }
            }
            Map<String, Object> tempMap = Maps.newHashMap();
            tempMap.put(Constant.BDBZZQSE, zsl.toString());
            tempList.add(tempMap);
        }
        try {
            if (CollectionUtils.isNotEmpty(ywhList)) {
                for (int i = 0; i < ywhList.size(); i++) {
                    Rzjl rzjl = ywhList.get(i);
                    String bwxzqdm = rzjl.getBwxzqdm();
                    if (StringUtils.isNotBlank(bwxzqdm) && StringUtils.equals(bwxzqdm, qhdm)) {
                        String ywh = rzjl.getYwh();
                        String bwjcjg = rzjl.getBwjcjg();
                        String xybm = rzjl.getXybm();
                        Map<String, Object> tempMap = Maps.newHashMap();
                        for (Map.Entry<String, String> entry : methodMap.entrySet()) {
                            String key = entry.getKey();
                            String val = entry.getValue();
                            if (StringUtils.isNotBlank(val) && StringUtils.equals(Constant.XYBM_2023, xybm) &&
                                    !StringUtils.equals(Constant.FDCJYJG, key) && !StringUtils.equals(Constant.BDBZZQSE, key)) {
                                boolean flag = getReflectFlag(val, ywh, key, bwjcjg);
                                if (!flag) {//校验失败、累加结果
                                    tempMap.put(key, "1");
                                } else {
                                    tempMap.put(key, "0");
                                }
                            } else if (StringUtils.isNotBlank(val) && StringUtils.equals(Constant.FDCJYJG, key)) {
                                boolean flag = getReflectFlag(val, ywh, key, bwjcjg);
                                if (!flag) {//校验失败、累加结果
                                    tempMap.put(key, "1");
                                } else {
                                    tempMap.put(key, "0");
                                }
                            } else if (StringUtils.isNotBlank(val) && StringUtils.equals(Constant.BDBZZQSE, key)) {
                                boolean flag = getReflectFlag(val, ywh, key, bwjcjg);
                                if (!flag) {//校验失败、累加结果
                                    tempMap.put(key, "1");
                                } else {
                                    tempMap.put(key, "0");
                                }
                            }
                        }
                        tempList.add(tempMap);
                    }
                }
                //计算区县记录累加结果
                resMap = getCountInfo(qhdm, qhmc, tempList);
            } else {
                resMap = getCountInfo(qhdm, qhmc, tempList);
            }
        } catch (Exception e) {
            LOGGER.error("特殊字段空项率统计异常！{}", e);
        }
        return resMap;
    }


    private boolean getReflectFlag(String val, String ywh, String key, String bwjcjg) {
        boolean flag = true;
        try {
            Class source = TszdkxlServiceImpl.class;
            Method me = source.getDeclaredMethod(val, String.class, String.class, String.class);
            Object object = getBean("TszdkxlServiceImpl");
            flag = (boolean) me.invoke(object, ywh, key, bwjcjg);
        } catch (Exception e) {
            LOGGER.error("getReflectFlag异常！{}", e);
        }
        return flag;
    }

    static {
        methodMap.put(Constant.BDCDYH, "checkData");
        methodMap.put(Constant.SYQMJ, "checkData");
        methodMap.put(Constant.JZMJ, "checkData");
        methodMap.put(Constant.QLLX, "checkData");
        methodMap.put(Constant.QLRMC, "checkData");
        methodMap.put(Constant.ZJH, "checkData");
        methodMap.put(Constant.BDCQZH, "checkData");
        methodMap.put(Constant.BDCDJZMH, "checkData");
        methodMap.put(Constant.SLSJ, "checkData");
        methodMap.put(Constant.DJSJ, "checkData");
        methodMap.put(Constant.YT, "checkYtData");
        methodMap.put(Constant.GHYT, "checkData");
        methodMap.put(Constant.YWH, "checkData");
        methodMap.put(Constant.QXDM, "checkData");
        methodMap.put(Constant.DJLX, "checkData");
        methodMap.put(Constant.QLRLX, "checkData");
        methodMap.put(Constant.GYFS, "checkData");
        methodMap.put(Constant.COUNT, "");
        methodMap.put(Constant.FDCJYJG, "checkFdcjyjgData");
        methodMap.put(Constant.BDBZZQSE, "checkBdbzzqseData");
    }


    /**
     * 校验数据是否存在
     *
     * @param ywh
     * @param key
     * @param bwjcjg 字段名称
     * @return
     */
    public boolean checkYtData(String ywh, String key, String bwjcjg) {
        boolean res = true;
        if (StringUtils.isNotBlank(bwjcjg) && (bwjcjg.contains(Constant.GHYT.toLowerCase()) || bwjcjg.contains(Constant.GHYT.toUpperCase()))) {
            bwjcjg = bwjcjg.replaceAll(Constant.GHYT.toUpperCase(), "");
            bwjcjg = bwjcjg.replaceAll(Constant.GHYT.toLowerCase(), "");
        }
        if (StringUtils.isNotBlank(bwjcjg) && (bwjcjg.contains(key.toUpperCase()) || bwjcjg.contains(key.toLowerCase()))) {
            res = false;
        }
        return res;
    }

    public boolean checkData(String ywh, String key, String bwjcjg) {
        boolean res = true;
        if (StringUtils.isNotBlank(bwjcjg) && (bwjcjg.contains(key.toUpperCase()) || bwjcjg.contains(key.toLowerCase()))) {
            res = false;
        }
        return res;
    }

    public boolean checkFdcjyjgData(String ywh, String key, String bwjcjg) {
        boolean res = true;
        if (StringUtils.isNotBlank(bwjcjg) && (bwjcjg.contains(key.toUpperCase()) || bwjcjg.contains(key.toLowerCase()))) {
            res = false;
        }
        return res;
    }

    /**
     * 校验数据是否存在
     *
     * @param ywh
     * @param key 字段名称
     * @return
     */
    public boolean checkBdbzzqseData(String ywh, String key, String bwjcjg) {

        boolean res = true;
        if (StringUtils.isNotBlank(bwjcjg) && (bwjcjg.contains(key.toUpperCase()) || bwjcjg.contains(key.toLowerCase()))) {
            res = false;
        }
        return res;
    }


    /**
     * 统计每个区县每项记录总和
     *
     * @param qhdm
     * @param qhmc
     * @param qxtjxxList
     * @return
     */
    public Map<String, Object> getCountInfo(String qhdm, String qhmc, List<Map<String, Object>> qxtjxxList) {
        Map<String, Object> resMap = Maps.newHashMap();
        BigDecimal count = BigDecimal.valueOf(0);//合计
        for (Map.Entry<String, String> entry : methodMap.entrySet()) {
            String key = entry.getKey();
            String valStr = entry.getValue();
            if (StringUtils.isNotBlank(valStr)) {
                BigDecimal resVal = BigDecimal.valueOf(0);
                if (CollectionUtils.isNotEmpty(qxtjxxList)) {
                    for (int i = 0; i < qxtjxxList.size(); i++) {
                        Map<String, Object> qxtjxx = qxtjxxList.get(i);
                        if (qxtjxx.containsKey(key)) {
                            BigDecimal val = BigDecimal.valueOf(Long.parseLong(qxtjxx.get(key).toString()));
                            resVal = resVal.add(val);
                            count = count.add(val);
                        }
                    }
                    resMap.put(key, String.valueOf(resVal));
                } else {
                    resMap.put(key, "0");
                }
            }
        }
        resMap.put(Constant.COUNT, String.valueOf(count));//每个地区横向合计
        resMap.put("qhdm", qhdm);
        resMap.put("qhmc", qhmc);
        return resMap;//区县记录汇总
    }

    /**
     * 纵向合计
     *
     * @param tjxxList
     * @return
     */
    public Map<String, Object> getSxCountInfo(List<Map<String, Object>> tjxxList) {
        Map<String, Object> resMap = Maps.newHashMap();
        for (Map.Entry<String, String> entry : methodMap.entrySet()) {
            String key = entry.getKey();
            int resVal = 0;
            if (CollectionUtils.isNotEmpty(tjxxList)) {
                for (int i = 0; i < tjxxList.size(); i++) {
                    Map<String, Object> qxtjxx = tjxxList.get(i);
                    String val = (String) qxtjxx.get(key);
                    resVal += Integer.parseInt(val);
                }
                resMap.put(key, String.valueOf(resVal));
            } else {
                resMap.put(key, "0");
            }
        }
        resMap.put("qhmc", "合计");
        return resMap;//区县记录汇总
    }


    private static ApplicationContext applicationContext = null;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        TszdkxlServiceImpl.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) throws BeansException {
        return applicationContext.getBean(name);
    }
}
