package cn.gtmap.realestate.supervise.server.service.impl;


import cn.gtmap.realestate.supervise.server.config.Constant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:tinajian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/4/13
 * @description 将服务和具体业务进行绑定
 */
@Service
public class ServeRegister {

    Map<String, AbstractServeDetail> registerServeDetail = new HashMap<String, AbstractServeDetail>();

    @Autowired
    AddAbstractServe addServe;

    /**
     * 通过spring初始化bean对bean进行过滤获取所有的ServeDetail的服务
     * 避免每次都会修改到类也比较方便的解决了初始化为null的问题
     */
    @Autowired
    AddCancelAbstractServe addCancelServe;

    @Autowired
    CancelAbstractServe cancelServe;

    @Autowired
    DyiqdjAbstractServe dyiqdjServe;

    @Autowired
    CfdjAbstractServe cfdjServe;

    @Autowired
    DyqdjAbstractServe dyqdjServe;

    @Autowired
    YgdjAbstractServe ygdjServe;

    @Autowired
    YydjAbstractServe yydjServe;


    private void registerServer(String name, AbstractServeDetail serveDetail) {
        registerServeDetail.put(name, serveDetail);
    }

    public Map<String, AbstractServeDetail> getRegisterServeDetail() {
        return registerServeDetail;
    }


    public void init() {
        //首次登记
        registerServer(Constant.TDSYQSCDJ, addServe);
        registerServer(Constant.JSYDSYQSCDJ, addServe);
        registerServer(Constant.FDCQSCDJ1, addServe);
        registerServer(Constant.FDCQSCDJ2, addServe);
        registerServer(Constant.JZWQFSYQSCDJ, addServe);
        registerServer(Constant.HYSYQSCDJ, addServe);
        registerServer(Constant.GZWSYQSCDJ, addServe);
        registerServer(Constant.NYDSYQSCDJ, addServe);
        registerServer(Constant.LQSCDJ, addServe);
        registerServer(Constant.DYAQSCDJ, addServe);
        registerServer(Constant.DYIQSCDJ, addServe);
        registerServer(Constant.QTXGQLSCDJ, addServe);

        //转移登记
        registerServer(Constant.TDSYQZYDJ, addCancelServe);
        registerServer(Constant.JSYDSYQZYDJ, addCancelServe);
        registerServer(Constant.FDCQZYDJ1, addCancelServe);
        registerServer(Constant.FDCQZYDJ2, addCancelServe);
        registerServer(Constant.JZWQFSYQZYDJ, addCancelServe);
        registerServer(Constant.HYSYQZYDJ, addCancelServe);
        registerServer(Constant.GZWSYQZYDJ, addCancelServe);
        registerServer(Constant.NYDSYQZYDJ, addCancelServe);
        registerServer(Constant.LQZYDJ, addCancelServe);
        registerServer(Constant.DYAQZYDJ, addCancelServe);
        registerServer(Constant.DYIQZYDJ, addCancelServe);
        registerServer(Constant.QTDJZYDJ, addCancelServe);

        //变更登记
        registerServer(Constant.TDSYQBGDJ, addCancelServe);
        registerServer(Constant.JSYDSYQBGDJ, addCancelServe);
        registerServer(Constant.FDCQBGDJ1, addCancelServe);
        registerServer(Constant.FDCQBGDJ2, addCancelServe);
        registerServer(Constant.JZWQFSYQBGDJ, addCancelServe);
        registerServer(Constant.HYSYQBGDJ, addCancelServe);
        registerServer(Constant.GZWSYQBGDJ, addCancelServe);
        registerServer(Constant.NYDSYQBGDJ, addCancelServe);
        registerServer(Constant.LQBGDJ, addCancelServe);
        registerServer(Constant.DYAQBGDJ, addCancelServe);
        registerServer(Constant.DYIQBGDJ, addCancelServe);
        registerServer(Constant.QTXGQLBGDJ, addCancelServe);

        //注销登记
        registerServer(Constant.ZXDJ, cancelServe);

        //更正登记
        registerServer(Constant.TDSYQGZDJ, addCancelServe);
        registerServer(Constant.JSYDSYQGZDJ, addCancelServe);
        registerServer(Constant.FDCQGZDJ1, addCancelServe);
        registerServer(Constant.FDCQGZDJ2, addCancelServe);
        registerServer(Constant.JZWQFSYQGZDJ, addCancelServe);
        registerServer(Constant.HYSYQGZDJ, addCancelServe);
        registerServer(Constant.GZWSYQGZDJ, addCancelServe);
        registerServer(Constant.NYDSYQGZDJ, addCancelServe);
        registerServer(Constant.LQGZDJ, addCancelServe);
        registerServer(Constant.DYAQGZDJ, addCancelServe);
        registerServer(Constant.DYIQGZDJ, addCancelServe);
        registerServer(Constant.QTXGQLGZDJ, addCancelServe);


        //换证登记
        registerServer(Constant.TDSYQHZDJ, addCancelServe);
        registerServer(Constant.JSYDSYQHZDJ, addCancelServe);
        registerServer(Constant.FDCQHZDJ1, addCancelServe);
        registerServer(Constant.FDCQHZDJ2, addCancelServe);
        registerServer(Constant.JZWQFSYQHZDJ, addCancelServe);
        registerServer(Constant.HYSYQHZDJ, addCancelServe);
        registerServer(Constant.GZWSYQHZDJ, addCancelServe);
        registerServer(Constant.NYDSYQHZDJ, addCancelServe);
        registerServer(Constant.LQHZDJ, addCancelServe);
        registerServer(Constant.DYAQHZDJ, addCancelServe);
        registerServer(Constant.DYIQHZDJ, addCancelServe);
        registerServer(Constant.QTDJHZDJ, addCancelServe);

        //异议登记
        registerServer(Constant.YYDJ, yydjServe);
        //预告登记
        registerServer(Constant.YGDJ, ygdjServe);
        //查封登记
        registerServer(Constant.CFDJ, cfdjServe);
    }
}
