package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.service.Serve;
import cn.gtmap.realestate.supervise.server.service.ServeLog;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/4/13
 * @description 服务工厂，为注册好的服务提供具体业务服务
 */
@Service
public class ServeFactory implements Serve {

    /**
     * 注册服务器
     */
    @Autowired
    ServeRegister serveRegister;

    /**
     *根据业务号获取业务服务需要处理的文件消息体
     * @param fileMessage
     * @return 业务处理j结果
     * @throws DocumentException
     */
    @Override
    public ServeLog serveDetail(FileMessage fileMessage){

        if(serveRegister.getRegisterServeDetail().size() == 0) {
            serveRegister.init();
        }
        String recType = fileMessage.getRectype();
        if (!recType.isEmpty()) {
            AbstractServeDetail detail = serveRegister.getRegisterServeDetail().get(recType);
            if (detail != null) {
                return detail.serveDetail(fileMessage);
            }
        }
        return new ServeLogImpl();
    }
}
