package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaSftpMapper;
import cn.gtmap.realestate.supervise.server.entity.Log;
import cn.gtmap.realestate.supervise.server.es.SearchService;
import cn.gtmap.realestate.supervise.server.service.SbcxService;
import cn.gtmap.realestate.supervise.server.sftp.SftpService;
import cn.gtmap.realestate.supervise.server.utils.FileUtils;
import com.gtis.common.util.UUIDGenerator;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Date;

/**
 * Created by 徐涛 on 2018-6-8.
 */
@Service
public class SbcxServiceImpl implements SbcxService {

    private static final Logger LOGGER = LoggerFactory.getLogger(SbcxServiceImpl.class);

    @Autowired
    private SearchService searchService;

    @Autowired
    private SftpService sftpService;

    @Autowired
    private BaSftpMapper baSftpMapper;

    @Autowired
    SbcxServiceImpl sbcxService;

    @Autowired
    LogServiceImpl logService;

    @Override
    public void manualReport(String files, UserAuthDTO userAuthDTO, HttpServletRequest request, String sftpBizBakPath) {
        String[] fileNams = files.split(",");
        String user = userAuthDTO.getUsername();
        String ip = request.getRemoteAddr();

        for (int i = 0; i < fileNams.length; i++) {
            String fileName = fileNams[i];
            String[] tempFileInfos = fileName.split("\\|");
            String tempFileName = tempFileInfos[0];
            String tempYwbwid = "";
            if (tempFileInfos.length == 2) {
                tempYwbwid = tempFileInfos[1];
            }
            try {
                String xmlContent = searchService.mainGetData(tempFileName, "", "", tempYwbwid, "");
                boolean uploadFlag = uploadXml(tempFileName, xmlContent);
                if (uploadFlag) {
                    sbcxService.updateSbjgByFileName(tempFileName);
                } else {
                    baSftpMapper.updateWsbByFileName(tempFileName);
                }

                String fileOldName = tempFileName + ".temp";
                byte[] contentByte = xmlContent.getBytes("UTF-8");
                if (uploadFlag) {
                    FileUtils.saveFile(contentByte, sftpBizBakPath, fileOldName, tempFileName);//写文件
                }
                insertLog(tempFileName, ip, user);
            } catch (Exception e) {
                LOGGER.error("手动上报失败,文件名:{},异常信息:{}", fileName, e);
                String errorMsg = tempFileName + ",\n" + e.getMessage();
                insertLog(errorMsg, ip, user);
                continue;
            }
        }
    }


    @Override
    public void updateSbjgByFileName(String fileName) {
        baSftpMapper.updateSbjgByFileName(fileName);
    }


    @Override
    public boolean uploadXml(String fileName, String xmlContent) throws SftpException, JSchException, IOException {
        boolean flag = sftpService.sftpUploadXmlFile(fileName, xmlContent);
        return flag;
    }


    private boolean insertLog(String cznr, String ip, String user) {
        Log log = new Log();
        log.setCzlx("手动上报");
        log.setCznr("参数为:" + cznr);
        log.setCzrq(new Date());
        log.setId(UUIDGenerator.generate18());
        log.setIp(ip);
        log.setYhmc(user);
        logService.insertBalog(log);
        return true;
    }

    public void manualReport(String files, UserAuthDTO userAuthDTO, HttpServletRequest request) {
        String[] fileNams = files.split(",");
        String user = userAuthDTO.getUsername();
        String ip = request.getRemoteAddr();
        for (int i = 0; i < fileNams.length; i++) {
            String fileName = fileNams[i];
            try {
                String xmlContent = this.searchService.mainGetData(fileName, "");
                uploadXml(fileName, xmlContent);
                this.sbcxService.updateSbjgByFileName(fileName);
                insertLog(fileName, ip, user);
            } catch (Exception e) {
                String errorMsg = fileName + ",\n" + e.getMessage();
                LOGGER.error("手动上报失败,文件名:{},异常信息:{}", fileName, e);
                insertLog(errorMsg, ip, user);
            }
        }
    }

}
