package cn.gtmap.realestate.supervise.server.service.impl;


import cn.gtmap.realestate.supervise.entity.*;
import cn.gtmap.realestate.supervise.server.dao.mapper.SaveHistoryMaterialInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.List;


/**
 * 保存“物”历史信息
 */
@Service
public class SaveHistoryMaterialInfoServiceImpl {

    /**
     * 保存“物”历史信息映射类
     */
    @Autowired
    private SaveHistoryMaterialInfoMapper saveHistoryMaterialInfoMapper;

    /**
     * 保存历史信息
     * @param objects
     * @param ywh
     */
    public void saveDetail(List<Object> objects, String ywh){
        if(!ObjectUtils.isEmpty(objects)){
            for (Object obj : objects) {
                mergeIntoBaHZdjbxx(obj,ywh);
                mergeIntoBaHZhjbxx(obj,ywh);
                mergeIntoBaHC(obj,ywh);
                mergeIntoBaHH(obj,ywh);
                mergeIntoBaHLjz(obj,ywh);
                mergeIntoBaHZrz(obj,ywh);
                mergeIntoBaHGzw(obj,ywh);
            }
        }
    }

    /**
     * 备案宗地基本信息历史表
     * @param object
     * @param ywh
     */
    private void mergeIntoBaHZdjbxx(Object object, String ywh){
        if (object instanceof BaZdjbxx) {
            BaHZdjbxx baHZdjbxx = new BaHZdjbxx((BaZdjbxx)object, ywh);
            saveHistoryMaterialInfoMapper.mergeIntoBaHZdjbxx(baHZdjbxx);
        }
    }

    /**
     * 备案宗海基本信息历史表
     * @param object
     * @param ywh
     */
    private void mergeIntoBaHZhjbxx(Object object, String ywh){
        if (object instanceof BaZhjbxx) {
            BaHZhjbxx baHZhjbxx = new BaHZhjbxx((BaZhjbxx)object, ywh);
            saveHistoryMaterialInfoMapper.mergeIntoBaHZhjbxx(baHZhjbxx);
        }
    }

    /**
     * 备案层历史表
     * @param object
     * @param ywh
     */
    private void mergeIntoBaHC(Object object, String ywh){
        if (object instanceof BaC) {
            BaHC baHC = new BaHC((BaC)object, ywh);
            saveHistoryMaterialInfoMapper.mergeIntoBaHC(baHC);
        }
    }

    /**
     * 备案户历史表
     * @param object
     * @param ywh
     */
    private void mergeIntoBaHH(Object object, String ywh){
        if (object instanceof BaH) {
            BaHH baHH = new BaHH((BaH)object, ywh);
            saveHistoryMaterialInfoMapper.mergeIntoBaHH(baHH);
        }
    }

    /**
     * 备案逻辑幢历史表
     * @param object
     * @param ywh
     */
    private void mergeIntoBaHLjz(Object object, String ywh){
        if (object instanceof BaLjz) {
            BaHLjz baHLjz = new BaHLjz((BaLjz)object, ywh);
            saveHistoryMaterialInfoMapper.mergeIntoBaHLjz(baHLjz);
        }
    }

    /**
     * 备案自然幢历史表
     * @param object
     * @param ywh
     */
    private void mergeIntoBaHZrz(Object object, String ywh){
        if (object instanceof BaZrz) {
            BaHZrz baHZrz = new BaHZrz((BaZrz)object, ywh);
            saveHistoryMaterialInfoMapper.mergeIntoBaHZrz(baHZrz);
        }
    }

    /**
     * 备案构筑物历史表
     * @param object
     * @param ywh
     */
    private void mergeIntoBaHGzw(Object object, String ywh){
        if (object instanceof BaGzw) {
            BaHGzw baHGzw = new BaHGzw((BaGzw)object, ywh);
            saveHistoryMaterialInfoMapper.mergeIntoBaHGzw(baHGzw);
        }
    }

}
