package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.common.impl.DataInsertDbService;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaXzqhMapper;
import cn.gtmap.realestate.supervise.server.entity.Rzjl;
import cn.gtmap.realestate.supervise.server.model.CheckResult;
import cn.gtmap.realestate.supervise.server.service.MonitorService;
import cn.gtmap.realestate.supervise.server.sftp.SftpService;
import cn.gtmap.realestate.supervise.server.sftp.WatchDirService;
import cn.gtmap.realestate.supervise.server.utils.XmlUtil;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2018/9/20
 * @description
 */
@Service
public class RzjlManageService {

    String qxdm = AppConfig.getProperty("supersive.server.qhdm");//需要转换的区划代码

    @Autowired
    BaXzqhMapper baXzqhMapper;

    @Autowired
    DataInsertDbService dataInsertDbService;

    @Autowired
    XzqhInfoServiceImpl xzqhInfoService;

    @Autowired
    MonitorService monitorService;

    @Autowired
    WatchDirService watchDirService;

    @Autowired
    SftpService sftpService;

    @Autowired
    EntityMapper entityMapper;

    Map<FileMessage, Rzjl> allResults = Maps.newHashMap();

    public void insertRzjl(Object object, String sjrkcz, String rkjg, String khdbm, String jrxzqdm, String jrdmc, String bwid) {

        Map<FileMessage, Rzjl> temp = Maps.newHashMap();
        getAllResults().clear();
        Rzjl rzjl = new Rzjl();
        rzjl.setSjrkcz(sjrkcz);
        rzjl.setRkjg(rkjg);
        rzjl.setId(bwid);
        FileMessage fileMessage = null;
        Map<String, Object> param = Maps.newHashMap();
        if (object instanceof FileMessage) {
            rzjl.setBwjcjg("数据验证成功");
            rzjl.setXybm(sjrkcz);
            fileMessage = (FileMessage) object;
            param.put("respCode", "0000");
        } else if (object instanceof CheckResult) {
            CheckResult result = (CheckResult) object;
            rzjl.setBwjcjg(result.toString());
            List<String> errors = result.getErrors();
            if (null != errors && !errors.isEmpty()) {
                String errorStr = errors.get(0);
                String errorCode = errorStr.substring(0, errorStr.indexOf(':'));
                rzjl.setXybm(errorCode);
                param.put("respCode", errorCode);
            }
            fileMessage = ((CheckResult) object).getFileMessage();
        }
        if (fileMessage != null) {

            String fileName = fileMessage.getFileName();
            rzjl.setXybwlj(fileName.replace("Biz", "Rep"));
            String areaCode = fileMessage.getAreaCode();

            String exchangeQxdm = XmlUtil.getExhangeQxdm(qxdm, jrxzqdm);
            if (StringUtils.isNotBlank(exchangeQxdm)) {
                areaCode = exchangeQxdm;
            }

            entityMapper.saveOrUpdate(rzjl, rzjl.getId());
            temp.put(fileMessage, rzjl);
            setAllResults(temp);

            param.put("bwxzqdm", areaCode);
        }
        String bdcdyh = fileMessage.getEstateNum();//不动产单元号
        String ywh = dataInsertDbService.getYwh(fileMessage);
        param.put("bdcdyh", bdcdyh);
        param.put("ywh", ywh);
        xzqhInfoService.dataSynchronization(param);//区县Qxtjxx数据同步
        String filename2 = fileMessage.getFileName();
        monitorService.synQxjrjkxx(param, filename2);//区县Qxjrjkxx接入数据同步
        dataInsertDbService.sendSocketMessage(jrxzqdm, jrdmc);//调用发送websocket
        if ("0000".equalsIgnoreCase(sjrkcz)) {
            dataInsertDbService.uploadSftpXml((FileMessage) object, khdbm, bwid, jrxzqdm);//报部
        }
    }

    /**
     * 初始化rzjlb表
     *
     * @param id
     * @param fileName
     */
    public void initRzjl(String id, String fileName, FileMessage fileMessage, String jrddm, String jrdmc, Object object) {
        Rzjl rzjl = new Rzjl();
        rzjl.setId(id);
        rzjl.setJrxzqdm(jrddm);
        rzjl.setCzsj(new Date());
        rzjl.setJrxzqmc(jrdmc);
        rzjl.setYwbwid(id);
        String areaCode = fileMessage.getAreaCode();
        String exchangeQxdm = XmlUtil.getExhangeQxdm(qxdm, jrddm);
        if (StringUtils.isNotBlank(exchangeQxdm)) {
            areaCode = exchangeQxdm;
        }
        if (object instanceof FileMessage) {
            rzjl.setBwjcjg("数据验证成功");
            fileMessage = (FileMessage) object;
        } else if (object instanceof CheckResult) {
            CheckResult result = (CheckResult) object;
            rzjl.setBwjcjg(result.toString());
            List<String> errors = result.getErrors();
            if (null != errors && !errors.isEmpty()) {
                String errorStr = errors.get(0);
                String errorCode = errorStr.substring(0, errorStr.indexOf(':'));
                rzjl.setXybm(errorCode);
            }
            fileMessage = ((CheckResult) object).getFileMessage();
        }
        if (fileMessage != null) {
            rzjl.setXybwlj(fileName.replace("Biz", "Rep"));
        }
        rzjl.setFilename(fileName);
        rzjl.setFilename(fileName);
        rzjl.setBdcdyh(fileMessage.getEstateNum());
        rzjl.setYwbm(fileMessage.getRectype());
        rzjl.setBwxzqdm(areaCode);
        String qhmc = baXzqhMapper.getCityInfoByqhdm(areaCode);
        rzjl.setBwxzqmc(qhmc);
        rzjl.setBwlj(fileName);
        String ywh = dataInsertDbService.getYwh(fileMessage);
        rzjl.setYwh(ywh);
        entityMapper.saveOrUpdate(rzjl, rzjl.getId());
    }

    public void updateRzjlZt(String id, String zt) {
        Rzjl rzjl = new Rzjl();
        rzjl.setId(id);
        rzjl.setSjzt(zt);
        entityMapper.saveOrUpdate(rzjl, rzjl.getId());
    }

    public Map<FileMessage, Rzjl> getAllResults() {
        return allResults;
    }

    public void setAllResults(Map<FileMessage, Rzjl> allResults) {
        this.allResults = allResults;
    }
}
