package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.common.SystemLogService;
import cn.gtmap.realestate.supervise.server.entity.CheckRule;
import cn.gtmap.realestate.supervise.server.service.RuleFiterService;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:Administrator@gtmap.cn">Administrator</a>
 * @version 1.0, 2017/7/4
 * @description
 */
@Service
public class RuleFiterServiceImpl implements RuleFiterService{

        @Autowired
        private EntityMapper entityMapper;

        @Override
        @SystemLogService(description = "修改检查规则", czlx = "修改检查规则")
        public boolean update(CheckRule data, UserAuthDTO userInfos) {
            return entityMapper.saveOrUpdate(data, data.getId()) > 0;
        }


        @Override
        public List<CheckRule> getRuleInfoList(Map param) {
            List<CheckRule> GxDsSyssData = new ArrayList<>();
            ExampleUtil example = new ExampleUtil(CheckRule.class, param);
            example.setOrderByClause("weight ");
            GxDsSyssData = entityMapper.selectByExample(example);
            return GxDsSyssData;
        }

    @Override
    public List<CheckRule> getRuleInfoByCheck() {
        List<CheckRule> GxDsSyssData = new ArrayList<>();
        Map param = new HashMap<>();
        param.put("ischeck", "是");
        ExampleUtil example = new ExampleUtil(CheckRule.class, param);
        example.setOrderByClause("CAST( 'weight' AS DECIMAL )  desc");
        GxDsSyssData = entityMapper.selectByExample(example);
        return GxDsSyssData;
    }

    @Override
    @SystemLogService(description = "修改检查规则顺序", czlx = "修改检查规则顺序")
    public void shortWeight(String shortString,UserAuthDTO userInfos) {
        Map<String,String> shortValues = new HashMap<String,String>();
        String[] shorts = shortString.split(",");
        for(String detail : shorts) {
            shortValues.put(detail.split("\\|")[0], detail.split("\\|")[1]);
        }
        ExampleUtil example = new ExampleUtil(CheckRule.class, null);
        List<CheckRule> rules = entityMapper.selectByExample(example);
        for(CheckRule rule : rules) {
            rule.setWeight(Integer.valueOf(shortValues.get(rule.getWeight()+"")));
            entityMapper.saveOrUpdate(rule, rule.getId());
        }
    }
}
