package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaRzjlMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaSftpMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaXzqhMapper;
import cn.gtmap.realestate.supervise.server.entity.Qxjrjkxx;
import cn.gtmap.realestate.supervise.server.entity.Qxsbjkxx;
import cn.gtmap.realestate.supervise.server.service.MonitorService;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.google.common.collect.Lists;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/13
 * @description 监控统计 业务逻辑层实现类
 */
@Service
public class MonitorServiceImpl implements MonitorService {


    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorServiceImpl.class);

    @Autowired
    BaRzjlMapper baRzjlMapper;


    @Autowired
    BaSftpMapper baSftpMapper;

    @Autowired
    EntityMapper entityMapper;

    @Autowired
    BaXzqhMapper baXzqhMapper;


    /**
     * 接入数量统计
     *
     * @param map
     * @return
     */
    @Override
    public List<Map<String, String>> getJrslData(Map<String, String> map) {

        //查询大市数据
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String, Object>> cityList = baXzqhMapper.getDsxx(qhdm);
        List<Map<String, String>> resList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(cityList)) {
            for (Map<String, Object> temp : cityList) {
                String qhdmStr = (String) temp.get("QHDM");
                if (StringUtils.equals(Constant.HC, qhdmStr)) {//韩城市特殊处理
                    map.put("flag", "1");
                }
                if (StringUtils.equals(Constant.YL, qhdmStr)) {//杨凌示范区特殊处理
                    map.put("flag", "1");
                }
                if (!StringUtils.equals(Constant.YL, qhdmStr) && !StringUtils.equals(Constant.HC, qhdmStr)) {
                    map.put("flag", "");
                }
                map.put("qhdm", qhdmStr);
                Map<String, String> tempMap = baRzjlMapper.getDsxxByQhdm(map);
                Object sbzsl = tempMap.get("SBZSL");
                Object xycgsl = tempMap.get("XYCGSL");
                if (null != sbzsl && null != xycgsl) {
                    tempMap.put("XZQDM", (String) temp.get("QHDM"));
                    tempMap.put("JRXZQMC", (String) temp.get("QHMC"));
                    resList.add(tempMap);
                }
            }
        }
        return resList;
    }

    /**
     * 接入数量统计、提供外围调用
     *
     * @param map
     * @return
     */
    @Override
    public List<LinkedHashMap<String, String>> getJrsl(Map<String, String> map) {

        List<LinkedHashMap<String, String>> sbzlList = baRzjlMapper.getJrsl(map);
        return sbzlList;
    }


    /**
     * 接入情况监控
     *
     * @param map
     * @return
     */

    @Override
    public List<Map<String, String>> getJrqkData(Map<String, String> map) {
        String cityCode = map.get("city");//大市
        String qxCode = map.get("county");//区县

        //全省
        if (StringUtils.isEmpty(cityCode) && StringUtils.isEmpty(qxCode)) {
            List<Map<String, String>> cityDataList = baRzjlMapper.getJrqkjkCityData(map);
            return cityDataList;
        }

        //统计大市
        if (StringUtils.isNotBlank(cityCode) && StringUtils.isEmpty(qxCode)) {
            List<Map<String, String>> cityDataList = baRzjlMapper.getJrqkjkCityData(map);
            return cityDataList;
        }

        //统计区县
        List<Map<String, String>> sbzlList = baRzjlMapper.getJrqkDataMaps(map);
        return sbzlList;
    }

    /**
     * 上报数量
     *
     * @param map
     * @return
     */
    @Override
    public List<Map<String, String>> getSbslData(Map<String, String> map) {

        //查询大市数据
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String, Object>> cityList = baXzqhMapper.getDsxx(qhdm);
        if (CollectionUtils.isNotEmpty(cityList)) {
            List<Map<String, String>> resList = Lists.newArrayList();
            for (Map<String, Object> temp : cityList) {
                String qhdmStr = (String) temp.get("QHDM");
                if (StringUtils.equals(Constant.HC, qhdmStr)) {//韩城市特殊处理
                    map.put("flag", "1");
                }
                if (StringUtils.equals(Constant.YL, qhdmStr)) {//杨凌示范区特殊处理
                    map.put("flag", "1");
                }
                if (!StringUtils.equals(Constant.YL, qhdmStr) && !StringUtils.equals(Constant.HC, qhdmStr)) {
                    map.put("flag", "");
                }
                map.put("qhdm", qhdmStr);
                Map<String, String> tempMap = baSftpMapper.getDsxxByQhdm(map);
                Object sbzsl = tempMap.get("SBZSL");
                Object xycgsl = tempMap.get("XYCGSL");
                if (null != sbzsl && null != xycgsl) {
                    tempMap.put("XZQDM", (String) temp.get("QHDM"));
                    tempMap.put("QHMC", (String) temp.get("QHMC"));
                    resList.add(tempMap);
                }
            }
            if (CollectionUtils.isEmpty(resList) && resList.size() > 0) {
                List<Map<String, String>> sbzlList = baSftpMapper.getSbslInfos(map);
                return sbzlList;
            }
            return resList;
        }

        //查询区县数据
        List<Map<String, String>> resList = baSftpMapper.getSbslInfos(map);
        return resList;
    }

    /**
     * 上报情况监控
     *
     * @param map
     * @return
     */
    @Override
    public List<Map<String, String>> getSbqkData(Map<String, String> map) {
        String cityCode = map.get("city");//大市
        String qxCode = map.get("county");//区县

        //全省
        if (StringUtils.isEmpty(cityCode) && StringUtils.isEmpty(qxCode)) {
            List<Map<String, String>> cityDataList = baSftpMapper.getJrqkjkCityData(map);
            return cityDataList;
        }

        //统计大市
        if (StringUtils.isNotBlank(cityCode) && StringUtils.isEmpty(qxCode)) {
            List<Map<String, String>> cityDataList = baSftpMapper.getJrqkjkCityData(map);
            return cityDataList;
        }
        //统计区县
        List<Map<String, String>> resList = baSftpMapper.getSbqkData(map);
        return resList;
    }

    /**
     * 区县接入监控信息同步
     *
     * @param param
     * @return
     */
    @Override
    public boolean synQxjrjkxx(Map<String, Object> param, String fileName) {

        LOGGER.info("synQxjrjkxx.in !");
        try {
            Date date = new Date();
            param.put("date", date);
            Qxjrjkxx qxjrjkxx = baRzjlMapper.getQxjrjkxx(param);
            String respCode = (String) param.get("respCode");
            if (null == qxjrjkxx) {//初始化数据
                qxjrjkxx = new Qxjrjkxx();
                qxjrjkxx.setId(UUIDGenerator.generate18());
                qxjrjkxx.setXzqdm(String.valueOf(param.get("bwxzqdm")));
                qxjrjkxx.setYear(TimeUtils.dateToStr(date, "yyyy"));
                qxjrjkxx.setMonth(TimeUtils.dateToStr(date, "MM"));
                qxjrjkxx.setDay(TimeUtils.dateToStr(date, "dd"));
                qxjrjkxx.setJrsl("1");
                qxjrjkxx.setSjgxsj(new Date());
                if (StringUtils.equals(respCode, "0000")) {
                    qxjrjkxx.setCgsl("1");
                    qxjrjkxx.setSbsl("0");
                } else {
                    qxjrjkxx.setCgsl("0");
                    qxjrjkxx.setSbsl("1");
                }
                Qxjrjkxx temp = baRzjlMapper.getQxjrjkxx(param);
                if (null != temp) {
                    updateQxjrjkxx(temp, respCode, param, fileName);
                } else {
                    baRzjlMapper.insertQxjrjkxx(qxjrjkxx);
                }
            } else {
                updateQxjrjkxx(qxjrjkxx, respCode, param, fileName);
            }
        } catch (Exception e) {
            LOGGER.error("synQxjrjkxx.Exception in!{}", e);
            synQxjrjkxx(param, fileName);
        }
        return true;
    }

    public synchronized void updateQxjrjkxx(Qxjrjkxx qxjrjkxx, String respCode, Map<String, Object> param, String fileName) {
        try {
            String jrsl = qxjrjkxx.getJrsl();
            String cgsl = qxjrjkxx.getCgsl();
            String sbsl = qxjrjkxx.getSbsl();
            int jrslNum = Integer.parseInt(jrsl) + 1;
            qxjrjkxx.setJrsl(String.valueOf(jrslNum));
            qxjrjkxx.setSjgxsj(new Date());
            boolean flag = false;
            if (StringUtils.equals(respCode, "0000")) {
                int cgslTemp = baRzjlMapper.getCgsl(param);
                if (cgslTemp <= 1) {
                    flag = true;
                    int cgslNum = Integer.parseInt(cgsl) + 1;
                    qxjrjkxx.setCgsl(String.valueOf(cgslNum));
                }
            } else {
                int sbslTemp = baRzjlMapper.getSbsl(param);
                if (sbslTemp <= 1) {
                    flag = true;
                    int sbslNum = null == sbsl ? 0 : Integer.parseInt(sbsl) + 1;
                    qxjrjkxx.setSbsl(String.valueOf(sbslNum));
                }
            }
            if (flag) {
                LOGGER.info("接入统计表统计信息，入库前统计数量：{}，文件名：{}", jrslNum, fileName);
                baRzjlMapper.updateQxjrjkxx(qxjrjkxx);
            }
        } catch (Exception e) {
            LOGGER.error("updateQxjrjkxx.Exception in!{}", e);
        }

    }

    /**
     * 区县上报监控信息同步
     *
     * @param param
     * @return
     */
    @Override
    public boolean synQxsbjkxx(Map<String, Object> param, String fileName) {

        Date date = new Date();
        param.put("date", date);
        try {
            Qxsbjkxx qxsbjkxx = baRzjlMapper.getQxsbjkxx(param);
            if (null == qxsbjkxx) {//初始化数据
                qxsbjkxx = new Qxsbjkxx();
                qxsbjkxx.setId(UUIDGenerator.generate18());
                qxsbjkxx.setXzqdm(String.valueOf(param.get("bwxzqdm")));
                qxsbjkxx.setYear(TimeUtils.dateToStr(date, "yyyy"));
                qxsbjkxx.setMonth(TimeUtils.dateToStr(date, "MM"));
                qxsbjkxx.setDay(TimeUtils.dateToStr(date, "dd"));
                qxsbjkxx.setJrsl("1");
                qxsbjkxx.setCgsl("");
                qxsbjkxx.setSjgxsj(new Date());
                Qxsbjkxx temp = baRzjlMapper.getQxsbjkxx(param);
                if (null != temp) {
                    updateQxsbjkxx(temp, param, fileName);
                } else {
                    baRzjlMapper.insertQxsbjkxx(qxsbjkxx);
                }
            } else {
                updateQxsbjkxx(qxsbjkxx, param, fileName);
            }
        } catch (Exception e) {
            LOGGER.error("synQxsbjkxx.Exception!{}", e);
            synQxsbjkxx(param, fileName);
        }
        return true;
    }

    public synchronized void updateQxsbjkxx(Qxsbjkxx qxsbjkxx, Map<String, Object> param, String fileName) {

        int sbsl = baSftpMapper.getSbsl(param);
        if (sbsl < 1) {

            String jrsl = qxsbjkxx.getJrsl();
            int jrslNum = Integer.parseInt(jrsl);
            LOGGER.info("ba_qxsbjkxx上报总数量统计更新：{},更新前数量：{}", fileName, jrslNum);
            qxsbjkxx.setJrsl(String.valueOf(jrslNum + 1));
            qxsbjkxx.setSjgxsj(new Date());
            baRzjlMapper.updateQxsbjkxx(qxsbjkxx);
        }
    }

    /**
     * 根据父代码查询对应区县接入数量信息
     *
     * @param param
     * @return
     */
    @Override
    public List<Map<String, String>> getQxxxByFdm(Map<String, String> param) {
        List<Map<String, String>> resList = baRzjlMapper.getQxxxByFdm(param);
        return resList;
    }


    /**
     * 根据父代码查询对应区县接入数量信息
     *
     * @param param
     * @return
     */
    @Override
    public List<Map<String, String>> getQxSbslByFdm(Map<String, String> param) {
        List<Map<String, String>> resList = baSftpMapper.getQxxxByFdm(param);
        return resList;
    }

    /**
     * 接入上报数量统计
     *
     * @param param
     * @return
     */
    @Override
    public List<Map<String, String>> getJrsbslData(Map<String, String> param) {

        //查询大市数据
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String, Object>> cityList = baXzqhMapper.getDsxx(qhdm);
        if (CollectionUtils.isNotEmpty(cityList)) {
            List<Map<String, String>> resList = Lists.newArrayList();
            for (Map<String, Object> temp : cityList) {
                String qhdmStr = (String) temp.get("QHDM");
                if (StringUtils.equals(Constant.HC, qhdmStr)) {//韩城市特殊处理
                    param.put("flag", "1");
                }
                if (StringUtils.equals(Constant.YL, qhdmStr)) {//杨凌示范区特殊处理
                    param.put("flag", "1");
                }
                if (!StringUtils.equals(Constant.YL, qhdmStr) && !StringUtils.equals(Constant.HC, qhdmStr)) {
                    param.put("flag", "");
                }
                param.put("qhdm", qhdmStr);
                Map<String, String> tempMap = baRzjlMapper.getJrsbslData(param);
                Object sbzsl = tempMap.get("JRSL");
                Object xycgsl = tempMap.get("JRCGSL");
                if (null != sbzsl && null != xycgsl) {
                    tempMap.put("XZQDM", (String) temp.get("QHDM"));
                    tempMap.put("JRXZQMC", (String) temp.get("QHMC"));
                    resList.add(tempMap);
                }
            }
            if (CollectionUtils.isEmpty(resList)) {
                List<Map<String, String>> sbzlList = baRzjlMapper.getJrslInfos(param);
                return sbzlList;
            }
            return resList;
        }

        //查询区县数据
        List<Map<String, Object>> qxxxList = baXzqhMapper.getQxxxByFdm(qhdm);
        if (CollectionUtils.isNotEmpty(qxxxList)) {
            List<Map<String, String>> resList = Lists.newArrayList();
            for (Map<String, Object> temp : qxxxList) {
                {
                    String qhdmStr = (String) temp.get("QHDM");
                    if (StringUtils.equals(Constant.HC, qhdmStr)) {//韩城市特殊处理
                        param.put("flag", "1");
                    }
                    if (StringUtils.equals(Constant.YL, qhdmStr)) {//杨凌示范区特殊处理
                        param.put("flag", "1");
                    }
                    if (!StringUtils.equals(Constant.YL, qhdmStr) && !StringUtils.equals(Constant.HC, qhdmStr)) {
                        param.put("flag", "");
                    }
                    param.put("qhdm", qhdmStr);
                    Map<String, String> tempMap = baRzjlMapper.getQxJrsbslData(param);
                    Object sbzsl = tempMap.get("JRSL");
                    Object xycgsl = tempMap.get("JRCGSL");
                    if (null != sbzsl && null != xycgsl) {
                        tempMap.put("XZQDM", (String) temp.get("QHDM"));
                        tempMap.put("JRXZQMC", (String) temp.get("QHMC"));
                        resList.add(tempMap);
                    }
                }
            }
            if (CollectionUtils.isEmpty(resList)) {
                List<Map<String, String>> sbzlList = baRzjlMapper.getJrslInfos(param);
                return sbzlList;
            }
            return resList;
        }
        return null;
    }


    /**
     * 根据父代码查询对应区县接入数量信息
     *
     * @param param
     * @return
     */
    @Override
    public List<Map<String, String>> getJrsbslByFdm(Map<String, String> param) {
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String, String>> resList = new ArrayList<>();
        if("32".equals(qhdm.substring(0, 2))){
            resList = baRzjlMapper.getJrsbslByFdm(param);
        }else {
            resList = baRzjlMapper.getJrsbslByFdmNotRemoveNull(param);
        }

        return resList;
    }

    /**
     * 接入情况监控
     *
     * @param map
     * @return
     */

    @Override
    public List<Map<String, String>> getJrsbqkData(Map<String, String> map) {

        String qhdm = AppConfig.getProperty("region.qhdm");
        String cityCode = map.get("city");//大市
        String qxCode = map.get("county");//区县

        List<Map<String, String>> cityDataList = new ArrayList<>();

        //全省
        if (StringUtils.isEmpty(cityCode) && StringUtils.isEmpty(qxCode)) {

            if("32".equals(qhdm.substring(0, 2))){
                cityDataList = baRzjlMapper.getJrsbqkData(map);
            }else {
                cityDataList = baRzjlMapper.getJrsbqkDataNotRemoveNull(map);
            }
            return cityDataList;
        }

        //统计大市
        if (StringUtils.isNotBlank(cityCode) && StringUtils.isEmpty(qxCode)) {
            if("32".equals(qhdm.substring(0, 2))){
                cityDataList = baRzjlMapper.getJrsbqkData(map);
            }else {
                cityDataList = baRzjlMapper.getJrsbqkDataNotRemoveNull(map);
            }
            return cityDataList;
        }

        //统计区县
        if("32".equals(qhdm.substring(0, 2))){
            cityDataList = baRzjlMapper.getJrsbqkData(map);
        }else {
            cityDataList = baRzjlMapper.getJrsbqkDataNotRemoveNull(map);
        }
        return cityDataList;
    }
}
