package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.model.MessageServer;
import cn.gtmap.realestate.supervise.model.Respond;
import cn.gtmap.realestate.supervise.server.common.SystemLogService;
import cn.gtmap.realestate.supervise.server.common.impl.DataInsertDbService;
import cn.gtmap.realestate.supervise.server.common.impl.ObjectServiceImpl;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaLogMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaSftpMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaYwbmMapper;
import cn.gtmap.realestate.supervise.server.entity.Log;
import cn.gtmap.realestate.supervise.server.entity.Xzqh;
import cn.gtmap.realestate.supervise.server.es.SearchService;
import cn.gtmap.realestate.supervise.server.rabbitmq.SendMessage;
import cn.gtmap.realestate.supervise.server.rocketmq.ProducerMsg;
import cn.gtmap.realestate.supervise.server.service.LogService;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import cn.gtmap.realestate.supervise.utils.XmlUtil;
import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.*;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/10
 * @description 日志接口实现类
 */
@Service
public class LogServiceImpl implements LogService {

    private static final Logger LOGGER = LoggerFactory.getLogger(LogServiceImpl.class);

    @Autowired
    private EntityMapper entityMapper;

    @Autowired
    private BaYwbmMapper baYwbmMapper;

    @Autowired
    private BaLogMapper baLogMapper;

    @Autowired
    private BaSftpMapper baSftpMapper;

    @Autowired
    private ObjectServiceImpl objectService;

    @Autowired
    private CheckRepeatService checkRepeatService;

    @Autowired
    private SearchService searchService;

//    @Autowired
    private SendMessage sendMessage;

    @Autowired
    private DataInsertDbService dataInsertDbService;

    private ProducerMsg producerMsg;

    /**
     * 获取业务编码
     *
     * @return
     */
    @Override
    public List<Map<String, String>> getYwbmInfos() {
        return baYwbmMapper.getYwbmInfos();
    }

    /**
     * 获取行政区划信息
     *
     * @return
     */
    @Override
    public List<Map<String, String>> queryXzqhInfos() {
        Map map = new HashMap();
        ExampleUtil example = new ExampleUtil(Xzqh.class, map);
        return entityMapper.selectByExample(example);
    }


    /**
     * 插入中心日志表
     *
     * @param log
     */
    @Override
    public void insertBalog(Log log) {
        entityMapper.saveOrUpdate(log, log.getId());
    }



    /**
     * 中心日志查看操作内容
     *
     * @param cznrid
     * @return
     */
    @Override
    public Map<String, String> queryCznrInfos(String cznrid) {
        return baLogMapper.queryCznrInfos(cznrid);
    }


    /**
     * 操作类型字典表查询
     *
     * @return
     */
    @Override
    public List<Map<String, String>> queryCzlx() {

        return baLogMapper.queryCzlx();
    }


    /**
     * 插入中心日志表
     * @param bizId
     * @param qxdm
     */
    public void insertLog(String bizId, String flag, String recType, String ywh, String qxdm) {
        //重新入库
        String cznr = "";
        String czlx = "";
        if (StringUtils.isNotBlank(flag) && StringUtils.equals("1", flag)) {
            cznr = "操作用户:" + bizId + "," + "业务类型:" + recType + ",业务号:" + ywh + ",重新入库未能注销原权利";
            czlx = "重新入库注销原权利";
        } else {//非重新入库
            cznr = "操作用户:" + bizId + "," + "业务类型:" + recType + ",业务号:" + ywh + ",未能注销原权利";
            czlx = "注销原权利";
        }
        Log logger = new Log();
        logger.setId(UUID.randomUUID().toString());
        logger.setCzlx(czlx);//"注销原权利"
        logger.setIp(qxdm);
        logger.setCznr(cznr);
        logger.setCzrq(new Date());
        logger.setYhmc(bizId);
        entityMapper.saveOrUpdate(logger, logger.getId());
    }


    /**
     * 上图失败记录日志
     * @param bdcdyh
     * @param cznr
     */
    public void insertStsbLog(String bdcdyh, String cznr) {
        Log logger = new Log();
        logger.setId(UUID.randomUUID().toString());
        logger.setCzlx("上图失败");
        try {
            //获取的是本地的IP地址
            InetAddress address = InetAddress.getLocalHost();
            String hostAddress = address.getHostAddress();
            logger.setIp(hostAddress);
            String czxx = "操作用户:系统,bdcdyh:"+bdcdyh+","+cznr;
            logger.setCznr(czxx);
            logger.setCzrq(new Date());
            logger.setYhmc("系统");
            entityMapper.saveOrUpdate(logger, logger.getId());
        } catch (UnknownHostException e) {
            LOGGER.error("insertStsbLog.UnknownHostException!{}",e.getMessage());
            throw  new AppException(e,2023);
        }
    }


    @Override
    @SystemLogService(description = "入库数据删除", czlx = "入库数据删除")
    public void delBwInfos(Map<String, String> param, UserAuthDTO userAuthDTO)  {
        String bwlj = param.get("bwlj");
        String bdcdyh = param.get("bdcdyh");
        String ywbm = param.get("ywbm");
        String fileName = param.get("fileName");
        String areaCode = param.get("sbcode");
        String id = param.get("id");
        String xmlInfos = searchService.mainGetData(bwlj, "","","","");
        List<String> ywbwIdList = searchService.getBwidByFileName(fileName,"","");//业务报文ID
        if(CollectionUtils.isNotEmpty(ywbwIdList)){
            for (String ywbwid:ywbwIdList){
                searchService.delData("Biz", ywbwid);
            }
        }
        List<String> xybwIdList = searchService.getBwidByFileName(fileName.replace("Biz","Rep"),"","");//响应报文ID
        if(CollectionUtils.isNotEmpty(xybwIdList)){
            for (String xybwid:xybwIdList){
                searchService.delData("Rep", xybwid);
            }
        }
        List<Object> objectList = objectService.getObject(xmlInfos, ywbm, fileName, areaCode, bdcdyh);
        String serverQueue = AppConfig.getProperty("supervise.rabbitmq.queue");
        checkRepeatService.serveDetail(objectList);
        baSftpMapper.delBwInfos(id);


        String bizMsgID = "";
        if(StringUtils.isNotBlank(xmlInfos)){
            Map<String,String> head=null ;
            try {
                head= XmlUtil.getParamValueByElement(xmlInfos, "Head");
            } catch (DocumentException e) {
                LOGGER.error("delBwInfos.DocumentException!{}",e);
            }
            if (null != head) {
                bizMsgID = head.get("BizMsgID");
            }
        }else{
            bizMsgID = fileName.substring(2,fileName.indexOf('.'));
        }
        sendRespMessage(bizMsgID,fileName,areaCode,serverQueue);
    }

    private void sendRespMessage(String bizMsgId,String fileName,String areaCode,String queueName){
        Respond responseMessage = new Respond();
        responseMessage.setSuccessFlag("2");
        responseMessage.setCertID("");
        responseMessage.setBizMsgID(bizMsgId);
        responseMessage.setAdditionalData2("");
        responseMessage.setAdditionalData("");
        responseMessage.setQRCode("");
        responseMessage.setResponseInfo("上报失败");
        responseMessage.setResponseCode("2026");
        responseMessage.setServerName(queueName);
        responseMessage.setFileName(fileName);
        responseMessage.setAreaCode(areaCode);
        MessageServer messageServer = new MessageServer();
        messageServer.setResponseMessage(responseMessage);
        messageServer.setServerQueue(queueName);
        boolean envFlag = dataInsertDbService.getEnv();
        if (envFlag) {
            if (null == producerMsg) {
                WebApplicationContext wac = ContextLoader.getCurrentWebApplicationContext();
                producerMsg = (ProducerMsg) wac.getBean(ProducerMsg.class);
            }
            producerMsg.sendMsg(JSON.toJSONString(messageServer), queueName,fileName);
        } else {
            if (null == sendMessage) {
                WebApplicationContext wac = ContextLoader.getCurrentWebApplicationContext();
                sendMessage = (SendMessage) wac.getBean(SendMessage.class);
            }
            sendMessage.sendDirectMsg(JSON.toJSONString(messageServer), queueName);
        }
    }
}
