package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.realestate.supervise.server.dao.mapper.LeaderDeskSupportMapper;
import cn.gtmap.realestate.supervise.server.service.LeaderDeskSupportService;
import com.google.common.collect.Maps;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service("leaderDeskSupportService")
public class LeaderDeskSupportServiceImpl implements LeaderDeskSupportService {

    /**
     * 日志
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderDeskSupportServiceImpl.class);

    /**
     * 领导桌面
     */
    @Autowired
    private LeaderDeskSupportMapper leaderDeskSupportMapper;

    /**
     * 获取上报总数
     * @param xzqhdm
     * @param endDate
     * @return
     */
    @Override
    public Map<String, Object> getSbCount(String xzqhdm, String endDate) {
        Map<String, Object> sbCountMap = Maps.newHashMap();
        try {
            sbCountMap = leaderDeskSupportMapper.getSbCount(xzqhdm, endDate);
        } catch (DataAccessException e) {
            LOGGER.error(DataAccessException.class.getName(), e);
        }
        return sbCountMap;
    }

    /**
     * 获取接入成功数和成功率
     * @param xzqhdm
     * @param endDate
     * @return
     */
    @Override
    public Map<String, Object> getJrCount(String xzqhdm, String endDate) {
        Map<String, Object> jrCountMap = Maps.newHashMap();
        try {
            jrCountMap = leaderDeskSupportMapper.getJrCount(xzqhdm, endDate);
            if(jrCountMap.containsKey("cgl") && StringUtils.isNotBlank(MapUtils.getString(jrCountMap,"cgl"))){
                jrCountMap.put("cgl", MapUtils.getString(jrCountMap,"cgl").split("\\.")[0]);
            }
        } catch (DataAccessException e) {
            LOGGER.error(DataAccessException.class.getName(), e);
        }
        return jrCountMap;
    }
}
