package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.realestate.supervise.server.dao.mapper.KxlMapper;
import cn.gtmap.realestate.supervise.server.service.KxlService;
import cn.gtmap.realestate.supervise.server.utils.ExportExcelUtils;
import cn.gtmap.realestate.supervise.server.utils.ExportExcelUtilsSX;
import cn.gtmap.realestate.supervise.utils.OperationalLogUtil;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0 2019-7-19
 * @auther <a href="mailto:xutao@gtmap.cn">xutao</a>
 * @description
 */
@Service
public class KxlServiceImpl implements KxlService {

    /**
     * 日志打印对象
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(KxlServiceImpl.class);

    private static final String CHILDREN = "children";

    private static final String provinceDm = AppConfig.getProperty("region.qhdm");

    /**
     * 空项率底层映射
     */
    @Autowired
    private KxlMapper kxlMapper;

    /**
     * 获取市级和县级建设用地使用权空项信息
     *
     * @param param
     * @return
     */
    @Override
    public List<Map<String, Object>> listCityAndCountyJsydsyq(Map<String, Object> param) {
        List<Map<String, Object>> cityJsydsqyList = null;
        List<Map<String, Object>> countyJsydsqyList = null;
        try {
            cityJsydsqyList = kxlMapper.listCityJsydsyq(param);
            listJsydsyqCal(cityJsydsqyList);
            countyJsydsqyList = kxlMapper.listCountyJsydsyq(param);
            listJsydsyqCal(countyJsydsqyList);
        } catch (DataAccessException e) {
            LOGGER.error("listCityAndCountyJsydsyq:{}", e.getMessage());
        }
        List<Map<String, Object>> resultList = mergeCityAndCountyList(cityJsydsqyList, countyJsydsqyList);
        return resultList;
    }

    /**
     * 获取市级和县级房屋使用权空项信息
     *
     * @param param
     * @return
     */
    @Override
    public List<Map<String, Object>> listCityAndCountyFwsyq(Map<String, Object> param) {
        List<Map<String, Object>> cityFwsyqList = null;
        List<Map<String, Object>> countyFwsqyList = null;
        try {
            cityFwsyqList = kxlMapper.listCityFwsyq(param);
            listFwsyqCal(cityFwsyqList);
            countyFwsqyList = kxlMapper.listCountyFwsyq(param);
            listFwsyqCal(countyFwsqyList);
        } catch (DataAccessException e) {
            LOGGER.error("listCityAndCountyFwsyq:{}", e.getMessage());
        }
        List<Map<String, Object>> resultList = mergeCityAndCountyList(cityFwsyqList, countyFwsqyList);
        return resultList;
    }

    /**
     * 获取市级和县级查封空项信息
     *
     * @param param
     * @return
     */
    @Override
    public List<Map<String, Object>> listCityAndCountyCf(Map<String, Object> param) {
        List<Map<String, Object>> cityCfList = null;
        List<Map<String, Object>> countyCfList = null;
        try {
            cityCfList = kxlMapper.listCityCf(param);
            listCfCal(cityCfList);
            countyCfList = kxlMapper.listCountyCf(param);
            listCfCal(countyCfList);
        } catch (DataAccessException e) {
            LOGGER.error("listCityAndCountyCf:{}", e.getMessage());
        }
        List<Map<String, Object>> resultList = mergeCityAndCountyList(cityCfList, countyCfList);
        return resultList;
    }

    /**
     * 获取市级和县级抵押空项信息
     *
     * @param param
     * @return
     */
    @Override
    public List<Map<String, Object>> listCityAndCountyDy(Map<String, Object> param) {
        List<Map<String, Object>> cityDyList = null;
        List<Map<String, Object>> countyDyList = null;
        try {
            cityDyList = kxlMapper.listCityDy(param);
            listDyCal(cityDyList);
            countyDyList = kxlMapper.listCountyDy(param);
            listDyCal(countyDyList);
        } catch (DataAccessException e) {
            LOGGER.error("listCityAndCountyDy:{}", e.getMessage());
        }
        List<Map<String, Object>> resultList = mergeCityAndCountyList(cityDyList, countyDyList);
        return resultList;
    }

    /**
     * 获取市级和县级预告空项信息
     *
     * @param param
     * @return
     */
    @Override
    public List<Map<String, Object>> listCityAndCountyYg(Map<String, Object> param) {
        List<Map<String, Object>> cityYgList = null;
        List<Map<String, Object>> countyYgList = null;
        try {
            cityYgList = kxlMapper.listCityYg(param);
            listYgCal(cityYgList);
            countyYgList = kxlMapper.listCountyYg(param);
            listYgCal(countyYgList);
        } catch (DataAccessException e) {
            LOGGER.error("listCityAndCountyYg:{}", e.getMessage());
        }
        List<Map<String, Object>> resultList = mergeCityAndCountyList(cityYgList, countyYgList);
        return resultList;
    }

    /**
     * 合并市与县数据
     */
    private List<Map<String, Object>> mergeCityAndCountyList(
            List<Map<String, Object>> city, List<Map<String, Object>> county) {
        List<Map<String, Object>> childrenList;
        if (CollectionUtils.isNotEmpty(city) && CollectionUtils.isNotEmpty(county)) {
            for (int i = 0; i < city.size(); i++) {
                childrenList = Lists.newArrayList();
                for (int j = 0; j < county.size(); j++) {
                    if (StringUtils.equals(MapUtils.getString(county.get(j), "CITY_QHDM")
                            , MapUtils.getString(city.get(i), "CITY_QHDM"))) {
                        childrenList.add(county.get(j));
                    }
                }
                city.get(i).put(CHILDREN, childrenList);
            }
        }
        return city;
    }

    /**
     * 获取市级和县级空项率信息
     *
     * @param param
     * @return
     */
    @Override
    public List<Map<String, Object>> listCityAndCountyData(Map<String, Object> param, boolean isXhAll) {
        List<Map<String, Object>> cityJsydsqyList = null;
        List<Map<String, Object>> cityFwsyqList = null;
        List<Map<String, Object>> cityCfList = null;
        List<Map<String, Object>> cityDyList = null;
        List<Map<String, Object>> cityYgList = null;

        List<Map<String, Object>> countyJsydsqyList = null;
        List<Map<String, Object>> countyFwsqyList = null;
        List<Map<String, Object>> countyCfList = null;
        List<Map<String, Object>> countyDyList = null;
        List<Map<String, Object>> countyYgList = null;

        try {
            cityJsydsqyList = kxlMapper.listCityJsydsyq(param);
            cityFwsyqList = kxlMapper.listCityFwsyq(param);
            cityCfList = kxlMapper.listCityCf(param);
            cityDyList = kxlMapper.listCityDy(param);
            cityYgList = kxlMapper.listCityYg(param);

            countyJsydsqyList = kxlMapper.listCountyJsydsyq(param);
            countyFwsqyList = kxlMapper.listCountyFwsyq(param);
            countyCfList = kxlMapper.listCountyCf(param);
            countyDyList = kxlMapper.listCountyDy(param);
            countyYgList = kxlMapper.listCountyYg(param);

            listJsydsyqCal(cityJsydsqyList);
            listFwsyqCal(cityFwsyqList);
            listCfCal(cityCfList);
            listDyCal(cityDyList);
            listYgCal(cityYgList);

            listJsydsyqCal(countyJsydsqyList);
            listFwsyqCal(countyFwsqyList);
            listCfCal(countyCfList);
            listDyCal(countyDyList);
            listYgCal(countyYgList);

        } catch (DataAccessException e) {
            LOGGER.error("listCityAndCountyData:{}", e.getMessage());
        }

        mergeColCityData(cityJsydsqyList, cityFwsyqList);
        mergeColCityData(cityJsydsqyList, cityCfList);
        mergeColCityData(cityJsydsqyList, cityDyList);
        mergeColCityData(cityJsydsqyList, cityYgList);

        mergeColCountyData(countyJsydsqyList, countyFwsqyList);
        mergeColCountyData(countyJsydsqyList, countyCfList);
        mergeColCountyData(countyJsydsqyList, countyDyList);
        mergeColCountyData(countyJsydsqyList, countyYgList);

        appendChildrenList(cityJsydsqyList, countyJsydsqyList, isXhAll);

        return cityJsydsqyList;
    }

    @Override
    public List<Map<String, Object>> listCityAndCountyDataFinal(Map<String, Object> param, boolean isXhAll) {
        List<Map<String, Object>> cityJsydsqyList = null;
        List<Map<String, Object>> cityFwsyqList = null;
        List<Map<String, Object>> cityCfList = null;
        List<Map<String, Object>> cityDyList = null;
        List<Map<String, Object>> cityYgList = null;

        List<Map<String, Object>> countyJsydsqyList = null;
        List<Map<String, Object>> countyFwsqyList = null;
        List<Map<String, Object>> countyCfList = null;
        List<Map<String, Object>> countyDyList = null;
        List<Map<String, Object>> countyYgList = null;

        List<String> finalKeys = Lists.newArrayList();
        finalKeys.add("JSYDSQY_FINAL_VAL");
        finalKeys.add("FWSYQ_FINAL_VAL");
        finalKeys.add("DY_FINAL_VAL");
        finalKeys.add("YG_FINAL_VAL");
        finalKeys.add("CF_FINAL_VAL");

        try {
            cityJsydsqyList = kxlMapper.listCityJsydsyq(param);
            cityFwsyqList = kxlMapper.listCityFwsyq(param);
            cityCfList = kxlMapper.listCityCf(param);
            cityDyList = kxlMapper.listCityDy(param);
            cityYgList = kxlMapper.listCityYg(param);

            countyJsydsqyList = kxlMapper.listCountyJsydsyq(param);
            countyFwsqyList = kxlMapper.listCountyFwsyq(param);
            countyCfList = kxlMapper.listCountyCf(param);
            countyDyList = kxlMapper.listCountyDy(param);
            countyYgList = kxlMapper.listCountyYg(param);

            listJsydsyqCal(cityJsydsqyList);
            listFwsyqCal(cityFwsyqList);
            listCfCal(cityCfList);
            listDyCal(cityDyList);
            listYgCal(cityYgList);

            listJsydsyqCal(countyJsydsqyList);
            listFwsyqCal(countyFwsqyList);
            listCfCal(countyCfList);
            listDyCal(countyDyList);
            listYgCal(countyYgList);

            listJsydsyqCalFinal(cityJsydsqyList);
            listFwsyqCalFinal(cityFwsyqList);
            listCfCalFinal(cityCfList);
            listDyCalFinal(cityDyList);
            listYgCalFinal(cityYgList);

            listJsydsyqCalFinal(countyJsydsqyList);
            listFwsyqCalFinal(countyFwsqyList);
            listCfCalFinal(countyCfList);
            listDyCalFinal(countyDyList);
            listYgCalFinal(countyYgList);

        } catch (DataAccessException e) {
            LOGGER.error("listCityAndCountyDataFinal:{}", e.getMessage());
        }

        mergeColCityData(cityJsydsqyList, cityFwsyqList);
        mergeColCityData(cityJsydsqyList, cityCfList);
        mergeColCityData(cityJsydsqyList, cityDyList);
        mergeColCityData(cityJsydsqyList, cityYgList);

        mergeColCountyData(countyJsydsqyList, countyFwsqyList);
        mergeColCountyData(countyJsydsqyList, countyCfList);
        mergeColCountyData(countyJsydsqyList, countyDyList);
        mergeColCountyData(countyJsydsqyList, countyYgList);

        calZhpf(cityJsydsqyList, finalKeys, "0.00");
        calZhpf(countyJsydsqyList, finalKeys, "0.00");

        appendChildrenList(cityJsydsqyList, countyJsydsqyList, isXhAll);

        return cityJsydsqyList;
    }

    /**
     * 保存统计数据
     *
     * @param param
     */
    @Override
    public void saveCityAndCountyData(Map<String, Object> param) {
        kxlMapper.updateJsydsyqSbzt(param);
        kxlMapper.updateFwsyqSbzt(param);
        kxlMapper.updateCfSbzt(param);
        kxlMapper.updateDySbzt(param);
        kxlMapper.updateYgSbzt(param);
    }

    /**
     * 行政区划
     *
     * @param qhdm
     * @return
     */
    @Override
    public List<Map<String, Object>> listXzqh(String qhdm) {
        List<Map<String, Object>> resultList = null;
        try {
            resultList = kxlMapper.listXzqh(qhdm);
        } catch (DataAccessException e) {
            LOGGER.error("listXzqh:{}", e.getMessage());
        }
        return resultList;
    }

    /**
     * 导出 excel
     *
     * @param param
     * @param response
     */
    @Override
    public void exportExcelKxl(Map<String, Object> param, HttpServletResponse response, HttpServletRequest request) {
        String regionLevel = CommonUtil.formatEmptyValue(param.get("regionLevel"));
        /**
         * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
         * @description 省级用户使用新版本，市级用户使用原来的老模板（江苏模板）。
         */
        String modelName = "kxl";

        if (provinceDm.substring(0, 2).equals("32") || !StringUtils.equals(regionLevel,"省级")) {
            List<Map<String, Object>> resultList = listCityAndCountyData(param, true);
            resultList = appendChildrenToCityList(resultList);
            String kssj = MapUtils.getString(param, "kssj");
            String jssj = MapUtils.getString(param, "jssj");

            kssj = DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(kssj).toString("yyyy年MM月dd日");
            jssj = DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(jssj).toString("yyyy年MM月dd日");
            StringBuilder sb = new StringBuilder();
            sb.append(MapUtils.getString(param, "provinceName"));
            sb.append("不动产登记增量数据相关字段空项率统计（");
            sb.append(kssj).append("至").append(jssj).append("）");

            List<String> kxlKeysList = Lists.newArrayList();
            kxlKeysList.add("XH");
            kxlKeysList.add("QHMC");
            kxlKeysList.add("YT_KXL");
            kxlKeysList.add("YT_VAL");
            kxlKeysList.add("QLXZ_KXL");
            kxlKeysList.add("QLXZ_VAL");
            kxlKeysList.add("QLSDFS_KXL");
            kxlKeysList.add("QLSDFS_VAL");
            kxlKeysList.add("GYQK_KXL");
            kxlKeysList.add("GYQK_VAL");
            kxlKeysList.add("DB_KXL");
            kxlKeysList.add("DB_VAL");
            kxlKeysList.add("RJL_KXL");
            kxlKeysList.add("RJL_VAL");

            kxlKeysList.add("FWGYQK_KXL");
            kxlKeysList.add("FWGYQK_VAL");
            kxlKeysList.add("FWFWXZ_KXL");
            kxlKeysList.add("FWFWXZ_VAL");
            kxlKeysList.add("FWJG_KXL");
            kxlKeysList.add("FWJG_VAL");
            kxlKeysList.add("JGSJ_KXL");
            kxlKeysList.add("JGSJ_VAL");

            kxlKeysList.add("ZWLXQX_KXL");
            kxlKeysList.add("ZWLXQX_VAL");
            kxlKeysList.add("ZGQQDSSSE_KXL");
            kxlKeysList.add("ZGQQDSSSE_VAL");
            kxlKeysList.add("YBDY_ZJDYZL_KXL");
            kxlKeysList.add("YBDY_ZJDYZL_VAL");
            kxlKeysList.add("YBDY_ZJDYFW_KXL");
            kxlKeysList.add("YBDY_ZJDYFW_VAL");
            kxlKeysList.add("ZGDY_ZJDYZL_KXL");
            kxlKeysList.add("ZGDY_ZJDYZL_VAL");
            kxlKeysList.add("ZGDY_ZJDYFW_KXL");
            kxlKeysList.add("ZGDY_ZJDYFW_VAL");
            kxlKeysList.add("ZXDYYY_KXL");
            kxlKeysList.add("ZXDYYY_VAL");
            kxlKeysList.add("ZXSJ_KXL");
            kxlKeysList.add("ZXSJ_VAL");

            kxlKeysList.add("YWRZJZL_KXL");
            kxlKeysList.add("YWRZJZL_VAL");
            kxlKeysList.add("YWRZJH_KXL");
            kxlKeysList.add("YWRZJH_VAL");
            kxlKeysList.add("GHYT_KXL");
            kxlKeysList.add("GHYT_VAL");
            kxlKeysList.add("FWXZ_KXL");
            kxlKeysList.add("FWXZ_VAL");

            kxlKeysList.add("JFJG_KXL");
            kxlKeysList.add("JFJG_VAL");
            kxlKeysList.add("JFWJ_KXL");
            kxlKeysList.add("JFWJ_VAL");
            kxlKeysList.add("JFDJSJ_KXL");
            kxlKeysList.add("JFDJSJ_VAL");
            kxlKeysList.add("JFDBR_KXL");
            kxlKeysList.add("JFDBR_VAL");
            kxlKeysList.add("JFYWH_KXL");
            kxlKeysList.add("JFYWH_VAL");
            OperationalLogUtil.log(request, "1", "不动产登记数据库相关字段空项率统计导出", "接入系统");
            ExportExcelUtils.exportKxlInfos(resultList, sb.toString(), kxlKeysList, modelName, response);
        } else {
            if(StringUtils.equals(regionLevel,"省级")) {
                modelName = "new/kxl";
            }
            List<Map<String, Object>> resultList = listCityAndCountyData(param, true);
            List<Map<String, Object>> resultList1 = listCityAndCountyData(param, true);
            List<Map<String, Object>> cityList = listCityAndCountyData(param, true);

            Map<String, Object> por = resultList.get(0);

            resultList = appendChildrenToCityList(resultList);
            resultList1 = appendChildrenToCityList(resultList1);

            cityList.remove(0);

            for (Map<String, Object> temp1 : cityList) {
                resultList1.remove(temp1);
            }

            Object cityQhmc = por.get("QHMC");
            por.put("CITY_QHMC", cityQhmc);

            resultList1.remove(0);
            resultList1.add(0, por);


            String kssj = MapUtils.getString(param, "kssj");
            String jssj = MapUtils.getString(param, "jssj");

            kssj = DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(kssj).toString("yyyy年MM月dd日");
            jssj = DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(jssj).toString("yyyy年MM月dd日");
            StringBuilder sb = new StringBuilder();
            sb.append(MapUtils.getString(param, "provinceName"));
            sb.append("不动产登记增量数据相关字段空项率统计（");
            sb.append(kssj).append("至").append(jssj).append("）");

            //大市表头
            List<String> kxlKeysList = Lists.newArrayList();
            //区县表头
            List<String> kxlKeysList1 = Lists.newArrayList();
            kxlKeysList.add("XH");
            kxlKeysList.add("QHMC");
            kxlKeysList.add("YT_KXL");
//            kxlKeysList.add("YT_VAL");
            kxlKeysList.add("QLXZ_KXL");
//            kxlKeysList.add("QLXZ_VAL");
            kxlKeysList.add("QLSDFS_KXL");
//            kxlKeysList.add("QLSDFS_VAL");
            kxlKeysList.add("GYQK_KXL");
//            kxlKeysList.add("GYQK_VAL");
            kxlKeysList.add("DB_KXL");
//            kxlKeysList.add("DB_VAL");
            kxlKeysList.add("RJL_KXL");
//            kxlKeysList.add("RJL_VAL");

            kxlKeysList.add("FWGYQK_KXL");
//            kxlKeysList.add("FWGYQK_VAL");
            kxlKeysList.add("FWXZ_KXL");
//            kxlKeysList.add("FWXZ_VAL");
            kxlKeysList.add("FWJG_KXL");
//            kxlKeysList.add("FWJG_VAL");
            kxlKeysList.add("JGSJ_KXL");
//            kxlKeysList.add("JGSJ_VAL");

            kxlKeysList.add("ZWLXQX_KXL");
//            kxlKeysList.add("ZWLXQX_VAL");
            kxlKeysList.add("ZGQQDSSSE_KXL");
//            kxlKeysList.add("ZGQQDSSSE_VAL");
            kxlKeysList.add("YBDY_ZJDYZL_KXL");
//            kxlKeysList.add("YBDY_ZJDYZL_VAL");
            kxlKeysList.add("YBDY_ZJDYFW_KXL");
//            kxlKeysList.add("YBDY_ZJDYFW_VAL");
            kxlKeysList.add("ZGDY_ZJDYZL_KXL");
//            kxlKeysList.add("ZGDY_ZJDYZL_VAL");
            kxlKeysList.add("ZGDY_ZJDYFW_KXL");
//            kxlKeysList.add("ZGDY_ZJDYFW_VAL");
            kxlKeysList.add("ZXDYYY_KXL");
//            kxlKeysList.add("ZXDYYY_VAL");
            kxlKeysList.add("ZXSJ_KXL");
//            kxlKeysList.add("ZXSJ_VAL");

            kxlKeysList.add("YWRZJZL_KXL");
//            kxlKeysList.add("YWRZJZL_VAL");
            kxlKeysList.add("YWRZJH_KXL");
//            kxlKeysList.add("YWRZJH_VAL");
            kxlKeysList.add("GHYT_KXL");
//            kxlKeysList.add("GHYT_VAL");
            kxlKeysList.add("FWXZ_KXL");
//            kxlKeysList.add("FWXZ_VAL");

            kxlKeysList.add("JFJG_KXL");
//            kxlKeysList.add("JFJG_VAL");
            kxlKeysList.add("JFWJ_KXL");
//            kxlKeysList.add("JFWJ_VAL");
            kxlKeysList.add("JFDJSJ_KXL");
//            kxlKeysList.add("JFDJSJ_VAL");
            kxlKeysList.add("JFDBR_KXL");
//            kxlKeysList.add("JFDBR_VAL");
            kxlKeysList.add("JFYWH_KXL");
//            kxlKeysList.add("JFYWH_VAL");


            kxlKeysList1.add("XH");
            kxlKeysList1.add("CITY_QHMC");
            kxlKeysList1.add("QHMC");
            kxlKeysList1.add("YT_KXL");
//            kxlKeysList1.add("YT_VAL");
            kxlKeysList1.add("QLXZ_KXL");
//            kxlKeysList1.add("QLXZ_VAL");
            kxlKeysList1.add("QLSDFS_KXL");
//            kxlKeysList1.add("QLSDFS_VAL");
            kxlKeysList1.add("GYQK_KXL");
//            kxlKeysList1.add("GYQK_VAL");
            kxlKeysList1.add("DB_KXL");
//            kxlKeysList1.add("DB_VAL");
            kxlKeysList1.add("RJL_KXL");
//            kxlKeysList1.add("RJL_VAL");

            kxlKeysList1.add("FWGYQK_KXL");
//            kxlKeysList1.add("FWGYQK_VAL");
            kxlKeysList1.add("FWXZ_KXL");
//            kxlKeysList1.add("FWXZ_VAL");
            kxlKeysList1.add("FWJG_KXL");
//            kxlKeysList1.add("FWJG_VAL");
            kxlKeysList1.add("JGSJ_KXL");
//            kxlKeysList1.add("JGSJ_VAL");

            kxlKeysList1.add("ZWLXQX_KXL");
//            kxlKeysList1.add("ZWLXQX_VAL");
            kxlKeysList1.add("ZGQQDSSSE_KXL");
//            kxlKeysList1.add("ZGQQDSSSE_VAL");
            kxlKeysList1.add("YBDY_ZJDYZL_KXL");
//            kxlKeysList1.add("YBDY_ZJDYZL_VAL");
            kxlKeysList1.add("YBDY_ZJDYFW_KXL");
//            kxlKeysList1.add("YBDY_ZJDYFW_VAL");
            kxlKeysList1.add("ZGDY_ZJDYZL_KXL");
//            kxlKeysList1.add("ZGDY_ZJDYZL_VAL");
            kxlKeysList1.add("ZGDY_ZJDYFW_KXL");
//            kxlKeysList1.add("ZGDY_ZJDYFW_VAL");
            kxlKeysList1.add("ZXDYYY_KXL");
//            kxlKeysList1.add("ZXDYYY_VAL");
            kxlKeysList1.add("ZXSJ_KXL");
//            kxlKeysList1.add("ZXSJ_VAL");

            kxlKeysList1.add("YWRZJZL_KXL");
//            kxlKeysList1.add("YWRZJZL_VAL");
            kxlKeysList1.add("YWRZJH_KXL");
//            kxlKeysList1.add("YWRZJH_VAL");
            kxlKeysList1.add("GHYT_KXL");
//            kxlKeysList1.add("GHYT_VAL");
            kxlKeysList1.add("FWXZ_KXL");
//            kxlKeysList1.add("FWXZ_VAL");

            kxlKeysList1.add("JFJG_KXL");
//            kxlKeysList1.add("JFJG_VAL");
            kxlKeysList1.add("JFWJ_KXL");
//            kxlKeysList1.add("JFWJ_VAL");
            kxlKeysList1.add("JFDJSJ_KXL");
//            kxlKeysList1.add("JFDJSJ_VAL");
            kxlKeysList1.add("JFDBR_KXL");
//            kxlKeysList1.add("JFDBR_VAL");
            kxlKeysList1.add("JFYWH_KXL");
//            kxlKeysList1.add("JFYWH_VAL");
            OperationalLogUtil.log(request, "1", "不动产登记数据库相关字段空项率统计导出", "接入系统");
            //省级用户导出市级用户还是使用老模板

            ExportExcelUtilsSX.exportKxlInfos(resultList, resultList1, sb.toString(), kxlKeysList, kxlKeysList1, modelName, response);



        }

    }

    @Override
    public void exportExcelKxlAll(Map<String, Object> param, HttpServletResponse response, HttpServletRequest request) {

    }

    /**
     * 导出 excel江苏
     *
     * @param param
     * @param response
     */
    @Override
    public void exportExcelDbzlJS(Map<String, Object> param, HttpServletResponse response, HttpServletRequest request) {
        List<Map<String, Object>> resultList = listCityAndCountyDataFinal(param, true);
        List<Map<String, Object>> resultListSort = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(resultList)) {
            for (int i = 1; i < resultList.size(); i++) {
                resultListSort.add(resultList.get(i));
            }

            resultListSort.add(resultList.get(0));
            resultListSort = appendChildrenToCityList(resultListSort);
            apendXhToList(resultListSort);
        }

        String kssj = MapUtils.getString(param, "kssj");
        String jssj = MapUtils.getString(param, "jssj");

        kssj = DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(kssj).toString("yyyy年MM月dd日");
        jssj = DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(jssj).toString("yyyy年MM月dd日");
        StringBuilder sb = new StringBuilder();
        sb.append(MapUtils.getString(param, "provinceName"));
        sb.append("不动产登记增量数据登簿质量评价表（");
        sb.append(kssj).append("至").append(jssj).append("）");

        List<String> kxlKeysList = Lists.newArrayList();
        kxlKeysList.add("XH");
        kxlKeysList.add("QHMC");
        kxlKeysList.add("JSYDSQY_FINAL_VAL");
        kxlKeysList.add("JSYDSQY_FINAL_KXL");
        kxlKeysList.add("FWSYQ_FINAL_VAL");
        kxlKeysList.add("FWSYQ_FINAL_KXL");
        kxlKeysList.add("DY_FINAL_VAL");
        kxlKeysList.add("DY_FINAL_KXL");
        kxlKeysList.add("YG_FINAL_VAL");
        kxlKeysList.add("YG_FINAL_KXL");
        kxlKeysList.add("CF_FINAL_VAL");
        kxlKeysList.add("CF_FINAL_KXL");
        kxlKeysList.add("ZHPF");
        OperationalLogUtil.log(request, "1", "不动产登记增量数据登簿质量评价表导出", "接入系统");
        ExportExcelUtils.exportDbzlInfos(resultListSort, sb.toString(), kxlKeysList, "dbzl", response);
    }

    /**
     * 导出 excel陕西
     *
     * @param sqparam
     * @param response
     */
    @Override
    public void exportExcelDbzlSX(Map<String, Object> param, Map<String, Object> sqparam, HttpServletResponse response, HttpServletRequest request) {
        List<Map<String, Object>> resultList = listCityAndCountyDataFinal(param, true);
        List<Map<String, Object>> sqresultList = listCityAndCountyDataFinal(sqparam, true);
        if(CollectionUtils.isNotEmpty(resultList)) {
            for(int i=0;i<resultList.size();i++) {
                //省数据
                if (i == 0) {
                    String sqzhpf = "";
                    if(CollectionUtils.isNotEmpty(sqresultList)) {
                        sqzhpf = CommonUtil.formatEmptyValue(sqresultList.get(i).get("ZHPF"));
                    }
                    String zhpf = CommonUtil.formatEmptyValue(resultList.get(i).get("ZHPF"));
                    resultList.get(i).put("SQZHPF", sqzhpf);
                    double sqzhpfDouble = Double.valueOf(sqzhpf);
                    double zhpfdfDouble = Double.valueOf(zhpf);
                    double bh = zhpfdfDouble - sqzhpfDouble;
                    String bhqk = String.valueOf((double) Math.round(bh * 100) / 100);
                    resultList.get(i).put("BHQK", bhqk);
                } else {
                    //市数据
                    String sqzhpf = "";
                    if(CollectionUtils.isNotEmpty(sqresultList)) {
                        sqzhpf = CommonUtil.formatEmptyValue(sqresultList.get(i).get("ZHPF"));
                    }
                    String zhpf = CommonUtil.formatEmptyValue(resultList.get(i).get("ZHPF"));
                    resultList.get(i).put("SQZHPF", sqzhpf);
                    double sqzhpfDouble = Double.valueOf(sqzhpf);
                    double zhpfdfDouble = Double.valueOf(zhpf);
                    double bh = zhpfdfDouble - sqzhpfDouble;
                    String bhqk = String.valueOf((double) Math.round(bh * 100) / 100);
                    resultList.get(i).put("BHQK", bhqk);

                    //区县数据
                    List<Map<String, Object>> qxdataList = (List<Map<String, Object>>) resultList.get(i).get("children");
                    List<Map<String, Object>> sqqxdataList = (List<Map<String, Object>>) sqresultList.get(i).get("children");

                    if (CollectionUtils.isNotEmpty(qxdataList)) {
                        for (int j = 0; j < qxdataList.size(); j++) {
                            String sqzhpf1 = CommonUtil.formatEmptyValue(sqqxdataList.get(j).get("ZHPF"));
                            String zhpf1 = CommonUtil.formatEmptyValue(qxdataList.get(j).get("ZHPF"));
                            qxdataList.get(j).put("SQZHPF", sqzhpf1);
                            double sqzhpfDouble1 = Double.valueOf(sqzhpf1);
                            double zhpfdfDouble1 = Double.valueOf(zhpf1);
                            double bh1 = zhpfdfDouble1 - sqzhpfDouble1;
                            String bhqk1 = String.valueOf((double) Math.round(bh1 * 100) / 100);
                            qxdataList.get(j).put("BHQK", bhqk1);
                        }
                    }
                }
            }

        }

        Map<String,Object> porCity = resultList.get(0);

        List<Map<String, Object>> resultListSort = Lists.newArrayList();
        List<Map<String, Object>> resultListSort1 = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(resultList)){
            for (int i = 1; i < resultList.size(); i++) {
                resultListSort.add(resultList.get(i));
            }
            resultListSort.add(resultList.get(0));
            resultListSort = appendChildrenToCityList(resultListSort);
            apendXhToList(resultListSort);

        }
        resultList.remove(0);

        for(Map<String,Object> temp1:resultListSort){
            if(temp1.equals(porCity)){
                Object cityQhmc = temp1.get("QHMC");
                temp1.put("CITY_QHMC",cityQhmc);
            }
            resultListSort1.add(temp1);

        }

        for(Map<String,Object> temp1:resultList){
            resultListSort1.remove(temp1);
        }


        String kssj = MapUtils.getString(param, "kssj");
        String jssj = MapUtils.getString(param, "jssj");

        kssj = DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(kssj).toString("yyyy年MM月dd日");
        jssj = DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(jssj).toString("yyyy年MM月dd日");
        StringBuilder sb = new StringBuilder();
        sb.append(MapUtils.getString(param, "provinceName"));
        sb.append("不动产登记增量数据登簿质量评价表（");
        sb.append(kssj).append("至").append(jssj).append("）");

        List<String> kxlKeysList = Lists.newArrayList();
        List<String> kxlKeysList1 = Lists.newArrayList();
        kxlKeysList.add("XH");
        kxlKeysList.add("QHMC");
        kxlKeysList.add("JSYDSQY_FINAL_VAL");
        kxlKeysList.add("JSYDSQY_FINAL_KXL");
        kxlKeysList.add("FWSYQ_FINAL_VAL");
        kxlKeysList.add("FWSYQ_FINAL_KXL");
        kxlKeysList.add("DY_FINAL_VAL");
        kxlKeysList.add("DY_FINAL_KXL");
        kxlKeysList.add("YG_FINAL_VAL");
        kxlKeysList.add("YG_FINAL_KXL");
        kxlKeysList.add("CF_FINAL_VAL");
        kxlKeysList.add("CF_FINAL_KXL");
        kxlKeysList.add("ZHPF");
        kxlKeysList.add("SQZHPF");
        kxlKeysList.add("BHQK");

        kxlKeysList1.add("XH");
        kxlKeysList1.add("CITY_QHMC");
        kxlKeysList1.add("QHMC");
        kxlKeysList1.add("JSYDSQY_FINAL_VAL");
        kxlKeysList1.add("JSYDSQY_FINAL_KXL");
        kxlKeysList1.add("FWSYQ_FINAL_VAL");
        kxlKeysList1.add("FWSYQ_FINAL_KXL");
        kxlKeysList1.add("DY_FINAL_VAL");
        kxlKeysList1.add("DY_FINAL_KXL");
        kxlKeysList1.add("YG_FINAL_VAL");
        kxlKeysList1.add("YG_FINAL_KXL");
        kxlKeysList1.add("CF_FINAL_VAL");
        kxlKeysList1.add("CF_FINAL_KXL");
        kxlKeysList1.add("ZHPF");
        kxlKeysList1.add("SQZHPF");
        kxlKeysList1.add("BHQK");
        OperationalLogUtil.log(request, "1", "不动产登记增量数据登簿质量评价表导出", "接入系统");
        ExportExcelUtilsSX.exportDbzlInfos(resultListSort,resultListSort1, sb.toString(),kxlKeysList, kxlKeysList1, "new/dbzl", response);
    }

    /**
     * 获取上一次结束时间
     *
     * @return
     */
    @Override
    public String getlastJssj() {
        String jssj = null;
        try {
            jssj = kxlMapper.getlastJssj();
        } catch (DataAccessException e) {
            LOGGER.error("getlastJssj:{}", e.getMessage());
        }
        return jssj;
    }

    @Override
    public void saveDataCz(Map<String, Object> param) {
        try {
            kxlMapper.saveDataCz(param);
        } catch (DataAccessException e) {
            LOGGER.error("saveDataCz:{}", e.getMessage());
        }
    }

    /**
     * 合并列
     */
    private void mergeColCityData(List<Map<String, Object>> cityCol1, List<Map<String, Object>> cityCol2) {
        if (CollectionUtils.isNotEmpty(cityCol1) && CollectionUtils.isNotEmpty(cityCol2)) {
            for (int i = 0; i < cityCol1.size(); i++) {
                for (int j = 0; j < cityCol2.size(); j++) {
                    if (StringUtils.equals(MapUtils.getString(cityCol1.get(i), "CITY_QHDM")
                            , MapUtils.getString(cityCol2.get(j), "CITY_QHDM"))) {
                        cityCol1.get(i).putAll(cityCol2.get(j));
                        break;
                    }
                }
            }
        }
    }

    /**
     * 合并列
     */
    private void mergeColCountyData(List<Map<String, Object>> cityCol1, List<Map<String, Object>> cityCol2) {
        if (CollectionUtils.isNotEmpty(cityCol1) && CollectionUtils.isNotEmpty(cityCol2)) {
            for (int i = 0; i < cityCol1.size(); i++) {
                for (int j = 0; j < cityCol2.size(); j++) {
                    if (StringUtils.equals(MapUtils.getString(cityCol1.get(i), "COUNTY_QHDM")
                            , MapUtils.getString(cityCol2.get(j), "COUNTY_QHDM"))) {
                        cityCol2.get(j).remove("COUNTY_QHDM");
                        cityCol2.get(j).remove("QHMC");
                        cityCol1.get(i).putAll(cityCol2.get(j));
                        break;
                    }
                }
            }
        }
    }

    /**
     * 给市加上区县数据
     *
     * @param city
     * @param county
     */
    private void appendChildrenList(List<Map<String, Object>> city
            , List<Map<String, Object>> county, boolean ixXhAll) {
        List<Map<String, Object>> childrenList;
        int count = 0;
        if (CollectionUtils.isNotEmpty(city) && CollectionUtils.isNotEmpty(county)) {
            for (int i = 0; i < city.size(); i++) {
                city.get(i).put("XH", count++);
                childrenList = Lists.newArrayList();
                for (int j = 0; j < county.size(); j++) {
                    if (StringUtils.equals(MapUtils.getString(city.get(i), "CITY_QHDM")
                            , MapUtils.getString(county.get(j), "CITY_QHDM"))) {
                        if (ixXhAll) {
                            county.get(j).put("XH", count++);
                        }
                        childrenList.add(county.get(j));
                    }
                }
                if (CollectionUtils.isNotEmpty(childrenList)) {
                    city.get(i).put(CHILDREN, childrenList);
                }
            }
        }
    }

    /**
     * 添加序号
     *
     * @param list
     */
    private void apendXhToList(List<Map<String, Object>> list) {
        int count = 1;
        if (CollectionUtils.isNotEmpty(list)) {
            for (int i = 0; i < list.size(); i++) {
                list.get(i).put("XH", count++);
            }
        }
    }

    /**
     * 将子列表展开到列表中
     *
     * @param list
     */
    private List<Map<String, Object>> appendChildrenToCityList(List<Map<String, Object>> list) {
        List<Map<String, Object>> resultList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            for (int i = 0; i < list.size(); i++) {
                resultList.add(list.get(i));
                if (CollectionUtils.isNotEmpty((List) MapUtils.getObject(list.get(i), CHILDREN))) {
                    for (int j = 0; j < ((List) MapUtils.getObject(list.get(i), CHILDREN)).size(); j++) {
                        resultList.add((Map<String, Object>) ((List) MapUtils.getObject(list.get(i), CHILDREN)).get(j));
                    }
                }
            }
        }
        return resultList;
    }

    /**
     * 算分-建设用地
     *
     * @param jsydsqyList
     */
    private void listJsydsyqCal(List<Map<String, Object>> jsydsqyList) {
        if (CollectionUtils.isNotEmpty(jsydsqyList)) {
            for (int i = 0; i < jsydsqyList.size(); i++) {
                calValue(jsydsqyList.get(i), "YT_FZ", "YT_FM", "YT", 4, "0.00");
                calValue(jsydsqyList.get(i), "QLXZ_FZ", "QLXZ_FM", "QLXZ", 4, "0.00");
                calValue(jsydsqyList.get(i), "QLSDFS_FZ", "QLSDFS_FM", "QLSDFS", 4, "0.00");
                calValue(jsydsqyList.get(i), "GYQK_FZ", "GYQK_FM", "GYQK", 4, "0.00");
                calValue(jsydsqyList.get(i), "ZJZL_FZ", "ZJZL_FM", "ZJZL", 4, "0.00");
                calValue(jsydsqyList.get(i), "ZJH_FZ", "ZJH_FM", "ZJH", 4, "0.00");
                calValue(jsydsqyList.get(i), "DB_FZ", "DB_FM", "DB", 1.2, "0.00");
                calValue(jsydsqyList.get(i), "RJL_FZ", "RJL_FM", "RJL", 1.2, "0.00");
            }
        }
    }

    /**
     * 算分-房屋使用权
     *
     * @param fwsyqList
     */
    private void listFwsyqCal(List<Map<String, Object>> fwsyqList) {
        if (CollectionUtils.isNotEmpty(fwsyqList)) {
            for (int i = 0; i < fwsyqList.size(); i++) {
                calValue(fwsyqList.get(i), "FWGYQK_FZ", "FWGYQK_FM", "FWGYQK", 2.8, "0.00");
                calValue(fwsyqList.get(i), "ZJZL_FZ", "ZJZL_FM", "ZJZL", 4, "0.00");
                calValue(fwsyqList.get(i), "ZJH_FZ", "ZJH_FM", "ZJH", 4, "0.00");
                calValue(fwsyqList.get(i), "FWFWXZ_FZ", "FWFWXZ_FM", "FWFWXZ", 2.8, "0.00");
                calValue(fwsyqList.get(i), "FWJG_FZ", "FWJG_FM", "FWJG", 1, "0.00");
                calValue(fwsyqList.get(i), "JGSJ_FZ", "JGSJ_FM", "JGSJ", 1, "0.00");
                calValue(fwsyqList.get(i), "BDCQZH_FZ", "BDCQZH_FM", "BDCQZH", 4, "0.00");
            }
        }
    }

    /**
     * 算分-查封登记
     *
     * @param cfList
     */
    private void listCfCal(List<Map<String, Object>> cfList) {
        if (CollectionUtils.isNotEmpty(cfList)) {
            for (int i = 0; i < cfList.size(); i++) {
                calValue(cfList.get(i), "JFJG_FZ", "JFJG_FM", "JFJG", 16, "0.00");
                calValue(cfList.get(i), "JFWJ_FZ", "JFWJ_FM", "JFWJ", 16, "0.00");
                calValue(cfList.get(i), "JFWH_FZ", "JFWH_FM", "JFWH", 16, "0.00");
                calValue(cfList.get(i), "JFDJSJ_FZ", "JFDJSJ_FM", "JFDJSJ", 16, "0.00");
                calValue(cfList.get(i), "JFDBR_FZ", "JFDBR_FM", "JFDBR", 16, "0.00");
                calValue(cfList.get(i), "JFYWH_FZ", "JFYWH_FM", "JFYWH", 16, "0.00");
            }
        }
    }

    /**
     * 算分-抵押
     *
     * @param dyList
     */
    private void listDyCal(List<Map<String, Object>> dyList) {
        if (CollectionUtils.isNotEmpty(dyList)) {
            for (int i = 0; i < dyList.size(); i++) {
                calValue(dyList.get(i), "ZWLXQX_FZ", "ZWLXQX_FM", "ZWLXQX", 7, "0.00");
                calValue(dyList.get(i), "ZGQQDSSSE_FZ", "ZGQQDSSSE_FM", "ZGQQDSSSE", 4.5, "0.00");
                calValue(dyList.get(i), "YBDY_ZJDYZL_FZ", "YBDY_ZJDYZL_FM", "YBDY_ZJDYZL", 3, "0.00");
                calValue(dyList.get(i), "YBDY_ZJDYFW_FZ", "YBDY_ZJDYFW_FM", "YBDY_ZJDYFW", 3, "0.00");
                calValue(dyList.get(i), "ZGDY_ZJDYZL_FZ", "ZGDY_ZJDYZL_FM", "ZGDY_ZJDYZL", 3, "0.00");
                calValue(dyList.get(i), "ZGDY_ZJDYFW_FZ", "ZGDY_ZJDYFW_FM", "ZGDY_ZJDYFW", 3, "0.00");
                calValue(dyList.get(i), "ZXDYYY_FZ", "ZXDYYY_FM", "ZXDYYY", 3, "0.00");
                calValue(dyList.get(i), "ZXSJ_FZ", "ZXSJ_FM", "ZXSJ", 3, "0.00");
                calValue(dyList.get(i), "ZXDYYWH_FZ", "ZXDYYWH_FM", "ZXDYYWH", 3, "0.00");
            }
        }
    }

    /**
     * 算分-预告
     *
     * @param ygList
     */
    private void listYgCal(List<Map<String, Object>> ygList) {
        if (CollectionUtils.isNotEmpty(ygList)) {
            for (int i = 0; i < ygList.size(); i++) {
                calValue(ygList.get(i), "ZJH_FZ", "ZJH_FM", "ZJH", 3.2, "0.00");
                calValue(ygList.get(i), "TDSYQR_FZ", "TDSYQR_FM", "TDSYQR", 3.2, "0.00");
                calValue(ygList.get(i), "YWRZJZL_FZ", "YWRZJZL_FM", "YWRZJZL", 3.2, "0.00");
                calValue(ygList.get(i), "YWRZJH_FZ", "YWRZJH_FM", "YWRZJH", 3.2, "0.00");
                calValue(ygList.get(i), "GHYT_FZ", "GHYT_FM", "GHYT", 3.2, "0.00");
                calValue(ygList.get(i), "FWXZ_FZ", "FWXZ_FM", "FWXZ", 3.2, "0.00");
            }
        }
    }

    /**
     * 算分-建设用地（总分）
     *
     * @param jsydsqyList
     */
    private void listJsydsyqCalFinal(List<Map<String, Object>> jsydsqyList) {
        List<String> jsydsyq = Lists.newArrayList();
        jsydsyq.add("YT");
        jsydsyq.add("QLXZ");
        jsydsyq.add("QLSDFS");
        jsydsyq.add("GYQK");
        jsydsyq.add("DB");
        jsydsyq.add("RJL");

        if (CollectionUtils.isNotEmpty(jsydsqyList)) {
            for (int i = 0; i < jsydsqyList.size(); i++) {
                calValueFinal(jsydsqyList.get(i), jsydsyq, "JSYDSQY_FINAL", 81.6, 0.2, 31, "0.00");
            }
        }
    }

    /**
     * 算分-房屋使用权（总分）
     *
     * @param fwsyqList
     */
    private void listFwsyqCalFinal(List<Map<String, Object>> fwsyqList) {
        List<String> fwsyq = Lists.newArrayList();
        fwsyq.add("FWGYQK");
        fwsyq.add("FWFWXZ");
        fwsyq.add("FWJG");
        fwsyq.add("JGSJ");

        if (CollectionUtils.isNotEmpty(fwsyqList)) {
            for (int i = 0; i < fwsyqList.size(); i++) {
                calValueFinal(fwsyqList.get(i), fwsyq, "FWSYQ_FINAL", 92.4, 0.3, 46, "0.00");
            }
        }
    }

    /**
     * 算分-查封登记（总分）
     *
     * @param cfList
     */
    private void listCfCalFinal(List<Map<String, Object>> cfList) {
        List<String> cf = Lists.newArrayList();
        cf.add("JFJG");
        cf.add("JFWJ");
        cf.add("JFDJSJ");
        cf.add("JFDBR");
        cf.add("JFYWH");

        if (CollectionUtils.isNotEmpty(cfList)) {
            for (int i = 0; i < cfList.size(); i++) {
                calValueFinal(cfList.get(i), cf, "CF_FINAL", 20, 0.1, 15, "0.00");
            }
        }
    }

    /**
     * 算分-抵押（总分）
     *
     * @param dyList
     */
    private void listDyCalFinal(List<Map<String, Object>> dyList) {
        List<String> dy = Lists.newArrayList();
        dy.add("ZWLXQX");
        dy.add("ZGQQDSSSE");
        dy.add("YBDY_ZJDYZL");
        dy.add("YBDY_ZJDYFW");
        dy.add("ZGDY_ZJDYZL");
        dy.add("ZGDY_ZJDYFW");
        dy.add("ZXDYYY");
        dy.add("ZXSJ");

        if (CollectionUtils.isNotEmpty(dyList)) {
            for (int i = 0; i < dyList.size(); i++) {
                calValueFinal(dyList.get(i), dy, "DY_FINAL", 70.5, 0.3, 25, "0.00");
            }
        }
    }

    /**
     * 算分-预告（总分）
     *
     * @param ygList
     */
    private void listYgCalFinal(List<Map<String, Object>> ygList) {
        List<String> yg = Lists.newArrayList();
        yg.add("YWRZJZL");
        yg.add("YWRZJH");
        yg.add("GHYT");
        yg.add("FWXZ");

        if (CollectionUtils.isNotEmpty(ygList)) {
            for (int i = 0; i < ygList.size(); i++) {
                calValueFinal(ygList.get(i), yg, "YG_FINAL", 87.2, 0.1, 37, "0.00");
            }
        }
    }

    /**
     * 计算综合评分
     *
     * @param list
     * @param keys
     */
    private void calZhpf(List<Map<String, Object>> list, List<String> keys, String format) {
        if (CollectionUtils.isNotEmpty(list) && CollectionUtils.isNotEmpty(keys)) {
            DecimalFormat df = new DecimalFormat(format);
            double zhpf = 0.0;
            for (int i = 0; i < list.size(); i++) {
                zhpf = 0.0;
                for (int j = 0; j < keys.size(); j++) {
                    zhpf += MapUtils.getDoubleValue(list.get(i), keys.get(j));
                }
                list.get(i).put("ZHPF", df.format(zhpf));
            }
        }
    }

    /**
     * 计算比例
     *
     * @param obj
     * @param fz
     * @param fm
     * @return
     */
    private String divValue(Map<String, Object> obj, String fz, String fm) {
        String val1 = MapUtils.getString(obj, fz);
        String val2 = MapUtils.getString(obj, fm);
        BigDecimal result;
        BigDecimal bval1 = new BigDecimal(Integer.parseInt(val1));
        BigDecimal bval2 = new BigDecimal(Integer.parseInt(val2));
        if (bval2.intValue() == 0) {
            result = new BigDecimal(0.0000);
        } else {
            if (bval1.intValue() == 0) {
                result = new BigDecimal(0.0000);
            } else {
                result = bval1.divide(bval2, 4, RoundingMode.HALF_UP);
            }
        }
        DecimalFormat df = new DecimalFormat("0.0000");
        return df.format(result);
    }

    /**
     * 计算分值
     *
     * @param obj
     * @param fz
     * @param fm
     * @param valName
     * @param score
     * @param format
     * @return
     */
    private String calValue(Map<String, Object> obj, String fz, String fm, String valName
            , double score, String format) {
        DecimalFormat df = new DecimalFormat(format);
        String bl = divValue(obj, fz, fm);
        obj.put(valName + "_KXL", df.format(Double.parseDouble(bl) * 100) + "%");
        Double dbl = Double.parseDouble(bl);
        Double result = score * (1 - dbl);
        obj.put(valName + "_VAL", df.format(result));
        return df.format(result);
    }

    /**
     * 计算分值-总评分
     *
     * @param obj
     * @param valNameList
     * @param valName
     * @param scoreRemain
     * @param format
     * @return
     */
    private String calValueFinal(Map<String, Object> obj, List<String> valNameList, String valName
            , double scoreRemain, double proportion, int zs, String format) {
        BigDecimal kxlAll = new BigDecimal(0.0);
        double kxl = 0.0;
        Double scoreAll = 0.0;
        if (CollectionUtils.isNotEmpty(valNameList)) {
            for (int i = 0; i < valNameList.size(); i++) {
                kxl += MapUtils.getIntValue(obj, valNameList.get(i) + "_KXL");
                scoreAll += MapUtils.getDoubleValue(obj, valNameList.get(i) + "_VAL");
            }
            scoreAll += scoreRemain;
            BigDecimal bval1 = new BigDecimal(kxl);
            BigDecimal bval2 = new BigDecimal(zs);
            if (bval2.intValue() == 0) {
                kxlAll = new BigDecimal(0.0000);
            } else {
                if (bval1.intValue() == 0) {
                    kxlAll = new BigDecimal(0.0000);
                } else {
                    kxlAll = bval1.divide(bval2, 4, RoundingMode.HALF_UP);
                }
            }
        }

        DecimalFormat df = new DecimalFormat(format);
        obj.put(valName + "_KXL", df.format(kxlAll.multiply(new BigDecimal(1))) + "%");
        obj.put(valName + "_VAL", df.format(scoreAll * proportion));
        return df.format(kxlAll);
    }
}
