package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaAccessLogMapper;
import cn.gtmap.realestate.supervise.server.entity.AccessInfo;
import cn.gtmap.realestate.supervise.server.entity.AccessLog;
import cn.gtmap.realestate.supervise.server.entity.AccessLogs;
import cn.gtmap.realestate.supervise.server.entity.RegisterInfo;
import cn.gtmap.realestate.supervise.server.service.JrrzService;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import cn.gtmap.realestate.supervise.server.utils.XmlUtil;
import com.google.common.collect.Lists;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.rpc.client.RPCServiceClient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/11/2
 * @description 登簿日志上报接口
 */
@Service
public class JrrzServiceImpl implements JrrzService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServeDetail.class);

    //报部地址
    String serviceUrl = AppConfig.getProperty("webService.url");

    //报省地址
    String serviceProvinceUrl = AppConfig.getProperty("webService.province.url");

    //需要合并数据的区县代码配置
    String areaCodes = AppConfig.getProperty("supersive.jrrz.area.code");

    //报省开关
    String isJrrzProvice = AppConfig.getProperty("isJrrzProvice");

    @Autowired
    EntityMapper entityMapper;

    @Autowired
    BaAccessLogMapper baAccessLogMapper;

    @Override
    public String exchangeInfo(String registrationLogXml) {

        AccessLogs data = XmlUtil.converyToJavaBean(registrationLogXml , AccessLogs.class);

        String areaCode = "";
        boolean flag = true;
        if (null != data) {
            List<AccessLog> accessLogList = data.getAccessLog();
            if (CollectionUtils.isNotEmpty(accessLogList)) {
                AccessLog accessLog = accessLogList.get(0);
                areaCode = accessLog.getAreaCode();
            }
        }

        if (StringUtils.isNotBlank(areaCodes)) {
            String[] tempAreaCode = areaCodes.split("\\|");
            for (String str : tempAreaCode) {
                if (StringUtils.equals(str, areaCode)) {
                    flag = false;
                    break;
                }
            }
        }
        if (!flag) {
            String resStr = "success";
            insertAccessLog(resStr, registrationLogXml, flag);
            return resStr;
        } else {

            //报部
            String resStr = sendUpload(registrationLogXml, data,false);

            return resStr;
        }
    }

    /**
     * 手动上报
     *
     * @param param
     * @return
     */
    @Override
    public String uploadData(String param,boolean sdsbFlag) {
        String[] params = param.split("\\|");
        String res = "fail";
        if (null != params && params.length > 0) {
            List<String> stringList = Lists.newArrayList();
            for (int i = 0; i < params.length; i++) {
                String temp = params[i];
                if (!stringList.contains(temp)) {
                    stringList.add(temp);
                }
            }
            AccessLogs accessLogs = new AccessLogs();
            List<AccessLog> accessLogList = Lists.newArrayList();
            for (String str : stringList) {
                AccessLog accessLog = new AccessLog();
                if (StringUtils.isNotBlank(str)) {
                    String[] strings = str.split("\\_");
                    String areacode = strings[0];
                    String date = strings[1];
                    RegisterInfo registerInfo = baAccessLogMapper.getRegisterInfoByCode(areacode, date);
                    AccessInfo accessInfo = baAccessLogMapper.getAccessInfoByCode(areacode, date);
                    Map<String, String> remarkMap = baAccessLogMapper.getMaxRemark(areacode,date);//这边应该取字段长度值最长的
                    String remark = remarkMap.get("REMARK");
                    accessLog.setRegisterInfo(registerInfo);

                    if(StringUtils.isNotBlank(remark)){
                        accessLog.setRemark(remark);
                    }else{
                        accessLog.setRemark("");
                    }

                    accessLog.setAccessDate(date.replaceAll("-", ""));
                    XtRegion xtRegion = baAccessLogMapper.getRegionByCode(areacode);
                    accessLog.setAreaCode(areacode);
                    accessLog.setAreaName(xtRegion.getQhmc());
                    accessInfo.setRemark(null);
                    accessInfo.setAccessdate(null);
                    accessInfo.setAreacode(null);
                    accessInfo.setAreaname(null);
                    accessLog.setAccessInfo(accessInfo);
                }
                accessLogList.add(accessLog);
            }

            accessLogs.setAccessLog(accessLogList);

            String xml = XmlUtil.entityToXml(accessLogs);
            LOGGER.info("手动上报登簿日志开始！上报内容：{}", xml);
            res = sendUpload(xml, accessLogs,sdsbFlag);
            LOGGER.info("手动上报登簿日志结束！结果：{}", res);
        }

        return res;
    }


    /**
     * 更新是否报部 新增字段
     * @param accessLogs
     * @param sfbb
     */
    public void updateSB(AccessLogs accessLogs,String sfbb) {
          List<AccessLog> accessLogs1 = accessLogs.getAccessLog();
          for (AccessLog accessLog : accessLogs1) {
                 accessLog.setSfbb(sfbb);
                  baAccessLogMapper.updatebbresult(accessLog);
          }
    }



    private String sendUpload(String registrationLogXml, AccessLogs data,boolean sdsbFlag) {
        String resStr = send(registrationLogXml, data);//报部

        String resProvinceStr = "";
        //报省开关
        if (StringUtils.equals(isJrrzProvice, "true")) {
            resProvinceStr = sendProvice(registrationLogXml);//报省
        }
        if (StringUtils.equals(resStr, "success") || StringUtils.equals(resProvinceStr, "success")) {
            if(sdsbFlag){
                //手动上报成功、更新状态
                updateSbzt(data,Constant.CODE_1);//报部成功更新状态
                updateSB(data,Constant.CODE_T);

            }else{
                insertAccessLog(resStr, registrationLogXml, true);

            }

        }

        //报部失败返回
        if (!StringUtils.equals("success", resStr)) {
            updateSbzt(data,Constant.CODE_0);//报部失败更新状态
            updateSB(data,Constant.CODE_F);
            return resStr;
        }
        //报省失败&报省开关打开，返回信息
        if (!StringUtils.equals(resProvinceStr, "success") && StringUtils.equals(isJrrzProvice, "true")) {
            return resProvinceStr;
        }
        return resStr;




    }


    /**
     * 报部发送信息
     *
     * @param registrationLogXml
     * @return
     */
    public String send(String registrationLogXml, AccessLogs accessLogs) {

                //使用RPC方式调用WebService
        RPCServiceClient serviceClient = null;
        String res = "";
        try {
            serviceClient = new RPCServiceClient();
            Options options = serviceClient.getOptions();

            EndpointReference targetEPR = new EndpointReference(serviceUrl);
            options.setTo(targetEPR);
            OMFactory fac = OMAbstractFactory.getOMFactory();

            // 这个和qname差不多，设置命名空间
            OMNamespace omNs = fac.createOMNamespace("http://loushang.ws", "exchangeInfo");

            OMElement data = fac.createOMElement("exchangeInfo", omNs);

            // 对应参数的节点，strName 为参数名称
            String strName = "args0";

            OMElement inner = fac.createOMElement(strName, omNs);

            // 参数值
            inner.setText(registrationLogXml);

            data.addChild(inner);

            OMElement object = serviceClient.sendReceive(data);

            //获取返回结果
            res = object.getFirstElement().getText();
            serviceClient.cleanupTransport();
            LOGGER.info("报部成功！！！");
            updateSB(accessLogs,Constant.CODE_T);
            updateSbzt(accessLogs, Constant.CODE_1);


        } catch (Exception e) {
            LOGGER.error("登簿日志报部.send.Exception error in:{}", e);
//            throw new AppException(2025);
            res = "登簿日志报部异常!";
            LOGGER.info("报部失败！！！");
            updateSbzt(accessLogs,Constant.CODE_0);
            updateSB(accessLogs,Constant.CODE_F);

        }
        return res;
    }


    /**
     * 数据解析入库
     *
     * @param resStr
     * @param registrationLogXml
     */
    public void insertAccessLog(String resStr, String registrationLogXml, boolean flag) {
        if (StringUtils.equals(resStr, "success")) {
            String clientRealIp = getClientRealIP();
            AccessLogs data = XmlUtil.converyToJavaBean(registrationLogXml, AccessLogs.class);
            if (null != data) {
                List<AccessLog> accessLogList = data.getAccessLog();
                for (AccessLog accessLog : accessLogList) {
                    String date = accessLog.getAccessDate();
                    Date date1 = TimeUtils.strToDate(date);
                    String areaCode = accessLog.getAreaCode();
                    String remark = accessLog.getRemark();
                    String areaName = accessLog.getAreaName();
                    AccessInfo accessInfo = new AccessInfo();
                    RegisterInfo registerInfo =new RegisterInfo();
//                    if (flag) {
//                        //删除已存在数据再进行新数据入库
//                        baAccessLogMapper.delAccesslog(areaCode, areaName, date1);
//                    }
                    //到表里面按条件查询 若能查到数据 那么就是更新 若查不到就是新增
                    Map<String,Object> baxx = new HashMap<>();
                    baxx.put("areacode",areaCode);
                    baxx.put("areaname",areaName);
                    baxx.put("date",date1);
                    baxx.put("ip",clientRealIp);
                    RegisterInfo  registerInfoupdate = baAccessLogMapper.getBalogDBL(baxx);
                    AccessInfo accessInfoUpdate =baAccessLogMapper.getBalogJRL(baxx);

                    //不管是新增还是覆盖 都要用到下面的值
                    accessInfo = accessLog.getAccessInfo();
                    accessInfo.setAccessdate(date1);
                    accessInfo.setRemark(remark);
                    accessInfo.setAreacode(areaCode);
                    accessInfo.setAreaname(areaName);
                    accessInfo.setIp(clientRealIp);

                    registerInfo = accessLog.getRegisterInfo();
                    registerInfo.setAccessdate(date1);
                    registerInfo.setRemark(remark);
                    registerInfo.setAreacode(areaCode);
                    registerInfo.setAreaname(areaName);
                    registerInfo.setIp(clientRealIp);

                    if(null!=registerInfoupdate && null!=accessInfoUpdate){
                        accessInfo.setId(accessInfoUpdate.getId());
                        registerInfo.setId(registerInfoupdate.getId());

                        if(flag==true){
                            accessInfo.setSfbb("true");
                            registerInfo.setSfbb("true");
                        }else{
                            accessInfo.setSfbb("false");
                            registerInfo.setSfbb("false");
                        }

                        entityMapper.saveOrUpdate(accessInfo, accessInfoUpdate.getId());
                        entityMapper.saveOrUpdate(registerInfo,registerInfoupdate.getId());
                    }else{

                        String accessId = UUIDGenerator.generate18();
                        accessInfo.setId(accessId);
                        if(flag==true) {
                            accessInfo.setSfbb("true");
                        }else{
                            accessInfo.setSfbb("false");//新增的话肯定是未报部
                        }



                        registerInfo = accessLog.getRegisterInfo();
                        String registerid = UUIDGenerator.generate18();
                        registerInfo.setId(registerid);
                        if(flag==true){
                            LOGGER.info("全新的数据赋值sfbb");
                            registerInfo.setSfbb("true");
                        }else{
                            registerInfo.setSfbb("false");//新增的话肯定是未报部
                        }

                        entityMapper.insertSelective(accessInfo);
                        entityMapper.insertSelective(registerInfo);
                    }
                }
            }
        }
    }


    /**
     * 报省
     *
     * @param xmlInfo
     * @return
     */
    public String sendProvice(String xmlInfo) {

        //使用RPC方式调用WebService
        String res = "";
        try {
            ServiceClient sender = new ServiceClient();
            EndpointReference endpointReference = new EndpointReference(serviceProvinceUrl);
            Options options = new Options();

            options.setTo(endpointReference);
            sender.setOptions(options);
            OMFactory fac = OMAbstractFactory.getOMFactory();
            // 这个和qname差不多，设置命名空间
            OMNamespace omNs = fac.createOMNamespace("http://loushang.ws", "exchangeInfo");
            OMElement data = fac.createOMElement("exchangeInfo", omNs);
            // 对应参数的节点
            String[] strs = new String[]{"args0"};
            // 参数值
            String[] val = new String[]{xmlInfo};
            for (int i = 0; i < strs.length; i++) {
                QName qname = new QName(strs[i]);
                OMElement inner = fac.createOMElement(qname);
                inner.setText(val[i]);
                data.addChild(inner);
            }
            // 发送数据，返回结果
            OMElement result = sender.sendReceive(data);
            res = result.getFirstElement().getText();
            sender.cleanupTransport();
        } catch (Exception e) {
            LOGGER.error("登簿日志报省.send.Exception error in:{}", e);
//            throw new AppException(2025);
            res = "登簿日志报省异常!";
        }
        return res;
    }

    /**
     * 获取客户端请求真实IP
     *
     * @return
     */
    public String getClientRealIP() {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        HttpServletRequest request = (HttpServletRequest) message.get(AbstractHTTPDestination.HTTP_REQUEST);
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }

        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }

        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip.trim().contains(",")) {//为什么会有这一步，因为经过多层代理后会有多个代理，取第一个ip地址就可以了
            String[] ips = ip.split(",");
            ip = ips[0];
        }
        return ip;
    }


    /**
     * 更新报部失败状态
     *
     * @param accessLogs
     */
    private void updateSbzt(AccessLogs accessLogs,String sbzt) {
        List<AccessLog> accessLogs1 = accessLogs.getAccessLog();
        for (AccessLog accessLog : accessLogs1) {
            accessLog.setSbzt(sbzt);
            baAccessLogMapper.updateSbjg(accessLog);
        }
    }



}
