package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaAccessLogMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaRzjlMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaXzqhMapper;
import cn.gtmap.realestate.supervise.server.service.JrdbzlpjService;
import cn.gtmap.realestate.supervise.server.service.JrqktjService;
import cn.gtmap.realestate.supervise.server.service.KxlService;
import cn.gtmap.realestate.supervise.server.utils.DataFormatUtils;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2018/8/6
 * @description 接入情况统计业务逻辑层实现类
 */
@Service
public class JrqktjServiceImpl implements JrqktjService {


    @Autowired
    BaXzqhMapper baXzqhMapper;

    @Autowired
    BaRzjlMapper baRzjlMapper;

    @Autowired
    BaAccessLogMapper baAccessLogMapper;


    @Autowired
    private JrdbzlpjService jrdbzlpjService;


    @Autowired
    private KxlService kxlService;




    @Override
    public List<Map<String, Object>> getJrqktjxx(String qhdm, Date kssj, Date jssj) {

        List<Map<String, Object>> xzqhxxList = baXzqhMapper.getXzqhxx(qhdm);
        if (CollectionUtils.isNotEmpty(xzqhxxList)) {
            if (null == kssj && null == jssj) {
                Date nowDate = new Date();
                kssj = TimeUtils.getThisWeekMonday(nowDate);
                jssj = nowDate;
            }
            String kssjStr = TimeUtils.dateToStr(kssj, "yyyyMMdd");
            String jssjStr = TimeUtils.dateToStr(jssj, "yyyyMMdd");
            for (Map<String, Object> temp : xzqhxxList) {
                String qhdmStr = (String) temp.get("QHDM");
                Map<String, Object> jrslMap = getJrsl(qhdmStr, kssjStr, jssjStr);
                BigDecimal zjrl = (BigDecimal) jrslMap.get("ZJRL") == null ? BigDecimal.valueOf(0) : (BigDecimal) jrslMap.get("ZJRL");//总接入量
                BigDecimal cgjrl = (BigDecimal) jrslMap.get("CGJRL") == null ? BigDecimal.valueOf(0) : (BigDecimal) jrslMap.get("CGJRL");//成功接入量
                int qxsl = temp.get("QXSL") == null ? 0 : Integer.parseInt(temp.get("QXSL").toString());//区县总数
                int wscsjsl = getWscsjqx(qhdmStr, kssjStr, jssjStr);//未上传数据区县数量
                int wscdbqxsl = getWdbqxsl(qhdmStr, kssjStr, jssjStr);//未上传登簿日志县区数量
                if (StringUtils.equals(Constant.XY, qhdmStr) || StringUtils.equals(Constant.WN, qhdmStr)) {//咸阳市 //渭南市
                    String qhdmTemp = "";
                    if (StringUtils.equals(Constant.XY, qhdmStr)) {
                        qhdmTemp = Constant.YL;
                    }
                    if (StringUtils.equals(Constant.WN, qhdmStr)) {
                        qhdmTemp = Constant.HC;
                    }
                    Map<String, Object> tempJrsl = getJrsl(qhdmTemp, kssjStr, jssjStr);//杨凌示范区 //韩城市
                    BigDecimal zjrlTemp = (BigDecimal) tempJrsl.get("ZJRL") == null ? BigDecimal.valueOf(0) : (BigDecimal) tempJrsl.get("ZJRL");
                    BigDecimal cgjrlTemp = (BigDecimal) tempJrsl.get("CGJRL") == null ? BigDecimal.valueOf(0) : (BigDecimal) tempJrsl.get("CGJRL");
                    zjrl = zjrl.add(zjrlTemp);
                    cgjrl = cgjrl.add(cgjrlTemp);
                    qxsl = qxsl + 1;
                    temp.put("QXSL", qxsl);
                    int tempWscsjsl = getWscsjqx(qhdmTemp, kssjStr, jssjStr);//未上传数据区县数量
                    int tempWscdbsl = getWdbqxsl(qhdmTemp, kssjStr, jssjStr);//未上传登簿日志县区数量
                    wscsjsl = wscsjsl + tempWscsjsl;
                    wscdbqxsl = wscdbqxsl + tempWscdbsl;
                }

                BigDecimal bd = zjrl.intValue() <= 0 ? BigDecimal.valueOf(0) : cgjrl.divide(zjrl, 4, BigDecimal.ROUND_HALF_EVEN);//成功率
                double cgl = bd.doubleValue();
                double jrcgldf = 40.00 - 2 * (1 - cgl) * 100 <= 0 ? 0 : DataFormatUtils.getTwoDecimal(40.00 - 2 * (1 - cgl) * 100);//接入成功率得分
                double sjjrdf = (qxsl == 0 ? 0 : 40 - 2 * wscsjsl / Double.valueOf(qxsl) * 100) <= 0 ? 0 : DataFormatUtils.getTwoDecimal(qxsl == 0 ? 0 : 40 - 2 * wscsjsl / Double.valueOf(qxsl) * 100);//数据接入得分
                double dbrzjrdf = (qxsl == 0 ? 0 : 20 - 1 * wscdbqxsl / Double.valueOf(qxsl) * 100) <= 0 ? 0 : DataFormatUtils.getTwoDecimal(qxsl == 0 ? 0 : 20 - 1 * wscdbqxsl / Double.valueOf(qxsl) * 100);//登簿日志接入得分
                temp.put("ZJRL", zjrl);//总接入量
                temp.put("CGJRL", cgjrl);//成功接入量
                temp.put("JRCGL", DataFormatUtils.getTwoDecimalStr(cgl * 100) + "%");//接入成功率
                if (cgl < 0.8) {
                    jrcgldf = 0;
                }
                temp.put("JRCGLDF", String.format("%.2f", jrcgldf));//接入成功率得分
                temp.put("WSCSJQXSL", wscsjsl);//未上传数据区县数量
                double tempWscsjqx = (double) wscsjsl / (double) qxsl;
                if (tempWscsjqx > 0.2) {
                    sjjrdf = 0;
                }
                temp.put("SJJRDF", String.format("%.2f", sjjrdf));//数据接入得分
                temp.put("WSCDBQXSL", wscdbqxsl);//未上传登簿日志县区数量
                double tempWscdbrzqx = (double) wscdbqxsl / (double) qxsl;
                if (tempWscdbrzqx > 0.2) {
                    dbrzjrdf = 0;
                }
                temp.put("DBRZJRDF", String.format("%.2f", dbrzjrdf));//登簿日志接入得分
                double jrzlzhpf = jrcgldf + sjjrdf + dbrzjrdf;
                temp.put("JRZLZHPF", String.format("%.2f", jrzlzhpf));//接入质量综合评分
            }

            //降序排序
            Collections.sort(xzqhxxList, new Comparator<Map<String, Object>>() {
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    Double va1 = Double.valueOf(o1.get("JRZLZHPF").toString());//从list里面拿出来的一个
                    Double va2 = Double.valueOf(o2.get("JRZLZHPF").toString()); //从list里面拿出来的第二个
                    return va2.compareTo(va1);
                }
            });
        }

        return xzqhxxList;
    }

    /**
     * 江苏省接入首页接入情况统计
     *
     * @param qhdm
     * @param kssj
     * @param jssj
     * @return
     */
    @Override
    public List<Map<String, Object>> getRocketMqJrqktjxx(String qhdm, Date kssj, Date jssj) {

        List<Map<String, Object>> xzqhxxList = baXzqhMapper.getXzqhxx(qhdm);
        if (CollectionUtils.isNotEmpty(xzqhxxList)) {
            if (null == kssj && null == jssj) {
                Date nowDate = new Date();
                kssj = TimeUtils.getThisWeekMonday(nowDate);
                jssj = nowDate;
            }
            String kssjStr = TimeUtils.dateToStr(kssj, "yyyyMMdd");
            String jssjStr = TimeUtils.dateToStr(jssj, "yyyyMMdd");
            for (Map<String, Object> temp : xzqhxxList) {
                String qhdmStr = (String) temp.get("QHDM");
                Map<String, Object> jrslMap = getJrsl(qhdmStr, kssjStr, jssjStr);//获取接入信息
                BigDecimal zjrl = (BigDecimal) jrslMap.get("ZJRL") == null ? BigDecimal.valueOf(0) : (BigDecimal) jrslMap.get("ZJRL");//总接入量
                BigDecimal cgjrl = (BigDecimal) jrslMap.get("CGJRL") == null ? BigDecimal.valueOf(0) : (BigDecimal) jrslMap.get("CGJRL");//成功接入量
                int qxsl = temp.get("QXSL") == null || temp.get("QXSL").equals(BigDecimal.valueOf(0))? 1 : Integer.parseInt(temp.get("QXSL").toString());//区县总数
                if(temp.get("QXSL") == null || temp.get("QXSL").equals(BigDecimal.valueOf(0))){
                    temp.put("QXSL",1);
                }
                int wscsjsl = getWscsjqx(qhdmStr, kssjStr, jssjStr);//未上传数据区县数量
                if(zjrl.equals(BigDecimal.valueOf(0))){
                    wscsjsl=1;
                }
                int wscdbqxsl = getWdbqxsl(qhdmStr, kssjStr, jssjStr);//未上传登簿日志县区数量
//                if(wscdbqxsl==0){
//                    wscdbqxsl=1;
//                }
                if (StringUtils.equals(Constant.XY, qhdmStr) || StringUtils.equals(Constant.WN, qhdmStr)) {//咸阳市 //渭南市
                    String qhdmTemp = "";
                    if (StringUtils.equals(Constant.XY, qhdmStr)) {
                        qhdmTemp = Constant.YL;
                    }
                    if (StringUtils.equals(Constant.WN, qhdmStr)) {
                        qhdmTemp = Constant.HC;
                    }
                    Map<String, Object> tempJrsl = getJrsl(qhdmTemp, kssjStr, jssjStr);//杨凌示范区 //韩城市
                    BigDecimal zjrlTemp = (BigDecimal) tempJrsl.get("ZJRL") == null ? BigDecimal.valueOf(0) : (BigDecimal) tempJrsl.get("ZJRL");
                    BigDecimal cgjrlTemp = (BigDecimal) tempJrsl.get("CGJRL") == null ? BigDecimal.valueOf(0) : (BigDecimal) tempJrsl.get("CGJRL");
                    zjrl = zjrl.add(zjrlTemp);
                    cgjrl = cgjrl.add(cgjrlTemp);
                    qxsl = qxsl + 1;
                    temp.put("QXSL", qxsl);
                    int tempWscsjsl = getWscsjqx(qhdmTemp, kssjStr, jssjStr);//未上传数据区县数量
                    int tempWscdbsl = getWdbqxsl(qhdmTemp, kssjStr, jssjStr);//未上传登簿日志县区数量
                    wscsjsl = wscsjsl + tempWscsjsl;
                    wscdbqxsl = wscdbqxsl + tempWscdbsl;
                }

                BigDecimal bd = zjrl.intValue() <= 0 ? BigDecimal.valueOf(0) : cgjrl.divide(zjrl, 4, BigDecimal.ROUND_HALF_EVEN);//成功率
                double cgl = bd.doubleValue();
                double jrcgldf = 40.00 - 2 * (1 - cgl) * 100 <= 0 ? 0 : DataFormatUtils.getTwoDecimal(40.00 - 2 * (1 - cgl) * 100);//接入成功率得分
                double sjjrdf = (qxsl == 0 ? 0 : 40 - 2 * wscsjsl / Double.valueOf(qxsl) * 100) <= 0 ? 0 : DataFormatUtils.getTwoDecimal(qxsl == 0 ? 0 : 40 - 2 * wscsjsl / Double.valueOf(qxsl) * 100);//数据接入得分
                double dbrzjrdf = (qxsl == 0 ? 0 : 20 - 1 * wscdbqxsl / Double.valueOf(qxsl) * 100) <= 0 ? 0 : DataFormatUtils.getTwoDecimal(qxsl == 0 ? 0 : 20 - 1 * wscdbqxsl / Double.valueOf(qxsl) * 100);//登簿日志接入得分
                temp.put("ZJRL", zjrl);//总接入量
                temp.put("CGJRL", cgjrl);//成功接入量
                temp.put("JRCGL", DataFormatUtils.getTwoDecimalStr(cgl * 100) + "%");//接入成功率
                if (cgl < 0.8) {
                    jrcgldf = 0;
                }
                temp.put("JRCGLDF", String.format("%.2f", jrcgldf));//接入成功率得分
                temp.put("WSCSJQXSL", wscsjsl);//未上传数据区县数量
                double tempWscsjqx = (double) wscsjsl / (double) qxsl;
                if (tempWscsjqx > 0.2) {
                    sjjrdf = 0;
                }
                temp.put("SJJRDF", String.format("%.2f", sjjrdf));//数据接入得分
                temp.put("WSCDBQXSL", wscdbqxsl);//未上传登簿日志县区数量
                double tempWscdbrzqx = (double) wscdbqxsl / (double) qxsl;
                if (tempWscdbrzqx > 0.2) {
                    dbrzjrdf = 0;
                }
                temp.put("DBRZJRDF", String.format("%.2f", dbrzjrdf));//登簿日志接入得分
                double jrzlzhpf = jrcgldf + sjjrdf + dbrzjrdf;
                temp.put("JRZLZHPF", String.format("%.2f", jrzlzhpf));//接入质量综合评分
            }

            //降序排序
            Collections.sort(xzqhxxList, new Comparator<Map<String, Object>>() {
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    Double va1 = Double.valueOf(o1.get("JRZLZHPF").toString());//从list里面拿出来的一个
                    Double va2 = Double.valueOf(o2.get("JRZLZHPF").toString()); //从list里面拿出来的第二个
                    return va2.compareTo(va1);
                }
            });
        }

        return xzqhxxList;
    }


    /**
     * 新的接入首页获取统计信息
     * @param kssj
     * @param jssj
     * @return
     */
    @Override
    public List<Map<String, Object>> getRocketNewMqJrqktjxx(String kssj, String jssj,String qhdm) {
        Map<String, Object> param = new HashMap<>();
        if (StringUtils.isNotBlank(kssj) && null != kssj) {
            param.put("kssj", kssj);
        }

        if (StringUtils.isNotBlank(jssj) && null != jssj) {
            param.put("jssj", jssj);
        }
        List<Map<String, Object>> jrtjXXList = baRzjlMapper.getRocketMqnewJrqktjxx(param);

        List<Map<String, Object>> xzqhList = baXzqhMapper.getDsxx(qhdm);//获取省份对应的地市个数
        List<Map<String, Object>> resultList = new ArrayList<>();//要返回的结果list 各大市数据
        Map<String, Object> ProvinceResultMap = Maps.newHashMap();//省级数据

        Map<String, String> paraMap = Maps.newHashMap();
        paraMap.put("kssj", kssj);
        paraMap.put("jssj", jssj);
        param.put("provinceDm", qhdm);
        List<Map<String, String>> jrzlpjData = jrdbzlpjService.getJrzlpjData(paraMap);//获取接入质量评价数据
        List<Map<String, Object>> jrdbzlpjData = kxlService.listCityAndCountyDataFinal(param, false);//获取登薄日志评价数据


        int sumJrywl = 0;
        int sumJrdbl = 0;
        int sumDbrzdbl = 0;
        int sumProvincexzqhTotal=0;
        int sumProvincejrywlTotal=0;
        int sumProvincejrdblTotal=0;
        int sumProvincedbrzTotal=0;
        double sumProvincejrzlpfTotal=0;
        double sumProvincedbzlpfTotal=0;
        //开始组装数据
        if (CollectionUtils.isNotEmpty(jrtjXXList) && CollectionUtils.isNotEmpty(xzqhList)) {
            for (int i = 0; i < xzqhList.size(); i++) {
                for (int j = 0; j < jrtjXXList.size(); j++) {
                    if (StringUtils.equals(jrtjXXList.get(j).get("QHJB").toString(), "省级")) {
                        ProvinceResultMap = jrtjXXList.get(j);
                    }
                    if (StringUtils.equals(jrtjXXList.get(j).get("QHJB").toString(), "市级") && StringUtils.equals(jrtjXXList.get(j).get("QHDM").toString(), xzqhList.get(i).get("QHDM").toString())) {
                        //得到地级市区
                        Map<String, Object> dsList = jrtjXXList.get(j);
                        //循坏该地级区 下面所有的县区
                        //得到该地级区下所有的 县市区接入业务量总和

                        for (int h = 0; h < jrtjXXList.size(); h++) {
                            if (StringUtils.equals(dsList.get("QHDM").toString(), jrtjXXList.get(h).get("FDM").toString()) && null != jrtjXXList.get(h).get("JRYWL")) {//地级市区下面的县区
                                sumJrywl += Integer.parseInt(jrtjXXList.get(h).get("JRYWL").toString());
                            }
                            if (StringUtils.equals(dsList.get("QHDM").toString(), jrtjXXList.get(h).get("FDM").toString()) && null != jrtjXXList.get(h).get("JRDBL")) {//地级市区下面的县区
                                sumJrdbl += Integer.parseInt(jrtjXXList.get(h).get("JRDBL").toString());
                            }
                            if (StringUtils.equals(dsList.get("QHDM").toString(), jrtjXXList.get(h).get("FDM").toString()) && null != jrtjXXList.get(h).get("DBRZDBL")) {//地级市区下面的县区
                                sumDbrzdbl += Integer.parseInt(jrtjXXList.get(h).get("DBRZDBL").toString());
                            }
                        }

                        for (int h = 0; h < jrzlpjData.size(); h++) {
                            if (StringUtils.equals(jrzlpjData.get(h).get("QHJB").toString(), "省级")) {
                                sumProvincejrzlpfTotal = Double.valueOf(jrzlpjData.get(h).get("DF").toString());
                                continue;
                            }
                            if (StringUtils.equals(dsList.get("QHDM").toString(), jrzlpjData.get(h).get("QHDM").toString())) {
                                dsList.put("JRZLZPF", jrzlpjData.get(h).get("DF").toString());//设置接入质量评分
                                break;
                            }
                        }
                        for (int m = 0; m < jrdbzlpjData.size(); m++) {
                            //登薄质量评价数据 用 字符串长度来判断是否为省份
                            if (jrdbzlpjData.get(m).get("CITY_QHDM").toString().length() == 2) {
                                sumProvincedbzlpfTotal = Double.valueOf(jrdbzlpjData.get(m).get("ZHPF").toString());
                                continue;
                            }
                            if (StringUtils.equals(dsList.get("QHDM").toString(), jrdbzlpjData.get(m).get("CITY_QHDM").toString())) {
                                dsList.put("DBRZZPF", jrdbzlpjData.get(m).get("ZHPF").toString()); //设置 登薄日志评分
                                break;
                            }
                        }
                        dsList.put("JRYWL", Integer.valueOf(sumJrywl));
                        dsList.put("JRDBL", Integer.valueOf(sumJrdbl));
                        dsList.put("DBRZDBL", Integer.valueOf(sumDbrzdbl));
                        Double JRZLZPF = Double.valueOf(dsList.get("JRZLZPF").toString());
                        Double DBRZZPF = Double.valueOf(dsList.get("DBRZZPF").toString());
                        BigDecimal JRZLZPFBig= new BigDecimal(Double.toString(JRZLZPF));
                        BigDecimal DBRZZPFBig= new BigDecimal(Double.toString(DBRZZPF));
                        double  allpf= JRZLZPFBig.add(DBRZZPFBig).doubleValue();
                        dsList.put("AllPF",  String.format("%.2f", allpf));//总评分
                        resultList.add(dsList);
                        sumJrywl = 0;
                        sumJrdbl = 0;
                        sumDbrzdbl = 0;
                    }

                }

            }


        }

            //降序排序 安装总评分降序
            Collections.sort(resultList, new Comparator<Map<String, Object>>() {
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    Double va1 = Double.valueOf(o1.get("AllPF").toString());//从list里面拿出来的一个
                    Double va2 = Double.valueOf(o2.get("AllPF").toString()); //从list里面拿出来的第二个
                    return va2.compareTo(va1);
                }
              });


           //设置 序号 并且将 省级数据放进要返回的list中
          for(int f=0;f<=resultList.size();f++) {
              if(f < resultList.size()){
                  resultList.get(f).put("XH", f+1);
                  if(StringUtils.isNotBlank(resultList.get(f).get("TOTALXZQ").toString())){
                      sumProvincexzqhTotal += Integer.parseInt(resultList.get(f).get("TOTALXZQ").toString());
                  }
                 if(StringUtils.isNotBlank(resultList.get(f).get("JRYWL").toString())){
                     sumProvincejrywlTotal += Integer.parseInt(resultList.get(f).get("JRYWL").toString());
                 }
                 if(StringUtils.isNotBlank(resultList.get(f).get("JRDBL").toString())){
                     sumProvincejrdblTotal += Integer.parseInt(resultList.get(f).get("JRDBL").toString());
                 }
                  if(StringUtils.isNotBlank(resultList.get(f).get("DBRZDBL").toString())){
                      sumProvincedbrzTotal +=  Integer.parseInt(resultList.get(f).get("DBRZDBL").toString());
                  }

              }
              if (f == resultList.size()) {
                  ProvinceResultMap.put("XH", resultList.size() + 1);
                  ProvinceResultMap.put("TOTALXZQ", sumProvincexzqhTotal);
                  ProvinceResultMap.put("JRYWL", sumProvincejrywlTotal);
                  ProvinceResultMap.put("JRDBL", sumProvincejrdblTotal);
                  ProvinceResultMap.put("DBRZDBL", sumProvincedbrzTotal);
                  ProvinceResultMap.put("JRZLZPF", String.format("%.2f",sumProvincejrzlpfTotal));
                  ProvinceResultMap.put("DBRZZPF", String.format("%.2f",sumProvincedbzlpfTotal));
                  Double provincejrywlpf=Double.valueOf(ProvinceResultMap.get("JRZLZPF").toString());
                  Double provincedbrzlpf=Double.valueOf(ProvinceResultMap.get("DBRZZPF").toString());
                  BigDecimal JRZLZPFBig= new BigDecimal(Double.toString(provincejrywlpf));
                  BigDecimal DBRZZPFBig= new BigDecimal(Double.toString(provincedbrzlpf));
                  double  allpfProvince= JRZLZPFBig.add(DBRZZPFBig).doubleValue();
                  ProvinceResultMap.put("AllPF",String.format("%.2f", allpfProvince) );
              }
          }
        resultList.add(ProvinceResultMap);

        return resultList;


    }


    /**
     * 获取总接入量，成功接入量信息
     *
     * @param qhdm
     * @param kssj
     * @param jssj
     * @return
     */
    private Map<String, Object> getJrsl(String qhdm, String kssj, String jssj) {
        Map<String, Object> resMap = baRzjlMapper.getJrtjqkJrsl(qhdm, kssj, jssj);
        return resMap;
    }

    /**
     * 获取总接入量，成功接入量信息
     *
     * @param qhdm
     * @param kssj
     * @param jssj
     * @return
     */
    private Map<String, Object> getRocketMQJrsl(String qhdm, Date kssj, Date jssj) {
        Map<String, Object> resMap = baRzjlMapper.getRocketMqJrqktjxx(qhdm, kssj, jssj);
        return resMap;
    }


    /**
     * 获取
     *
     * @param qhdm
     * @param kssj
     * @param jssj
     * @return
     */
    private int getWscsjqx(String qhdm, String kssj, String jssj) {

        int qxsl = baXzqhMapper.getWscsjqx(qhdm, kssj, jssj);

        return qxsl;
    }

    /**
     * 获取
     *
     * @param qhdm
     * @param kssj
     * @param jssj
     * @return
     */
    private int getRocketMqWscsjqx(String qhdm, Date kssj, Date jssj) {

        int qxsl = baXzqhMapper.getRocketMqWscsjqx(qhdm, kssj, jssj);

        return qxsl;
    }

    /**
     * 获取未登薄区县数量
     *
     * @param qhdm
     * @param kssj
     * @param jssj
     * @return
     */
    private int getWdbqxsl(String qhdm, String kssj, String jssj) {
        int wdbqxsl = baAccessLogMapper.getWdbqxsl(qhdm, kssj, jssj);
        return wdbqxsl;
    }

}
