package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.realestate.supervise.server.dao.mapper.BaXzqhMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.JrjcfkqkMapper;
import cn.gtmap.realestate.supervise.server.service.JrjcfkqkService;
import cn.gtmap.realestate.supervise.server.utils.ExportExcelUtils;
import cn.gtmap.realestate.supervise.utils.OperationalLogUtil;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0 2019-7-31
 * @auther <a href="mailto:xutao@gtmap.cn">xutao</a>
 * @description
 */
@Service
public class JrjcfkqkServiceImpl implements JrjcfkqkService {

    /**
     * 日志打印对象
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(JrjcfkqkServiceImpl.class);

    @Autowired
    private JrjcfkqkMapper jrjcfkqkMapper;

    @Autowired
    private BaXzqhMapper baXzqhMapper;

    private static final String CITY_QHDM = "QHDM";

    private static final String CITY_QHMC = "QHMC";

    private static final String FDM = "fdm";

    private static final String provinceDm = AppConfig.getProperty("region.qhdm");

    /**
     * 市数据
     *
     * @param param
     * @return
     */
    @Override
    public List<Map<String, Object>> listCityData(Map<String, Object> param) {
        List<Map<String, Object>> cityData = new ArrayList<>();
        String fdm = "";
        if(provinceDm.substring(2,4).equals("00")){
            param.put(FDM, provinceDm);
        }else {
            fdm = baXzqhMapper.getFDMByqhdm(provinceDm);
            param.put(FDM,fdm);
        }

        List<Map<String, Object>> cityWscbwList = jrjcfkqkMapper.listCityData_jrzsl(param);
        List<Map<String, Object>> cityDlcsList = jrjcfkqkMapper.listCityData_dlcs(param);
        mergeList(cityWscbwList, cityDlcsList, CITY_QHDM, CITY_QHDM);

        getCityWscQx(cityWscbwList, param);
        calculateCgl(cityWscbwList);
        appendXh(cityWscbwList);

        if(provinceDm.substring(2,4).equals("00")){
            return cityWscbwList;
        }else {
            for(int i= 0;i<cityWscbwList.size();i++){
                if(cityWscbwList.get(i).get("QHDM").toString().equals(provinceDm)){
                    cityData.add(cityWscbwList.get(i));
                }
            }
            return cityData;
        }
    }

    /**
     * 添加序号
     *
     * @param list
     */
    private void appendXh(List<Map<String, Object>> list) {
        for (int i = 0; i < list.size(); i++) {
            list.get(i).put("XH", i + 1);
        }
    }

    /**
     * 计算成功率
     *
     * @param list
     */
    private void calculateCgl(List<Map<String, Object>> list) {
        for (int i = 0; i < list.size(); i++) {
            list.get(i).put("CGL", divValue(list.get(i), "CGSL", "JRZSL"));
        }
    }

    /**
     * 计算比例
     *
     * @param obj
     * @param fz
     * @param fm
     * @return
     */
    private String divValue(Map<String, Object> obj, String fz, String fm) {
        String val1 = MapUtils.getString(obj, fz);
        String val2 = MapUtils.getString(obj, fm);
        BigDecimal result;
        if(StringUtils.isBlank(val1)){
            val1 = "0";
        }
        if(StringUtils.isBlank(val2)){
            val2 = "0";
        }
        BigDecimal bval1 = new BigDecimal(Integer.parseInt(val1));
        BigDecimal bval2 = new BigDecimal(Integer.parseInt(val2));
        if (bval2.intValue() == 0) {
            result = new BigDecimal(0.0000);
        } else {
            if (bval1.intValue() == 0) {
                result = new BigDecimal(0.0000);
            } else {
                result = bval1.divide(bval2, 4, RoundingMode.HALF_UP);
            }
        }
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(result.multiply(new BigDecimal(100))) + "%";
    }

    /**
     * 获取区县
     *
     * @param cityList
     */
    private void getCityWscQx(List<Map<String, Object>> cityList, Map<String, Object> param) {
        if (CollectionUtils.isNotEmpty(cityList)) {
            String fdm;
            for (int i = 0; i < cityList.size(); i++) {
                fdm = MapUtils.getString(cityList.get(i), CITY_QHDM);
                param.put(FDM, fdm);
                List<Map<String, Object>> wscbwList = jrjcfkqkMapper.listCityData_wscbw(param);
                List<Map<String, Object>> wscdbrzList = jrjcfkqkMapper.listCityData_wscdbrz(param);
                cityList.get(i).put("WSCBW", mergeQhmc_WSCBW(wscbwList, "WSCBW", "JRZSL","CGSL"));
                cityList.get(i).put("WSCDBRZ", mergeQhmc(wscdbrzList, "WSCDBRZ"));
            }
        }
    }

    /**
     * 合并区县
     *
     * @param list
     * @return
     */
    private String mergeQhmc_WSCBW(List<Map<String, Object>> list, String key, String key1, String key2) {
        StringBuffer sb = new StringBuffer();
        if (CollectionUtils.isNotEmpty(list)) {
            for (int i = 0; i < list.size(); i++) {
                if(StringUtils.isBlank(MapUtils.getString(list.get(i), key2))
                    || StringUtils.equals(MapUtils.getString(list.get(i), key2), "0")){
                    if(StringUtils.equals(MapUtils.getString(list.get(i), key), "1")) {
                        sb.append(MapUtils.getString(list.get(i), CITY_QHMC));
                        sb.append("，");
                    } else if (!StringUtils.equals(MapUtils.getString(list.get(i), key1), "0")){
                        sb.append(MapUtils.getString(list.get(i), CITY_QHMC));
                        sb.append("，");
                    }
                }
            }
        }
        if(StringUtils.isBlank(sb.toString())){
            sb.append("-");
            return sb.toString();
        }
        return sb.toString().substring(0, sb.length()-1);
    }

    /**
     * 合并区县
     *
     * @param list
     * @return
     */
    private String mergeQhmc(List<Map<String, Object>> list, String key) {
        StringBuffer sb = new StringBuffer();
        if (CollectionUtils.isNotEmpty(list)) {
            for (int i = 0; i < list.size(); i++) {
                if (StringUtils.equals(MapUtils.getString(list.get(i), key), "1")) {
                    sb.append(MapUtils.getString(list.get(i), CITY_QHMC));
                    sb.append("，");
                }
            }
        }
        if(StringUtils.isBlank(sb.toString())){
            sb.append("-");
            return sb.toString();
        }
        return sb.toString().substring(0, sb.length()-1);
    }

    /**
     * 合并
     *
     * @param list0
     * @param list1
     * @param key0
     * @param key1
     */
    private void mergeList(List<Map<String, Object>> list0, List<Map<String, Object>> list1, String key0, String key1) {
        if (CollectionUtils.isNotEmpty(list0) && CollectionUtils.isNotEmpty(list1)) {
            for (int i = 0; i < list0.size(); i++) {
                for (int j = 0; j < list1.size(); j++) {
                    if (StringUtils.equals(MapUtils.getString(list0.get(i), key0), MapUtils.getString(list1.get(j), key1))) {
                        list0.get(i).putAll(list1.get(j));
                    }
                }
            }
        }
    }

    /**
     * 导出
     *
     * @param param
     * @param response
     */
    @Override
    public void exportExcelJrjcfkqk(Map<String, Object> param, HttpServletResponse response, HttpServletRequest request) {
        String kssj = MapUtils.getString(param, "kssj");
        String jssj = MapUtils.getString(param, "jssj");

        kssj = DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(kssj).toString("yyyy年MM月dd日");
        jssj = DateTimeFormat.forPattern("yyyy-MM-dd").parseDateTime(jssj).toString("yyyy年MM月dd日");

        StringBuilder sb = new StringBuilder();
        sb.append(MapUtils.getString(param, "provinceName"));
        sb.append("信息平台接入监测反馈情况（");
        sb.append(kssj).append("至").append(jssj).append("）");

        List<String> keysList = Lists.newArrayList();
        keysList.add("XH");
        keysList.add("QHMC");
        keysList.add("WSCBW");
        keysList.add("WSCDBRZ");
        keysList.add("JRZSL");
        keysList.add("CGSL");
        keysList.add("CGL");
        keysList.add("DLCS");
        OperationalLogUtil.log(request, "1", "信息平台接入监测反馈情况导出", "接入系统");
        ExportExcelUtils.exportJrjcfkqkInfos(listCityData(param), sb.toString(), keysList, "jrjcfkqk", response);
    }

}
