package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaTjfxMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.JrdbzlpjMapper;
import cn.gtmap.realestate.supervise.server.entity.Pjdfqk;
import cn.gtmap.realestate.supervise.server.service.JrdbzlpjService;
import cn.gtmap.realestate.supervise.server.service.KxlService;
import cn.gtmap.realestate.supervise.server.utils.Constants;
import cn.gtmap.realestate.supervise.server.utils.WordUtil;
import cn.gtmap.realestate.supervise.utils.OperationalLogUtil;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;


@Service
public class JrdbzlpjServiceImpl implements JrdbzlpjService {
    @Autowired
    private JrdbzlpjMapper jrdbzlpjMapper;

    @Autowired
    private BaTjfxMapper baTjfxMapper;

    @Autowired
    private JrdbzlpjService jrdbzlpjService;

    @Autowired
    private KxlService kxlService;

    String region = AppConfig.getProperty("region.qhdm");




    @Override
    public List<Map<String, String>> getJrzlpjData(Map<String, String> map) {
        List<Map<String, String>> queryData = jrdbzlpjMapper.getJrzlpjData(map);
        List<Map<String, String>> jrhz = jrdbzlpjMapper.getJrzlpjHzByCity(map);

        List<Map<String, String>> wscsjqx = new ArrayList<>();
        List<Map<String, String>> wdbqxsl = new ArrayList<>();
        int num = 1;
        for (Map<String, String> data : queryData) {
            if ("省级".equals(data.get("QHJB"))) {
                data.putAll(getProvinceHzData(data,jrhz,map,queryData));
                data.put("XH",String.valueOf(num));
                num ++;
                continue;
            }
            if ("市级".equals(data.get("QHJB"))) {
                data.putAll(getHzData(jrhz,data.get("QHDM")));
                data.put("XH",String.valueOf(num));
                num ++;
            }
            data.putAll(getProportion(data,map,wscsjqx,wdbqxsl,queryData));
        }

        return queryData;
    }

    /**
     * 计算全省数据
     * @param provinceData 全省数据
     * @param jrhz 各市汇总数据
     * @param map 参数
     * @return 全省汇总数据
     */
    private Map<String, String> getProvinceHzData(Map<String, String> provinceData, List<Map<String, String>> jrhz,Map<String, String> map,List<Map<String, String>> queryData) {
        long jrdblTotal = 0;
        long dbrzdblTotal = 0;
        double jrdbl1Total = 0;
        double jrdbl2Total = 0;
        double jrdbl3Total = 0;
        long jrywlTotal = 0;
        int wscsjslTotal = 0;
        int wscdbqxslTotal =0;
        int wscsjsl;
        int wscdbqxsl;
        for (Map<String, String> data : jrhz) {
            dbrzdblTotal += Integer.valueOf(data.get("DBRZDBL"));
            jrdblTotal += Integer.valueOf(data.get("JRDBL"));
            jrdbl1Total += Integer.valueOf(data.get("JRDBL1"));
            jrdbl2Total += Integer.valueOf(data.get("JRDBL2"));
            jrdbl3Total += Integer.valueOf(data.get("JRDBL3"));
            jrywlTotal += Integer.valueOf(data.get("JRYWL"));
//            wscsjsl = getWscsjqx(data.get("QHDM"), map.get("kssj"), map.get("jssj"));
//            wscdbqxsl = getWdbqxsl(data.get("QHDM"), map.get("kssj"), map.get("jssj"));
//            wscsjslTotal += wscsjsl;
//            wscdbqxslTotal += wscdbqxsl;
        }
        String qhdmStr = provinceData.get("QHDM");
        for (Map<String, String> temp: queryData) {
            if ("县级".equals(temp.get("QHJB"))) {
                wscsjslTotal += Integer.valueOf(temp.get("WSCSJSL"));
                wscdbqxslTotal += Integer.valueOf(temp.get("WSCDBQXSL"));
            }
        }

        String wcgjrdbl = String.valueOf(dbrzdblTotal - jrdblTotal);
        double wcgjrzb = dbrzdblTotal ==0 ? -1: Double.valueOf(wcgjrdbl)/dbrzdblTotal;
        double jrdbl1Zb = jrdblTotal ==0 ? 0: jrdbl1Total/jrdblTotal;
        double jrdbl2Zb = jrdblTotal ==0 ? 0: jrdbl2Total/jrdblTotal;
        double jrdbl3Zb = jrdblTotal ==0 ? 0: jrdbl3Total/jrdblTotal;
        provinceData.put("JRYWL",String.valueOf(jrywlTotal));
        provinceData.put("JRDBL",String.valueOf(jrdblTotal));
        provinceData.put("DBRZDBL",String.valueOf(dbrzdblTotal));
        provinceData.put("JRDBL1",String.valueOf((int)jrdbl1Total));
        provinceData.put("JRDBL2",String.valueOf((int)jrdbl2Total));
        provinceData.put("JRDBL3",String.valueOf((int)jrdbl3Total));


        provinceData.put("WSCSJSL",String.valueOf(wscsjslTotal));
        provinceData.put("WSCDBQXSL",String.valueOf(wscdbqxslTotal));

        int wsbdf = wscsjslTotal >= 10? 0 : 10- wscsjslTotal;
        int wscdf = wscdbqxslTotal >=10 ? 0: 10-wscdbqxslTotal;
        double wcgjrdbdf = 0;
        if (wcgjrzb >= 0) {
            wcgjrdbdf = 40- 40 * wcgjrzb;
        }
        double fdzbdf = 40* jrdbl1Zb + 30* jrdbl2Zb +10* jrdbl3Zb;
        double zf = wscdf + wsbdf + wcgjrdbdf + fdzbdf;
        provinceData.put("DF",String.format("%.2f", zf));


        provinceData.put("WCGJRDBL",wcgjrdbl);
        provinceData.put("WCGJRZB",String.format("%.2f", wcgjrzb*100)+"%");
        provinceData.put("JRDBL1ZB",String.format("%.2f", jrdbl1Zb*100)+"%");
        provinceData.put("JRDBL2ZB",String.format("%.2f", jrdbl2Zb*100)+"%");
        provinceData.put("JRDBL3ZB",String.format("%.2f", jrdbl3Zb*100)+"%");
        return provinceData;
    }

    /**
     * 获取各市汇总
     * @param jrhz  各市汇总数据
     * @param qhdm  区划代码
     * @return 市汇总数据
     */
    private Map<String, String> getHzData(List<Map<String, String>> jrhz,String qhdm){
        Map<String, String> result = new HashMap<>(3);
        for (Map<String, String> map : jrhz) {
            if (qhdm.equals(map.get("QHDM"))) {
                result = map;
                break;
            }
        }
        return result;
    }

    /**
     * 计算各个占比，分数
     * @param map 参数
     * @param wdbqxsl  未上报区县
     * @param wscsjqx  未上传区县
     * @param data 各区县数据
     */
    public Map<String, String> getProportion(Map<String, String> data, Map<String,String> map,List<Map<String, String>> wscsjqx,List<Map<String, String>> wdbqxsl,List<Map<String, String>> queryData) {
        String dbrzdbl = data.get("DBRZDBL");
        String jrdbl = data.get("JRDBL");
        String jrdbl1 = data.get("JRDBL1");
        String jrdbl2 = data.get("JRDBL2");
        String jrdbl3 = data.get("JRDBL3");
        // 未上传数据区县数量
        int wscsjsl = 0;
        // 未上传登簿日志县区数量
        int wscdbqxsl = 0;
        String wcgjrdbl = String.valueOf(Integer.valueOf(dbrzdbl) - Integer.valueOf(jrdbl));
        double wcgjrzb = Integer.valueOf(dbrzdbl) ==0 ? -1: Double.valueOf(wcgjrdbl)/Integer.valueOf(dbrzdbl);
        double jrdbl1Zb = Integer.valueOf(jrdbl) ==0 ? 0: Double.valueOf(jrdbl1)/Integer.valueOf(jrdbl);
        double jrdbl2Zb = Integer.valueOf(jrdbl) ==0 ? 0: Double.valueOf(jrdbl2)/Integer.valueOf(jrdbl);
        double jrdbl3Zb = Integer.valueOf(jrdbl) ==0 ? 0: Double.valueOf(jrdbl3)/Integer.valueOf(jrdbl);
        data.put("WCGJRDBL",wcgjrdbl);

        String qhdmStr =  data.get("QHDM");

        //未上传得分
        int wscdf;
        // 未上传登簿得分
        int wsbdf;
        if ("市级".equals(data.get("QHJB"))) {
            //wscsjsl = getWscsjqx(qhdmStr, map.get("kssj"), map.get("jssj"));
            //wscdbqxsl = getWdbqxsl(qhdmStr, map.get("kssj"), map.get("jssj"));
            for (Map<String, String> temp: queryData) {
                if (qhdmStr.equals(temp.get("FDM"))) {
                    wscsjsl += Integer.valueOf(temp.get("WSCSJSL"));
                    wscdbqxsl += Integer.valueOf(temp.get("WSCDBQXSL"));
                }
            }
            wscdf = wscdbqxsl >=10 ? 0: 10-wscdbqxsl;
            wsbdf = wscsjsl >= 10? 0 : 10- wscsjsl;
        } else {
            wscsjsl = Integer.valueOf(data.get("WSCSJSL"));
            wscdbqxsl = Integer.valueOf(data.get("WSCDBQXSL"));
            if (wscsjsl == 1) {
                wscdf = 0;
            } else {
                wscdf = 10;
            }
            if (wscdbqxsl ==1) {
                wsbdf = 0;
            } else {
                wsbdf = 10;
            }
//            if (ifqxsf(wscsjqx,qhdmStr)) {
//                wscsjsl = 1;
//                wscdf = 0;
//            } else {
//                wscsjsl = 0;
//                wscdf = 10;
//            }
//            if (ifdb(wdbqxsl,qhdmStr)) {
//                wscdbqxsl = 1;
//                wsbdf = 0;
//            } else {
//                wscdbqxsl = 0;
//                wsbdf = 10;
//            }

        }
        data.put("WSCDBQXSL",String.valueOf(wscdbqxsl));
        data.put("WSCSJSL",String.valueOf(wscsjsl));
        double wcgjrdbdf = 0;
        if (wcgjrzb >= 0) {
            wcgjrdbdf = 40- 40 * wcgjrzb;
        }
        double fdzbdf = 40* jrdbl1Zb + 30* jrdbl2Zb +10* jrdbl3Zb;
        double zf = wscdf + wsbdf + wcgjrdbdf + fdzbdf;
        data.put("DF",String.format("%.2f", zf));

        data.put("WCGJRZB",String.format("%.2f", wcgjrzb*100)+"%");
        data.put("JRDBL1ZB",String.format("%.2f", jrdbl1Zb*100)+"%");
        data.put("JRDBL2ZB",String.format("%.2f", jrdbl2Zb*100)+"%");
        data.put("JRDBL3ZB",String.format("%.2f", jrdbl3Zb*100)+"%");
        // 计算分数，
        return data;
    }

    /**
     * 获取未上传数据区县
     *
     * @param qhdm 区划代码
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @return 未上传数据区县
     */
    private int getWscsjqx(String qhdm, String kssj, String jssj) {
        return  jrdbzlpjMapper.getWscsjqxCount(qhdm, kssj, jssj);
    }

    /**
     * 获取未登薄区县数量
     *
     * @param qhdm 区划代码
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @return 未登薄区县数量
     */
    private int getWdbqxsl(String qhdm, String kssj, String jssj) {
        return jrdbzlpjMapper.getWdbqxslCount(qhdm, kssj, jssj);
    }

    /**
     * 判断区县是否上传
     */
    private boolean ifqxsf(List<Map<String, String>> wscsjqx,String qhdm){
        boolean flag = false;
        for (Map<String, String > map : wscsjqx) {
            if (qhdm.equals(map.get("QHDM"))) {
                flag = true;
                break;
            }
        }
        return  flag;
    }

    /**
     * 判断未登薄区县
     * @param wdbqxsl  登薄区县
     * @param qhdm 区划代码
     */
    private boolean ifdb(List<Map<String, String>> wdbqxsl,String qhdm){
        boolean flag = false;
        for (Map<String, String > map : wdbqxsl) {
            if (qhdm.equals(map.get("QHDM"))) {
                flag = true;
                break;
            }
        }
        return  flag;
    }

    @Override
    public void exportJrpjzlDataSX(HttpServletResponse response, HttpServletRequest request, Map<String, String> map ,Map<String, String> sqmap) {
        List<Map<String,String>> data =  getJrzlpjData(map);
        List<Map<String,String>> sqdata =  getJrzlpjData(sqmap);
        //增加上期综合评分和变化情况
        for(int i=0;i<data.size();i++){
            String sqdf = sqdata.get(i).get("DF");
            String df = data.get(i).get("DF");

            data.get(i).put("SQDF",sqdf);
            double sqdfDouble = Double.valueOf(sqdf);
            double dfDouble = Double.valueOf(df);
            double bh = dfDouble - sqdfDouble;

            String bhqk = String.valueOf( (double) Math.round(bh * 100) / 100);

            data.get(i).put("BHQK",bhqk);

        }
        List<Map<String, String>> cityData = new ArrayList<>();
        Map<String, String> proData = new HashMap<>(5);
        Map<String, String> proData1 = new HashMap<>(5);
        // 获取大市
        for (Map<String,String> temp : data) {
            if ("省级".equals(temp.get("QHJB"))) {
                proData = temp;
                proData1 = temp;
            }
            if ("市级".equals(temp.get("QHJB"))) {
                cityData.add(temp);
            }
        }
        List<Map<String,String>> result = new ArrayList<>();
        List<Map<String,String>> result1 = new ArrayList<>();

        // 区县按照大市排序
        if(proData.size() != 0){
            result.add(proData);
            String proviceName = proData.get("QHMC");
            proData1.put("DSQHMC",proviceName);
            result1.add(proData1);
        }

        for (Map<String,String> temp : cityData) {
            result.add(temp);
            for (Map<String,String> mapData : data) {
                if (mapData.get("FDM").equals(temp.get("QHDM"))) {
                    result.add(mapData);
                    mapData.put("DSQHMC",temp.get("QHMC"));
                    result1.add(mapData);
                }
            }
        }

        // 大市按照得分排序
        Collections.sort(cityData, new Comparator<Map<String, String>>() {
            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                if (Double.valueOf(o1.get("DF")) > Double.valueOf(o2.get("DF"))) {
                    return -1;
                }
                if (Double.valueOf(o1.get("DF")) < Double.valueOf(o2.get("DF"))) {
                    return 1;
                }
                return 0;
            }
        });
        List<Map<String,String>> newCity = new ArrayList<>();

        if(proData.size() != 0){
            newCity.add(proData);
        }
        newCity.addAll(cityData);
        String kssj = "";
        String jssj = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
            Date kssjDate = sdf.parse(map.get("kssj"));
            Date jssjDate = sdf.parse(map.get("jssj"));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年mm月dd日");
            kssj = simpleDateFormat.format(kssjDate);
            jssj = simpleDateFormat.format(jssjDate);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        String exportName = map.get("qhmc")+"不动产登记增量数据接入质量评价表（"+kssj+"至"+jssj+"）";
        //大市表头
        List<Map<String, String>> title = new ArrayList<>();
        Map<String, String> temp = new HashMap<>(3);

        //区县表头
        List<Map<String, String>> title1 = new ArrayList<>();

        temp.put("key","XH");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","DSQHMC");
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","QHMC");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","JRYWL");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","JRDBL");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","DBRZDBL");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","WSCDBQXSL");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","WSCSJSL");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","WCGJRDBL");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","WCGJRZB");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","JRDBL1");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","JRDBL1ZB");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","JRDBL2");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","JRDBL2ZB");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","JRDBL3");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","JRDBL3ZB");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","wlqk");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","fdbhj");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","fzdqh");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","DF");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","SQDF");
        title.add(temp);
        title1.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","BHQK");
        title.add(temp);
        title1.add(temp);

        OperationalLogUtil.log(request, "1", "信息平台增量数据接入质量评价表", "接入系统");
        exportExcelSX(response,exportName,title,title1,newCity,result,result1);
    }

    @Override
    public void exportJrpjzlData(HttpServletResponse response, HttpServletRequest request, Map<String, String> map) {
        List<Map<String,String>> data =  getJrzlpjData(map);
        List<Map<String, String>> cityData = new ArrayList<>();
        Map<String, String> proData = new HashMap<>(5);
        // 获取大市
        for (Map<String,String> temp : data) {
            if ("省级".equals(temp.get("QHJB"))) {
                proData = temp;
            }
            if ("市级".equals(temp.get("QHJB"))) {
                cityData.add(temp);
            }
        }
        List<Map<String,String>> result = new ArrayList<>();
        // 区县按照大市排序
        if(!proData.isEmpty()){
            result.add(proData);
        }

        for (Map<String,String> temp : cityData) {
            result.add(temp);
            for (Map<String,String> mapData : data) {
                if (mapData.get("FDM").equals(temp.get("QHDM"))) {
                    result.add(mapData);
                }
            }
        }

        // 大市按照得分排序
        Collections.sort(cityData, new Comparator<Map<String, String>>() {
            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                if (Double.valueOf(o1.get("DF")) > Double.valueOf(o2.get("DF"))) {
                    return -1;
                }
                if (Double.valueOf(o1.get("DF")) < Double.valueOf(o2.get("DF"))) {
                    return 1;
                }
                return 0;
            }
        });
        List<Map<String,String>> newCity = new ArrayList<>();
        if (!proData.isEmpty()) {
            newCity.add(proData);
        }
//        newCity.add(proData);
        newCity.addAll(cityData);
        String kssj = "";
        String jssj = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
            Date kssjDate = sdf.parse(map.get("kssj"));
            Date jssjDate = sdf.parse(map.get("jssj"));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年mm月dd日");
            kssj = simpleDateFormat.format(kssjDate);
            jssj = simpleDateFormat.format(jssjDate);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        String exportName = map.get("qhmc")+"不动产登记增量数据接入质量评价表（"+kssj+"至"+jssj+"）";
        List<Map<String, String>> title = new ArrayList<>();
        Map<String, String> temp = new HashMap<>(3);
        temp.put("key","XH");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","QHMC");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","JRYWL");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","JRDBL");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","DBRZDBL");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","WSCDBQXSL");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","WSCSJSL");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","WCGJRDBL");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","WCGJRZB");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","JRDBL1");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","JRDBL1ZB");
        title.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","JRDBL2");
        title.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","JRDBL2ZB");
        title.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","JRDBL3");
        title.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","JRDBL3ZB");
        title.add(temp);

        temp = new HashMap<>(3);
        temp.put("key","wlqk");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","fdbhj");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","fzdqh");
        title.add(temp);
        temp = new HashMap<>(3);
        temp.put("key","DF");
        title.add(temp);
        OperationalLogUtil.log(request, "1", "信息平台增量数据接入质量评价表", "接入系统");
        exportExcel(response,exportName,title,newCity,result);
    }

    /**
     * 导出
     * @param response  response
     * @param data 数据
     * @param cityData 大市数据
     * @param title     表头
     */
    public void exportExcel(HttpServletResponse response, String exportName, List<Map<String, String>> title, List<Map<String, String>> cityData, List<Map<String, String>> data) {
        //导出数据
        String egovConf = AppConfig.getProperty("egov.conf");
        String filePath = egovConf + "/server/jrzlpjb.xlsx";
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            filePath = filePath.substring(filePath.indexOf("/") + 1);
        } else {
            filePath = filePath.substring(filePath.indexOf(":") + 1);
        }
        try {
            FileInputStream fis = new FileInputStream(filePath);
            XSSFWorkbook wb = new XSSFWorkbook(fis);
            // 第二步，在webbook中添加一个sheet,对应Excel文件中的sheet
            XSSFSheet sheet = wb.getSheetAt(0);
            // 第三步，在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short
            // 第四步，创建单元格，并设置值表头 设置表头居中

            // 插入第一个sheet页
            wb = writeExcel(wb, sheet,5,title,cityData,exportName);
            // 插入第二个sheet页
            XSSFSheet dataSheet = wb.getSheetAt(1);
            wb = writeExcel(wb, dataSheet,5,title,data,exportName);

            // 第六步，将文件存到指定位置
            String timeStr = new String(exportName.getBytes(), "iso-8859-1");

            response.setContentType("application/vnd.ms-excel");
            //timeStr为文件名
            response.setHeader("Location", timeStr + ".xlsx");
            // 设置下载时的文件名称
            response.setHeader(
                    "Content-Disposition",
                    "attachment; filename="
                            + timeStr + ".xlsx");

            OutputStream outputStream = response.getOutputStream();
            wb.write(outputStream);
            fis.close();
            outputStream.close();
        } catch (Exception e) {
            throw new AppException(e);
        }
    }

    /**
     * 导出(陕西)
     * @param response  response
     * @param data 数据
     * @param cityData 大市数据
     * @param title     表头
     */
    public void exportExcelSX(HttpServletResponse response, String exportName, List<Map<String, String>> title, List<Map<String, String>> title1, List<Map<String, String>> cityData, List<Map<String, String>> data, List<Map<String, String>> data1) {
        //导出数据
        String egovConf = AppConfig.getProperty("egov.conf");
        String filePath = egovConf + "/server/new/jrzlpjb.xlsx";
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            filePath = filePath.substring(filePath.indexOf("/") + 1);
        } else {
            filePath = filePath.substring(filePath.indexOf(":") + 1);
        }
        try {
            FileInputStream fis = new FileInputStream(filePath);
            XSSFWorkbook wb = new XSSFWorkbook(fis);
            // 第二步，在webbook中添加一个sheet,对应Excel文件中的sheet
            XSSFSheet sheet = wb.getSheetAt(0);
            // 第三步，在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short
            // 第四步，创建单元格，并设置值表头 设置表头居中

            // 插入第一个sheet页
            wb = writeExcel(wb, sheet,5,title,cityData,exportName);
            // 插入第二个sheet页
            XSSFSheet dataSheet = wb.getSheetAt(1);

            if(data1.size()<sheet.getPhysicalNumberOfRows()-5){
                hbRegion(wb,dataSheet,title1.size(),data1.size());
                dataSheet.addMergedRegion(new CellRangeAddress(5, 4 + data1.size() , 1, 1));
            }
            wb = writeExcel(wb, dataSheet,5,title1,data1,exportName);


            // 第六步，将文件存到指定位置
            String timeStr = new String(exportName.getBytes(), "iso-8859-1");

            response.setContentType("application/vnd.ms-excel");
            //timeStr为文件名
            response.setHeader("Location", timeStr + ".xlsx");
            // 设置下载时的文件名称
            response.setHeader(
                    "Content-Disposition",
                    "attachment; filename="
                            + timeStr + ".xlsx");

            OutputStream outputStream = response.getOutputStream();
            wb.write(outputStream);
            fis.close();
            outputStream.close();
        } catch (Exception e) {
            throw new AppException(e);
        }
    }

    /**
     * 将数据写入sheet页
     * @param wb  XSSFWorkbook
     * @param sheet XSSFSheet
     * @param startRow 起始行
     * @param title 字段
     * @param rowsList 数据
     * @param exportName 导出名字
     * @return XSSFWorkbook
     */
    private XSSFWorkbook writeExcel(XSSFWorkbook wb, XSSFSheet sheet, int startRow, List<Map<String, String>> title, List<Map<String, String>> rowsList,String exportName){

        XSSFCellStyle cellStyle = null;
        //插入数据
        Row firstRow = sheet.getRow(0);
        firstRow.getCell(0).setCellValue(exportName);
        int xh = 0;
        if (CollectionUtils.isNotEmpty(rowsList)) {
            for (int j = 0; j < rowsList.size(); j++) {
                //获取新的一行,第J+1行
                Row datarow = sheet.getRow(startRow + j);
                if(datarow == null) {
                    datarow = sheet.createRow(startRow + j);
                }
                //对这一行的各个字段，按照表头的key插入数据
                for (int m = 0; m < title.size(); m++) {
                    String textValue = "";
                    if (rowsList.get(j).get(title.get(m).get("key")) != null) {
                        Object value = rowsList.get(j).get(title.get(m).get("key"));
                        if (value instanceof Date) {
                            Date date = (Date) value;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            textValue = sdf.format(date);
                        } else if (value instanceof String) {
                            textValue = (String) value;
                        } else if (value instanceof BigDecimal) {
                            textValue = String.valueOf(value);
                        } else {
                            textValue = "";
                        }
                    }
                    //插入第m列字段,获取第m列的title的key值，从rowList中的（Map类型）第j个记录中，通过第m列的title的key值获取数据
                    if(datarow.getCell(m) == null) {
                        datarow.createCell(m);
                        if(cellStyle == null) {
                            cellStyle = (XSSFCellStyle) wb.createCellStyle();
                            cellStyle.setBorderBottom(CellStyle.BORDER_THIN); // 下边框
                            cellStyle.setBorderLeft(CellStyle.BORDER_THIN);// 左边框
                            cellStyle.setBorderTop(CellStyle.BORDER_THIN);// 上边框
                            cellStyle.setBorderRight(CellStyle.BORDER_THIN);// 右边框
                        }
                        datarow.getCell(m).setCellStyle(cellStyle);
                    }

                    if ("XH".equals(title.get(m).get("key"))) {
                        datarow.getCell(m).setCellValue(xh);
                        xh++;
                    } else {
                        datarow.getCell(m).setCellValue(textValue);
                    }

                }
            }
        }
        return wb;
    }

    @Override
    public Map<String, String> getRegion(String qhdm) {
        return jrdbzlpjMapper.getRegion(qhdm);
    }

    @Override
    public void saveCountData(String kssj, String jssj) {
        jrdbzlpjMapper.saveCountData(kssj,jssj);
    }

    @Override
    public List<Map<String, String>> getCity(String qhdm) {
        return jrdbzlpjMapper.getCity(qhdm);
    }

    @Override
    public void updateTjczrz(String kssj, String jssj) {
        jrdbzlpjMapper.updateTjczrz(kssj,jssj);
    }

    @Override
    public void exportDetail(HttpServletRequest request, HttpServletResponse response, Map<String, String> map) {

        Map<String, List<Map<String, String>>> dataMap = new HashMap<>();
        List<Map<String, String>> dataList;
        List<Map<String, String>> queryData = jrdbzlpjMapper.getDetail(map);
        List<String> getYwh = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(queryData)) {
            getYwh = jrdbzlpjMapper.getDbywh(map);
        }
        List<Map<String, String>> regionList = jrdbzlpjMapper.getCity(map.get("fdm"));
        for (Map<String, String> regionMap : regionList) {
            dataList = new ArrayList<>();
            for (Map<String, String> model : queryData) {
                if (regionMap.get("QHDM").equals(model.get("YWH").substring(0,6))) {
                    if (getYwh.contains(model.get("YWH"))) {
                        model.put("IFCOUNT","是");
                    } else {
                        model.put("IFCOUNT","否");
                    }
                    dataList.add(model);
                }
            }
            dataMap.put(regionMap.get("QHMC"), dataList);
        }
        String exportName = "业务数据统计明细台账("+map.get("kssj")+"至"+map.get("jssj")+")";
        List<Map<String, String>> title = new ArrayList<>();
        Map<String,String> titleMap = new HashMap<>();
        titleMap.put("key","BWMC");
        title.add(titleMap);
        titleMap = new HashMap<>();
        titleMap.put("key","YWH");
        title.add(titleMap);
        titleMap = new HashMap<>();
        titleMap.put("key","BDCDYH");
        title.add(titleMap);
        titleMap = new HashMap<>();
        titleMap.put("key","IFCOUNT");
        title.add(titleMap);
        OperationalLogUtil.log(request, "1", "业务数据统计明细台账", "接入系统");
        exportDetailExcel(response, exportName, title, dataMap, map.get("qhmc"));
    }

    /**
     * 导出
     * @param response  response
     * @param data 数据
     * @param title     表头
     */
    public void exportDetailExcel(HttpServletResponse response, String exportName,
                                  List<Map<String, String>> title, Map<String, List<Map<String,String>>> data,String qhmc) {
        //导出数据
        String egovConf = AppConfig.getProperty("egov.conf");
        String filePath = egovConf + "/server/jrzldetail.xlsx";
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            filePath = filePath.substring(filePath.indexOf("/") + 1);
        } else {
            filePath = filePath.substring(filePath.indexOf(":") + 1);
        }
        try {
            FileInputStream fis = new FileInputStream(filePath);
            XSSFWorkbook wb = new XSSFWorkbook(fis);
            // 第二步，在webbook中添加一个sheet,对应Excel文件中的sheet
            // 第三步，在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short
            // 第四步，创建单元格，并设置值表头 设置表头居中

            for (Map.Entry<String, List<Map<String, String>>> map : data.entrySet()) {
                XSSFSheet sheet = wb.cloneSheet(0);
                wb.setSheetName(wb.getSheetIndex(sheet),map.getKey());
                wb = writeExcel(wb, sheet,2,title,map.getValue(),map.getKey()+ exportName);
            }
            if (wb.getNumberOfSheets() > 1) {
                wb.removeSheetAt(0);
            }

            // 第六步，将文件存到指定位置
            String timeStr = new String((qhmc+exportName).getBytes(), "iso-8859-1");

            response.setContentType("application/vnd.ms-excel");
            //timeStr为文件名
            response.setHeader("Location", timeStr + ".xlsx");
            // 设置下载时的文件名称
            response.setHeader(
                    "Content-Disposition",
                    "attachment; filename="
                            + timeStr + ".xlsx");

            OutputStream outputStream = response.getOutputStream();
            wb.write(outputStream);
            fis.close();
            outputStream.close();
        } catch (Exception e) {
            throw new AppException(e);
        }
    }

    /**
     * 根据传入的地市,区县,开始时间,结束时间获取登簿日志未接入天数
     * @param map
     * @return
     */
    @Override
    public Map<String,Object> jrwdxData(Map<String, String> map) {
        Map<String,Object> resultData = new HashMap<>();
        List<Map<String,String>> dsData = new ArrayList<>();

//        登簿日志未接入天数
        List<Map<String,String>> wjrdbrzDsResultData = new ArrayList<>();
        List<Map<String,String>> wjrdbrzQxResultData =baTjfxMapper.obtainDbrzwjrDays(map);

//        报文未接入天数
        List<Map<String,String>>  wjrbwDsResultData = new ArrayList<>();
        List<Map<String,String>>  wjrbwQxResultData = baTjfxMapper.obtainBwwjrDays(map);

//        登簿量为0天数
        List<Map<String,String>> dblIsZeroDsResultData = new ArrayList<>();
        List<Map<String,String>> dblIsZeroQxResultData = baTjfxMapper.obtainDblIsZero(map);

//        //西咸新区的代码和xt_region不一致,替换区划代码
//        for(Map map1:wjrdbrzQxResultData){
//            if("617099".equals(map1.get("QHDM").toString())){
//                wjrdbrzQxResultData.remove(map1);
//                map1.put("QHDM","619999");
//                wjrdbrzQxResultData.add(map1);
//            }
//        }
//
//        for(Map map1:wjrbwQxResultData){
//            if("617099".equals(map1.get("QHDM").toString())){
//                wjrbwQxResultData.remove(map1);
//                map1.put("QHDM","619999");
//                wjrbwQxResultData.add(map1);
//            }
//        }
//
//        for(Map map1:dblIsZeroQxResultData){
//            if("617099".equals(map1.get("QHDM").toString())){
//                dblIsZeroQxResultData.remove(map1);
//                map1.put("QHDM","619999");
//                dblIsZeroQxResultData.add(map1);
//            }
//        }

        List<Map<String,String>> dsList = jrdbzlpjMapper.getDs(region);
        for(Map map1:dsList){
            //610100
          String qhdm = map1.get("QHDM").toString();
            int ts1 = 0;
            int ts2 = 0;
            int ts3 = 0;
            for(Map map2:wjrdbrzQxResultData){
               if(qhdm.substring(0,qhdm.length()-2).equals(map2.get("QHDM").toString().substring(0,(map2.get("QHDM").toString().length()-2)))){
                       ts1 = ts1 + Integer.parseInt(map2.get("TS").toString());

               }
            }

            for(Map map2:wjrbwQxResultData){
                if(qhdm.substring(0,qhdm.length()-2).equals(map2.get("QHDM").toString().substring(0,(map2.get("QHDM").toString().length()-2)))){
                        ts2 =ts2+ Integer.parseInt(map2.get("TS").toString());
                }
            }

            for(Map map2:dblIsZeroQxResultData){
                if(qhdm.substring(0,qhdm.length()-2).equals(map2.get("QHDM").toString().substring(0,(map2.get("QHDM").toString().length()-2)))){
                        ts3 =ts3+ Integer.parseInt(map2.get("TS").toString());

                }
            }
            map1.put("wjrdbrzTS",ts1);
            map1.put("wjrbwTS",ts2);
            map1.put("dblIsZeroTS",ts3);
            dsData.add(map1);
        }

        resultData.put("dsData",dsData);
        getDsMap(dsData,map);

        //数据重组




        resultData.put("wjrdbrzQxResultData",wjrdbrzQxResultData);
        resultData.put("wjrbwQxResultData",wjrbwQxResultData);
        resultData.put("dblIsZeroQxResultData",dblIsZeroQxResultData);
        return resultData;
    }

    /**
     *
     * @param dslist 原装数据
     * @param map   时间参数
     * @return
     */
     public   List<Map<String,String>> getDsMap(List<Map<String,String>> dslist,Map<String, String> map){
         //杨凌示范区、韩城市、西咸新区 3个区单独统计 没有下钻的区县
         //获得杨凌示范区、韩城市、西咸新区 数据
         List<String> threeArea = new ArrayList<>();//特使的三个地级市
         threeArea.add(Constants.qhmc1);
         threeArea.add(Constants.qhmc2);
         threeArea.add(Constants.qhmc3);
         List<Map<String,String>> reusltlists = new ArrayList<>();


         for(String qhmc:threeArea){
             HashMap<String,String> paramMAPs =new HashMap<>();
             String t1 = null;
             String t2 = null;
             String t3 = null;
             Set<String> keys = map.keySet();
             for(String key:keys){
                 paramMAPs.put(key,map.get(key));
             }
             HashMap<String,String> resultMap =new HashMap<>();
             paramMAPs.put("qhmc",qhmc);
              if(StringUtils.equals(qhmc,Constants.qhmc3)) {
                  paramMAPs.put("qhmc",qhmc.substring(0,qhmc.length()-2));
                  t1 =baTjfxMapper.obtainDbrzwjrDaysXiXian(paramMAPs);
                  paramMAPs.put("t1","bw");
                  t2 =baTjfxMapper.obtainDbrzwjrDaysXiXian(paramMAPs);
                  paramMAPs.put("t1","");
                  paramMAPs.put("t2","dbzl0");
                  t3 =baTjfxMapper.obtainDbrzwjrDaysXiXian(paramMAPs);
              }else{
                  t1 =baTjfxMapper.obtainDbrzwjrDaysTwoArea(paramMAPs);
                  paramMAPs.put("t1","bw");
                  t2 =baTjfxMapper.obtainDbrzwjrDaysTwoArea(paramMAPs);
                  paramMAPs.put("t1","");
                  paramMAPs.put("t2","dbzl0");
                  t3 =baTjfxMapper.obtainDbrzwjrDaysTwoArea(paramMAPs);
              }
             resultMap.put("QHMC",qhmc);
             resultMap.put("wjrdbrzTS",t1);
             resultMap.put("wjrbwTS",t2);
             resultMap.put("dblIsZeroTS",t3);
             reusltlists.add(resultMap);

         }

         for(Map mapds:dslist){
             for(Map mapsThree:reusltlists){
                 if(StringUtils.equals(mapds.get("QHMC").toString(),mapsThree.get("QHMC").toString())){
                      //替换数据
                       mapds.put("wjrdbrzTS",mapsThree.get("wjrdbrzTS")==null?0:mapsThree.get("wjrdbrzTS").toString());
                       mapds.put("wjrbwTS",mapsThree.get("wjrbwTS")==null?0:mapsThree.get("wjrbwTS").toString());
                       mapds.put("dblIsZeroTS",mapsThree.get("dblIsZeroTS")==null?0:mapsThree.get("dblIsZeroTS"));
                 }
             }
         }

         return  dslist ;
     }



    /**
     * 接入成功率
     * @param map
     * @return
     */
    @Override
    public Map<String, Object> getJrcgl(Map<String, String> map) {
        Map<String, Object> param = new HashMap<>(5);
        List<Map<String,String>> dsList = jrdbzlpjMapper.getDs(region);
        List<Map<String,String>> qxList = jrdbzlpjMapper.getQx();

        List<String> dslist = new ArrayList<>(5);
        List<String> qxlist = new ArrayList<>(5);

        List<Map<String,String>> provinceData = baTjfxMapper.getProvinceJrcg(map);
        List<Map<String,String>> dsData = baTjfxMapper.getDsJrcg(map);
        List<Map<String,String>> qxData = baTjfxMapper.getQxJrcg(map);

        //由于ba_rzjl中西咸新区的区划代码和xt_region的不一致更换与xt_region一致
        for(int i= 0;i<dsData.size();i++){
            if("西咸新区".equals(dsData.get(i).get("QHMC"))){
                Map<String,String> xxData = dsData.get(i);
                xxData.put("QHDM","619999");
                dsData.remove(i);
                dsData.add(i,xxData);
            }
        }
        List<Map<String,String>> dsResultData = new ArrayList<>(5);
        List<Map<String,String>> qxResultData = new ArrayList<>(5);
        List<Map<String,String>> provinceResultData = new ArrayList<>(5);

        for(Map map1:dsList){
            for (Object key : map1.keySet()) {
                if("QHDM".equals(key.toString())){
                    dslist.add(map1.get(key).toString());
                    break;
                }

            }
        }

        for(Map map1:qxList){
            for (Object key : map1.keySet()) {
                if("QHDM".equals(key.toString())){
                    qxlist.add(map1.get(key).toString());
                    break;
                }
            }
        }

        int total;
        int success;
        //全省数据
        total = 0;
        success = 0;

        for(Map map1: provinceData){
            String qhdm = "";
            String jg = "";
            String rkjg = "";
            for (Object key : map1.keySet()) {
                if("QHDM".equals(key.toString())){
                    qhdm = map1.get("QHDM").toString();
                }
                if("JG".equals(key.toString())){
                    if(map1.get("JG") == null){
                        jg = "0";
                    }else {
                        jg = map1.get("JG").toString();
                    }
                }
                if("RKJG".equals(key.toString())){
                    if(map1.get("RKJG") == null){
                        rkjg = "失败";
                    }else {
                        rkjg = map1.get("RKJG").toString();
                    }
                }
            }

                total += Integer.parseInt(jg);
                if("成功".equals(rkjg)){
                    success += Integer.parseInt(jg);
                }
        }
        txfloat(success,total);
        Map<String,String> provinceParam = new HashMap<>(5);
        provinceParam.put("provinceData", txfloat(success,total));
        provinceResultData.add(provinceParam);

        //地市数据
        for(String str :dslist){
            total = 0;
            success = 0;
            //str = 320100;
            for(Map map1: dsData){
                String qhdm = "";
                String jg = "";
                String rkjg = "";
                for (Object key : map1.keySet()) {
                   if("QHDM".equals(key.toString())){
                       qhdm = map1.get("QHDM").toString();
                   }
                    if("JG".equals(key.toString())){
                        if(map1.get("JG") == null){
                            jg = "0";
                        }else {
                            jg = map1.get("JG").toString();
                        }
                    }
                    if("RKJG".equals(key.toString())){
                        if(map1.get("RKJG") == null){
                            rkjg = "失败";
                        }else {
                            rkjg = map1.get("RKJG").toString();
                        }
                    }
                }
                if(str.equals(qhdm)){
                    total += Integer.parseInt(jg);
                    if("成功".equals(rkjg)){
                        success += Integer.parseInt(jg);
                    }
                }
            }
            txfloat(success,total);
            Map<String,String> dsParam = new HashMap<>(5);
            dsParam.put(str, txfloat(success,total));
            dsResultData.add(dsParam);
        }

        //区县数据
        for(String str :qxlist){
            total = 0;
            success = 0;
            //str = 320100;
            for(Map map1: qxData){
                String qhdm = "";
                String jg = "";
                String rkjg = "";
                for (Object key : map1.keySet()) {
                    if("QHDM".equals(key.toString())){
                        qhdm = map1.get("QHDM").toString();
                    }
                    if("JG".equals(key.toString())){
                        if(map1.get("JG") == null){
                            jg = "0";
                        }else {
                            jg = map1.get("JG").toString();
                        }
                    }
                    if("RKJG".equals(key.toString())){
                        if(map1.get("RKJG") == null){
                            rkjg = "失败";
                        }else {
                            rkjg = map1.get("RKJG").toString();
                        }
                    }
                }
                if(str.equals(qhdm)){
                    total += Integer.parseInt(jg);
                    if("成功".equals(rkjg)){
                        success += Integer.parseInt(jg);
                    }
                }
            }
            txfloat(success,total);
            Map<String,String> qxParam = new HashMap<>(5);
            qxParam.put(str, txfloat(success,total));
            qxResultData.add(qxParam);
        }


        param.put("provinceData",provinceResultData);
        param.put("dsData",dsResultData);
        param.put("qxData",qxResultData);
        return param;
    }

    /**
     * 根据传入的地市,区县,开始时间,结束时间获取成功的上报数据  条数除以接入总数
     * @param map
     * @return
     */
    @Override
    public Map<String, Object> getSbcgl(Map<String, String> map) {
        Map<String, Object> param = new HashMap<>(5);
        List<Map<String,String>> dsList = jrdbzlpjMapper.getDs(region);
        List<Map<String,String>> qxList = jrdbzlpjMapper.getQx();

        List<String> dslist = new ArrayList<>(5);
        List<String> qxlist = new ArrayList<>(5);

        List<Map<String,String>> provinceData = baTjfxMapper.getProvinceJrsb(map);
        List<Map<String,String>> dsData = baTjfxMapper.getDsJrsb(map);
        List<Map<String,String>> qxData = baTjfxMapper.getQxJrsb(map);

        //由于ba_sftp_rzjl中西咸新区的区划代码和xt_region的不一致更换与xt_region一致
        for(int i= 0;i<dsData.size();i++){
            if("西咸".equals(dsData.get(i).get("QHMC"))){
                Map<String,String> xxData = dsData.get(i);
                xxData.put("QHMC","西咸新区");
                xxData.put("QHDM","619999");
                dsData.remove(i);
                dsData.add(i,xxData);
            }
        }

        List<Map<String,String>> dsResultData = new ArrayList<>(5);
        List<Map<String,String>> qxResultData = new ArrayList<>(5);
        List<Map<String,String>> provinceResultData = new ArrayList<>(5);

        for(Map map1:dsList){
            for (Object key : map1.keySet()) {
                if("QHDM".equals(key.toString())){
                    dslist.add(map1.get(key).toString());
                    break;
                }
            }
        }

        for(Map map1:qxList){
            for (Object key : map1.keySet()) {
                if("QHDM".equals(key.toString())){
                    qxlist.add(map1.get(key).toString());
                    break;
                }
            }
        }

        int total;
        int success;
        //全省数据
        total = 0;
        success = 0;

        for(Map map1: provinceData){
            String qhdm = "";
            String jg = "";
            String sbjg = "";
            for (Object key : map1.keySet()) {
                if("QHDM".equals(key.toString())){
                    qhdm = map1.get("QHDM").toString();
                }
                if("JG".equals(key.toString())){
                    if(map1.get("JG") == null){
                        jg = "0";
                    }else {
                        jg = map1.get("JG").toString();
                    }
                }
                if("SBJG".equals(key.toString())){
                    if(map1.get("SBJG") == null){
                        sbjg = "失败";
                    }else {
                        sbjg = map1.get("SBJG").toString();
                    }
                }
            }

            total += Integer.parseInt(jg);
            if("成功".equals(sbjg)){
                success += Integer.parseInt(jg);
            }
        }
        txfloat(success,total);
        Map<String,String> provinceParam = new HashMap<>(5);
        provinceParam.put("provinceData", txfloat(success,total));
        provinceResultData.add(provinceParam);

        //地市数据
        for(String str :dslist){
            total = 0;
            success = 0;
            //str = 320100;
            for(Map map1: dsData){
                String qhdm = "";
                String jg = "";
                String sbjg = "";
                for (Object key : map1.keySet()) {
                    if("QHDM".equals(key.toString())){
                        qhdm = map1.get("QHDM").toString();
                    }
                    if("JG".equals(key.toString())){
                        if(map1.get("JG") == null){
                            jg = "0";
                        }else {
                            jg = map1.get("JG").toString();
                        }
                    }
                    if("SBJG".equals(key.toString())){
                        if(map1.get("SBJG") == null){
                            sbjg = "失败";
                        }else {
                            sbjg = map1.get("SBJG").toString();
                        }
                    }
                }
                if(str.equals(qhdm)){
                    total += Integer.parseInt(jg);
                    if("成功".equals(sbjg)){
                        success += Integer.parseInt(jg);
                    }
                }
            }
            txfloat(success,total);
            Map<String,String> dsParam = new HashMap<>(5);
            dsParam.put(str, txfloat(success,total));
            dsResultData.add(dsParam);
        }

        //区县数据
        for(String str :qxlist){
            total = 0;
            success = 0;
            //str = 320100;
            for(Map map1: qxData){
                String qhdm = "";
                String jg = "";
                String sbjg = "";
                for (Object key : map1.keySet()) {
                    if("QHDM".equals(key.toString())){
                        qhdm = map1.get("QHDM").toString();
                    }
                    if("JG".equals(key.toString())){
                        if(map1.get("JG") == null){
                            jg = "0";
                        }else {
                            jg = map1.get("JG").toString();
                        }
                    }
                    if("SBJG".equals(key.toString())){
                        if(map1.get("SBJG") == null){
                            sbjg = "失败";
                        }else {
                            sbjg = map1.get("SBJG").toString();
                        }
                    }
                }
                if(str.equals(qhdm)){
                    total += Integer.parseInt(jg);
                    if("成功".equals(sbjg)){
                        success += Integer.parseInt(jg);
                    }
                }
            }
            txfloat(success,total);
            Map<String,String> qxParam = new HashMap<>(5);
            qxParam.put(str, txfloat(success,total));
            qxResultData.add(qxParam);
        }

        param.put("provinceData",provinceResultData);
        param.put("dsData",dsResultData);
        param.put("qxData",qxResultData);
        return param;
    }

    @Override
    public List<Pjdfqk> getJrjsxqk(String kssj, String jssj) {
        List<Pjdfqk> resultList = new ArrayList<>();
        Map<String, String> param = Maps.newHashMap();
        param.put("kssj", kssj);
        param.put("jssj", jssj);
        param.put("provinceDm", region);
        List<Map<String, String>> data = jrdbzlpjService.getJrzlpjData(param);
        Map<String, Object> dataMap = getData(region, data);
        Map<String, Object> data1Map = getData(region, data);
        List resultData = new ArrayList<>();

        List<Map<String, String>> resultDf = (List<Map<String, String>>) dataMap.get("children");
        for (int i = 0; i < resultDf.size(); i++) {
            Pjdfqk pd = new Pjdfqk();
            Map<String, String> reusltmap = resultDf.get(i);
            pd.setXzqhmc(reusltmap.get("QHMC"));
            pd.setQhdm(reusltmap.get("QHDM"));
            pd.setQhjb(reusltmap.get("QHJB"));
            pd.setJrdbl1zb(Double.valueOf(reusltmap.get("JRDBL1ZB").substring(0, reusltmap.get("JRDBL1ZB").length() - 1)));
            pd.setJrdbl2zb(Double.valueOf(reusltmap.get("JRDBL2ZB").substring(0, reusltmap.get("JRDBL2ZB").length() - 1)));
            pd.setJrdbl3zb(Double.valueOf(reusltmap.get("JRDBL3ZB").substring(0, reusltmap.get("JRDBL3ZB").length() - 1)));

            Map<String, Object> childrenMap = getData(pd.getQhdm(), data);
            List<Pjdfqk> childrenList =new ArrayList<>(); //children 地级市下面的children属性
            List<Map<String,Object>> children = (List<Map<String, Object>>) childrenMap.get("children");//获得区县的数据
            for(int j=0;j<children.size();j++){
                Pjdfqk pkchildren =new Pjdfqk();
                pkchildren.setXzqhmc(children.get(j).get("QHMC").toString());
                pkchildren.setQhdm(children.get(j).get("QHDM").toString());
                pkchildren.setQhjb(children.get(j).get("QHJB").toString());
                pkchildren.setJrdbl1zb(Double.valueOf(children.get(j).get("JRDBL1ZB").toString().substring(0, children.get(j).get("JRDBL1ZB").toString().length() - 1)));
                pkchildren.setJrdbl2zb(Double.valueOf(children.get(j).get("JRDBL2ZB").toString().substring(0, children.get(j).get("JRDBL2ZB").toString().length() - 1)));
                pkchildren.setJrdbl3zb(Double.valueOf(children.get(j).get("JRDBL3ZB").toString().substring(0, children.get(j).get("JRDBL3ZB").toString().length() - 1)));
                childrenList.add(pkchildren);
            }
            pd.setChildrens(childrenList);
            resultList.add(pd);

        }
        return resultList;
    }

    @Override
    public List<Pjdfqk> getJrkxlqk(String kssj, String jssj) {
        Map<String, String> kxlzdMap = new HashMap<>();
        Map<String, Object> param = Maps.newHashMap();
        param.put("kssj", kssj);
        param.put("jssj",jssj);
        param.put("provinceDm", region);
        List<Pjdfqk> kxlresultList = new ArrayList<>();

        List<Map<String, Object>> data = kxlService.listCityAndCountyData(param, false);
        data.remove(0);
//        kxlzdMap

        for (int i = 0; i < data.size(); i++) {
            Pjdfqk pd = new Pjdfqk();
            pd.setXzqhmc(data.get(i).get("QHMC").toString());
            kxlzdMap.put("DB_KXL", String.valueOf(data.get(i).get("DB_KXL")));
            kxlzdMap.put("FWFWXZ_KXL", String.valueOf(data.get(i).get("FWFWXZ_KXL")));
            kxlzdMap.put("FWGYQK_KXL", String.valueOf(data.get(i).get("FWGYQK_KXL")));
            kxlzdMap.put("FWJG_KXL", String.valueOf(data.get(i).get("FWJG_KXL")));
            kxlzdMap.put("FWXZ_KXL", String.valueOf(data.get(i).get("FWXZ_KXL")));
            kxlzdMap.put("GHYT_KXL", String.valueOf(data.get(i).get("GHYT_KXL")));
            kxlzdMap.put("GYQK_KXL", String.valueOf(data.get(i).get("GYQK_KXL")));
            kxlzdMap.put("JFDBR_KXL", String.valueOf(data.get(i).get("JFDBR_KXL")));
            kxlzdMap.put("JFDJSJ_KXL", String.valueOf(data.get(i).get("JFDJSJ_KXL")));
            kxlzdMap.put("JFJG_KXL", String.valueOf(data.get(i).get("JFJG_KXL")));
            kxlzdMap.put("JGSJ_KXL", String.valueOf(data.get(i).get("JGSJ_KXL")));


            kxlzdMap.put("JFWJ_KXL", String.valueOf(data.get(i).get("JFWJ_KXL")));
            kxlzdMap.put("JFYWH_KXL", String.valueOf(data.get(i).get("JFYWH_KXL")));

            kxlzdMap.put("QLSDFS_KXL", String.valueOf(data.get(i).get("QLSDFS_KXL")));
            kxlzdMap.put("QLXZ_KXL", String.valueOf(data.get(i).get("QLXZ_KXL")));
            kxlzdMap.put("RJL_KXL", String.valueOf(data.get(i).get("RJL_KXL")));
            kxlzdMap.put("YBDY_ZJDYFW_KXL", String.valueOf(data.get(i).get("YBDY_ZJDYFW_KXL")));
            kxlzdMap.put("YBDY_ZJDYZL_KXL", String.valueOf(data.get(i).get("YBDY_ZJDYZL_KXL")));
            kxlzdMap.put("YT_KXL", String.valueOf(data.get(i).get("YT_KXL")));

            kxlzdMap.put("YWRZJH_KXL", String.valueOf(data.get(i).get("YWRZJH_KXL")));
            kxlzdMap.put("YWRZJZL_KXL", String.valueOf(data.get(i).get("YWRZJZL_KXL")));
            kxlzdMap.put("ZGDY_ZJDYFW_KXL", String.valueOf(data.get(i).get("ZGDY_ZJDYFW_KXL")));
            kxlzdMap.put("ZGDY_ZJDYZL_KXL", String.valueOf(data.get(i).get("ZGDY_ZJDYZL_KXL")));
            kxlzdMap.put("ZGQQDSSSE_KXL", String.valueOf(data.get(i).get("ZGQQDSSSE_KXL")));
            kxlzdMap.put("ZWLXQX_KXL", String.valueOf(data.get(i).get("ZWLXQX_KXL")));
            kxlzdMap.put("ZXDYYY_KXL", String.valueOf(data.get(i).get("ZXDYYY_KXL")));
            kxlzdMap.put("ZXSJ_KXL", String.valueOf(data.get(i).get("ZXSJ_KXL")));
            Map<String, Integer> zzMap = calculatekxl(kxlzdMap);
            pd.setManfengs(zzMap.get("manfengs"));
            pd.setSdgegs(zzMap.get("sdgegs"));
            pd.setZdgs(zzMap.get("zdgs"));
            pd.setJigegs(zzMap.get("jigegs"));
            pd.setLinfengs(zzMap.get("linfengs"));
            List<Map<String, Object>> childrenList = (List<Map<String, Object>>) data.get(i).get("children");
            List<Pjdfqk> pdlchildrenList =new ArrayList<>();
            for(int j=0;j<childrenList.size();j++){
                Pjdfqk pjdfqkchildren =new Pjdfqk();
                pjdfqkchildren.setXzqhmc(childrenList.get(j).get("QHMC").toString());
//                 kxlzdMap.put("YT_KXL", String.valueOf(childrenList.get(j).get("YT_KXL")));
                kxlzdMap.put("DB_KXL", String.valueOf(childrenList.get(j).get("DB_KXL")));
                kxlzdMap.put("FWFWXZ_KXL", String.valueOf(childrenList.get(j).get("FWFWXZ_KXL")));
                kxlzdMap.put("FWGYQK_KXL", String.valueOf(childrenList.get(j).get("FWGYQK_KXL")));
                kxlzdMap.put("FWJG_KXL", String.valueOf(childrenList.get(j).get("FWJG_KXL")));
                kxlzdMap.put("FWXZ_KXL", String.valueOf(childrenList.get(j).get("FWXZ_KXL")));
                kxlzdMap.put("GHYT_KXL", String.valueOf(childrenList.get(j).get("GHYT_KXL")));
                kxlzdMap.put("GYQK_KXL", String.valueOf(childrenList.get(j).get("GYQK_KXL")));
                kxlzdMap.put("JFDBR_KXL", String.valueOf(childrenList.get(j).get("JFDBR_KXL")));
                kxlzdMap.put("JFDJSJ_KXL", String.valueOf(childrenList.get(j).get("JFDJSJ_KXL")));
                kxlzdMap.put("JFJG_KXL", String.valueOf(childrenList.get(j).get("JFJG_KXL")));
                kxlzdMap.put("JGSJ_KXL", String.valueOf(childrenList.get(j).get("JGSJ_KXL")));


                kxlzdMap.put("JFWJ_KXL", String.valueOf(childrenList.get(j).get("JFWJ_KXL")));
                kxlzdMap.put("JFYWH_KXL", String.valueOf(childrenList.get(j).get("JFYWH_KXL")));

                kxlzdMap.put("QLSDFS_KXL", String.valueOf(childrenList.get(j).get("QLSDFS_KXL")));
                kxlzdMap.put("QLXZ_KXL", String.valueOf(childrenList.get(j).get("QLXZ_KXL")));
                kxlzdMap.put("RJL_KXL", String.valueOf(childrenList.get(j).get("RJL_KXL")));
                kxlzdMap.put("YBDY_ZJDYFW_KXL", String.valueOf(childrenList.get(j).get("YBDY_ZJDYFW_KXL")));
                kxlzdMap.put("YBDY_ZJDYZL_KXL", String.valueOf(childrenList.get(j).get("YBDY_ZJDYZL_KXL")));
                kxlzdMap.put("YT_KXL", String.valueOf(childrenList.get(j).get("YT_KXL")));

                kxlzdMap.put("YWRZJH_KXL", String.valueOf(childrenList.get(j).get("YWRZJH_KXL")));
                kxlzdMap.put("YWRZJZL_KXL", String.valueOf(childrenList.get(j).get("YWRZJZL_KXL")));
                kxlzdMap.put("ZGDY_ZJDYFW_KXL", String.valueOf(childrenList.get(j).get("ZGDY_ZJDYFW_KXL")));
                kxlzdMap.put("ZGDY_ZJDYZL_KXL", String.valueOf(childrenList.get(j).get("ZGDY_ZJDYZL_KXL")));
                kxlzdMap.put("ZGQQDSSSE_KXL", String.valueOf(childrenList.get(j).get("ZGQQDSSSE_KXL")));
                kxlzdMap.put("ZWLXQX_KXL", String.valueOf(childrenList.get(j).get("ZWLXQX_KXL")));
                kxlzdMap.put("ZXDYYY_KXL", String.valueOf(childrenList.get(j).get("ZXDYYY_KXL")));
                kxlzdMap.put("ZXSJ_KXL", String.valueOf(childrenList.get(j).get("ZXSJ_KXL")));


                Map<String, Integer> zzchildrenMap = calculatekxl(kxlzdMap);
                pjdfqkchildren.setManfengs(zzchildrenMap.get("manfengs"));
                pjdfqkchildren.setSdgegs(zzchildrenMap.get("sdgegs"));
                pjdfqkchildren.setZdgs(zzchildrenMap.get("zdgs"));
                pjdfqkchildren.setJigegs(zzchildrenMap.get("jigegs"));
                pjdfqkchildren.setLinfengs(zzchildrenMap.get("linfengs"));
                pdlchildrenList.add(pjdfqkchildren);
            }
            pd.setChildrens(pdlchildrenList);

            kxlresultList.add(pd);
        }

        return kxlresultList;
    }

    /**
     * 计算kxl字段个数 按范围计算
     *
     * @param
     * @param
     * @return 计算分值个数 按范围
     */

    public Map<String, Integer> calculatekxl(Map<String, String> kxlMap) {
        Integer manfengs = 0;
        Integer sdgegs = 0;
        Integer zdgs = 0;
        Integer jigegs = 0;
        Integer linfengs = 0;
        Map<String, Integer> calculateresult = new HashMap<>();
        for (String reuslt : kxlMap.values()) {
            if (Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) == 100) {
                manfengs++;
            }

            if (Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) >= 80 && Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) < 100) {
                sdgegs++;
            }

            if (Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) >= 50 && Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) < 80) {
                zdgs++;
            }

            if (Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) > 0 && Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) < 50) {
                jigegs++;
            }

            if (Double.valueOf(reuslt.substring(0, reuslt.length() - 1)) == 0) {
                linfengs++;
            }

        }
        calculateresult.put("manfengs", manfengs);
        calculateresult.put("sdgegs", sdgegs);
        calculateresult.put("zdgs", zdgs);
        calculateresult.put("jigegs", jigegs);
        calculateresult.put("linfengs", linfengs);

        return calculateresult;
    }

    /**
     * 组装数据
     *
     * @param xzqdm 行政区代码
     * @param data  数据
     * @return 组装的数据
     */
    private Map<String, Object> getData(String xzqdm, List<Map<String, String>> data) {
        Map<String, Object> resultMap = new HashMap<>(12);
        List<Map<String, Object>> result = new ArrayList<>();
        for (Map<String, String> map : data) {
            if (xzqdm.equals(map.get("QHDM"))) {
                resultMap.putAll(map);
            }
            if (xzqdm.equals(map.get("FDM"))) {
                Map<String, Object> temp = getData(map.get("QHDM"), data);
                result.add(temp);
            }
            if (!result.isEmpty()) {
                resultMap.put("children", result);
            }
        }
        return resultMap;
    }


    /**
     * TODO 除法运算，保留小数
     * @param a 被除数
     * @param b 除数
     * @return 商
     */
    public static String txfloat(int a,int b) {
        // TODO 自动生成的方法存根
        if(b==0){
            return 0 + "";
        }else {
            DecimalFormat df=new DecimalFormat("0.00");//设置保留位数
            return df.format((double) a*100/b);
        }
    }

    public void exportWord(HttpServletRequest request, HttpServletResponse response, Map map){

        String filename = map.get("fileName").toString();
        Map<String, Object> params = Maps.newHashMap();
        params.putAll(map);
        WordUtil.createDoc(request, response, params, filename);
    }

    /**
     * excel 清空单元格
     * @param sheet   sheet
     * @param titleNum 标题行数
     * @param regionNum 开始取消合并的单元格索引
     * @param cellTotal   单元格列总数
     * @param dataNum   数据长度
     */
    private static void emptyRow(Sheet sheet, int titleNum, int regionNum, int cellTotal, int dataNum){

        int sheetTotal = sheet.getPhysicalNumberOfRows();//获得总行数
        //取消合并单元格,方便清空单元格
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount-regionNum; i++) {
            //取消单元格合并以后,合并单元格的总数一直在变化,标题中已经合并的单元格有九个,
            // 所以一直取消合并第九个单元格就可以把标题下面的合并的单元格取消合并
            sheet.removeMergedRegion(regionNum);
        }

        //清空单元格
        for(int j = titleNum;j<sheetTotal;j++){
            Row xssfRow = sheet.getRow(j);
            for (int k= 0;k<cellTotal;k++){
                Cell xssfCell = xssfRow.getCell(k);
                xssfCell.setCellValue("");
            }
            if(j>titleNum +dataNum - 1){
                sheet.removeRow(xssfRow);
            }
        }
    }


    private static void hbRegion(XSSFWorkbook wb,Sheet sheet,int titleNum,int dataNum){

        //普通的单元格
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);//左右居中
        cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);//上下居中
        cellStyle.setWrapText(true);//自动换行
        cellStyle.setBorderBottom(CellStyle.BORDER_THIN); // 底部边框
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex()); // 底部边框颜色
        cellStyle.setBorderLeft(CellStyle.BORDER_THIN);  // 左边边框
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex()); // 左边边框颜色
        cellStyle.setBorderRight(CellStyle.BORDER_THIN); // 右边边框
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());  // 右边边框颜色
        cellStyle.setBorderTop(CellStyle.BORDER_THIN); // 上边边框
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());  // 上边边框颜色

        //最下面的单元格
        CellStyle cellStyleBottom = cellStyle;
        cellStyleBottom.setBorderBottom(CellStyle.BORDER_MEDIUM);

        //右下角的单元格
        CellStyle cellStyleBottomAndRight = cellStyle;
        cellStyleBottom.setBorderBottom(CellStyle.BORDER_MEDIUM);
        cellStyleBottomAndRight.setBorderRight(CellStyle.BORDER_MEDIUM);

        //表头行数
        int i0 = 4;
        int sheetTotal = sheet.getPhysicalNumberOfRows();//获得总行数

        //取消合并单元格,方便清空单元格
        sheet.removeMergedRegion(16);
        for (int i = 2; i < 12; i++) {
            sheet.removeMergedRegion(2);
        }

        //清空单元格
        for(int j = i0;j<sheetTotal;j++){
            Row xssfRow = sheet.getRow(j);
            for (int k= 0;k<titleNum;k++){
                Cell xssfCell = xssfRow.getCell(k);
                xssfCell.setCellValue("");
            }
            if(j>i0 +dataNum - 1){
                sheet.removeRow(xssfRow);
            }
        }




    }
}
