package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.server.common.impl.ObjectServiceImpl;
import cn.gtmap.realestate.supervise.server.dao.InsertSingleTableDao;
import cn.gtmap.realestate.supervise.server.model.SimpleTableResult;
import cn.gtmap.realestate.supervise.server.service.InsertAndCancelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/6
 * @description 新增并注销业务接口
 */
@Service
public class InsertAndCancelServiceImpl implements InsertAndCancelService {

    private static final Logger LOGGER = LoggerFactory.getLogger(InsertAndCancelServiceImpl.class);

    @Autowired
    InsertSingleTableDao insertSingleTableDao;

    @Autowired
    EntityMapper entityMapper;

    @Autowired
    CancelServiceImpl cancelService;

    @Autowired
    ObjectServiceImpl objectService;

    @Override
    @Transactional
    public SimpleTableResult insertAndCancel(List<Object> objs, String recType, Map paramMap, String bdcdyh, String bizId, String ywh, String qxdm, String cxrkbj) {
        SimpleTableResult result = new SimpleTableResult();
        try {
            //将对象插入到数据库中
            if (objs != null) {
                //注销上一手
                cancelService.cancel(objs, recType, paramMap, bizId, ywh, qxdm, bdcdyh, cxrkbj);
                cancelService.insertData(recType, objs, bdcdyh);
            }
        } catch (Exception e) {
            LOGGER.error("InsertAndCancelServiceImpl Exception!{}", e);
            result.setResult(false);
            result.setResultInfo(e.getCause().toString());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return result;
        }
        result.setResult(true);
        return result;
    }

    /**
     * 新增业务逻辑
     *
     * @param recType
     * @param objs
     * @return
     */
//    public SimpleTableResult insertData(String recType, List<Object> objs, String bdcdyh) {
//
//        SimpleTableResult insertResult = new SimpleTableResult();
//
//        //KTT_ZDJBXX 土地所有权转移登记,5000101
//        if (ConstantConfig.TDSYQZYDJ.equals(recType) || ConstantConfig.TDSYQGZDJ.equals(recType)
//                || ConstantConfig.JSYDSYQZYDJ.equals(recType)
//                || ConstantConfig.JSYDSYQGZDJ.equals(recType)
//                || ConstantConfig.NYDSYQZYDJ.equals(recType)
//                || ConstantConfig.NYDSYQGZDJ.equals(recType)
//                || ConstantConfig.LQGZDJ.equals(recType)
//                || ConstantConfig.LQZYDJ.equals(recType)) {
//
//            Map<String, Object> tempMap = new HashMap<>();
//            for (Object obj : objs) {
//                if (obj instanceof BaZdjbxx) {
//                    tempMap.put("bdcdyh", bdcdyh);
//                    ExampleUtil example = new ExampleUtil(BaZdjbxx.class, tempMap);
//                    List<BaZdjbxx> zdjbxxList = entityMapper.selectByExample(example);
//                    if (null != zdjbxxList && !zdjbxxList.isEmpty()) {
//                        for (BaZdjbxx bazdjbxx : zdjbxxList) {
//                            entityMapper.deleteByPrimaryKey(BaZdjbxx.class, bazdjbxx.getId());
//                        }
//                    }
//                }
//            }
//        }
//
//        if (ConstantConfig.FDCQZYDJ1.equals(recType) || ConstantConfig.FDCQGZDJ1.equals(recType)
//                || ConstantConfig.FDCQGZDJ2.equals(recType) || ConstantConfig.FDCQZYDJ2.equals(recType)) {
//            String zddm = "";
//            for (Object object : objs) {
//                if (object instanceof BaZrz) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    zddm = ((BaZrz) object).getZddm();
//                    String zrzh = ((BaZrz) object).getZrzh();
//                    tempMap.put("zddm", zddm);
//                    tempMap.put("zrzh", zrzh);
//                    ExampleUtil example = new ExampleUtil(BaZrz.class, tempMap);
//                    List<BaZrz> baZrzs = entityMapper.selectByExample(example);
//                    if (null != baZrzs && !baZrzs.isEmpty()) {
//                        for (BaZrz baZrz : baZrzs) {
//                            entityMapper.deleteByPrimaryKey(BaZrz.class, baZrz.getId());
//                        }
//                    }
//                    if (null != zddm && !zddm.isEmpty()) {
//                        String zrzbh = zddm + "_" + zrzh;
//                        ((BaZrz) object).setZrzbh(zrzbh);
//                    } else {
//                        zddm = bdcdyh.substring(0, 19);
//                        String zrzbh = zddm + "_" + zrzh;
//                        ((BaZrz) object).setZrzbh(zrzbh);
//                    }
//                }
//
//                if (object instanceof BaH) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    tempMap.put("bdcdyh", bdcdyh);
//                    ExampleUtil example = new ExampleUtil(BaH.class, tempMap);
//                    List<BaH> baHS = entityMapper.selectByExample(example);
//                    if (null != baHS && !baHS.isEmpty()) {
//                        for (BaH baH : baHS) {
//                            entityMapper.deleteByPrimaryKey(BaH.class, baH.getId());
//                        }
//                    }
//                }
//            }
//
//            for (Object object : objs) {
//                if (object instanceof BaLjz) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    String ljzh = ((BaLjz) object).getLjzh();
//                    String zrzh = ((BaLjz) object).getZrzh();
//                    tempMap.put("ljzh", ljzh);
//                    tempMap.put("zrzh", zrzh);
//                    ExampleUtil example = new ExampleUtil(BaLjz.class, tempMap);
//                    List<BaLjz> baLjzs = entityMapper.selectByExample(example);
//                    if (null != baLjzs && !baLjzs.isEmpty()) {
//                        for (BaLjz baLjz : baLjzs) {
//                            entityMapper.deleteByPrimaryKey(BaLjz.class, baLjz.getId());
//                        }
//                    }
//                    if (null != zddm && !zddm.isEmpty()) {
//                        String zrzbh = zddm + "_" + zrzh;
//                        ((BaLjz) object).setZrzbh(zrzbh);
//                    } else {
//                        zddm = bdcdyh.substring(0, 19);
//                        String zrzbh = zddm + "_" + zrzh;
//                        ((BaLjz) object).setZrzbh(zrzbh);
//                    }
//                }
//                if (object instanceof BaC) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    String ch = ((BaC) object).getCh();
//                    String zrzh = ((BaC) object).getZrzh();
//                    String param = bdcdyh.substring(0, 19) + "_" + zrzh;
//                    tempMap.put("ch", ch);
//                    tempMap.put("zrzbh", param);
//                    ExampleUtil example = new ExampleUtil(BaC.class, tempMap);
//                    List<BaC> baCS = entityMapper.selectByExample(example);
//                    if (null != baCS && !baCS.isEmpty()) {
//                        for (BaC baC : baCS) {
//                            entityMapper.deleteByPrimaryKey(BaC.class, baC.getId());
//                        }
//                    }
//                    if (null != zddm && !zddm.isEmpty()) {
//                        String zrzbh = zddm + "_" + zrzh;
//                        ((BaC) object).setZrzbh(zrzbh);
//                    } else {
//                        zddm = bdcdyh.substring(0, 19);
//                        String zrzbh = zddm + "_" + zrzh;
//                        ((BaC) object).setZrzbh(zrzbh);
//                    }
//                }
//            }
//        }
//
//        if (ConstantConfig.JZWQFSYQZYDJ.equals(recType) || ConstantConfig.JZWQFSYQGZDJ.equals(recType)
//                || ConstantConfig.GZWSYQZYDJ.equals(recType) || ConstantConfig.GZWSYQGZDJ.equals(recType)) {
//            Map<String, Object> tempMap = new HashMap<>();
//            for (Object object : objs) {
//                if (object instanceof BaGzw) {
//                    tempMap.put("bdcdyh", bdcdyh);
//                    ExampleUtil example = new ExampleUtil(BaGzw.class, tempMap);
//                    List<BaGzw> baGzws = entityMapper.selectByExample(example);
//                    if (null != baGzws && !baGzws.isEmpty()) {
//                        for (BaGzw baGzw : baGzws) {
//                            entityMapper.deleteByPrimaryKey(BaGzw.class, baGzw.getId());
//                        }
//                    }
//                }
//            }
//        }
//
//        if (ConstantConfig.HYSYQZYDJ.equals(recType) || ConstantConfig.HYSYQGZDJ.equals(recType)) {
//            for (Object object : objs) {
//                if (object instanceof BaZhjbxx) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    tempMap.put("bdcdyh", bdcdyh);
//                    ExampleUtil example = new ExampleUtil(BaZhjbxx.class, tempMap);
//                    List<BaZhjbxx> baZhjbxxes = entityMapper.selectByExample(example);
//                    if (null != baZhjbxxes && !baZhjbxxes.isEmpty()) {
//                        for (BaZhjbxx baZhjbxx : baZhjbxxes) {
//                            entityMapper.deleteByPrimaryKey(BaZhjbxx.class, baZhjbxx.getId());
//                        }
//                    }
//                }
//
//                if (object instanceof BaYhzk) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    String zhdm = ((BaYhzk) object).getZhdm();
//                    tempMap.put("zhdm", zhdm);
//                    ExampleUtil example = new ExampleUtil(BaYhzk.class, tempMap);
//                    List<BaYhzk> baYhzks = entityMapper.selectByExample(example);
//                    if (null != baYhzks && !baYhzks.isEmpty()) {
//                        for (BaYhzk baYhzk : baYhzks) {
//                            entityMapper.deleteByPrimaryKey(BaYhzk.class, baYhzk.getId());
//                        }
//                    }
//                }
//
//                dealYhydzb(object);
//            }
//        }
//
//
//        if (ConstantConfig.TDSYQBGDJ.equals(recType) || ConstantConfig.JSYDSYQBGDJ.equals(recType)) {
//
//            for (Object obj : objs) {
//
//                if (obj instanceof BaZdjbxx) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    tempMap.put("bdcdyh", bdcdyh);
//                    ExampleUtil example = new ExampleUtil(BaZdjbxx.class, tempMap);
//                    List<BaZdjbxx> zdjbxxList = entityMapper.selectByExample(example);
//                    if (null != zdjbxxList && !zdjbxxList.isEmpty()) {
//                        for (BaZdjbxx bazdjbxx : zdjbxxList) {
//                            entityMapper.deleteByPrimaryKey(BaZdjbxx.class, bazdjbxx.getId());
//                        }
//                    }
//                }
//
//                if (obj instanceof BaJzx) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    String zdzhdm = ((BaJzx) obj).getZdzhdm();
//                    tempMap.put("zdzhdm", zdzhdm);
//                    ExampleUtil example = new ExampleUtil(BaJzx.class, tempMap);
//                    List<BaJzx> baJzxes = entityMapper.selectByExample(example);
//                    if (null != baJzxes && !baJzxes.isEmpty()) {
//                        for (BaJzx baJzx : baJzxes) {
//                            entityMapper.deleteByPrimaryKey(BaJzx.class, baJzx.getId());
//                        }
//                    }
//                }
//
//
//                if (obj instanceof BaJzd) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    String zdzhdm = ((BaJzd) obj).getZdzhdm();
//                    String jzdh = ((BaJzd) obj).getJzdh();
//                    tempMap.put("zdzhdm", zdzhdm);
//                    tempMap.put("jzdh", jzdh);
//                    ExampleUtil example = new ExampleUtil(BaJzd.class, tempMap);
//                    List<BaJzd> baJzds = entityMapper.selectByExample(example);
//                    if (null != baJzds && !baJzds.isEmpty()) {
//                        for (BaJzd baJzd : baJzds) {
//                            entityMapper.deleteByPrimaryKey(BaJzd.class, baJzd.getId());
//                        }
//                    }
//                }
//
//                dealZdk103(obj, bdcdyh);
//
//
//            }
//
//        }
//
//
//        if (ConstantConfig.FDCQBGDJ1.equals(recType) || ConstantConfig.FDCQBGDJ2.equals(recType)) {
//            String zddm = "";
//            for (Object object : objs) {
//                if (object instanceof BaZrz) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    zddm = ((BaZrz) object).getZddm();
//                    String zrzh = ((BaZrz) object).getZrzh();
//                    tempMap.put("zddm", zddm);
//                    tempMap.put("zrzh", zrzh);
//                    ExampleUtil example = new ExampleUtil(BaZrz.class, tempMap);
//                    List<BaZrz> baZrzs = entityMapper.selectByExample(example);
//                    if (null != baZrzs && !baZrzs.isEmpty()) {
//                        for (BaZrz baZrz : baZrzs) {
//                            entityMapper.deleteByPrimaryKey(BaZrz.class, baZrz.getId());
//                        }
//
//                    }
//                    if (null != zddm && !zddm.isEmpty()) {
//                        String zrzbh = zddm + "_" + zrzh;
//                        ((BaZrz) object).setZrzbh(zrzbh);
//                    } else {
//                        zddm = bdcdyh.substring(0, 19);
//                        String zrzbh = zddm + "_" + zrzh;
//                        ((BaZrz) object).setZrzbh(zrzbh);
//                    }
//                }
//
//                if (object instanceof BaH) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    tempMap.put("bdcdyh", bdcdyh);
//                    ExampleUtil example = new ExampleUtil(BaH.class, tempMap);
//                    List<BaH> baHS = entityMapper.selectByExample(example);
//                    if (null != baHS && !baHS.isEmpty()) {
//                        for (BaH baH : baHS) {
//                            entityMapper.deleteByPrimaryKey(BaH.class, baH.getId());
//                        }
//                    }
//                }
//
//                dealZdk103(object, bdcdyh);
//
//            }
//
//            for (Object object : objs) {
//
//                if (object instanceof BaLjz) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    String ljzh = ((BaLjz) object).getLjzh();
//                    String zrzh = ((BaLjz) object).getZrzh();
//                    tempMap.put("ljzh", ljzh);
//                    tempMap.put("zrzh", zrzh);
//                    ExampleUtil example = new ExampleUtil(BaLjz.class, tempMap);
//                    List<BaLjz> baLjzs = entityMapper.selectByExample(example);
//                    if (null != baLjzs && !baLjzs.isEmpty()) {
//                        for (BaLjz baLjz : baLjzs) {
//                            entityMapper.deleteByPrimaryKey(BaLjz.class, baLjz.getId());
//                        }
//                    }
//                    if (null != zddm && !zddm.isEmpty()) {
//                        String zrzbh = zddm + "_" + zrzh;
//                        ((BaLjz) object).setZrzbh(zrzbh);
//                    } else {
//                        zddm = bdcdyh.substring(0, 19);
//                        String zrzbh = zddm + "_" + zrzh;
//                        ((BaLjz) object).setZrzbh(zrzbh);
//                    }
//                }
//                if (object instanceof BaC) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    String ch = ((BaC) object).getCh();
//                    String zrzh = ((BaC) object).getZrzh();
//                    String param = bdcdyh.substring(0, 19) + "_" + zrzh;
//                    tempMap.put("ch", ch);
//                    tempMap.put("zrzbh", param);
//                    ExampleUtil example = new ExampleUtil(BaC.class, tempMap);
//                    List<BaC> baCS = entityMapper.selectByExample(example);
//                    if (null != baCS && !baCS.isEmpty()) {
//                        for (BaC baC : baCS) {
//                            entityMapper.deleteByPrimaryKey(BaC.class, baC.getId());
//                        }
//                    }
//                    if (null != zddm && !zddm.isEmpty()) {
//                        String zrzbh = zddm + "_" + zrzh;
//                        ((BaC) object).setZrzbh(zrzbh);
//                    } else {
//                        zddm = bdcdyh.substring(0, 19);
//                        String zrzbh = zddm + "_" + zrzh;
//                        ((BaC) object).setZrzbh(zrzbh);
//                    }
//                }
//            }
//        }
//
//
//        if (ConstantConfig.JZWQFSYQBGDJ.equals(recType) || ConstantConfig.GZWSYQBGDJ.equals(recType)) {
//
//            for (Object object : objs) {
//                if (object instanceof BaGzw) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    tempMap.put("bdcdyh", bdcdyh);
//                    ExampleUtil example = new ExampleUtil(BaGzw.class, tempMap);
//                    List<BaGzw> baGzws = entityMapper.selectByExample(example);
//                    if (null != baGzws && !baGzws.isEmpty()) {
//                        for (BaGzw baGzw : baGzws) {
//                            entityMapper.deleteByPrimaryKey(BaGzw.class, baGzw.getId());
//                        }
//                    }
//                }
//
//                dealZdk103(object, bdcdyh);
//
//            }
//        }
//
//
//        if (ConstantConfig.HYSYQBGDJ.equals(recType)) {
//            for (Object object : objs) {
//                if (object instanceof BaZhjbxx) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    tempMap.put("bdcdyh", bdcdyh);
//                    ExampleUtil example = new ExampleUtil(BaZhjbxx.class, tempMap);
//                    List<BaZhjbxx> baZhjbxxes = entityMapper.selectByExample(example);
//                    if (null != baZhjbxxes && !baZhjbxxes.isEmpty()) {
//                        for (BaZhjbxx baZhjbxx : baZhjbxxes) {
//                            entityMapper.deleteByPrimaryKey(BaZhjbxx.class, baZhjbxx.getId());
//                        }
//                    }
//                }
//
//                if (object instanceof BaYhzk) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    String zhdm = ((BaYhzk) object).getZhdm();
//                    tempMap.put("zhdm", zhdm);
//                    ExampleUtil example = new ExampleUtil(BaYhzk.class, tempMap);
//                    List<BaYhzk> baYhzks = entityMapper.selectByExample(example);
//                    if (null != baYhzks && !baYhzks.isEmpty()) {
//                        for (BaYhzk baYhzk : baYhzks) {
//                            entityMapper.deleteByPrimaryKey(BaYhzk.class, baYhzk.getId());
//                        }
//                    }
//                }
//
//                dealYhydzb(object);
//                dealZhk105(object, bdcdyh);
//
//            }
//        }
//
//        if (ConstantConfig.NYDSYQBGDJ.equals(recType) || ConstantConfig.LQBGDJ.equals(recType)) {
//            for (Object object : objs) {
//                if (object instanceof BaZdjbxx) {
//                    Map<String, Object> tempMap = new HashMap<>();
//                    tempMap.put("bdcdyh", bdcdyh);
//                    ExampleUtil example = new ExampleUtil(BaZdjbxx.class, tempMap);
//                    List<BaZdjbxx> baZhjbxxes = entityMapper.selectByExample(example);
//                    if (null != baZhjbxxes && !baZhjbxxes.isEmpty()) {
//                        for (BaZdjbxx baZdjbxx : baZhjbxxes) {
//                            entityMapper.deleteByPrimaryKey(BaZdjbxx.class, baZdjbxx.getId());
//                        }
//                    }
//                }
//                dealZdk103(object, bdcdyh);
//            }
//        }
//
//        insertSingleTableDao.insertSingleTable(objs);
//
//        return insertResult;
//    }


    /**
     * 处理宗地空间表信息
     *
     * @param object
     * @param bdcdyh
     */
//    public void dealZdk103(Object object, String bdcdyh) {
//        if (object instanceof BaZdk103) {
//            String xh = ((BaZdk103) object).getXh();
//            bdcdyh = ((BaZdk103) object).getBdcdyh();
//            Map<String, Object> temp = new HashMap<>();
//            temp.put("xh", xh);
//            temp.put("bdcdyh", bdcdyh);
//            ExampleUtil exampleTemp = new ExampleUtil(BaZdk103.class, temp);
//            List<BaZdk103> baZdk103List = entityMapper.selectByExample(exampleTemp);
//            if (null != baZdk103List && !baZdk103List.isEmpty()) {
//                for (BaZdk103 baZdk103 : baZdk103List) {
//                    entityMapper.deleteByPrimaryKey(BaZdk103.class, baZdk103.getId());
//                }
//
//            }
//        }
//    }


    /**
     * 处理宗海空间信息表
     *
     * @param object
     * @param bdcdyh
     */
//    public void dealZhk105(Object object, String bdcdyh) {
//
//        if (object instanceof BaZhk105) {
//            int xh = ((BaZhk105) object).getXh();
//            bdcdyh = ((BaZhk105) object).getBdcdyh();
//            Map<String, Object> temp = new HashMap<>();
//            temp.put("xh", xh);
//            temp.put("bdcdyh", bdcdyh);
//            ExampleUtil exampleTemp = new ExampleUtil(BaZhk105.class, temp);
//            List<BaZhk105> baZhk105List = entityMapper.selectByExample(exampleTemp);
//            if (null != baZhk105List && !baZhk105List.isEmpty()) {
//                for (BaZhk105 bazhk105 : baZhk105List) {
//                    entityMapper.deleteByPrimaryKey(BaZhk105.class, bazhk105.getId());
//                }
//            }
//        }
//    }


    /**
     * 处理用海用岛坐标
     *
     * @param object
     */
//    public void dealYhydzb(Object object) {
//
//        if (object instanceof BaYhydzb) {
//            Map<String, Object> tempMap = new HashMap<>();
//            String zhhddm = ((BaYhydzb) object).getZhhddm();
//            int xh = ((BaYhydzb) object).getXh();
//            tempMap.put("zhhddm", zhhddm);
//            tempMap.put("xh", xh);
//            ExampleUtil example = new ExampleUtil(BaYhydzb.class, tempMap);
//            List<BaYhydzb> baYhydzbs = entityMapper.selectByExample(example);
//            if (null != baYhydzbs && !baYhydzbs.isEmpty()) {
//                for (BaYhydzb baYhydzb : baYhydzbs) {
//                    entityMapper.deleteByPrimaryKey(BaYhydzb.class, baYhydzb.getId());
//                }
//            }
//        }
//
//    }
}
