package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.onemap.service.GeoService;
import cn.gtmap.realestate.supervise.entity.BaZdjbxx;
import cn.gtmap.realestate.supervise.entity.BaZdk103;
import cn.gtmap.realestate.supervise.entity.BaZhjbxx;
import cn.gtmap.realestate.supervise.entity.BaZhk105;
import cn.gtmap.realestate.supervise.model.graph.base.Area;
import cn.gtmap.realestate.supervise.model.graph.base.Line;
import cn.gtmap.realestate.supervise.model.graph.base.Point;
import cn.gtmap.realestate.supervise.server.dao.CheckGraphicByBdcdyh;
import cn.gtmap.realestate.supervise.server.dao.GetAllMapInfoByBdcdyh;
import cn.gtmap.realestate.supervise.server.dao.InsertGraphicInfo;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaBdcdyhInfos;
import cn.gtmap.realestate.supervise.server.entity.CheckGraphicInfo;
import cn.gtmap.realestate.supervise.server.entity.GraphicInfo;
import cn.gtmap.realestate.supervise.server.model.GraphicData;
import cn.gtmap.realestate.supervise.server.service.GraphicService;
import cn.gtmap.realestate.supervise.server.service.GraphicZdThreadService;
import cn.gtmap.realestate.supervise.server.service.GraphicZhThreadService;
import cn.gtmap.realestate.supervise.server.utils.Feature;
import cn.gtmap.realestate.supervise.server.utils.FeatureCollection;
import cn.gtmap.realestate.supervise.server.utils.ThreadPoolUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:Administrator@gtmap.cn">Administrator</a>
 * @version 1.0, 2017/7/22
 * @description
 */
@Service
public class GraphicServiceImpl implements GraphicService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GraphicServiceImpl.class);

    //宗地常量
    private static final String ZD = "zd";

    //宗海常量
    private static final String ZH = "zh";


    @Autowired
    private GeoService geoService;

    @Autowired
    BaBdcdyhInfos baBdcdyhInfos;

    @Autowired
    InsertGraphicInfo insertGraphicInfo;

    @Autowired
    GetAllMapInfoByBdcdyh getAllMapInfoByBdcdyh;

    @Autowired
    CheckGraphicByBdcdyh checkGraphicByBdcdyh;

    @Autowired
    LogServiceImpl logService;


    /**
     * 宗海上图程序
     *
     * @return
     */
    @Override
    public boolean insertZhGraphic() {
        boolean res = getInsertInfo(ZH);
        return res;
    }


    /**
     * 宗地上图程序
     *
     * @return
     */
    @Override
    public boolean insertZdGraphic() {
        boolean res = getInsertInfo(ZD);
        return res;
    }


    /**
     * @param type 宗地or宗海
     * @return 需要上图的具体信息已key，value方式返回，key是不动产单元号，value是genJson数据
     */
    private boolean getInsertInfo(String type) {


        //获取需要上图不动产单元信息
        List<String> datas = getAllGraphicBdcdyh(type);

        if (StringUtils.equals(ZH, type)) {
            GraphicData.addZhAllList(datas);//所有需要上图的宗海不动产单元信息
            ThreadPoolUtils threadPoolUtils = ThreadPoolUtils.getInstance();
            threadPoolUtils.addTask(new GraphicZhThreadService(baBdcdyhInfos, geoService, insertGraphicInfo, logService, checkGraphicByBdcdyh));
        }
        if (StringUtils.equals(ZD, type)) {
            GraphicData.addZdAllList(datas);//所有需要上图的宗地不动产单元信息
            ThreadPoolUtils threadPoolUtils = ThreadPoolUtils.getInstance();
            threadPoolUtils.addTask(new GraphicZdThreadService(geoService, baBdcdyhInfos, insertGraphicInfo, logService, checkGraphicByBdcdyh));
        }

        //循环不动产单元
        for (String key : datas) {
            try {
                //获取不动产单元的点面信息
                Area graphicInfo = getGraphicByBdcdyhByType(key, type);

                List<CheckGraphicInfo> infos = checkGraphicByBdcdyh.getCheckGraphicInfo(key);

                if (infos != null && !infos.isEmpty()) {
                    CheckGraphicInfo info = infos.get(0);
                    String sign = info.getSign();
                    if (!StringUtils.equals(sign, graphicInfo.toString())) {
                        Map<String, String> tempGraphicInfos = new HashMap<String, String>();
                        boolean res = dataHandle(key, type, graphicInfo, tempGraphicInfos);
                        if ("zd".equals(type) && res) {
                            //添加宗地上图坐标信息
                            GraphicData.putZdGraphic(tempGraphicInfos);
                        }
                        if ("zh".equals(type) && res) {
                            //添加宗地上图坐标信息
                            GraphicData.putZhGraphic(tempGraphicInfos);
                        }
                    } else {
                        if (StringUtils.equals(ZD, type)) {
                            baBdcdyhInfos.updateZdstbj(key);
                        }
                        if (StringUtils.equals(ZH, type)) {
                            baBdcdyhInfos.updateZhstbj(key);
                        }
                        //记录上图日志
                        GraphicInfo graphicInfo1 = new GraphicInfo();
                        graphicInfo1.setId(key);
                        graphicInfo1.setBdcdyh(key);
                        graphicInfo1.setSuccess("true");
                        graphicInfo1.setMessage("上图成功");
                        insertGraphicInfo.insertGraphicInfo(graphicInfo1);
                    }
                } else {
                    //记录上图坐标信息
                    CheckGraphicInfo info = new CheckGraphicInfo();
                    info.setId(key);
                    info.setBdcdyh(key);
                    info.setSign(graphicInfo.toString());
                    checkGraphicByBdcdyh.insertCheckGraphicInfos(info);
                    Map<String, String> graphicInfos = new HashMap<String, String>();
                    boolean res = dataHandle(key, type, graphicInfo, graphicInfos);
                    if (StringUtils.equals(ZD, type) && res) {
                        //添加宗地上图坐标信息
                        GraphicData.putZdGraphic(graphicInfos);
                    }
                    if (StringUtils.equals(ZH, type) && res) {
                        //添加宗地上图坐标信息
                        GraphicData.putZhGraphic(graphicInfos);
                    }
                }

                if (StringUtils.equals(ZD, type)) {
                    GraphicData.removeZdList();
                }
                if (StringUtils.equals(ZH, type)) {
                    GraphicData.removeZhList();
                }
            } catch (Exception e) {
                LOGGER.error("上图异常,异常信息:{}", e);
            }
        }

        return true;
    }


    /**
     * 判断图形坐标是否有问题
     *
     * @param key
     * @param type
     * @param graphicInfo
     * @param graphicInfos
     */
    private boolean dataHandle(String key, String type, Area graphicInfo, Map<String, String> graphicInfos) {
        try {
            Object properties = getPropertiesInfo(key, type);
            String ges = getServiceInfo(graphicInfo, properties);
            String error = geoService.findTopoError(ges);
            if (StringUtils.isBlank(error)) {
                graphicInfos.put(key, ges);
                LOGGER.info("准备开始上图:" + key);
                return true;
            } else {
                updateStbj(key, type);//上图失败、更新标记为2
                GraphicInfo info = new GraphicInfo();
                info.setId(key);
                info.setBdcdyh(key);
                info.setSuccess("false");
                info.setMessage(error);
                insertGraphicInfo.insertGraphicInfo(info);
                checkGraphicByBdcdyh.delCheckGraphicInfo(key);//删除记录
                logService.insertStsbLog(key, error);
                LOGGER.error("------------上图失败,bdcdyh:{}-----------", key);
                return false;
            }
        } catch (Exception e) {
            LOGGER.error("---上图失败信息 in ，bdcdyh:{},异常信息:{}-------", key, e);
            updateStbj(key, type);//上图失败、更新标记为2
            GraphicInfo info = new GraphicInfo();
            info.setId(key);
            info.setBdcdyh(key);
            info.setSuccess("false");
            info.setMessage(e.getMessage());
            checkGraphicByBdcdyh.delCheckGraphicInfo(key);//删除记录
            insertGraphicInfo.insertGraphicInfo(info);
            logService.insertStsbLog(key, e.getMessage());
            LOGGER.error("---上图失败信息 out ，bdcdyh:{},异常信息:{}------", key, e);
            return false;
        }

    }

    /**
     * @param type 宗地 or 宗海
     * @return 现在需要上图的不动产单元号
     */
    private List<String> getAllGraphicBdcdyh(String type) {
        if (StringUtils.equals(ZH, type)) {

            //查询需要上图的宗海不动产单元
            return baBdcdyhInfos.queryZhBdcdyhInfos();
        }
        if (StringUtils.equals(ZD, type)) {

            //查询需要上图的宗海不动产单元
            return baBdcdyhInfos.queryZdBdcdyhInfos();
        }
        return Lists.newArrayList();
    }

    /**
     * @param bdcdyh 需要查询的不动产单元号
     * @param type   宗地or宗海
     * @return 不动产单元号的坐标点
     */
    @Transactional
    public Area getGraphicByBdcdyhByType(String bdcdyh, String type) {

        List<BaZhk105> zhinfo = Lists.newArrayList();

        List<BaZdk103> zdinfo = Lists.newArrayList();

        //获取宗地基本信息
        if (StringUtils.equals(ZD, type)) {
            zdinfo = getAllMapInfoByBdcdyh.getBaZdk103Info(bdcdyh);
        }

        //获取宗海基本信息
        if (StringUtils.equals(ZH, type)) {
            zhinfo = getAllMapInfoByBdcdyh.getBaZhk105Info(bdcdyh);
        }

        Line line = new Line();

        Area area = new Area();

        if (CollectionUtils.isNotEmpty(zdinfo)) {
            for (BaZdk103 baZdk103 : zdinfo) {
                Point point = new Point();
                point.setX(baZdk103.getXzb());
                point.setY(baZdk103.getYzb());
                getAllMapInfoByBdcdyh.updateBaZdk103(baZdk103);
                line.add(point);
            }
        }
        if (CollectionUtils.isNotEmpty(zhinfo)) {
            for (BaZhk105 baZhk105 : zhinfo) {
                Point point = new Point();
                point.setX(baZhk105.getXzb());
                point.setY(baZhk105.getYzb());
                getAllMapInfoByBdcdyh.updateBaZhk105(baZhk105);
                line.add(point);
            }
        }
        area.addLine(line);
        area.MustArea();
        return area;
    }

    /**
     * @param bdcdyh 根据不动产单元号获取图层额外配置信息
     * @param type   宗地or宗海类型
     * @return 还有宗地宗海信息的bean
     */
    private Object getPropertiesInfo(String bdcdyh, String type) {

        //获取宗地基本信息
        if (StringUtils.equals(ZD, type)) {
            List<BaZdjbxx> info = getAllMapInfoByBdcdyh.getZdXX(bdcdyh);
            if (CollectionUtils.isNotEmpty(info)) {
                BaZdjbxx baZdjbxx = info.get(0);
                baZdjbxx.setSjly("0");
                return baZdjbxx;
            }
            return null;
        }

        //获取宗海基本信息
        if (StringUtils.equals(ZH, type)) {
            List<BaZhjbxx> info = getAllMapInfoByBdcdyh.getZhXX(bdcdyh);
            if (CollectionUtils.isNotEmpty(info)) {
                BaZhjbxx baZhjbxx = info.get(0);
                baZhjbxx.setSjly("0");
                return baZhjbxx;
            }
            return null;
        }
        return null;
    }

    /**
     * @param area       图形坐标点参数
     * @param properties 图形详细参数
     * @return 图形的genJson字符串
     */
    private String getServiceInfo(Area area, Object properties) {

        FeatureCollection featureCollection = new FeatureCollection();
        List<Feature> featureList = new ArrayList<Feature>();
        Feature feature = new Feature();
        feature.setType("Polygon");
        feature.setCoordinates(area);
        if(null!=properties){
            feature.setProperties(properties);
        }else{
            feature.setProperties(null);
        }
        featureList.add(feature);
        featureCollection.setFeatureList(featureList);

        return featureCollection.toString();
    }

    /**
     * 上图失败更新上图标记字段
     *
     * @param bdcdyh
     */
    public void updateStbj(String bdcdyh, String type) {

        //更新宗地上图标记
        if (StringUtils.equals(ZD, type)) {
            baBdcdyhInfos.updateBaZdk103Info(bdcdyh);
        }

        //更新宗海上图标记
        if (StringUtils.equals(ZH, type)) {
            baBdcdyhInfos.updateBaZhk105Info(bdcdyh);
        }
    }


}
