package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.BaDyaq;
import cn.gtmap.realestate.supervise.entity.BaDyaqLs;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.impl.InsertSingleTableDaoImpl;
import cn.gtmap.realestate.supervise.server.dao.mapper.DjqlMapper;
import cn.gtmap.realestate.supervise.server.model.SimpleTableResult;
import cn.gtmap.realestate.supervise.server.service.ServeLog;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/18
 * @description 抵押权登记
 */
@Service
public class DyqdjAbstractServe extends AbstractServeDetail {

    private static final Logger LOGGER = LoggerFactory.getLogger(DyqdjAbstractServe.class);

    @Autowired
    EntityMapper entityMapper;

    @Autowired
    InsertSingleTableDaoImpl insertSingleTableDao;

    @Autowired
    LogServiceImpl logService;

    @Autowired
    CheckRepeatService checkRepeatService;

    @Autowired
    DjqlMapper djqlMapper;

    @Override
    @Transactional
    public ServeLog serveDetail(FileMessage fileMessage) {

        SimpleTableResult simpleTableResult = new SimpleTableResult();

        try {
            init(fileMessage);
//            List<Object> objects = getList(content, recType, fileMessage.getFileName(), areaCode, bdcdyh);
            String flag = fileMessage.getCxrkbj();

            boolean flagTemp = false;

            //抵押权登记
            for (int i = 0; i < objects.size(); i++) {
                Object obj = objects.get(i);
                if (obj instanceof BaDyaq && !flagTemp) {
                    flagTemp = true;
                    String qszt = ((BaDyaq) obj).getQszt();
                    //注销业务
                    if (StringUtils.isNotBlank(qszt) && StringUtils.equals(Constant.QSZT0, qszt)) {
                        simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                    }
                    if (!qszt.isEmpty() && Constant.QSZT1.equals(qszt)) {
                        simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                        String scywh = ((BaDyaq) obj).getSsywh();
                        String ywh = ((BaDyaq) obj).getYwh();
                        String qxdm = ((BaDyaq) obj).getQxdm();
                        String scywhStr = qxdm + "_" + "0";
                        if (null != scywh && !scywh.isEmpty() && !scywhStr.equals(scywh)) {
                            Map<String, Object> param = new HashMap<>();
                            param.put("ywh", scywh);
                            List<BaDyaq> baDyaqList = djqlMapper.getDyaqList(param);
                            if (null != baDyaqList && !baDyaqList.isEmpty()) {
                                BaDyaq baDyaq = baDyaqList.get(0);
                                String qsztStr = baDyaq.getQszt();
                                if (!StringUtils.equals(Constant.QSZT2, qsztStr)) {
                                    checkRepeatService.copySingleData(baDyaq, BaDyaqLs.class);//入历史库
                                    baDyaq.setQszt(Constant.QSZT2);
                                    baDyaq.setSjgxsj(new Date());
                                    entityMapper.updateByPrimaryKeySelective(baDyaq);
                                }
                            } else {
                                logService.insertLog("系统", flag, recType, ywh, areaCode);
                            }
                        }
                    }
                    if (!qszt.isEmpty() && Constant.QSZT2.equals(qszt)) {

                        String bdcdyh = ((BaDyaq) obj).getBdcdyh();
                        String ywh = ((BaDyaq) obj).getYwh();
                        Map<String, Object> param = new HashMap<>();
                        param.put("bdcdyh", bdcdyh);
                        param.put("ywh", ywh);
                        List<BaDyaq> baDyaqList = djqlMapper.getDyaqList(param);
                        if (null != baDyaqList && !baDyaqList.isEmpty()) {//查到上一手信息，修改上一手

                            String zxdyywh = ((BaDyaq) obj).getZxdyywh();
                            String zxdyyy = ((BaDyaq) obj).getZxdyyy();
                            Date zxsj = ((BaDyaq) obj).getZxsj();
                            String fj = ((BaDyaq) obj).getFj();
                            BaDyaq baDyaq = baDyaqList.get(0);
                            checkRepeatService.copySingleData(baDyaq, BaDyaqLs.class);//入历史库
                            baDyaq.setZxdyywh(zxdyywh);
                            baDyaq.setZxdyyy(zxdyyy);
                            baDyaq.setZxsj(zxsj);
                            baDyaq.setFj(fj);
                            baDyaq.setSjgxsj(new Date());
                            baDyaq.setQszt(Constant.QSZT2);
                            entityMapper.updateByPrimaryKeySelective(baDyaq);
                            objects.remove(obj);
                            simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                        } else {//新增
                            simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                            logService.insertLog("系统", flag, recType, ywh, areaCode);
                        }
                    }
                }
            }
        } catch (Exception e) {
            LOGGER.error("DyqdjAbstractServe.Exception!{}:", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            simpleTableResult.setResult(false);
            simpleTableResult.setResultInfo(e.getCause().toString());
            super.getServeLog().setError(e.getCause().toString());
            return super.getServeLog();
        }
        simpleTableResult.setResult(true);
        return super.getServeLog();
    }
}
