package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.BaDyiq;
import cn.gtmap.realestate.supervise.entity.BaDyiqLs;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.impl.InsertSingleTableDaoImpl;
import cn.gtmap.realestate.supervise.server.dao.mapper.DjqlMapper;
import cn.gtmap.realestate.supervise.server.model.SimpleTableResult;
import cn.gtmap.realestate.supervise.server.service.ServeLog;
import cn.gtmap.realestate.supervise.server.utils.XmlUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/18
 * @description 地役权登记
 */
@Service
public class DyiqdjAbstractServe extends AbstractServeDetail {

    private static final Logger LOGGER = LoggerFactory.getLogger(DyiqdjAbstractServe.class);


    @Autowired
    EntityMapper entityMapper;

    @Autowired
    InsertSingleTableDaoImpl insertSingleTableDao;

    @Autowired
    LogServiceImpl logService;

    @Autowired
    CheckRepeatService checkRepeatService;

    @Autowired
    DjqlMapper djqlMapper;

    @Override
    @Transactional
    public ServeLog serveDetail(FileMessage fileMessage) {

        SimpleTableResult simpleTableResult = new SimpleTableResult();
        try {
            init(fileMessage);
//            List<Object> objects = getList(content, recType, fileMessage.getFileName(), areaCode, bdcdyh);
            String flag = fileMessage.getCxrkbj();
            //获取head里面注销上一手参数值
            Map paramPre = XmlUtil.getXMLValueMap(content, "PreCertID", "PreEstateNum");
            boolean flagTemp = false;
            //地役权登记
            for (int i = 0; i < objects.size(); i++) {
                Object obj = objects.get(i);
                if (obj instanceof BaDyiq && !flagTemp) {
                    flagTemp = true;
                    String qszt = ((BaDyiq) obj).getQszt();
                    if (StringUtils.isNotBlank(qszt) && StringUtils.equals(Constant.QSZT0, qszt)) {
                        simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                    }

                    if (StringUtils.isNotBlank(qszt) && Constant.QSZT1.equals(qszt)) {
                        String precertid = (String) paramPre.get("bdcdyh");
                        if (null != precertid && !precertid.isEmpty()) {
                            Map<String, Object> param = new HashMap<>();
                            String ywh = ((BaDyiq) obj).getYwh();
                            param.put("bdcdjzmh", precertid);
                            List<BaDyiq> baDyiqList = djqlMapper.getDyiqList(param);
                            if (null != baDyiqList && !baDyiqList.isEmpty()) {
                                BaDyiq baDyiq = baDyiqList.get(0);
                                String qsztStr = baDyiq.getQszt();
                                if (!StringUtils.equals(Constant.QSZT2, qsztStr)) {
                                    checkRepeatService.copySingleData(baDyiq, BaDyiqLs.class);//入历史表
                                    baDyiq.setSjgxsj(new Date());
                                    baDyiq.setQszt(Constant.QSZT2);
                                    entityMapper.updateByPrimaryKeySelective(baDyiq);
                                }
                            } else {
                                logService.insertLog("系统", flag, recType, ywh, areaCode);
                            }
                        }
                        simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                    }
                    if (!qszt.isEmpty() && Constant.QSZT2.equals(qszt)) {
                        //新增
                        String gydbdcdyh = ((BaDyiq) obj).getGydbdcdyh();
                        String xydbdcdyh = ((BaDyiq) obj).getXydbdcdyh();
                        String bdcdjzmh = ((BaDyiq) obj).getBdcdjzmh();
                        String ywh = ((BaDyiq) obj).getYwh();
                        Map<String, Object> param = new HashMap<>();
                        param.put("gydbdcdyh", gydbdcdyh);
                        param.put("xydbdcdyh", xydbdcdyh);
                        param.put("bdcdjzmh", bdcdjzmh);
                        List<BaDyiq> baDyiqList = djqlMapper.getDyiqList(param);
                        if (null != baDyiqList && !baDyiqList.isEmpty()) {
                            BaDyiq baDyiq = baDyiqList.get(0);
                            String qsztStr = baDyiq.getQszt();
                            checkRepeatService.copySingleData(baDyiq, BaDyiqLs.class);//入历史表
                            baDyiq.setQszt(Constant.QSZT2);
                            baDyiq.setFj(((BaDyiq) obj).getFj());
                            baDyiq.setSjgxsj(new Date());
                            entityMapper.updateByPrimaryKeySelective(baDyiq);
                            objects.remove(obj);
                            simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                        } else {
                            simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                            logService.insertLog("系统", flag, recType, ywh, areaCode);
                        }
                    }
                }
            }
        } catch (Exception e) {
            LOGGER.error("DyiqdjAbstractServe.Exception in!{}", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            simpleTableResult.setResult(false);
            simpleTableResult.setResultInfo(e.getCause().toString());
            super.getServeLog().setError(e.getCause().toString());
            return super.getServeLog();
        }
        simpleTableResult.setResult(true);
        return new ServeLogImpl();
    }
}
