package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.realestate.supervise.server.service.DataConsistencyService;
import cn.gtmap.realestate.supervise.utils.HttpClientUtil;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 2020/9/26
 * @description 数据一致性服务
 */
@Service
public class DataConsistencyServiceImpl implements DataConsistencyService {

    private static final Logger LOGGER = LoggerFactory.getLogger(DataConsistencyServiceImpl.class);

    @Async
    @Override
    public void updateResultState(String ywh) {
        String updateResultStateUrl = AppConfig.getProperty("dataConsistency.updateResultState.url");
        if(StringUtils.isNotBlank(ywh)&&StringUtils.isNotBlank(updateResultStateUrl)) {
            LOGGER.info("数据一致性更新监管结果审核状态开始,{},{}",ywh,updateResultStateUrl);
            Map<String, String> param = new HashMap<>();
            param.put("ywh", ywh);
            try {
                HttpClientUtil.sendHttpClient(updateResultStateUrl, param);
            } catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
    }
}
