package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.common.SystemLogService;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaJrdMapper;
import cn.gtmap.realestate.supervise.server.entity.Bajrdxzqh;
import cn.gtmap.realestate.supervise.server.entity.ClientInfo;
import cn.gtmap.realestate.supervise.server.service.ClientInfoService;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/4/11
 * @description 接入点管理业务逻辑实现类
 */
@Service
public class ClientInfoServiceImpl implements ClientInfoService {

    @Autowired
    private EntityMapper entityMapper;

    @Autowired
    private BaJrdMapper baJrdMapper;

    @Override
    @SystemLogService(description = "新增接入点", czlx = "接入点管理")
    public boolean save(ClientInfo data, UserAuthDTO userInfos) {

        return entityMapper.saveOrUpdate(data, data.getKhdbm()) > 0;
    }

    @Override
    @SystemLogService(description = "修改接入点", czlx = "接入点管理")
    public boolean update(ClientInfo data, UserAuthDTO userInfos) {
        boolean flag;
        try {
            flag = entityMapper.saveOrUpdate(data, data.getKhdbm()) > 0;
        } catch (Exception e) {
            throw new AppException(e, 2001);
        }
        return flag;
    }

    @Override
    @SystemLogService(description = "删除接入点", czlx = "接入点管理")
    public void delete(Map param, UserAuthDTO userInfos) {
        ExampleUtil example = new ExampleUtil(ClientInfo.class, param);
        entityMapper.deleteByExample(example);
    }


    @Override
    public List<ClientInfo> getUserInfoList(Map param) {
        List<ClientInfo> GxDsSyssData;
        Example example = new Example(ClientInfo.class);
        if (null != param && !param.isEmpty()) {
            if (param.containsKey("fzr")) {
                example.createCriteria().andLike("fzr", String.valueOf(param.get("fzr")));
            }
            if (param.containsKey("qxdm")) {
                example.createCriteria().andLike("qxdm", String.valueOf(param.get("qxdm")));
            }
            if (param.containsKey("qxmc")) {
                example.createCriteria().andLike("qxmc", String.valueOf(param.get("qxmc")));
            }
            if (param.containsKey("khdbm")) {
                example.createCriteria().andLike("khdbm", String.valueOf(param.get("khdbm")));
            }
        }
        // 按照接入点代码排序
        example.setOrderByClause(" to_number(qxdm) ");
        GxDsSyssData = entityMapper.selectByExample(example);
        return GxDsSyssData;
    }


    @Override
    public List<ClientInfo> getUserInfos(Map param) {
        List<ClientInfo> GxDsSyssData;
        ExampleUtil example = new ExampleUtil(ClientInfo.class, param);
        // 按照接入点代码排序
        example.setOrderByClause(" to_number(qxdm) ");
        GxDsSyssData = entityMapper.selectByExample(example);
        return GxDsSyssData;
    }

    /**
     * 获取接入点概况
     *
     * @return
     */
    @Override
    public Map<String, Object> getJrdgk(String qhmc) {
        List<ClientInfo> jrdgkInfoList = baJrdMapper.getJrdgk(qhmc);
        Map<String, Object> resMap = Maps.newHashMap();
        int zsl = 0;
        int zcsl = 0;
        int ycsl = 0;
        Date nowDate = new Date();
        long nowTime = nowDate.getTime();
        for (ClientInfo clientInfo : jrdgkInfoList) {
            String jrdzt = clientInfo.getJrdzt();
            Date ztgxsj = clientInfo.getZtgxsj();
            long ztgxsjTemp = ztgxsj.getTime();
            long temp = nowTime - ztgxsjTemp;
            int min = (int) (temp / 1000 / 60);
            zsl++;//统计总数量
            if (StringUtils.equals("0", jrdzt) || min > 60) {
                ycsl++;
            }
            if (StringUtils.equals("1", jrdzt) && min <= 60) {
                zcsl++;
            }
        }
        resMap.put("ZSL", zsl);
        resMap.put("ZCSL", zcsl);
        resMap.put("YCSL", ycsl);

        return resMap;
    }

    @Override
    @SystemLogService(description = "删除接入点关联区划信息", czlx = "接入点管理")
    public void deleteQxData(Map param, UserAuthDTO userInfos) {
        ExampleUtil example = new ExampleUtil(Bajrdxzqh.class, param);
        entityMapper.deleteByExample(example);
    }

    @Override
    @SystemLogService(description = "新增接入点关联区划信息", czlx = "接入点管理")
    public void saveJrdqx(Bajrdxzqh bajrdxzqh, UserAuthDTO userAuthDTO) {
        entityMapper.saveOrUpdate(bajrdxzqh, bajrdxzqh.getId());
    }
}
