package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.aes.AESUtil;
import cn.gtmap.realestate.supervise.aes.SecurityUtil;
import cn.gtmap.realestate.supervise.entity.*;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import com.google.common.collect.Lists;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/10
 * @description
 */
@Service
public class CheckRepeatService extends SecurityUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(CheckRepeatService.class);

    @Autowired
    EntityMapper entityMapper;

    @Autowired
    AESUtil aesUtil;


    /**
     * 依据业务号删除
     *
     * @param object
     */
    @Async
    public void delByYwh(Object object) {
        String className = object.getClass().getSimpleName();
        if (StringUtils.equals(className, "BaC") || StringUtils.equals(className, "BaLjz")) {
            return;
        }
        try {
            Map<String, Object> param = new HashMap<>();
            Class<?> attrObjClass = Class.forName(Constant.ENTITY_PATH + className);
            Method methodYwh = getMthod(attrObjClass, "getYwh");
            if (null != methodYwh) {
                String ywh = (String) methodYwh.invoke(object);//节点里面ywh
                param.put("ywh", ywh);
                if (StringUtils.isNotBlank(ywh)) {
                    Method methodBdcdyh = getMthod(attrObjClass, "getBdcdyh");
                    if (null != methodBdcdyh) {
                        String bdcdyh = (String) methodBdcdyh.invoke(object);
                        if (StringUtils.isNotBlank(bdcdyh)) {
                            param.put("bdcdyh", bdcdyh);
                            if (StringUtils.equals(className, "BaYgdj") ) {
                                Method methodYgdjzl = getMthod(attrObjClass, "getYgdjzl");
                                if (null != methodBdcdyh) {
                                    String ygdjzl = (String) methodYgdjzl.invoke(object);
                                    param.put("ygdjzl", ygdjzl);
                                }
                            }
                        }
                    }
                }
                ExampleUtil example = new ExampleUtil(attrObjClass, param);
                List<?> tempList = entityMapper.selectByExampleNotNull(attrObjClass, example);
                Method[] sourceMethods = attrObjClass.getMethods();
                if (CollectionUtils.isNotEmpty(tempList)) {
                    for (int j = 0; j < tempList.size(); j++) {
                        List<String> encryptFields = getAllAnnoationInfo(attrObjClass);
                        if (CollectionUtils.isNotEmpty(encryptFields)) {
                            Object source = tempList.get(j);
                            decryptSource(sourceMethods, attrObjClass, source);
                        }
                    }
                    Class objClass = Class.forName(Constant.ENTITY_PATH + className + "Ls");
                    copyData(tempList, objClass); //入历史表
                    entityMapper.deleteByExample(example);
                }

            }
        } catch (ClassNotFoundException e) {
            LOGGER.error("CheckRepeatService.delByYwh ClassNotFoundException in !{}", e);
            throw new AppException(e, 2008);
        } catch (IllegalAccessException e) {
            LOGGER.error("CheckRepeatService.delByYwh IllegalAccessException in !{}", e);
            throw new AppException(e, 2008);
        } catch (InvocationTargetException e) {
            LOGGER.error("CheckRepeatService.delByYwh InvocationTargetException in !{}", e);
            throw new AppException(e, 2008);
        }

    }

    /**
     * 判断方法是否为空
     *
     * @param className
     * @param methodName
     * @return
     */
    private Method getMthod(Class className, String methodName) {
        Method method = null;
        try {
            method = className.getMethod(methodName);
        } catch (NoSuchMethodException e) {
            return method;
        }
        return method;
    }

    public void decryptSource(Method[] sourceMethods, Class<?> attrObjClass, Object source) {
        List<String> encryptFields = getAllAnnoationInfo(attrObjClass);
        Map<String, Object> changeValue = new HashMap<String, Object>();
        try {
            for (int m = 0; m < sourceMethods.length; m++) {
                if (sourceMethods[m].getName().startsWith("get")) {
                    String lsName = sourceMethods[m].getName().substring(3);// 属性
                    if (encryptFields.contains(lsName.toLowerCase())) {
                        Object loValue = sourceMethods[m].invoke(source, null);
                        changeValue.put(lsName.toLowerCase(), loValue);
                    }
                }
            }
            for (int h = 0; h < sourceMethods.length; h++) {
                if (sourceMethods[h].getName().startsWith("set")) {
                    String lsName = sourceMethods[h].getName().substring(3);// 属性
                    if (encryptFields.contains(lsName.toLowerCase())) {
                        Object obj = changeValue.get(lsName.toLowerCase());
                        if (null != obj) {
                            String encryptBefore = changeValue.get(lsName.toLowerCase()).toString();
                            sourceMethods[h].invoke(source, aesUtil.decrypt(encryptBefore));
                        }
                    }
                }
            }
        } catch (IllegalAccessException e) {
            LOGGER.error("数据解密异常 decryptSource.IllegalAccessException！{}", e);
        } catch (InvocationTargetException e) {
            LOGGER.error("数据解密异常 decryptSource.InvocationTargetException！{}", e);
        }
    }

    /**
     * 依据不动产单元号删除
     *
     * @param object
     */
    @Async
    public void delByBdcdyh(Object object) {
        String className = object.getClass().getSimpleName();
        String[] strs = {"BaZdk103", "BaZhk105", "BaZhjbxx", "BaFdcqxm", "BaZrz", "BaZdjbxx",
                "BaH", "BaGzw", "BaMzdzw", "BaXzdzw", "BaDzdzw"};
        boolean flag = Arrays.asList(strs).contains(className);
        String bdcdyh = "";
        if (flag) {
            Class attrObjClass = null;
            Class objClass = null;
            try {
                objClass = Class.forName(Constant.ENTITY_PATH + className + "Ls");
                attrObjClass = Class.forName(Constant.ENTITY_PATH + className);
                Method method = attrObjClass.getMethod("getBdcdyh");
                if (null != method) {
                    bdcdyh = (String) method.invoke(object);//节点里面bdcdyh
                }
                Map<String, Object> param = new HashMap<>();
                if (object instanceof BaZdk103) {
                    bdcdyh = ((BaZdk103) object).getBdcdyh();
                }
                if (object instanceof BaZhk105) {
                    bdcdyh = ((BaZhk105) object).getBdcdyh();
                }
                param.put("bdcdyh", bdcdyh);
                ExampleUtil example = new ExampleUtil(attrObjClass, param);
                List tempList = entityMapper.selectByExample(attrObjClass, example);
                Method[] sourceMethods = attrObjClass.getMethods();
                if (CollectionUtils.isNotEmpty(tempList)) {
                    for (int j = 0; j < tempList.size(); j++) {
                        List<String> encryptFields = getAllAnnoationInfo(attrObjClass);
                        if (CollectionUtils.isNotEmpty(encryptFields)) {
                            Object source = tempList.get(j);
                            decryptSource(sourceMethods, attrObjClass, source);
                        }
                    }
                    copyData(tempList, objClass); //入历史表
                    entityMapper.deleteByExample(example);
                }

            } catch (ClassNotFoundException e) {
                LOGGER.error("CheckRepeatService.delByBdcdyh ClassNotFoundException in !{}", e.getMessage());
                throw new AppException(e, 2008);
            } catch (NoSuchMethodException e) {
                LOGGER.error("CheckRepeatService.delByBdcdyh NoSuchMethodException in !{}", e.getMessage());
                throw new AppException(e, 2008);
            } catch (IllegalAccessException e) {
                LOGGER.error("CheckRepeatService.delByBdcdyh IllegalAccessException in !{}", e.getMessage());
                throw new AppException(e, 2008);
            } catch (InvocationTargetException e) {
                LOGGER.error("CheckRepeatService.delByBdcdyh InvocationTargetException in !{}", e.getMessage());
                throw new AppException(e, 2008);
            }

        }
    }


    /**
     * 删除其它数据
     *
     * @param object
     */
    @Async
    public void delOther(Object object, String zrzh, String zddm) {

        Map<String, Object> param = new HashMap<>();
        if (object instanceof BaYhydzb) {
            String zhhddm = ((BaYhydzb) object).getZhdm();
            param.put("zhhddm", zhhddm);
            ExampleUtil example = new ExampleUtil(BaYhydzb.class, param);
            List<BaYhydzb> baYhydzbList = entityMapper.selectByExample(BaYhydzb.class, example);
            copyData(baYhydzbList, BaYhydzbLs.class); //入历史表
            entityMapper.deleteByExample(example);
        }

        if (object instanceof BaYhzk) {
            String zhdm = ((BaYhzk) object).getZhdm();
            param.put("zhdm", zhdm);
            ExampleUtil example = new ExampleUtil(BaYhzk.class, param);
            List<BaYhzk> baYhzkList = entityMapper.selectByExample(BaYhzk.class, example);
            copyData(baYhzkList, BaYhzkLs.class); //入历史表
            entityMapper.deleteByExample(example);
        }

//        if (object instanceof BaZhbhqk) {
//            String zhdm = ((BaZhbhqk) object).getZhdm();
//            Date djsj = ((BaZhbhqk) object).getDjsj();
//            param.put("zhdm", zhdm);
//            param.put("djsj", djsj);
//            ExampleUtil example = new ExampleUtil(BaZhbhqk.class, param);
//
//            List<BaZhbhqk> baZhbhqkList = entityMapper.selectByExample(BaZhbhqk.class, example);
//            copyData(baZhbhqkList, BaZhbhqkLs.class); //入历史表
//
//            entityMapper.deleteByExample(example);
//        }

//        if (object instanceof BaZdbhqk) {
//            String zddm = ((BaZdbhqk) object).getZddm();
//            Date djsj = ((BaZdbhqk) object).getDjsj();
//            param.put("zddm", zddm);
//            param.put("djsj", djsj);
//            ExampleUtil example = new ExampleUtil(BaZdbhqk.class, param);
//
//            List<BaZdbhqk> baZdbhqkList = entityMapper.selectByExample(BaZdbhqk.class, example);
//            copyData(baZdbhqkList, BaZdbhqkLs.class); //入历史表
//
//            entityMapper.deleteByExample(example);
//        }

        if (object instanceof BaJzd) {
            String zdzhdm = ((BaJzd) object).getZdzhdm();
            param.put("zdzhdm", zdzhdm);
            ExampleUtil example = new ExampleUtil(BaJzd.class, param);
            List<BaJzd> bajzdList = entityMapper.selectByExample(BaJzd.class, example);
            copyData(bajzdList, BaJzdLs.class); //入历史表
            entityMapper.deleteByExample(example);
        }
        if (object instanceof BaJzx) {
            String zdzhdm = ((BaJzx) object).getZdzhdm();
            param.put("zdzhdm", zdzhdm);
            ExampleUtil example = new ExampleUtil(BaJzx.class, param);
            List<BaJzx> baJzxList = entityMapper.selectByExample(BaJzx.class, example);
            copyData(baJzxList, BaJzxLs.class); //入历史表
            entityMapper.deleteByExample(example);
        }

        if (object instanceof BaC && (null != zrzh && !zrzh.isEmpty())) {
            String ch = ((BaC) object).getCh();
            String classPath = Constant.ENTITY_PATH + BaC.class.getSimpleName();
            String zrzhStr = getInfo(classPath, "getZrzh", object);
            String zrzbh = zddm + "_" + zrzhStr;
            if (StringUtils.isNotBlank(zrzbh)) {
                param.put("ch", ch);
                param.put("zrzbh", zrzbh);
                ExampleUtil example = new ExampleUtil(BaC.class, param);
                List<BaC> baC = entityMapper.selectByExample(BaC.class, example);
                copyData(baC, BaCLs.class); //入历史表
                entityMapper.deleteByExample(example);
            }
        }

        if (object instanceof BaLjz && (null != zrzh && !zrzh.isEmpty())) {
            String ljzh = ((BaLjz) object).getLjzh();
            String classPath = Constant.ENTITY_PATH + BaLjz.class.getSimpleName();
            String zrzhStr = getInfo(classPath, "getZrzh", object);
            String zrzbh =  zddm + "_" + zrzhStr;
            if (StringUtils.isNotBlank(zrzbh)) {
                param.put("ljzh", ljzh);
                param.put("zrzbh", zrzbh);
                ExampleUtil example = new ExampleUtil(BaLjz.class, param);
                List<BaLjz> baLjzList = entityMapper.selectByExample(BaLjz.class, example);
                copyData(baLjzList, BaLjzLs.class); //入历史表
                entityMapper.deleteByExample(example);
            }
        }

        if (object instanceof BaQlrgx) {
            String bdcdyh = ((BaQlrgx) object).getBdcdyh();
            String bdcqzh = ((BaQlrgx) object).getBdcqzh();
            param.put("bdcdyh", bdcdyh);
            param.put("bdcqzh", bdcqzh);
            ExampleUtil example = new ExampleUtil(BaQlrgx.class, param);

            List<BaQlrgx> baQlrgxList = entityMapper.selectByExample(BaQlrgx.class, example);
            copyData(baQlrgxList, BaQlrgxLs.class); //入历史表

            entityMapper.deleteByExample(example);
        }

        if (object instanceof BaZxdj) {
            String ywh = ((BaZxdj) object).getYwh();
            String bdcdyh = ((BaZxdj) object).getBdcdyh();
            param.put("ywh", ywh);
            param.put("bdcdyh", bdcdyh);
            ExampleUtil example = new ExampleUtil(BaZxdj.class, param);
            List<BaZxdj> bazxdjList = entityMapper.selectByExample(BaZxdj.class, example);
            copyData(bazxdjList, BaZxdjLs.class); //入历史表
            entityMapper.deleteByExample(example);
        }

    }


    @Transactional
    public void serveDetail(List<Object> objects) {
        if (null != objects && !objects.isEmpty()) {
            String zrzh = "";
            String zddm = "";
            for (Object obj : objects) {
                if (obj instanceof BaZrz) {
                    zrzh = ((BaZrz) obj).getZrzh();
                    zddm = ((BaZrz) obj).getZddm();
                }
            }
            for (Object obj : objects) {
                delByYwh(obj);
                delByBdcdyh(obj);
                delOther(obj, zrzh, zddm);
            }
        }
    }


    /**
     * 入批量数据到历史表
     *
     * @param listData
     * @param className
     */
    public void copyData(List listData, Class className) {
        if (CollectionUtils.isNotEmpty(listData)) {
            List tempList = Lists.newArrayList();
            for (int i = 0; i < listData.size(); i++) {
                try {
                    Object destObj = className.newInstance();
                    destObj = objectClone(destObj, listData.get(i));
                    tempList.add(destObj);
                } catch (IllegalAccessException e) {
                    LOGGER.error("拷贝数据异常{}.IllegalAccessException！{}", className, e);
                } catch (InstantiationException e) {
                    LOGGER.error("拷贝数据异常{}.InstantiationException！{}", className, e);
                }
            }
            entityMapper.batchSaveSelective(tempList);
        }
    }

    /**
     * 入单条数据到历史表
     *
     * @param object
     * @param className
     */
    public void copySingleData(Object object, Class className) {
        if (null != object) {
            try {
                Object destObj = className.newInstance();
                destObj = objectClone(destObj, object);
                entityMapper.insertSelective(destObj);
            } catch (IllegalAccessException e) {
                LOGGER.error("拷贝数据异常copySingleData:{}.IllegalAccessException！{}", className, e);
            } catch (InstantiationException e) {
                LOGGER.error("拷贝数据异常copySingleData:{}.InstantiationException！{}", className, e);
            }
        }
    }

    /**
     * 复制数据
     *
     * @param newObject
     * @param oldObject
     * @return
     */
    public static Object objectClone(Object newObject, Object oldObject) {
        try {
            String name = newObject.getClass().getName();
            Field[] oldFields = oldObject.getClass().getDeclaredFields();
            Field newField;
            for (Field oldField : oldFields) {
                String filedName = oldField.getName();
                newField = newObject.getClass().getDeclaredField(filedName);
                if (null != newField) {
                    oldField.setAccessible(true);
                    newField.setAccessible(true);
//                    if (StringUtils.equals(filedName, Constant.SJGXSJ)) {
//                        newField.set(newObject, new Date());
//                    } else {
                    if (StringUtils.equals(filedName, Constant.ID)) {
                        newField.set(newObject, UUIDGenerator.generate18());
                    } else {
                        newField.set(newObject, oldField.get(oldObject));
                    }
//                    }
                }
            }
            if (StringUtils.equals(name, Constant.BA_GD_LS)) {
                newField = newObject.getClass().getDeclaredField(Constant.ID);
                newField.setAccessible(true);
                newField.set(newObject, UUIDGenerator.generate18());
            }
        } catch (Exception e) {
            LOGGER.error("拷贝数据异常objectClone.InstantiationException！{}", e);
        }
        return newObject;
    }

    public String getInfo(String classPath, String methodName, Object object) {
        String res = null;
        try {
            Class attrObjClass = Class.forName(classPath);
            Method method = attrObjClass.getMethod(methodName);
            res = "";
            if (null != method) {
                res = (String) method.invoke(object);
            }
        } catch (ClassNotFoundException e) {
            LOGGER.error("CheckRepeatService.getInfo ClassNotFoundException in !{}", e.getMessage());
            throw new AppException(e, 2008);
        } catch (NoSuchMethodException e) {
            LOGGER.error("CheckRepeatService.getInfo NoSuchMethodException in !{}", e.getMessage());
            throw new AppException(e, 2008);
        } catch (IllegalAccessException e) {
            LOGGER.error("CheckRepeatService.getInfo IllegalAccessException in !{}", e.getMessage());
            throw new AppException(e, 2008);
        } catch (InvocationTargetException e) {
            LOGGER.error("CheckRepeatService.getInfo InvocationTargetException in !{}", e.getMessage());
            throw new AppException(e, 2008);
        }
        return res;
    }

    @Override
    public String decrypt(String encrypted) {
        return null;
    }

    @Override
    public String encrypt(String clearPwd) {
        return null;
    }

    @Override
    public byte[] getDecrKey() {
        return new byte[0];
    }

    @Override
    public byte[] getEncrKey() {
        return new byte[0];
    }
}
