package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.BaCfdj;
import cn.gtmap.realestate.supervise.entity.BaCfdjLs;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.impl.InsertSingleTableDaoImpl;
import cn.gtmap.realestate.supervise.server.dao.mapper.DjqlMapper;
import cn.gtmap.realestate.supervise.server.model.SimpleTableResult;
import cn.gtmap.realestate.supervise.server.service.ServeLog;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/18
 * @description 查封登记
 */
@Service
public class CfdjAbstractServe extends AbstractServeDetail {

    private static final Logger LOGGER = LoggerFactory.getLogger(CfdjAbstractServe.class);

    @Autowired
    EntityMapper entityMapper;

    @Autowired
    InsertSingleTableDaoImpl insertSingleTableDao;

    @Autowired
    LogServiceImpl logService;

    @Autowired
    CheckRepeatService checkRepeatService;

    @Autowired
    DjqlMapper djqlMapper;

    @Override
    @Transactional
    public ServeLog serveDetail(FileMessage fileMessage) {

        SimpleTableResult simpleTableResult = new SimpleTableResult();
        try {
            init(fileMessage);
//            List<Object> objects = getList(content, recType, fileMessage.getFileName(), areaCode, bdcdyh);
            boolean flagTemp = false;
            //查封登记
            for (int i = 0; i < objects.size(); i++) {
                Object obj = objects.get(i);
                if (obj instanceof BaCfdj && !flagTemp) {
                    flagTemp = true;
                    String qszt = ((BaCfdj) obj).getQszt();
                    //新增
                    if (StringUtils.isNotBlank(qszt) && Constant.QSZT1.equals(qszt) || StringUtils.isNotBlank(qszt) && StringUtils.equals(Constant.QSZT0, qszt)) {
                        simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                    }
                    if (!qszt.isEmpty() && Constant.QSZT2.equals(qszt)) {
                        String bdcdyh = ((BaCfdj) obj).getBdcdyh();
                        String ywh = ((BaCfdj) obj).getYwh();
                        Map<String, Object> param = new HashMap<>();
                        param.put("bdcdyh", bdcdyh);
                        param.put("ywh", ywh);
                        ExampleUtil example = new ExampleUtil(BaCfdj.class, param);
                        List<BaCfdj> baCfdjList = entityMapper.selectByExample(example);

                        //解封修改权属状态信息
                        if (null != baCfdjList && !baCfdjList.isEmpty()) {
                            String jfywh = ((BaCfdj) obj).getJfywh();
                            String jfjg = ((BaCfdj) obj).getJfjg();
                            String jfwj = ((BaCfdj) obj).getJfwj();
                            String jfwh = ((BaCfdj) obj).getJfwh();
                            String jfdbr = ((BaCfdj) obj).getJfdbr();
                            Date jfdjsj = ((BaCfdj) obj).getJfdjsj();
                            String fj = ((BaCfdj) obj).getFj();
                            BaCfdj bacfdj = baCfdjList.get(0);
                            checkRepeatService.copySingleData(bacfdj, BaCfdjLs.class);//入历史表
                            bacfdj.setJfywh(jfywh);
                            bacfdj.setJfjg(jfjg);
                            bacfdj.setJfwj(jfwj);
                            bacfdj.setJfwh(jfwh);
                            bacfdj.setJfdbr(jfdbr);
                            bacfdj.setJfdjsj(jfdjsj);
                            bacfdj.setFj(fj);
                            bacfdj.setSjgxsj(new Date());
                            bacfdj.setQszt(Constant.QSZT2);
                            entityMapper.updateByPrimaryKeySelective(bacfdj);
                            objects.remove(obj);
                            simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                        } else {
                            simpleTableResult = insertSingleTableDao.insertSingleTable(objects);
                            String flag = fileMessage.getCxrkbj();
                            logService.insertLog("系统", flag, recType, ywh, areaCode);
                        }
                    }
                }
            }
        } catch (Exception e) {
            LOGGER.error("CfdjAbstractServe.Exception in!{}", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            simpleTableResult.setResult(false);
            simpleTableResult.setResultInfo(e.getCause().toString());
            super.getServeLog().setError(e.getCause().toString());
            return super.getServeLog();
        }
        simpleTableResult.setResult(true);
        return new ServeLogImpl();
    }
}
