package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.*;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.InsertSingleTableDao;
import cn.gtmap.realestate.supervise.server.dao.mapper.DjqlMapper;
import cn.gtmap.realestate.supervise.server.model.SimpleTableResult;
import cn.gtmap.realestate.supervise.server.service.CancelService;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import cn.gtmap.realestate.supervise.utils.AESSecutiryUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/6
 * @description 注销业务实现类
 */
@Service
public class CancelServiceImpl implements CancelService {


    @Autowired
    EntityMapper entityMapper;

    @Autowired
    LogServiceImpl logService;


    @Autowired
    InsertSingleTableDao insertSingleTableDao;

    @Autowired
    CheckRepeatService checkRepeatService;

    @Autowired
    DjqlMapper djqlMapper;


    /**
     * 注销业务入口
     * 根据业务类型recType修改对应表状态
     *
     * @param objects
     * @param recType
     * @return
     */
    @Override
    public SimpleTableResult cancel(List<Object> objects, String recType, Map paramMap, String bizId, String ywh, String qxdm, String bdcdyh, String cxrkbj) throws RuntimeException {

        SimpleTableResult result = new SimpleTableResult();
        boolean flag = true;
        if (objects != null && !objects.isEmpty()) {
            //土地所有权转移登记  //土地所有权变更登记 //土地所有权更正登记
            if (!recType.isEmpty() && Constant.TDSYQZYDJ.equals(recType) ||
                    Constant.TDSYQBGDJ.equals(recType) || Constant.TDSYQGZDJ.equals(recType)
                    || Constant.ZXDJ.equals(recType)) {
                flag = dataHandleTd(flag, paramMap, recType, bdcdyh, objects);
            }

            //建设用地使用权、宅基地使用权转移登记 ,建设用地使用权、宅基地使用权变更登记
            if (!recType.isEmpty() && Constant.JSYDSYQZYDJ.equals(recType) ||
                    Constant.JSYDSYQBGDJ.equals(recType)
                    || Constant.JSYDSYQGZDJ.equals(recType)
                    || Constant.ZXDJ.equals(recType)) {

                flag = dataHandleJsyd(flag, paramMap, recType, bdcdyh, objects);
            }

            //房地产权（项目内多幢房屋）转移登记 //变更 //更正
            if (!recType.isEmpty() && Constant.FDCQZYDJ1.equals(recType) || Constant.FDCQBGDJ1.equals(recType)
                    || Constant.FDCQGZDJ1.equals(recType) || Constant.ZXDJ.equals(recType)) {

                flag = dataHandleFdcq1(flag, paramMap, recType, bdcdyh, objects);
            }

            // 房地产权（独幢、层、套、间、房屋）转移登记
            if (!recType.isEmpty() && Constant.FDCQZYDJ2.equals(recType) || (Constant.FDCQBGDJ2.equals(recType))
                    || Constant.FDCQGZDJ2.equals(recType) || Constant.ZXDJ.equals(recType)) {

                flag = dataHandleFdcq2(flag, paramMap, recType, bdcdyh, objects);
            }


            //海域(含无居民海岛)使用权转移登记  ，海域(含无居民海岛)使用权变更登记
            if (!recType.isEmpty() && Constant.HYSYQZYDJ.equals(recType) ||
                    Constant.HYSYQBGDJ.equals(recType) || Constant.HYSYQGZDJ.equals(recType)
                    || Constant.ZXDJ.equals(recType)) {
                flag = dataHandleHy(flag, paramMap, recType, bdcdyh, objects);
            }

            //构（建）筑物所有权转移登记 ,构（建）筑物所有权变更登记
            if (!recType.isEmpty() && Constant.GZWSYQZYDJ.equals(recType) ||
                    Constant.GZWSYQBGDJ.equals(recType) || Constant.GZWSYQGZDJ.equals(recType)
                    || Constant.ZXDJ.equals(recType)) {

                flag = dataHandleGzw(flag, paramMap, recType, bdcdyh, objects);
            }

            //农用地使用权（非林地）转移登记 ,//农用地使用权（非林地）变更登记
            if (!recType.isEmpty() && Constant.NYDSYQZYDJ.equals(recType) ||
                    Constant.NYDSYQBGDJ.equals(recType) || Constant.NYDSYQGZDJ.equals(recType)
                    || Constant.ZXDJ.equals(recType)) {

                flag = dataHandleNyd(flag, paramMap, recType, bdcdyh, objects);
            }

            //林权转移登记 ,//林权变更登记
            if (!recType.isEmpty() && Constant.LQZYDJ.equals(recType) ||
                    Constant.LQBGDJ.equals(recType) || Constant.LQGZDJ.equals(recType)
                    || Constant.ZXDJ.equals(recType)) {
                flag = dataHandleLq(flag, paramMap, recType, bdcdyh, objects);

            }


            //建筑物区分所有权业主共有部分转移登记 ，建筑物区分所有权业主共有部分变更登记
            if (!recType.isEmpty() && Constant.JZWQFSYQZYDJ.equals(recType) ||
                    Constant.JZWQFSYQBGDJ.equals(recType) ||
                    Constant.JZWQFSYQGZDJ.equals(recType) || Constant.ZXDJ.equals(recType)) {

                flag = dataHandleJzw(flag, paramMap, recType, bdcdyh, objects);
            }

            result.setResult(true);
        }
        if (flag) {
            logService.insertLog("系统", cxrkbj, recType, ywh, qxdm);
        }
        return result;
    }


    public boolean dataHandleTd(boolean flag, Map<String, Object> paramMap, String recType, String bdcdyh, List<Object> objects) {
        List<BaTdsyq> baTdsyqList = null;
        if (paramMap.containsKey("bdcdyh")) {
            ExampleUtil example = new ExampleUtil(BaTdsyq.class, paramMap);
            baTdsyqList = entityMapper.selectByExample(example);

            //用 bdcdyh 和 bdcqzh查询记录
            if (null != baTdsyqList && !baTdsyqList.isEmpty()) {

                for (BaTdsyq obj : baTdsyqList) {
                    String qszt = obj.getQszt();
                    if (!StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaTdsyqLs.class);//入历史库
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                        flag = false;
                    }
                }
            }
        }

        //用BDCDYH查询记录
        if (!Constant.ZXDJ.equals(recType) && (null == baTdsyqList || baTdsyqList.isEmpty())) {
            paramMap.remove("bdcqzh");
            paramMap.put("bdcdyh", bdcdyh);
            ExampleUtil exa = new ExampleUtil(BaTdsyq.class, paramMap);
            List<BaTdsyq> resList = entityMapper.selectByExample(exa);
            if (null != resList && !resList.isEmpty()) {
                Date djsj1 = new Date();
                Date djsj2;
                for (Object object : objects) {
                    if (object instanceof BaTdsyq) {
                        djsj1 = ((BaTdsyq) object).getDjsj();
                    }
                }
                for (BaTdsyq obj : resList) {
                    djsj2 = obj.getDjsj();
                    String qszt = obj.getQszt();
                    if (djsj1.compareTo(djsj2) > 0 && !StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaTdsyqLs.class);//入历史库
                        flag = false;
                        obj.setSjgxsj(new Date());
                        obj.setQszt(Constant.QSZT2);
                        entityMapper.updateByPrimaryKeySelective(obj);
                    }
                }
            }
        }
        return flag;
    }


    public boolean dataHandleJsyd(boolean flag, Map<String, Object> paramMap, String recType, String bdcdyh, List<Object> objects) {
        List<BaJsydsyq> baJsydsyqList = null;
        if (paramMap.containsKey("bdcdyh")) {
            ExampleUtil example = new ExampleUtil(BaJsydsyq.class, paramMap);
            baJsydsyqList = entityMapper.selectByExample(example);
            //用 bdcdyh 和 bdcqzh查询记录
            if (null != baJsydsyqList && !baJsydsyqList.isEmpty()) {
                for (BaJsydsyq obj : baJsydsyqList) {
                    String qszt = obj.getQszt();
                    if (!StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaJsydsyqLs.class);//入历史库
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                        flag = false;
                    }
                }
            }
        }

        if (!Constant.ZXDJ.equals(recType) && (null == baJsydsyqList || baJsydsyqList.isEmpty()) && StringUtils.isNotBlank(bdcdyh)) { //用BDCDYH查询记录
            paramMap.remove("bdcqzh");
            paramMap.put("bdcdyh", bdcdyh);
            ExampleUtil exa = new ExampleUtil(BaJsydsyq.class, paramMap);
            List<BaJsydsyq> resList = entityMapper.selectByExample(exa);
            if (null != resList && !resList.isEmpty()) {
                Date djsj1 = new Date();
                Date djsj2;
                for (Object object : objects) {
                    if (object instanceof BaJsydsyq) {
                        djsj1 = ((BaJsydsyq) object).getDjsj();
                    }
                }
                for (BaJsydsyq obj : resList) {
                    djsj2 = obj.getDjsj();
                    String qszt = obj.getQszt();
                    if (djsj1.compareTo(djsj2) > 0 && !StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaJsydsyqLs.class);//入历史库
                        flag = false;
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                    }
                }
            }
        }
        return flag;
    }


    public boolean dataHandleFdcq1(boolean flag, Map<String, Object> paramMap, String recType, String bdcdyh, List<Object> objects) {
        List<BaFdcq1> baFdcq1List = null;
        if (paramMap.containsKey("bdcdyh")) {
            baFdcq1List = djqlMapper.getFdcq1List(paramMap);

            //用 bdcdyh 和 bdcqzh查询记录
            if (null != baFdcq1List && !baFdcq1List.isEmpty()) {
                for (BaFdcq1 obj : baFdcq1List) {
                    String qszt = obj.getQszt();
                    if (!StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaFdcq1Ls.class);//入历史库
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                        flag = false;
                    }
                }
            }
        }

        //用BDCDYH查询记录
        if (!Constant.ZXDJ.equals(recType) && (null == baFdcq1List || baFdcq1List.isEmpty())) {
            paramMap.remove("bdcqzh");
            paramMap.put("bdcdyh", bdcdyh);
            List<BaFdcq1> resList = djqlMapper.getFdcq1List(paramMap);
            if (null != resList && !resList.isEmpty()) {
                Date djsj1 = new Date();
                Date djsj2;
                for (Object object : objects) {
                    if (object instanceof BaFdcq1) {
                        djsj1 = ((BaFdcq1) object).getDjsj();
                    }
                }
                for (BaFdcq1 obj : resList) {
                    djsj2 = obj.getDjsj();
                    String qszt = obj.getQszt();
                    if (djsj1.compareTo(djsj2) > 0 && !StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaFdcq1Ls.class);//入历史库
                        flag = false;
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                    }
                }
            }
        }
        return flag;
    }


    public boolean dataHandleFdcq2(boolean flag, Map<String, Object> paramMap, String recType, String bdcdyh, List<Object> objects) {
        List<BaFdcq2> baFdcq2List = null;
        if (paramMap.containsKey("bdcdyh")) {
            baFdcq2List = djqlMapper.getFdcq2List(paramMap);
            //用 bdcdyh 和 bdcqzh查询记录
            if (null != baFdcq2List && !baFdcq2List.isEmpty()) {

                for (BaFdcq2 obj : baFdcq2List) {
                    String qszt = obj.getQszt();
                    if (!StringUtils.equals(Constant.QSZT2, qszt)) {
                        obj.setTdsyqr(AESSecutiryUtil.decrypt(obj.getTdsyqr()));
                        checkRepeatService.copySingleData(obj, BaFdcq2Ls.class);//入历史库
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                        flag = false;
                    }
                }
            }
        }

        //用BDCDYH查询记录
        if (!Constant.ZXDJ.equals(recType) && (null == baFdcq2List || baFdcq2List.isEmpty())) {
            paramMap.remove("bdcqzh");
            paramMap.put("bdcdyh", bdcdyh);
            List<BaFdcq2> resList = djqlMapper.getFdcq2List(paramMap);
            if (null != resList && !resList.isEmpty()) {
                Date djsj1 = new Date();
                Date djsj2;
                for (Object object : objects) {
                    if (object instanceof BaFdcq2) {
                        djsj1 = ((BaFdcq2) object).getDjsj();
                    }
                }
                for (BaFdcq2 obj : resList) {
                    djsj2 = obj.getDjsj();
                    String qszt = obj.getQszt();
                    if (djsj1.compareTo(djsj2) > 0 && !StringUtils.equals(Constant.QSZT2, qszt)) {
                        obj.setTdsyqr(AESSecutiryUtil.decrypt(obj.getTdsyqr()));
                        checkRepeatService.copySingleData(obj, BaFdcq2Ls.class);//入历史库
                        flag = false;
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                    }
                }
            }
        }
        return flag;
    }

    public boolean dataHandleHy(boolean flag, Map<String, Object> paramMap, String recType, String bdcdyh, List<Object> objects) {
        List<BaHysyq> baHysyqList = null;
        if (paramMap.containsKey("bdcdyh")) {
            ExampleUtil example = new ExampleUtil(BaHysyq.class, paramMap);
            baHysyqList = entityMapper.selectByExample(example);
            //用 bdcdyh 和 bdcqzh查询记录
            if (null != baHysyqList && !baHysyqList.isEmpty()) {
                for (BaHysyq obj : baHysyqList) {
                    String qszt = obj.getQszt();
                    if (!StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaHysyqLs.class);//入历史库
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                        flag = false;
                    }
                }
            }
        }

        //用BDCDYH查询记录
        if (!Constant.ZXDJ.equals(recType) && (null == baHysyqList || baHysyqList.isEmpty())) {
            paramMap.remove("bdcqzh");
            paramMap.put("bdcdyh", bdcdyh);
            ExampleUtil exa = new ExampleUtil(BaHysyq.class, paramMap);
            List<BaHysyq> resList = entityMapper.selectByExample(exa);
            if (null != resList && !resList.isEmpty()) {
                Date djsj1 = new Date();
                Date djsj2;
                for (Object object : objects) {
                    if (object instanceof BaHysyq) {
                        djsj1 = ((BaHysyq) object).getDjsj();
                    }
                }
                for (BaHysyq obj : resList) {
                    djsj2 = obj.getDjsj();
                    String qszt = obj.getQszt();
                    if (djsj1.compareTo(djsj2) > 0 && !StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaHysyqLs.class);//入历史库
                        flag = false;
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                    }
                }
            }
        }
        return flag;
    }

    public boolean dataHandleGzw(boolean flag, Map<String, Object> paramMap, String recType, String bdcdyh, List<Object> objects) {
        List<BaGjzwsyq> baGjzwsyqList = null;
        if (paramMap.containsKey("bdcdyh")) {
            ExampleUtil example = new ExampleUtil(BaGjzwsyq.class, paramMap);
            baGjzwsyqList = entityMapper.selectByExample(example);
            //用 bdcdyh 和 bdcqzh查询记录
            if (null != baGjzwsyqList && !baGjzwsyqList.isEmpty()) {
                for (BaGjzwsyq obj : baGjzwsyqList) {
                    String qszt = obj.getQszt();
                    if (!StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaGjzwsyqLs.class);//入历史库
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                        flag = false;
                    }
                }
            }
        }

        //用BDCDYH查询记录
        if (!Constant.ZXDJ.equals(recType) && (null == baGjzwsyqList || baGjzwsyqList.isEmpty())) {
            paramMap.remove("bdcqzh");
            paramMap.put("bdcdyh", bdcdyh);
            ExampleUtil exa = new ExampleUtil(BaGjzwsyq.class, paramMap);
            List<BaGjzwsyq> resList = entityMapper.selectByExample(exa);
            if (null != resList && !resList.isEmpty()) {
                Date djsj1 = new Date();
                Date djsj2;
                for (Object object : objects) {
                    if (object instanceof BaGjzwsyq) {
                        djsj1 = ((BaGjzwsyq) object).getDjsj();
                    }
                }
                for (BaGjzwsyq obj : resList) {
                    djsj2 = obj.getDjsj();
                    String qszt = obj.getQszt();
                    if (djsj1.compareTo(djsj2) > 0 && !StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaGjzwsyqLs.class);//入历史库
                        flag = false;
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                    }
                }

            }
        }
        return flag;
    }

    public boolean dataHandleNyd(boolean flag, Map<String, Object> paramMap, String recType, String bdcdyh, List<Object> objects) {
        List<BaNydsyq> baNydsyqList = null;
        if (paramMap.containsKey("bdcdyh")) {
            ExampleUtil example = new ExampleUtil(BaNydsyq.class, paramMap);
            baNydsyqList = entityMapper.selectByExample(example);
            //用 bdcdyh 和 bdcqzh查询记录
            if (null != baNydsyqList && !baNydsyqList.isEmpty()) {

                for (BaNydsyq obj : baNydsyqList) {
                    String qszt = obj.getQszt();
                    if (!StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaNydsyqLs.class);//入历史库
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                        flag = false;
                    }
                }
            }
        }

        //用BDCDYH查询记录
        if (!Constant.ZXDJ.equals(recType) && (null == baNydsyqList || baNydsyqList.isEmpty())) {
            paramMap.remove("bdcqzh");
            paramMap.put("bdcdyh", bdcdyh);
            ExampleUtil exa = new ExampleUtil(BaNydsyq.class, paramMap);
            List<BaNydsyq> resList = entityMapper.selectByExample(exa);
            if (null != resList && !resList.isEmpty()) {
                Date djsj1 = new Date();
                Date djsj2;
                for (Object object : objects) {
                    if (object instanceof BaNydsyq) {
                        djsj1 = ((BaNydsyq) object).getDjsj();
                    }
                }
                for (BaNydsyq obj : resList) {
                    djsj2 = obj.getDjsj();
                    String qszt = obj.getQszt();
                    if (djsj1.compareTo(djsj2) > 0 && !StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaNydsyqLs.class);//入历史库
                        flag = false;
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                    }
                }
            }
        }
        return flag;
    }

    public boolean dataHandleLq(boolean flag, Map<String, Object> paramMap, String recType, String bdcdyh, List<Object> objects) {
        List<BaLq> baLqList = null;
        if (paramMap.containsKey("bdcdyh")) {
            ExampleUtil example = new ExampleUtil(BaLq.class, paramMap);
            baLqList = entityMapper.selectByExample(example);
            //用 bdcdyh 和 bdcqzh查询记录
            if (null != baLqList && !baLqList.isEmpty()) {

                for (BaLq obj : baLqList) {
                    String qszt = obj.getQszt();
                    if (!StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaLqLs.class);//入历史库
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                        flag = false;
                    }
                }
            }
        }

        if (!Constant.ZXDJ.equals(recType) && (null == baLqList || baLqList.isEmpty())) { //用BDCDYH查询记录
            paramMap.remove("bdcqzh");
            ExampleUtil exa = new ExampleUtil(BaLq.class, paramMap);
            List<BaLq> resList = entityMapper.selectByExample(exa);
            if (null != resList && !resList.isEmpty()) {
                Date djsj1 = new Date();
                Date djsj2;
                for (Object object : objects) {
                    if (object instanceof BaLq) {
                        djsj1 = ((BaLq) object).getDjsj();
                    }
                }
                for (BaLq obj : resList) {
                    djsj2 = obj.getDjsj();
                    String qszt = obj.getQszt();
                    if (djsj1.compareTo(djsj2) > 0 && !StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaLqLs.class);//入历史库
                        flag = false;
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                    }
                }
            }
        }
        return flag;
    }

    public boolean dataHandleJzw(boolean flag, Map<String, Object> paramMap, String recType, String bdcdyh, List<Object> objects) {
        if (paramMap.containsKey("bdcqzh")) {
            paramMap.remove("bdcqzh");
        }

        List<BaFdcq3> baFdcq3List = null;
        if (paramMap.containsKey("bdcdyh")) {
            ExampleUtil example = new ExampleUtil(BaFdcq3.class, paramMap);
            baFdcq3List = entityMapper.selectByExample(example);
            //用 bdcdyh 和 bdcqzh查询记录
            if (null != baFdcq3List && !baFdcq3List.isEmpty()) {
                for (BaFdcq3 obj : baFdcq3List) {
                    String qszt = obj.getQszt();
                    if (!StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaFdcq3Ls.class);//入历史库
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                        flag = false;
                    }
                }
            }
        }

        if (!Constant.ZXDJ.equals(recType) && (CollectionUtils.isEmpty(baFdcq3List))) { //用BDCDYH查询记录
            paramMap.remove("bdcqzh");
            ExampleUtil exa = new ExampleUtil(BaFdcq3.class, paramMap);
            List<BaFdcq3> resList = entityMapper.selectByExample(exa);
            if (null != resList && !resList.isEmpty()) {
                Date djsj1 = new Date();
                Date djsj2;
                for (Object object : objects) {
                    if (object instanceof BaFdcq3) {
                        djsj1 = ((BaFdcq3) object).getDjsj();
                    }
                }
                for (BaFdcq3 obj : resList) {
                    djsj2 = obj.getDjsj();
                    String qszt = obj.getQszt();
                    if (djsj1.compareTo(djsj2) > 0 && !StringUtils.equals(Constant.QSZT2, qszt)) {
                        checkRepeatService.copySingleData(obj, BaFdcq3Ls.class);//入历史库
                        flag = false;
                        obj.setQszt(Constant.QSZT2);
                        obj.setSjgxsj(new Date());
                        entityMapper.updateByPrimaryKeySelective(obj);
                    }
                }
            }
        }
        return flag;
    }


    /**
     * 新增业务逻辑
     *
     * @param recType
     * @param objs
     * @return
     */
    public SimpleTableResult insertData(String recType, List<Object> objs, String bdcdyh) {

        SimpleTableResult insertResult = new SimpleTableResult();

        //KTT_ZDJBXX 土地所有权转移登记,5000101
        if (Constant.TDSYQZYDJ.equals(recType) || Constant.TDSYQGZDJ.equals(recType)
                || Constant.JSYDSYQZYDJ.equals(recType)
                || Constant.JSYDSYQGZDJ.equals(recType)
                || Constant.NYDSYQZYDJ.equals(recType)
                || Constant.NYDSYQGZDJ.equals(recType)
                || Constant.LQGZDJ.equals(recType)
                || Constant.LQZYDJ.equals(recType)) {

            Map<String, Object> tempMap = new HashMap<>();
            for (Object obj : objs) {
                if (obj instanceof BaZdjbxx) {
                    tempMap.put("bdcdyh", ((BaZdjbxx) obj).getBdcdyh());
                    ExampleUtil example = new ExampleUtil(BaZdjbxx.class, tempMap);
                    List<BaZdjbxx> zdjbxxList = entityMapper.selectByExample(example);
                    if (CollectionUtils.isNotEmpty(zdjbxxList)) {
                        checkRepeatService.copyData(zdjbxxList, BaZdjbxxLs.class);
                        for (BaZdjbxx bazdjbxx : zdjbxxList) {
                            entityMapper.deleteByPrimaryKey(BaZdjbxx.class, bazdjbxx.getId());
                        }
                    }
                }
            }
        }

        if (Constant.FDCQZYDJ1.equals(recType) || Constant.FDCQGZDJ1.equals(recType)
                || Constant.FDCQGZDJ2.equals(recType) || Constant.FDCQZYDJ2.equals(recType)) {
            String zddm = "";
            for (Object object : objs) {
                if (object instanceof BaZrz) {
                    Map<String, Object> tempMap = new HashMap<>();
                    zddm = ((BaZrz) object).getZddm();
                    String zrzh = ((BaZrz) object).getZrzh();
                    String bdcdyhStr = ((BaZrz) object).getBdcdyh();
                    tempMap.put("bdcdyh", bdcdyhStr);
                    ExampleUtil example = new ExampleUtil(BaZrz.class, tempMap);
                    List<BaZrz> baZrzs = entityMapper.selectByExample(example);
                    if (null != baZrzs && !baZrzs.isEmpty()) {
                        checkRepeatService.copyData(baZrzs, BaZrzLs.class);
                        for (BaZrz baZrz : baZrzs) {
                            entityMapper.deleteByPrimaryKey(BaZrz.class, baZrz.getId());
                        }
                    }
                    if (null != zddm && !zddm.isEmpty()) {
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaZrz) object).setZrzbh(zrzbh);
                    } else {
                        zddm = bdcdyh.substring(0, 19);
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaZrz) object).setZrzbh(zrzbh);
                    }
                }

                if (object instanceof BaH) {
                    Map<String, Object> tempMap = new HashMap<>();
                    tempMap.put("bdcdyh", ((BaH) object).getBdcdyh());
                    ExampleUtil example = new ExampleUtil(BaH.class, tempMap);
                    List<BaH> baHS = entityMapper.selectByExample(example);
                    if (null != baHS && !baHS.isEmpty()) {
                        checkRepeatService.copyData(baHS, BaHLs.class);
                        for (BaH baH : baHS) {
                            entityMapper.deleteByPrimaryKey(BaH.class, baH.getId());
                        }
                    }
                }
            }

            for (Object object : objs) {
                if (object instanceof BaLjz) {
                    Map<String, Object> tempMap = new HashMap<>();
                    String ljzh = ((BaLjz) object).getLjzh();
                    String zrzh = ((BaLjz) object).getZrzh();
                    String zrzbhStr = zddm + "_" + zrzh;
                    if(StringUtils.isNotBlank(zrzbhStr)){
                        tempMap.put("ljzh", ljzh);
                        tempMap.put("zrzbh", zrzbhStr);
                        ExampleUtil example = new ExampleUtil(BaLjz.class, tempMap);
                        List<BaLjz> baLjzs = entityMapper.selectByExample(example);
                        if (null != baLjzs && !baLjzs.isEmpty()) {
                            checkRepeatService.copyData(baLjzs, BaLjzLs.class);
                            for (BaLjz baLjz : baLjzs) {
                                entityMapper.deleteByPrimaryKey(BaLjz.class, baLjz.getId());
                            }
                        }
                    }
                    if (null != zddm && !zddm.isEmpty()) {
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaLjz) object).setZrzbh(zrzbh);
                    } else {
                        zddm = bdcdyh.substring(0, 19);
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaLjz) object).setZrzbh(zrzbh);
                    }
                }
                if (object instanceof BaC) {
                    Map<String, Object> tempMap = new HashMap<>();
                    String ch = ((BaC) object).getCh();
                    String zrzh = ((BaC) object).getZrzh();
                    String param = zddm + "_" + zrzh;
                    tempMap.put("ch", ch);
                    tempMap.put("zrzbh", param);
                    ExampleUtil example = new ExampleUtil(BaC.class, tempMap);
                    List<BaC> baCS = entityMapper.selectByExample(example);
                    if (null != baCS && !baCS.isEmpty()) {
                        checkRepeatService.copyData(baCS, BaCLs.class);
                        for (BaC baC : baCS) {
                            entityMapper.deleteByPrimaryKey(BaC.class, baC.getId());
                        }
                    }
                    if (null != zddm && !zddm.isEmpty()) {
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaC) object).setZrzbh(zrzbh);
                    } else {
                        zddm = bdcdyh.substring(0, 19);
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaC) object).setZrzbh(zrzbh);
                    }
                }
            }
        }

        if (Constant.JZWQFSYQZYDJ.equals(recType) || Constant.JZWQFSYQGZDJ.equals(recType)
                || Constant.GZWSYQZYDJ.equals(recType) || Constant.GZWSYQGZDJ.equals(recType)) {
            Map<String, Object> tempMap = new HashMap<>();
            for (Object object : objs) {
                if (object instanceof BaGzw) {
                    tempMap.put("bdcdyh", ((BaGzw) object).getBdcdyh());
                    ExampleUtil example = new ExampleUtil(BaGzw.class, tempMap);
                    List<BaGzw> baGzws = entityMapper.selectByExample(example);
                    if (null != baGzws && !baGzws.isEmpty()) {
                        checkRepeatService.copyData(baGzws, BaGzwLs.class);
                        for (BaGzw baGzw : baGzws) {
                            entityMapper.deleteByPrimaryKey(BaGzw.class, baGzw.getId());
                        }
                    }
                }
            }
        }

        if (Constant.HYSYQZYDJ.equals(recType) || Constant.HYSYQGZDJ.equals(recType)) {
            for (Object object : objs) {
                if (object instanceof BaZhjbxx) {
                    Map<String, Object> tempMap = new HashMap<>();
                    tempMap.put("bdcdyh", ((BaZhjbxx) object).getBdcdyh());
                    ExampleUtil example = new ExampleUtil(BaZhjbxx.class, tempMap);
                    List<BaZhjbxx> baZhjbxxes = entityMapper.selectByExample(example);
                    if (null != baZhjbxxes && !baZhjbxxes.isEmpty()) {
                        checkRepeatService.copyData(baZhjbxxes, BaZhjbxxLs.class);
                        for (BaZhjbxx baZhjbxx : baZhjbxxes) {
                            entityMapper.deleteByPrimaryKey(BaZhjbxx.class, baZhjbxx.getId());
                        }
                    }
                }

                if (object instanceof BaYhzk) {
                    Map<String, Object> tempMap = new HashMap<>();
                    String zhdm = ((BaYhzk) object).getZhdm();
                    tempMap.put("zhdm", zhdm);
                    ExampleUtil example = new ExampleUtil(BaYhzk.class, tempMap);
                    List<BaYhzk> baYhzks = entityMapper.selectByExample(example);
                    if (null != baYhzks && !baYhzks.isEmpty()) {
                        checkRepeatService.copyData(baYhzks, BaYhzkLs.class);
                        for (BaYhzk baYhzk : baYhzks) {
                            entityMapper.deleteByPrimaryKey(BaYhzk.class, baYhzk.getId());
                        }
                    }
                }
                dealYhydzb(object);
            }
        }


        if (Constant.TDSYQBGDJ.equals(recType) || Constant.JSYDSYQBGDJ.equals(recType)) {

            for (Object obj : objs) {

                if (obj instanceof BaZdjbxx) {
                    Map<String, Object> tempMap = new HashMap<>();
                    tempMap.put("bdcdyh", ((BaZdjbxx) obj).getBdcdyh());
                    ExampleUtil example = new ExampleUtil(BaZdjbxx.class, tempMap);
                    List<BaZdjbxx> zdjbxxList = entityMapper.selectByExample(example);
                    if (CollectionUtils.isNotEmpty(zdjbxxList)) {
                        checkRepeatService.copyData(zdjbxxList, BaZdjbxxLs.class);
                        for (BaZdjbxx bazdjbxx : zdjbxxList) {
                            entityMapper.deleteByPrimaryKey(BaZdjbxx.class, bazdjbxx.getId());
                        }
                    }
                }

                if (obj instanceof BaJzx) {
                    Map<String, Object> tempMap = new HashMap<>();
                    String zdzhdm = ((BaJzx) obj).getZdzhdm();
                    tempMap.put("zdzhdm", zdzhdm);
                    ExampleUtil example = new ExampleUtil(BaJzx.class, tempMap);
                    List<BaJzx> baJzxes = entityMapper.selectByExample(example);
                    if (null != baJzxes && !baJzxes.isEmpty()) {
                        checkRepeatService.copyData(baJzxes, BaJzxLs.class);
                        for (BaJzx baJzx : baJzxes) {
                            entityMapper.deleteByPrimaryKey(BaJzx.class, baJzx.getId());
                        }
                    }
                }


                if (obj instanceof BaJzd) {
                    Map<String, Object> tempMap = new HashMap<>();
                    String zdzhdm = ((BaJzd) obj).getZdzhdm();
//                    String jzdh = ((BaJzd) obj).getJzdh();
                    tempMap.put("zdzhdm", zdzhdm);
//                    tempMap.put("jzdh", jzdh);
                    ExampleUtil example = new ExampleUtil(BaJzd.class, tempMap);
                    List<BaJzd> baJzds = entityMapper.selectByExample(example);
                    if (null != baJzds && !baJzds.isEmpty()) {
                        checkRepeatService.copyData(baJzds, BaJzdLs.class);
                        for (BaJzd baJzd : baJzds) {
                            entityMapper.deleteByPrimaryKey(BaJzd.class, baJzd.getId());
                        }
                    }
                }
                dealZdk103(obj, bdcdyh);
            }
        }


        if (Constant.FDCQBGDJ1.equals(recType) || Constant.FDCQBGDJ2.equals(recType)) {
            String zddm = "";
            for (Object object : objs) {
                if (object instanceof BaZrz) {
                    Map<String, Object> tempMap = new HashMap<>();
                    zddm = ((BaZrz) object).getZddm();
                    String zrzh = ((BaZrz) object).getZrzh();
                    String bdcdyhStr = ((BaZrz) object).getBdcdyh();
                    tempMap.put("bdcdyh", bdcdyhStr);
//                    tempMap.put("zrzh", zrzh);
                    ExampleUtil example = new ExampleUtil(BaZrz.class, tempMap);
                    List<BaZrz> baZrzs = entityMapper.selectByExample(example);
                    if (null != baZrzs && !baZrzs.isEmpty()) {
                        checkRepeatService.copyData(baZrzs, BaZrzLs.class);
                        for (BaZrz baZrz : baZrzs) {
                            entityMapper.deleteByPrimaryKey(BaZrz.class, baZrz.getId());
                        }

                    }
                    if (null != zddm && !zddm.isEmpty()) {
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaZrz) object).setZrzbh(zrzbh);
                    } else {
                        zddm = bdcdyh.substring(0, 19);
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaZrz) object).setZrzbh(zrzbh);
                    }
                }

                if (object instanceof BaH) {
                    Map<String, Object> tempMap = new HashMap<>();
                    tempMap.put("bdcdyh", ((BaH) object).getBdcdyh());
                    ExampleUtil example = new ExampleUtil(BaH.class, tempMap);
                    List<BaH> baHS = entityMapper.selectByExample(example);
                    if (null != baHS && !baHS.isEmpty()) {
                        checkRepeatService.copyData(baHS, BaHLs.class);
                        for (BaH baH : baHS) {
                            entityMapper.deleteByPrimaryKey(BaH.class, baH.getId());
                        }
                    }
                }
                dealZdk103(object, bdcdyh);
            }

            for (Object object : objs) {

                if (object instanceof BaLjz) {
                    Map<String, Object> tempMap = new HashMap<>();
                    String ljzh = ((BaLjz) object).getLjzh();
                    String zrzh = ((BaLjz) object).getZrzh();
                    String zrzbhStr = zddm + "_" + zrzh;;
                    if (StringUtils.isNotBlank(zrzbhStr)) {
                        tempMap.put("ljzh", ljzh);
                        tempMap.put("zrzbh", zrzbhStr);
                        ExampleUtil example = new ExampleUtil(BaLjz.class, tempMap);
                        List<BaLjz> baLjzs = entityMapper.selectByExample(example);
                        if (null != baLjzs && !baLjzs.isEmpty()) {
                            checkRepeatService.copyData(baLjzs, BaLjzLs.class);
                            for (BaLjz baLjz : baLjzs) {
                                entityMapper.deleteByPrimaryKey(BaLjz.class, baLjz.getId());
                            }
                        }
                    }

                    if (null != zddm && !zddm.isEmpty()) {
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaLjz) object).setZrzbh(zrzbh);
                    } else {
                        zddm = bdcdyh.substring(0, 19);
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaLjz) object).setZrzbh(zrzbh);
                    }
                }
                if (object instanceof BaC) {
                    Map<String, Object> tempMap = new HashMap<>();
                    String ch = ((BaC) object).getCh();
                    String zrzh = ((BaC) object).getZrzh();
                    String param = zddm + "_" + zrzh;
                    tempMap.put("ch", ch);
                    tempMap.put("zrzbh", param);
                    ExampleUtil example = new ExampleUtil(BaC.class, tempMap);
                    List<BaC> baCS = entityMapper.selectByExample(example);
                    if (null != baCS && !baCS.isEmpty()) {
                        checkRepeatService.copyData(baCS, BaCLs.class);
                        for (BaC baC : baCS) {
                            entityMapper.deleteByPrimaryKey(BaC.class, baC.getId());
                        }
                    }
                    if (null != zddm && !zddm.isEmpty()) {
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaC) object).setZrzbh(zrzbh);
                    } else {
                        zddm = bdcdyh.substring(0, 19);
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaC) object).setZrzbh(zrzbh);
                    }
                }
            }
        }


        if (Constant.JZWQFSYQBGDJ.equals(recType) || Constant.GZWSYQBGDJ.equals(recType)) {

            for (Object object : objs) {
                if (object instanceof BaGzw) {
                    Map<String, Object> tempMap = new HashMap<>();
                    tempMap.put("bdcdyh", ((BaGzw) object).getBdcdyh());
                    ExampleUtil example = new ExampleUtil(BaGzw.class, tempMap);
                    List<BaGzw> baGzws = entityMapper.selectByExample(example);
                    if (null != baGzws && !baGzws.isEmpty()) {
                        checkRepeatService.copyData(baGzws, BaGzwLs.class);
                        for (BaGzw baGzw : baGzws) {
                            entityMapper.deleteByPrimaryKey(BaGzw.class, baGzw.getId());
                        }
                    }
                }
                dealZdk103(object, bdcdyh);
            }
        }


        if (Constant.HYSYQBGDJ.equals(recType)) {
            for (Object object : objs) {
                if (object instanceof BaZhjbxx) {
                    Map<String, Object> tempMap = new HashMap<>();
                    tempMap.put("bdcdyh", ((BaZhjbxx) object).getBdcdyh());
                    ExampleUtil example = new ExampleUtil(BaZhjbxx.class, tempMap);
                    List<BaZhjbxx> baZhjbxxes = entityMapper.selectByExample(example);
                    if (null != baZhjbxxes && !baZhjbxxes.isEmpty()) {
                        checkRepeatService.copyData(baZhjbxxes, BaZhjbxxLs.class);
                        for (BaZhjbxx baZhjbxx : baZhjbxxes) {
                            entityMapper.deleteByPrimaryKey(BaZhjbxx.class, baZhjbxx.getId());
                        }
                    }
                }

                if (object instanceof BaYhzk) {
                    Map<String, Object> tempMap = new HashMap<>();
                    String zhdm = ((BaYhzk) object).getZhdm();
                    tempMap.put("zhdm", zhdm);
                    ExampleUtil example = new ExampleUtil(BaYhzk.class, tempMap);
                    List<BaYhzk> baYhzks = entityMapper.selectByExample(example);
                    if (null != baYhzks && !baYhzks.isEmpty()) {
                        checkRepeatService.copyData(baYhzks, BaYhzkLs.class);
                        for (BaYhzk baYhzk : baYhzks) {
                            entityMapper.deleteByPrimaryKey(BaYhzk.class, baYhzk.getId());
                        }
                    }
                }

                dealYhydzb(object);
                dealZhk105(object, bdcdyh);

            }
        }

        if (Constant.NYDSYQBGDJ.equals(recType) || Constant.LQBGDJ.equals(recType)) {
            for (Object object : objs) {
                if (object instanceof BaZdjbxx) {
                    Map<String, Object> tempMap = new HashMap<>();
                    tempMap.put("bdcdyh", ((BaZdjbxx) object).getBdcdyh());
                    ExampleUtil example = new ExampleUtil(BaZdjbxx.class, tempMap);
                    List<BaZdjbxx> baZdjbxxes = entityMapper.selectByExample(example);
                    if (null != baZdjbxxes && !baZdjbxxes.isEmpty()) {
                        checkRepeatService.copyData(baZdjbxxes, BaZdjbxxLs.class);
                        for (BaZdjbxx baZdjbxx : baZdjbxxes) {
                            entityMapper.deleteByPrimaryKey(BaZdjbxx.class, baZdjbxx.getId());
                        }
                    }
                }
                dealZdk103(object, bdcdyh);
            }
        }

        insertSingleTableDao.insertSingleTable(objs);

        return insertResult;
    }

    /**
     * 处理宗地空间表信息
     *
     * @param object
     * @param bdcdyh
     */
    public void dealZdk103(Object object, String bdcdyh) {
        if (object instanceof BaZdk103) {
            String xh = ((BaZdk103) object).getXh();
            bdcdyh = ((BaZdk103) object).getBdcdyh();
            Map<String, Object> temp = new HashMap<>();
            temp.put("xh", xh);
            temp.put("bdcdyh", bdcdyh);
            ExampleUtil exampleTemp = new ExampleUtil(BaZdk103.class, temp);
            List<BaZdk103> baZdk103List = entityMapper.selectByExample(exampleTemp);
            if (null != baZdk103List && !baZdk103List.isEmpty()) {
                checkRepeatService.copyData(baZdk103List, BaZdk103Ls.class);
                for (BaZdk103 baZdk103 : baZdk103List) {
                    entityMapper.deleteByPrimaryKey(BaZdk103.class, baZdk103.getId());
                }

            }
        }
    }


    /**
     * 处理宗海空间信息表
     *
     * @param object
     * @param bdcdyh
     */
    public void dealZhk105(Object object, String bdcdyh) {

        if (object instanceof BaZhk105) {
            int xh = ((BaZhk105) object).getXh();
            bdcdyh = ((BaZhk105) object).getBdcdyh();
            Map<String, Object> temp = new HashMap<>();
            temp.put("xh", xh);
            temp.put("bdcdyh", bdcdyh);
            ExampleUtil exampleTemp = new ExampleUtil(BaZhk105.class, temp);
            List<BaZhk105> baZhk105List = entityMapper.selectByExample(exampleTemp);
            if (null != baZhk105List && !baZhk105List.isEmpty()) {
                checkRepeatService.copyData(baZhk105List, BaZhk105Ls.class);
                for (BaZhk105 bazhk105 : baZhk105List) {
                    entityMapper.deleteByPrimaryKey(BaZhk105.class, bazhk105.getId());
                }
            }
        }
    }


    /**
     * 处理用海用岛坐标
     *
     * @param object
     */
    public void dealYhydzb(Object object) {

        if (object instanceof BaYhydzb) {
            Map<String, Object> tempMap = new HashMap<>();
            String zhhddm = ((BaYhydzb) object).getZhdm();
            int xh = ((BaYhydzb) object).getXh();
            tempMap.put("zhhddm", zhhddm);
            tempMap.put("xh", xh);
            ExampleUtil example = new ExampleUtil(BaYhydzb.class, tempMap);
            List<BaYhydzb> baYhydzbs = entityMapper.selectByExample(example);
            if (null != baYhydzbs && !baYhydzbs.isEmpty()) {
                checkRepeatService.copyData(baYhydzbs, BaYhydzbLs.class);
                for (BaYhydzb baYhydzb : baYhydzbs) {
                    entityMapper.deleteByPrimaryKey(BaYhydzb.class, baYhydzb.getId());
                }
            }
        }

    }
}
