package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.realestate.supervise.entity.BaZxdj;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.common.impl.ObjectServiceImpl;
import cn.gtmap.realestate.supervise.server.dao.impl.InsertSingleTableDaoImpl;
import cn.gtmap.realestate.supervise.server.model.SimpleTableResult;
import cn.gtmap.realestate.supervise.server.service.ServeLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/18
 * @description 注销业务
 */

@Service
public class CancelAbstractServe extends AbstractServeDetail {

    private static final Logger LOGGER = LoggerFactory.getLogger(CancelAbstractServe.class);

    @Autowired
    CancelServiceImpl cancelService;

    @Autowired
    InsertSingleTableDaoImpl insertSingleTableDao;

    @Autowired
    ObjectServiceImpl objectService;

    @Override
    @Transactional
    public ServeLog serveDetail(FileMessage fileMessage){

        SimpleTableResult simpleTableResult = new SimpleTableResult();

        try {
            init(fileMessage);
//            List<Object> objects = getList(content, recType, fileMessage.getFileName(), areaCode, bdcdyh);
            String cxrkbj = fileMessage.getCxrkbj();
            for (Object object : objects) {
                if (object instanceof BaZxdj) {
                    String bdcdyh = ((BaZxdj) object).getBdcdyh();
                    String zxywh = ((BaZxdj) object).getZxywh();
                    Map<String, String> param = new HashMap<>();
                    param.put("bdcdyh", bdcdyh);
                    param.put("ywh", zxywh);
                    String ywh= ((BaZxdj) object).getYwh();
                   cancelService.cancel(objects, recType, param, bizId, ywh, areaCode, bdcdyh,cxrkbj);
                }
            }
            //注销
           insertSingleTableDao.insertSingleTable(objects);
        } catch (Exception e) {
            LOGGER.error("CancelAbstractServe.Exception in!{}",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            simpleTableResult.setResult(false);
            simpleTableResult.setResultInfo(e.getCause().toString());
            super.getServeLog().setError(e.getCause().toString());
            return super.getServeLog();
        }

        simpleTableResult.setResult(true);
        return new ServeLogImpl();
    }
}
