package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.realestate.supervise.entity.BaSlsq;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.model.Respond;
import cn.gtmap.realestate.supervise.server.common.impl.DataInsertDbService;
import cn.gtmap.realestate.supervise.server.common.impl.ObjectServiceImpl;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaRzjlMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BwcxrkMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BwcxrkrzMapper;
import cn.gtmap.realestate.supervise.server.entity.Babwcxrkxx;
import cn.gtmap.realestate.supervise.server.entity.Log;
import cn.gtmap.realestate.supervise.server.entity.Rzjl;
import cn.gtmap.realestate.supervise.server.es.SearchService;
import cn.gtmap.realestate.supervise.server.model.BwcxrkData;
import cn.gtmap.realestate.supervise.server.service.*;
import cn.gtmap.realestate.supervise.server.utils.BeanUtils;
import cn.gtmap.realestate.supervise.server.utils.ThreadPoolUtils;
import cn.gtmap.realestate.supervise.utils.JaxbUtil;
import cn.gtmap.realestate.supervise.utils.XmlUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2018/5/23
 * @description 报文重新入库业务逻辑
 */
@Service
public class BwcxrkServiceImpl implements BwcxrkService {

    private static final Logger LOGGER = LoggerFactory.getLogger(BwcxrkServiceImpl.class);

    @Autowired
    private BaRzjlMapper baRzjlMapper;

    @Autowired
    private SearchService searchService;

    @Autowired
    private ServeFactory serveFactory;

//    @Autowired
//    private DataInsertDbService dataInsertDbService;

    @Autowired
    private ObjectServiceImpl objectService;

    @Autowired
    private CheckRepeatService checkRepeatService;

    @Autowired
    private BwcxrkrzMapper bwcxrkrzMapper;

    @Autowired
    private LogService logService;

    @Autowired
//    @Lazy
    private BwcxrkServiceImpl bwcxrkService;

    @Autowired
    private BwcxrkMapper bwcxrkMapper;

    String qxdm = AppConfig.getProperty("supersive.server.qhdm");//需要转换的区划代码

    /**
     * 数据处理
     *
     * @param param
     * @param userAuthDTO
     * @param request
     * @return
     */
    @Override
    public void dataHandle(Map<String, Object> param, UserAuthDTO userAuthDTO, HttpServletRequest request) {

        String qhdm = (String) param.get("qhdm");
        List<Rzjl> rzjlList = baRzjlMapper.getGdxx(param);
        BwcxrkData.setCheckDataList(qhdm, rzjlList);//设置检查数据
        String fileName;
        String ywbwid;
        String userName = userAuthDTO.getUsername();
        String ip = request.getRemoteAddr();
        LOGGER.info("区划代码：{}-报文重新入库数据开始处理", qhdm);

        ThreadPoolUtils threadPoolUtils = ThreadPoolUtils.getInstance();
        threadPoolUtils.addTask(new ThreadDelDataService(bwcxrkService, bwcxrkMapper, qhdm));
        threadPoolUtils.addTask(new ThreadDataHandleService(userName, qhdm,
                serveFactory, bwcxrkrzMapper, bwcxrkMapper, bwcxrkService, ip, param));

        //获取需要重新入库处理的报文名字
        int i = 0;
        for (Rzjl rzjl : rzjlList) {
            fileName = rzjl.getFilename();
            ywbwid = rzjl.getYwbwid();
            try {
                i++;
                String fileContent = searchService.mainGetData(fileName, "", "", ywbwid, "");
                Map<String, String> head = XmlUtil.getParamValueByElement(fileContent, "Head");
                FileMessage fileMessage = new FileMessage();
                fileMessage.setBizMsgId(head.get("BizMsgID"));
                fileMessage.setRectype(head.get("RecType"));
                fileMessage.setEstateNum(head.get("EstateNum"));
                fileMessage.setAreaCode(head.get("AreaCode"));
                fileMessage.setContent(fileContent.getBytes("UTF-8"));
                fileMessage.setRecFlowID(head.get("RecFlowID"));
                fileMessage.setFileName(rzjl.getFilename());
                fileMessage.setCxrkbj("1");//重新入库报文标记
                long checkStartTime = System.currentTimeMillis();
                DataInsertDbService dataInsertDbService = BeanUtils.getDataInsertDbService();
                BaSlsq baSlsq = dataInsertDbService.serviceCheck(fileMessage);//校验业务报文是否相同
                long checkEndTime = System.currentTimeMillis();
                LOGGER.info("第" + i + "个报文:" + fileName + "，校验业务时间---" + (checkEndTime - checkStartTime));
                if (null != baSlsq) {
                    fileMessage.setScbj("1");//删除标记
                }
                BwcxrkData.setDelData(qhdm, fileMessage);
                BwcxrkData.setDelTempMap(qhdm, fileMessage);
            } catch (Exception e) {
                Map<String, Object> paramMap = Maps.newHashMap();
                paramMap.put("rkjg", 0);
                paramMap.put("sbyy", e.getMessage());
                paramMap.put("id", UUIDGenerator.generate18());
                paramMap.put("czyhmc", userName);
                paramMap.put("bwmc", fileName);
                paramMap.put("rksj", new Date());
                paramMap.put("qhdm", qhdm);
                bwcxrkrzMapper.insertBwcxrkrz(paramMap);
                LOGGER.error("报文重新入库异常，文件名:{},异常信息:{}", fileName, e);
                continue;
            }
        }
        BwcxrkData.getCheckDataList(qhdm).clear();
    }

    /**
     * 参数处理
     *
     * @param userName
     * @param qhdm
     * @param param
     * @param e
     * @param zsl
     * @param cgsl
     * @param sbsl
     * @param ip
     */

    public void prepareParam(String userName, String qhdm, Map param, Exception e, int zsl, int cgsl, int sbsl, String ip) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("用户名", userName);
        params.put("区划代码", qhdm);
        String startTime = (String) param.get("kssj");
        String endTime = (String) param.get("jssj");
        params.put("入库时间", startTime + "~" + endTime);
        params.put("总数量", zsl);
        params.put("成功数量", cgsl);
        params.put("失败数量", sbsl);
        String msg = StringUtils.isNotBlank(e.getMessage()) ? e.getMessage() : "无";
        params.put("异常信息", msg);
        insertLog(params, userName, ip);
    }


    /**
     * 删除业务相同报文
     *
     * @param fileName
     * @param fileMessage
     */
    @Async
    public void delBwxx(String fileName, FileMessage fileMessage) {
        String bdcdyh = fileMessage.getEstateNum();
        String content = cn.gtmap.realestate.supervise.server.utils.XmlUtil.getContent(fileMessage);
        List<Object> objectList = objectService.getObject(content, fileMessage.getRectype(), fileName, fileMessage.getAreaCode(), bdcdyh);
        checkRepeatService.serveDetail(objectList);
    }

    @Override
    @Transactional
    public boolean updateRkkjsjAndrkjssj(Babwcxrkxx babwcxrkxx, UserAuthDTO userInfos) {
        boolean flag;
        try {
            flag = bwcxrkMapper.updateRkkjsjAndrkjssj(babwcxrkxx) > 0;
        } catch (Exception e) {
            throw new AppException(e, 2001);
        }
        return flag;
    }

    @Override
    @Transactional
    public boolean updateRkzt(Babwcxrkxx babwcxrkxx, UserAuthDTO userInfos) {
        boolean flag;
        try {
            flag = bwcxrkMapper.updateRkzt(babwcxrkxx) > 0;
        } catch (Exception e) {
            throw new AppException(e, 2001);
        }
        return flag;
    }

    @Override
    public void insertLog(Map<String, Object> param, String userName, String ip) {
        String jsonString = JSON.toJSONString(param.toString());
        Log log = new Log();
        log.setCzlx("报文重新入库");
        log.setCznr("参数为:" + jsonString);
        log.setCzrq(new Date());
        log.setId(UUIDGenerator.generate18());
        log.setIp(ip);
        log.setYhmc(userName);
        logService.insertBalog(log);
    }


    /**
     * 入库失败报文手动入库
     *
     * @param fileNames
     * @param userInfos
     * @param request
     * @return
     */
    @Override
    public Map<String, String> bwsdrkHandle(String fileNames, UserAuthDTO userInfos, HttpServletRequest request) {
        String[] fileName = fileNames.split(",");
        String userName = userInfos.getUsername();
        String ip = request.getRemoteAddr();
        if (null != fileName && fileName.length > 0) {
            ServeLog serveLog = null;
            for (String fileNameStr : fileName) {
                if (StringUtils.isBlank(fileNameStr)) {
                    continue;
                }
                String[] fileNameInfos = fileNameStr.split("\\|");
                String tempFileName = fileNameInfos[0];
                String khdbm = getKhdbmByFileName(tempFileName);
                try {
                    String ywbwid = "";
                    if (fileNameInfos.length == 2) {
                        ywbwid = fileNameInfos[1];
                    }
                    String fileContent = searchService.mainGetData(tempFileName, "", "", ywbwid, "");
                    if (StringUtils.isNotBlank(fileContent)) {
                        Map<String, String> head = XmlUtil.getParamValueByElement(fileContent, "Head");
                        FileMessage fileMessage = new FileMessage();
                        String bizMsgId = head.get("BizMsgID");
                        fileMessage.setBizMsgId(bizMsgId);
                        fileMessage.setRectype(head.get("RecType"));
                        fileMessage.setEstateNum(head.get("EstateNum"));
                        fileMessage.setAreaCode(head.get("AreaCode"));
                        fileMessage.setContent(fileContent.getBytes("UTF-8"));
                        fileMessage.setRecFlowID(head.get("RecFlowID"));
                        fileMessage.setFileName(tempFileName);
                        DataInsertDbService dataInsertDbService = BeanUtils.getDataInsertDbService();
                        BaSlsq baSlsqList = dataInsertDbService.serviceCheck(fileMessage);//校验业务报文是否相同
                        if (null != baSlsqList) {
                            delBwxx(tempFileName, fileMessage);//根据业务报文内容删除数据
                        }
                        serveLog = serveFactory.serveDetail(fileMessage);
                        List errors = serveLog.getErrors();
                        String respFileName = tempFileName.replace("Biz", "Rep");
                        if (CollectionUtils.isEmpty(errors)) {//成功
                            delEsXybwxx(tempFileName, ywbwid);//删除ES数据
                            prepareCgXybwxx(bizMsgId, respFileName, ywbwid);//插入es响应报文
                            //更新 ba_rzjl 表状态，更新成功后报部处理
                            baRzjlMapper.updateRkzt(tempFileName);
                            String bz = "";
                            if (null != baSlsqList) {
                                bz = baSlsqList.getBz();
                            }
                            String tempQxdm = cn.gtmap.realestate.supervise.server.utils.XmlUtil.getExhangeQxdm(qxdm, bz);
                            dataInsertDbService.uploadSftpXml(fileMessage, khdbm, ywbwid, tempQxdm);//报部
                            insertBalog(tempFileName, ip, userName, "成功");
                        } else {
                            delEsXybwxx(tempFileName, ywbwid);//删除ES数据
                            if (null != errors && !errors.isEmpty()) {
                                String errorStr = (String) errors.get(0);
                                prepareSbXybwxx(respFileName, bizMsgId, errorStr, ywbwid);
                            }
                            insertBalog(tempFileName, ip, userName, serveLog.getErrors().toString());
                            serveLog.getErrors().clear();
                        }
                    }
                } catch (Exception e) {
                    if (null != serveLog) {
                        serveLog.getErrors().clear();
                    }
                    LOGGER.error("报文名称:{},报文手动入库异常:{}", tempFileName, e);
                    insertBalog(tempFileName, ip, userName, e.getMessage());
                    continue;
                }
            }
        }
        return Maps.newHashMap();
    }

    @Override
    public String getKhdbmByFileName(@Param("tempFileName") String tempFileName) {
        String listString;
        List<String> list = bwcxrkMapper.getKhdbmByFileName(tempFileName);
        if(list != null){
             listString = list.get(0);
        }else {
            listString = "";
        }
        return listString;
    }

    /**
     * 删除ES响应报文信息
     *
     * @param fileName
     */
    private void delEsXybwxx(String fileName, String ywbwid) {
        List<String> xybwIdList = searchService.getBwidByFileName(fileName.replace("Biz", "Rep"), "", ywbwid);//响应报文ID
        if (CollectionUtils.isNotEmpty(xybwIdList)) {
            String xybwid = xybwIdList.get(0);
            searchService.delData("Rep", xybwid);//删除es响应报文
        }
    }

    /**
     * 拼接成功响应报文
     *
     * @param bizMsgId
     * @param fileName
     */
    private void prepareCgXybwxx(String bizMsgId, String fileName, String ywbwid) {
        Respond responseMessage = new Respond();
        responseMessage.setSuccessFlag("1");
        responseMessage.setCertID("");
        responseMessage.setBizMsgID(bizMsgId);
        responseMessage.setAdditionalData("");
        responseMessage.setAdditionalData2("");
        responseMessage.setQRCode("");
        responseMessage.setResponseCode("0000");
        responseMessage.setResponseInfo("成功入库");
        String resInfo = JaxbUtil.convertToXml(responseMessage, "UTF-8");
        Map<String, Object> json = new HashMap<>();
        json.put("fileName", fileName);
        json.put("fileId", ywbwid);
        json.put("message", resInfo);
        json.put("respCode", "0000");
        searchService.mainCreateIndex(json, "");
    }

    /**
     * 拼接入库失败响应报文
     *
     * @param fileName
     * @param respInfo
     */
    private void prepareSbXybwxx(String fileName, String bizMsgId, String respInfo, String ywbwid) {
        Respond responseMessage = new Respond();
        responseMessage.setSuccessFlag("1");
        responseMessage.setCertID("");
        responseMessage.setBizMsgID(bizMsgId);
        responseMessage.setAdditionalData("");
        responseMessage.setAdditionalData2("");
        responseMessage.setQRCode("");
        responseMessage.setResponseCode("0001");
        responseMessage.setResponseInfo(respInfo);
        String resInfo = JaxbUtil.convertToXml(responseMessage, "UTF-8");
        Map<String, Object> json = new HashMap<>();
        json.put("fileName", fileName);
        json.put("message", resInfo);
        json.put("fileId", ywbwid);
        json.put("respCode", "0001");
        searchService.mainCreateIndex(json, "");
    }


    /**
     * 插入操作日志
     *
     * @param fileName
     * @param ip
     * @param userName
     * @param res
     */
    private void insertBalog(String fileName, String ip, String userName, String res) {
        Log log = new Log();
        log.setCzlx("报文手动入库");
        log.setCznr("报文手动入库" + "\n" + "参数为:" + fileName + "\n" + "入库结果:" + res);
        log.setCzrq(new Date());
        log.setId(UUIDGenerator.generate18());
        log.setIp(ip);
        log.setYhmc(userName);
        logService.insertBalog(log);
    }

}
