package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.common.impl.ObjectServiceImpl;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.model.SimpleTableResult;
import cn.gtmap.realestate.supervise.server.service.ServeLog;
import cn.gtmap.realestate.supervise.server.utils.XmlUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/18
 * @description 新增并注销业务
 */

@Service
public class AddCancelAbstractServe extends AbstractServeDetail {

    private static final Logger LOGGER = LoggerFactory.getLogger(AddCancelAbstractServe.class);

    @Autowired
    InsertAndCancelServiceImpl insertAndCancelService;

    @Autowired
    ObjectServiceImpl objectService;

    @Override
    public ServeLog serveDetail(FileMessage fileMessage) {
        SimpleTableResult result = new SimpleTableResult();
        try {
            init(fileMessage);
            //获取head里面注销上一手参数值 PreEstateNum：原不动产单元号  PreCertID：原不动产权证号
            Map paramPre = XmlUtil.getXMLValueMap(content, "PreEstateNum", "PreCertID");
            String ywh = areaCode + "_" + fileMessage.getRecFlowID();
            String cxrkbj = fileMessage.getCxrkbj();
            //qszt!=0 新增并注销
            result = insertAndCancelService.insertAndCancel(objects, recType, paramPre, bdcdyh, bizId, ywh, areaCode, cxrkbj);
        } catch (Exception e) {
            LOGGER.error("AddCancelAbstractServe.Exception in!{}", e);
            result.setResult(false);
            result.setResultInfo(e.getCause().toString());
            super.getServeLog().setError(e.getCause().toString());
            return super.getServeLog();
        }
        if(!result.isResult()){
            result.setResult(false);
            result.setResultInfo(result.getResultInfo());
            super.getServeLog().setError(result.getResultInfo());
            return super.getServeLog();
        }
        result.setResult(true);
        return new ServeLogImpl();
    }

    /**
     * 校验权属状态是否为0
     *
     * @param className
     * @return
     */
    private boolean checkQszt(String className) {
        boolean res = false;
        if (StringUtils.isNotBlank(className)) {
            for (int i = 0; i < objects.size(); i++) {
                Object tempObj = objects.get(i);
                String tempClassName = tempObj.getClass().getName();
                boolean flagRes = tempClassName.equalsIgnoreCase(Constant.ENTITY_PATH + className);
                if (flagRes) {
                    Field[] fields = tempObj.getClass().getDeclaredFields();
                    for (int j = 0; j < fields.length; j++) {
                        Field field = fields[j];
                        field.setAccessible(true); // 设置些属性是可以访问的
                        try {
                            if (field.getName().equalsIgnoreCase("qszt")) {
                                String qszt = (String) field.get(tempObj);
                                if (StringUtils.equals(qszt, "0")) {
                                    res = true;
                                }
                                break;
                            }
                        } catch (IllegalArgumentException e) {
                            LOGGER.error("AddCancelAbstractServe.IllegalArgumentException in!{}", e);
                        } catch (IllegalAccessException e) {
                            LOGGER.error("AddCancelAbstractServe.IllegalAccessException in!{}", e);
                        }
                    }
                    break;
                }
            }
        }
        return res;
    }
}
