package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.BaC;
import cn.gtmap.realestate.supervise.entity.BaLjz;
import cn.gtmap.realestate.supervise.entity.BaZdk103;
import cn.gtmap.realestate.supervise.entity.BaZrz;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.dao.impl.InsertSingleTableDaoImpl;
import cn.gtmap.realestate.supervise.server.dao.mapper.BwcxrkMapper;
import cn.gtmap.realestate.supervise.server.model.SimpleTableResult;
import cn.gtmap.realestate.supervise.server.service.ServeLog;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import cn.gtmap.realestate.supervise.server.utils.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/18
 * @description 添加服务
 */
@Service
public class AddAbstractServe extends AbstractServeDetail {

    private static final Logger LOGGER = LoggerFactory.getLogger(InsertSingleTableDaoImpl.class);


    @Autowired
    EntityMapper entityMapper;

    @Autowired
    InsertSingleTableDaoImpl insertSingleTableDao;

    @Autowired
    BwcxrkMapper bwcxrkMapper;

    @Override
    @Transactional
    public ServeLog serveDetail(FileMessage fileMessage) {

        SimpleTableResult result = new SimpleTableResult();
        try {
            init(fileMessage);
            String zddm = "";
            String bdcdyh = XmlUtil.getBdcdyh(content, "EstateNum");
            for (Object obj : objects) {
                if (obj instanceof BaZdk103) {
                    Map<String, Object> tempMap = new HashMap<>();
                    String xh = ((BaZdk103) obj).getXh();
                    String tempBdcdyh = ((BaZdk103) obj).getBdcdyh();
                    tempMap.put("bdcdyh", tempBdcdyh);
                    tempMap.put("xh", xh);
                    ExampleUtil example = new ExampleUtil(BaZdk103.class, tempMap);
                    List<BaZdk103> baZdk103List = entityMapper.selectByExample(example);
                    if (null != baZdk103List && !baZdk103List.isEmpty()) {
                        for (BaZdk103 baZdk103 : baZdk103List) {
//                            entityMapper.deleteByPrimaryKey(BaZdk103.class, baZdk103.getId());
                            bwcxrkMapper.delZdk103ById(baZdk103.getId());
                        }
                    }
                }

                if (obj instanceof BaZrz) {
                    zddm = ((BaZrz) obj).getZddm();
                    if (null != zddm && !zddm.isEmpty()) {
                        String zrzh = ((BaZrz) obj).getZrzh();
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaZrz) obj).setZrzbh(zrzbh);
                    } else {
                        String zrzh = ((BaZrz) obj).getZrzh();
                        zddm = bdcdyh.substring(0, 19);
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaZrz) obj).setZrzbh(zrzbh);
                    }

                }

                if (obj instanceof BaLjz) {

                    if (null != zddm && !zddm.isEmpty()) {
                        String zrzh = ((BaLjz) obj).getZrzh();
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaLjz) obj).setZrzbh(zrzbh);
                    } else {
                        String zrzh = ((BaLjz) obj).getZrzh();
                        zddm = bdcdyh.substring(0, 19);
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaLjz) obj).setZrzbh(zrzbh);
                    }
                }

                if (obj instanceof BaC) {
                    if (null != zddm && !zddm.isEmpty()) {
                        String zrzh = ((BaC) obj).getZrzh();
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaC) obj).setZrzbh(zrzbh);
                    } else {
                        String zrzh = ((BaC) obj).getZrzh();
                        zddm = bdcdyh.substring(0, 19);
                        String zrzbh = zddm + "_" + zrzh;
                        ((BaC) obj).setZrzbh(zrzbh);
                    }
                }
            }
            result = insertSingleTableDao.insertSingleTable(objects);
        } catch (Exception e) {
            LOGGER.error("AddAbstractServe.Exception error:{}",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            result.setResult(false);
            result.setResultInfo(e.getCause().toString());
            super.getServeLog().setError(e.getCause().toString());
            return super.getServeLog();
        }
        result.setResult(true);
        return new ServeLogImpl();
    }
}
