package cn.gtmap.realestate.supervise.server.service.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.common.ObjectService;
import cn.gtmap.realestate.supervise.server.service.Serve;
import cn.gtmap.realestate.supervise.server.service.ServeLog;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.util.List;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/4/13
 * @description 这个是服务端具体业务处理的抽象类
 */
@Service
public abstract class AbstractServeDetail implements Serve {

    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServeDetail.class);

    public String content;

    public List<Object> objects;

    String recType;

    String bdcdyh;

    String areaCode;

    String bizId;

    /**
     * xml装换为bean的工具
     */
    @Autowired
    private ObjectService objectService;

    /**
     * 记录我们插入数据出现的异常情况
     */
    @Autowired
    private ServeLog serveLog;

    public ServeLog getServeLog() {

        return serveLog;
    }


    /**
     * fileMessage 转换成String
     *
     * @param fileMessage
     * @return
     */
    public String getContent(FileMessage fileMessage) {

        String contentStr = null;
        try {
            contentStr = new String(fileMessage.getContent(), "UTF-8");
        } catch (UnsupportedEncodingException e) {
            serveLog.setError("解析文件错误可能是消息队列问题或是客户端发送文件出现失误！");
            LOGGER.error("AbstractServeDetail.getContent UnsupportedEncodingException in !{}", e.getMessage());
            throw new AppException(e, 2002);
        }
        return contentStr;
    }

    /**
     * String 转换成List
     *
     * @param content
     * @return
     */
    public List<Object> getList(String content, String recType, String fileName, String areaCode, String bdcdyh) {

        //将String装换为对象
        List<Object> objs = objectService.getObject(content, recType, fileName, areaCode, bdcdyh);
        return objs;
    }

    /**
     * @param fileMessage
     * @throws DocumentException
     */
    public void init(FileMessage fileMessage) {
        recType = fileMessage.getRectype();
        bdcdyh = fileMessage.getEstateNum();
        content = getContent(fileMessage);
        areaCode = fileMessage.getAreaCode();
        bizId = fileMessage.getBizMsgId();
        if (recType != null && content != null) {
            objects = getList(content, recType, fileMessage.getFileName(), areaCode, bdcdyh);
        }
    }


}
