package cn.gtmap.realestate.supervise.server.service;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/5/26
 * @description 行政区号字段表查询
 */
public interface XzqhInfoService {

    public List<Map<String, String>> getXzqhDatas(Map<String, String> map);

    /**
     * 获取地图行政区位置
     *
     * @param param
     * @return
     */
    public List<Map<String, Object>> getGeocoord(Map<String, Object> param);


    /**
     * 汇总统计信息
     *
     * @return
     */
    public List<Map<String, Object>> getHztjxx(String qhmc);

    /**
     * 数据同步
     *
     * @param param
     * @return
     */
    public boolean dataSynchronization(Map<String, Object> param);


    /**
     * 根据父代码查询区县信息
     *
     * @param fdm
     * @return
     */
    public List<Map<String, Object>> getQxxxByFdm(String fdm);


    /**
     * 获取坐标
     *
     * @param param
     * @return
     */
    public List<Map<String, Object>> getCityInfos(Map param);

    /**
     * 获取接入点名称
     *
     * @return
     */
    List<Map<String, String>> getJrdxx();

    /**
     * 上报概况
     *
     * @return
     */
    Map<String, Object> getSbqkData(String qhmc);


    /**
     * 系统首页获取上报变化趋势
     *
     * @return
     */
    List<Map<String, Object>> getJrqkList(String qhmc, String dateTime);


    /**
     * 根据qhdm获取接入点状态
     *
     * @param qhdm
     * @return
     */
    List<Map<String, String>> getJrdxxByQhdm(String qhdm);

    /**
     * 根据qhdm获取接入点关联区县信息
     *
     * @param qhdm
     * @return
     */
    List<Map<String, String>> getJrdQxxxByQhdm(String qhdm);


    /**
     * 获取xt_region所有数据
     *
     * @return
     */
    List<Map<String, String>> getXtregion();

    /**
     * 上报数据websocket推送
     * @return
     */
    List<Map<String, Object>> getSbData();


    /**
     * 陕西首页数据
     * @return
     */

   Map<String, Object> getIndexSx(String QHJB,String ParamQhdm);

}
