package cn.gtmap.realestate.supervise.server.service;

import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.dao.mapper.BwcxrkMapper;
import cn.gtmap.realestate.supervise.server.entity.Rzjl;
import cn.gtmap.realestate.supervise.server.model.BwcxrkData;
import cn.gtmap.realestate.supervise.server.service.impl.BwcxrkServiceImpl;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/7/2.
 */
public class ThreadDelDataService implements Runnable {

    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadDelDataService.class);

    private BwcxrkServiceImpl bwcxrkService;

    private BwcxrkMapper bwcxrkMapper;
    private String qhdm;

    public ThreadDelDataService(BwcxrkServiceImpl bwcxrkService,BwcxrkMapper bwcxrkMapper, String qhdmStr) {
        this.bwcxrkService = bwcxrkService;
        this.bwcxrkMapper = bwcxrkMapper;
        this.qhdm = qhdmStr;
    }

    @Override
    public void run() {
        int i = 0;
        while (!Thread.currentThread().isInterrupted()) {
            FileMessage fileMessage = BwcxrkData.getDelData(qhdm);
            //删除标记：1:需要删除
            if (null != fileMessage) {
                i++;
                String scbj = fileMessage.getScbj();
                if (StringUtils.isNotBlank(scbj) && StringUtils.equals("1", scbj)) {
                    try {
                        String fileName = fileMessage.getFileName();
                        long startTime = System.currentTimeMillis();
                        LOGGER.info("开始删除第{}个报文:报文名称:{}", i, fileName);
                        bwcxrkService.delBwxx(fileName, fileMessage);
                        long endTime = System.currentTimeMillis();
                        BwcxrkData.setAllDataList(qhdm, fileMessage);
                        BwcxrkData.removeTempData(qhdm);
                        LOGGER.info("结束删除报文:报文名称:{},时间:{}", fileName, (endTime - startTime));
                    } catch (Exception e) {
                        LOGGER.error("报文重新入库删除数据异常！{}", e);
                        BwcxrkData.setExceptionDataMap(qhdm,fileMessage);
                        Map<String, Object> resMap = Maps.newHashMap();
                        resMap.put("qhdm", qhdm);
                        resMap.put("rkzt", "3");
                        //更新ba_bwcxrkxx 表相关数据
                        bwcxrkMapper.updateBwcxrkByQhdm(resMap);
                        Thread.currentThread().interrupt();
                    }
                }else{
                    BwcxrkData.setAllDataList(qhdm, fileMessage);
                    BwcxrkData.removeTempData(qhdm);
                }
            }
            List<Rzjl> rzjlList = BwcxrkData.getCheckDataList(qhdm);
            List<FileMessage> allDataList = BwcxrkData.getAllDataList(qhdm);
            List<FileMessage> delDataList = BwcxrkData.getDelDataList(qhdm);
            List<FileMessage> delTempDataList = BwcxrkData.getDelTempDataList(qhdm);
            if (CollectionUtils.isEmpty(delTempDataList) && CollectionUtils.isEmpty(rzjlList) && CollectionUtils.isEmpty(allDataList) && CollectionUtils.isEmpty(delDataList)) {
                Thread.currentThread().interrupt();
                LOGGER.info("删除任务线程结束--");
            }
        }
    }
}
