package cn.gtmap.realestate.supervise.server.service;

import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.dao.mapper.BwcxrkMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BwcxrkrzMapper;
import cn.gtmap.realestate.supervise.server.entity.Rzjl;
import cn.gtmap.realestate.supervise.server.model.BwcxrkData;
import cn.gtmap.realestate.supervise.server.service.impl.BwcxrkServiceImpl;
import cn.gtmap.realestate.supervise.server.service.impl.ServeFactory;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/7/2.
 */

public class ThreadDataHandleService implements Runnable {

    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadDataHandleService.class);


    private String userName;

    private String qhdm;

    private ServeFactory serveFactory;

    private BwcxrkrzMapper bwcxrkrzMapper;

    private BwcxrkMapper bwcxrkMapper;

    private BwcxrkServiceImpl bwcxrkService;

    private String ip;

    private Map<String, Object> param;

    public ThreadDataHandleService(String userName, String qhdm, ServeFactory serveFactory, BwcxrkrzMapper bwcxrkrzMapper
            , BwcxrkMapper bwcxrkMapper, BwcxrkServiceImpl bwcxrkServiceImpl, String ipStr, Map<String, Object> params) {
        this.userName = userName;
        this.qhdm = qhdm;
        this.serveFactory = serveFactory;
        this.bwcxrkrzMapper = bwcxrkrzMapper;
        this.bwcxrkMapper = bwcxrkMapper;
        this.bwcxrkService = bwcxrkServiceImpl;
        this.ip = ipStr;
        this.param = params;
    }


    @Override
    public void run() {
        int zsl = BwcxrkData.getCheckDataList(qhdm).size();
        int cgsl = 0;
        int temp = 0;
        while (!Thread.currentThread().isInterrupted()) {
            FileMessage fileMessage = BwcxrkData.getAllDataOne(qhdm);
            if (null != fileMessage) {
                String fileName = fileMessage.getFileName();
                temp++;
                Map<String, Object> paramMap = Maps.newHashMap();
                try {
                    paramMap.put("id", UUIDGenerator.generate18());
                    long startTime = System.currentTimeMillis();
                    LOGGER.info("开始入库报文,第{}个报文名称:{}", temp, fileName);
                    ServeLog serveLog = serveFactory.serveDetail(fileMessage);
                    long endTime = System.currentTimeMillis();
                    List<String> listLogs = serveLog.getErrors();
                    //失败
                    if (null != listLogs && !listLogs.isEmpty()) {
                        paramMap.put("rkjg", 0);
                        paramMap.put("sbyy", listLogs.get(0));
                        serveLog.getErrors().clear();
                    } else {//成功
                        paramMap.put("rkjg", 1);
                        paramMap.put("sbyy", "");
                        cgsl++;
                    }
                    paramMap.put("czyhmc", userName);
                    paramMap.put("bwmc", fileName);
                    paramMap.put("rksj", new Date());
                    paramMap.put("qhdm", qhdm);
                    // 记录报文重新入库日志
                    bwcxrkrzMapper.insertBwcxrkrz(paramMap);
                    LOGGER.info("结束入库报文,第{}个报文名称:{},时间:{}", temp, fileName, (endTime - startTime));
                } catch (Exception e) {
                    paramMap.put("sbyy", e.getMessage());
                    paramMap.put("rkjg", 0);
                    paramMap.put("czyhmc", userName);
                    paramMap.put("bwmc", fileName);
                    paramMap.put("rksj", new Date());
                    paramMap.put("qhdm", qhdm);
                    // 记录报文重新入库日志
                    bwcxrkrzMapper.insertBwcxrkrz(paramMap);
                    LOGGER.error("报文重新入库异常:{}", e);
                }
            }

            List<Rzjl> rzjlList = BwcxrkData.getCheckDataList(qhdm);
            List<FileMessage> allDataList = BwcxrkData.getAllDataList(qhdm);
            List<FileMessage> delDataList = BwcxrkData.getDelDataList(qhdm);
            List<FileMessage> delTempDataList = BwcxrkData.getDelTempDataList(qhdm);
            List<FileMessage> exceptionDataList = BwcxrkData.getExceptionDataList(qhdm);
            if (CollectionUtils.isNotEmpty(exceptionDataList)) {
                BwcxrkData.removeAllExceptionDataMap(qhdm);
                Thread.currentThread().interrupt();
            }
            if (CollectionUtils.isEmpty(delTempDataList) && CollectionUtils.isEmpty(rzjlList) && CollectionUtils.isEmpty(allDataList) && CollectionUtils.isEmpty(delDataList)) {
                Map<String, Object> resMap = Maps.newHashMap();
                resMap.put("cgsl", cgsl);
                resMap.put("sbsl", String.valueOf(zsl - cgsl));
                resMap.put("zsl", zsl);
                resMap.put("qhdm", qhdm);
                resMap.put("rkzt", "2");
                //更新ba_bwcxrkxx 表相关数据
                bwcxrkMapper.updateBwcxrkByQhdm(resMap);
                bwcxrkService.prepareParam(userName, qhdm, param, new Exception(), zsl, cgsl, zsl - cgsl, ip);
                Thread.currentThread().interrupt();
                LOGGER.info("入库任务线程结束");
                LOGGER.info("区划代码:{},报文重新入库数据处理结束,总数量：{},成功数量：{},失败数量：{}", qhdm, zsl, cgsl, zsl - cgsl);
            }
        }
    }
}
