package cn.gtmap.realestate.supervise.server.service;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/13
 * @description 监控统计 业务逻辑层接口
 */
public interface MonitorService {

    /**
     * 接入数量统计
     *
     * @param map
     * @return
     */
    public List<Map<String, String>> getJrslData(Map<String, String> map);

    /**
     * 接入情况监控
     *
     * @param map
     * @return
     */
    public List<Map<String, String>> getJrqkData(Map<String, String> map);

    /**
     * 接入数量统计，提供外围调用
     *
     * @param map
     * @return
     */
    public List<LinkedHashMap<String, String>> getJrsl(Map<String, String> map);


    /**
     * 上报数量统计
     *
     * @param map
     * @return
     */
    public List<Map<String, String>> getSbslData(Map<String, String> map);

    /**
     * 上报情况监控
     *
     * @param map
     * @return
     */
    public List<Map<String, String>> getSbqkData(Map<String, String> map);


    /**
     * 区县接入监控信息同步
     *
     * @param param
     * @return
     */
    public boolean synQxjrjkxx(Map<String, Object> param,String fileName);

    /**
     * 区县上报监控信息同步
     *
     * @param param
     * @return
     */
    public boolean synQxsbjkxx(Map<String, Object> param,String fileName);

    /**
     * 根据父代码查询对应区县信息
     *
     * @param param
     * @return
     */
    public List<Map<String, String>> getQxxxByFdm(Map<String, String> param);


    /**
     * 根据父代码查询对应区县上报数量
     *
     * @param param
     * @return
     */
    public List<Map<String, String>> getQxSbslByFdm(Map<String, String> param);

    /**
     * 接入上报数量统计
     *
     * @param param
     * @return
     */
    public List<Map<String, String>> getJrsbslData(Map<String, String> param);

    /**
     * 查询区县接入上报数量
     * @param param
     * @return
     */
    public List<Map<String, String>> getJrsbslByFdm(Map<String, String> param);

    /**
     * 接入上报情况监控
     * @param map
     * @return
     */
    public List<Map<String, String>> getJrsbqkData(Map<String, String> map);
}
