package cn.gtmap.realestate.supervise.server.service;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.entity.Log;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/10
 * @description 日志操作接口
 */
public interface LogService {

    /**
     * 获取业务编码和名称
     *
     * @return
     */
    List<Map<String, String>> getYwbmInfos();

    /**
     * 查询行政区划信息
     *
     * @return
     */
    List<Map<String, String>> queryXzqhInfos();

    /**
     *报文查询
     * @param param
     * @return
     */
    //    List<Map<String,String>> getBwInfos(Map<String,Object> param);

    /**
     * 中心日志表
     *
     * @param log
     */
    void insertBalog(Log log);


    /**
     * 查看操作内容
     *
     * @param id
     * @return
     */
    public Map<String, String> queryCznrInfos(String id);

    /**
     * 上报报文查询
     *
     * @param param
     * @return
     */

//    List<Map<String, String>> getSbBwInfos(Map<String, Object> param);

    /**
     * 删除上报失败报文、不删除数据、修改状态
     * @param param
     * @param userAuthDTO
     */
    public void delBwInfos(Map<String, String> param, UserAuthDTO userAuthDTO);

    /**
     * 操作类型字典表查询
     *
     * @return
     */
    public List<Map<String, String>> queryCzlx();
}