package cn.gtmap.realestate.supervise.server.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0 2019-7-19
 * @auther <a href="mailto:xutao@gtmap.cn">xutao</a>
 * @description
 */
public interface KxlService {

    /**
     * 获取市级和县级建设用地使用权空项信息
     * @param param
     * @return
     */
    List<Map<String, Object>> listCityAndCountyJsydsyq(Map<String, Object> param);

    /**
     * 获取市级和县级房屋使用权空项信息
     * @param param
     * @return
     */
    List<Map<String, Object>> listCityAndCountyFwsyq(Map<String, Object> param);

    /**
     * 获取市级和县级查封空项信息
     * @param param
     * @return
     */
    List<Map<String, Object>> listCityAndCountyCf(Map<String, Object> param);

    /**
     * 获取市级和县级抵押空项信息
     * @param param
     * @return
     */
    List<Map<String, Object>> listCityAndCountyDy(Map<String, Object> param);

    /**
     * 获取市级和县级预告空项信息
     * @param param
     * @return
     */
    List<Map<String, Object>> listCityAndCountyYg(Map<String, Object> param);

    /**
     * 获取市级和县级空项率信息
     * @param param
     * @return
     */
    List<Map<String, Object>> listCityAndCountyData(Map<String, Object> param, boolean isXhAll);

    /**
     * 获取市级和县级空项率信息
     * @param param
     * @return
     */
    List<Map<String, Object>> listCityAndCountyDataFinal(Map<String, Object> param, boolean isXhAll);

    /**
     * 保存统计数据
     * @param param
     */
    void saveCityAndCountyData(Map<String, Object> param);

    /**
     * 行政区划
     * @param qhdm
     * @return
     */
    List<Map<String, Object>> listXzqh(String qhdm);

    /**
     * 导出 excel
     * @param param
     * @param response
     */
    void exportExcelKxl(Map<String, Object> param, HttpServletResponse response, HttpServletRequest request);

    /**
     * 导出 excel 子表
     * @param param
     * @param response
     */
    void exportExcelKxlAll(Map<String, Object> param, HttpServletResponse response, HttpServletRequest request);

    /**
     * 导出 excel (江苏)
     * @param param
     * @param response
     */
    void exportExcelDbzlJS(Map<String, Object> param, HttpServletResponse response, HttpServletRequest request);

    /**
     * 导出 excel (陕西)
     * @param param
     * @param response
     */
    void exportExcelDbzlSX(Map<String, Object> param,Map<String, Object> sqparam, HttpServletResponse response, HttpServletRequest request);


    /**
     * 获取上一次结束时间
     * @return
     */
    String getlastJssj();

    /**
     * 保存操作记录
     * @return
     */
    void saveDataCz(Map<String, Object> param);

}
