package cn.gtmap.realestate.supervise.server.service;

import cn.gtmap.realestate.supervise.server.entity.Pjdfqk;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 接入登簿质量评价
 * @author szh
 */
public interface JrdbzlpjService {
    /**
     * 获取接入质量评价数据
     * @param map
     * @return
     */
    List<Map<String, String>> getJrzlpjData(Map<String, String> map);

    /**
     * 导出接入质量评价数据
     * @param response
     * @param map
     */
    void exportJrpjzlDataSX(HttpServletResponse response, HttpServletRequest request, Map<String, String> map,Map<String, String> sqmap);


    void exportJrpjzlData(HttpServletResponse response, HttpServletRequest request, Map<String, String> map);

    Map<String, String> getRegion(String qhdm);

    /**
     * 保存统计数据
     * @param kssj 开始时间
     * @param jssj 结束时间
     */
    void saveCountData(String kssj, String jssj);

    /**
     * 获取大市
     * @param qhdm
     * @return
     */
    List<Map<String, String>> getCity(String qhdm);

    /**
     * 更新操作时间
     * @param kssj
     * @param jssj
     */
    void updateTjczrz(String kssj, String jssj);

    /**
     * 导出明细
     * @param map
     */
    void exportDetail(HttpServletRequest request, HttpServletResponse response, Map<String, String> map);

    /**
     * 接入稳定性
     * @param map
     * @return
     */
    Map<String,Object> jrwdxData(Map<String, String> map);

    /**
     * 接入成功率
     * @param map
     * @return
     */
    Map<String,Object> getJrcgl(Map<String, String> map);

    /**
     * 上报成功率
     * @param map
     * @return
     */
    Map<String,Object> getSbcgl(Map<String, String> map);

    /**
     * 接入及时性情况
     * @param kssj
     * @param jssj
     * @return
     */
    List<Pjdfqk>  getJrjsxqk(String kssj,String jssj);

    /**
     * 接入空项率情况
     * @param kssj
     * @param jssj
     * @return
     */
    List<Pjdfqk>  getJrkxlqk(String kssj,String jssj);

}
