package cn.gtmap.realestate.supervise.server.service;


import cn.gtmap.onemap.service.GeoService;
import cn.gtmap.realestate.supervise.server.dao.CheckGraphicByBdcdyh;
import cn.gtmap.realestate.supervise.server.dao.InsertGraphicInfo;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaBdcdyhInfos;
import cn.gtmap.realestate.supervise.server.entity.GraphicInfo;
import cn.gtmap.realestate.supervise.server.model.GraphicData;
import cn.gtmap.realestate.supervise.server.service.impl.LogServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2018/7/8
 * @description 宗海上图业务逻辑处理线程
 */
public class GraphicZhThreadService implements Runnable {

    private static final Logger LOGGER = LoggerFactory.getLogger(GraphicZhThreadService.class);

    private BaBdcdyhInfos baBdcdyhInfos;

    private GeoService geoService;

    private InsertGraphicInfo insertGraphicInfo;

    private LogServiceImpl logService;

    private CheckGraphicByBdcdyh checkGraphicByBdcdyh;


    public GraphicZhThreadService(BaBdcdyhInfos baBdcdyhInfos, GeoService geoService, InsertGraphicInfo insertGraphicInfo,
                                  LogServiceImpl logService, CheckGraphicByBdcdyh checkGraphicByBdcdyh) {
        this.baBdcdyhInfos = baBdcdyhInfos;
        this.geoService = geoService;
        this.insertGraphicInfo = insertGraphicInfo;
        this.logService = logService;
        this.checkGraphicByBdcdyh = checkGraphicByBdcdyh;
    }

    @Override
    public void run() {

        while (!Thread.currentThread().isInterrupted()) {
            Map<String, String> temp = GraphicData.getZhGraphic();
            String key = "";
            for (Map.Entry entry : temp.entrySet()) {
                key = (String) entry.getKey();
            }
            if (StringUtils.isNotBlank(key)) {
                try {
                    boolean res = geoService.delete("zhjbxx", "bdcdyh = '" + key + "'", null);
                    String message = geoService.insert("zhjbxx", temp.get(key), false, null);
                    LOGGER.info("删除bdcdy:{} zhjbxx ,成功?:{}", key, res);
                    if (key.equals(message)) {
                        message = "成功！";
                    }
                    //更新上图标记 1
                    baBdcdyhInfos.updateZhstbj(key);
                    LOGGER.info(message);
                    GraphicInfo info = new GraphicInfo();
                    info.setId(key);
                    info.setBdcdyh(key);
                    info.setSuccess("true");
                    info.setMessage(message);
                    info.setId(key);
                    insertGraphicInfo.insertGraphicInfo(info);
                } catch (Exception e) {
                    LOGGER.error("--insertIntoData.Exception in ---bdcdyh:{},异常信息:{}", key, e);
                    GraphicInfo info = new GraphicInfo();
                    info.setId(key);
                    info.setBdcdyh(key);
                    info.setSuccess("false");
                    info.setMessage(e.getMessage());
                    info.setId(key);
                    insertGraphicInfo.insertGraphicInfo(info);
                    baBdcdyhInfos.updateBaZhk105Info(key);//上图失败、更新标记为2
                    logService.insertStsbLog(key, e.getMessage());
                    checkGraphicByBdcdyh.delCheckGraphicInfo(key);//删除记录
                    LOGGER.error("--insertIntoData.Exception out ---bdcdyh:{},异常信息:{}", key, e.toString());
                }

            }

            List<String> zhList = GraphicData.getZhList();
            List<Map<String, String>> zhzbList = GraphicData.getZhzbList();
            if (CollectionUtils.isEmpty(zhList) && CollectionUtils.isEmpty(zhzbList)) {
                Thread.currentThread().interrupt();
                LOGGER.info("宗海上图子任务结束");
            }
        }
    }
}
