package cn.gtmap.realestate.supervise.server.service;

import cn.gtmap.onemap.service.GeoService;
import cn.gtmap.realestate.supervise.server.dao.CheckGraphicByBdcdyh;
import cn.gtmap.realestate.supervise.server.dao.InsertGraphicInfo;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaBdcdyhInfos;
import cn.gtmap.realestate.supervise.server.entity.GraphicInfo;
import cn.gtmap.realestate.supervise.server.model.GraphicData;
import cn.gtmap.realestate.supervise.server.service.impl.LogServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2018/7/8
 * @description 宗地上图业务逻辑处理线程
 */
public class GraphicZdThreadService implements Runnable {

    private static final Logger LOGGER = LoggerFactory.getLogger(GraphicZdThreadService.class);

    private BaBdcdyhInfos baBdcdyhInfos;

    private GeoService geoService;

    private InsertGraphicInfo insertGraphicInfo;

    private LogServiceImpl logService;

    private CheckGraphicByBdcdyh checkGraphicByBdcdyh;

    public GraphicZdThreadService(GeoService geoService, BaBdcdyhInfos baBdcdyhInfo, InsertGraphicInfo insertGraphicInfo,
                                  LogServiceImpl logService, CheckGraphicByBdcdyh checkGraphicByBdcdyh) {
        this.baBdcdyhInfos = baBdcdyhInfo;
        this.geoService = geoService;
        this.insertGraphicInfo = insertGraphicInfo;
        this.logService = logService;
        this.checkGraphicByBdcdyh = checkGraphicByBdcdyh;
    }

    @Override
    public void run() {

        while (!Thread.currentThread().isInterrupted()) {
            Map<String, String> zdzbStr = GraphicData.getZdGraphic();
            String key = "";
            for (Map.Entry entry : zdzbStr.entrySet()) {
                key = (String) entry.getKey();
            }
            if (StringUtils.isNotBlank(key)) {
                try {
                    boolean res = geoService.delete("zdjbxx", "bdcdyh = '" + key + "'", null);
                    String message = geoService.insert("zdjbxx", zdzbStr.get(key), false, null);
                    LOGGER.info("删除bdcdy:{} zdjbxx ,成功?:{}", key, res);
                    if (zdzbStr.get(key).equals(message)) {
                        message = "成功！";
                    }
                    //更新上图标记 1
                    baBdcdyhInfos.updateZdstbj(key);
                    LOGGER.info(message);
                    GraphicInfo info = new GraphicInfo();
                    info.setId(key);
                    info.setBdcdyh(key);
                    info.setSuccess("true");
                    info.setMessage(message);
                    info.setId(key);
                    insertGraphicInfo.insertGraphicInfo(info);

                } catch (Exception e) {
                    LOGGER.error("--insertIntoData.Exception in ---bdcdyh:{},异常信息:{}", key, e);
                    GraphicInfo info = new GraphicInfo();
                    info.setId(key);
                    info.setBdcdyh(key);
                    info.setSuccess("false");
                    info.setMessage(e.getMessage());
                    info.setId(key);
                    insertGraphicInfo.insertGraphicInfo(info);
                    baBdcdyhInfos.updateBaZdk103Info(key);//上图失败、更新标记为2
                    logService.insertStsbLog(key, e.getMessage());
                    checkGraphicByBdcdyh.delCheckGraphicInfo(key);//删除记录
                    LOGGER.error("--insertIntoData.Exception out ---bdcdyh:{},异常信息:{}", key, e.toString());
                }
            }

            List<String> zdList = GraphicData.getZdList();
            List<Map<String, String>> zdzbList = GraphicData.getZdzbList();
            if (CollectionUtils.isEmpty(zdList) && CollectionUtils.isEmpty(zdzbList)) {
                Thread.currentThread().interrupt();//中断线程
                LOGGER.info("宗地上图子任务结束");
            }
        }
    }
}

