package cn.gtmap.realestate.supervise.server.rocketmq;

import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.alibaba.rocketmq.client.producer.SendCallback;
import com.alibaba.rocketmq.client.producer.SendResult;
import com.alibaba.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2018/9/5
 * @description 服务端发送消息
 */
@Component
@Profile(value = "rocketMQ")
public class ProducerMsg implements ApplicationContextAware {

    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerMsg.class);

    private DefaultMQProducer producer;

    //组名称
    @Value("${supervise.server.rocketmq.clientGroupName}")
    private String groupName;

    //mq地址
    @Value("${supervise.server.rocketmq.ip}")
    private String ipAddress;

    @Value("${supervise.server.rocketmq.topciClient}")
    private String clientTopic;

    //上下文变量
    private ApplicationContext applicationContext;

    /**
     * 初始化
     *
     * @return
     */
    @PostConstruct
    private void init() {
        try {
            //实例化一个生产者组名称。
            producer = new DefaultMQProducer(groupName);
            producer.setNamesrvAddr(ipAddress);
            // 设置重试次数,默认2
//            producer.setRetryTimesWhenSendFailed(3);
            //设置发送超时时间，默认是3000
//            producer.setSendMsgTimeout(6000);

            producer.start();
            LOGGER.info("初始化mq成功：生产者组名称：{}，mq地址：{}", groupName, ipAddress);
        } catch (MQClientException e) {
            LOGGER.error("初始化mq异常：{}", e);
        }
    }

    /**
     * 向客户端发送消息
     *
     * @param msgContent
     * @param consumerTopic
     */
    public void sendMsg(String msgContent, String consumerTopic, String RepFileName) {
        try {
            Message msg = new Message(clientTopic, consumerTopic, msgContent.getBytes("UTF-8"));
            msg.setKeys(RepFileName);
            producer.send(msg, new SendCallback() {
                @Override
                public void onSuccess(SendResult sendResult) {
                    LOGGER.info("发送响应消息成功!");
                }

                @Override
                public void onException(Throwable e) {
                    LOGGER.info("发送消息异常!{}", e);
                }
            });
        } catch (Exception e) {
            LOGGER.error("客户端发送消息异常！异常信息:{}", e);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return applicationContext;
    }
}
