package cn.gtmap.realestate.supervise.server.rocketmq;

import cn.gtmap.realestate.supervise.aes.AESUtil;
import cn.gtmap.realestate.supervise.model.MessageClient;
import cn.gtmap.realestate.supervise.server.common.impl.DataInsertDbService;
import cn.gtmap.realestate.supervise.server.service.HeartbeatService;
import cn.gtmap.realestate.supervise.server.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.rocketmq.client.consumer.DefaultMQPushConsumer;
import com.alibaba.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import com.alibaba.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import com.alibaba.rocketmq.client.consumer.listener.MessageListenerOrderly;
import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.common.consumer.ConsumeFromWhere;
import com.alibaba.rocketmq.common.message.MessageExt;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2018/9/5
 * @description 服务端消费消息
 */
@Component
@Profile(value = "rocketMQ")
public class ConsumerMsg implements ApplicationListener<ApplicationEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerMsg.class);

    private DefaultMQPushConsumer consumer;

    //组名称
    @Value("${supervise.server.rocketmq.serverGroupName}")
    String groupName;

    //mq地址
    @Value("${supervise.server.rocketmq.ip}")
    String ipAddress;

    @Value("${supervise.server.rocketmq.topicServer}")
    String topicName;

    @Autowired
    AESUtil aesUtil;

    MessageClient dataMessage = null;

    @Autowired
    HeartbeatService heartbeatService;

    private boolean flag = false;

    @PostConstruct
    public void init() {
        try {

            consumer = new DefaultMQPushConsumer(groupName);

            consumer.setNamesrvAddr(ipAddress);

            // 批量消费,每次拉取10条
//            consumer.setConsumeMessageBatchMaxSize(10);

            // 程序第一次启动从消息队列头取数据
            // 如果非第一次启动，那么按照上次消费的位置继续消费
            consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);

            consumer.subscribe(topicName, "*");


        } catch (Exception e) {
            LOGGER.error("初始化客户端消费者服务异常！{}", e);
        }
    }

    /**
     * 注册消息监听
     */
    public void registerMessageListener() {

        consumer.registerMessageListener(
                new MessageListenerOrderly() {
                    @Override
                    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {

                        synchronized (this) {
                            if (CollectionUtils.isNotEmpty(msgs)) {
                                MessageExt messageExt = msgs.get(0);
                                String filename = "";
                                try {
                                    String tempMessage = aesUtil.decryptXML(new String(messageExt.getBody(), "UTF-8"));
                                    if (StringUtils.isNotBlank(tempMessage)) {
                                        dataMessage = JSON.parseObject(tempMessage, MessageClient.class);
                                        if (CollectionUtils.isNotEmpty(dataMessage.getMessageContents())) {
                                            filename = dataMessage.getFileMessages().get(0).getFileName();
                                            LOGGER.info("服务端收到消息:{}", filename);
                                            DataInsertDbService dataInsertDbService = BeanUtils.getDataInsertDbService();
                                            dataInsertDbService.setMessageClient(dataMessage);
                                            dataInsertDbService.dataHandle();//数据校验
                                            dataInsertDbService.serviceHandle();
                                        } else {
                                            //心跳检查消息处理
                                            Map<String, Object> param = Maps.newHashMap();
                                            param.put("khdbm", dataMessage.getForm());
                                            heartbeatService.updateBaJrdStatus(param);
                                        }
                                    }
                                } catch (Exception e) {
                                    LOGGER.error("服务端程序验证模块出现严重错误请查证!{},filename:{}", e, filename);
                                    if(e instanceof NoNodeAvailableException || e instanceof MyBatisSystemException || e instanceof RecoverableDataAccessException) {
                                        return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                                    }
                                }
                            }
                            return ConsumeOrderlyStatus.SUCCESS;
                        }

                    }
                }
        );
    }


    /**
     * 服务启动完成后开始消费报文
     *
     * @param event
     */
    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent && !flag) {
            flag = true;
            registerMessageListener();//注册监听
            try {
                consumer.start();
            } catch (MQClientException e) {
                LOGGER.error("中心端MQ消费者启动异常！{}", e);
            }
        }
    }
}
