package cn.gtmap.realestate.supervise.server.rabbitmq;

import com.gtis.config.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import java.util.UUID;


/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/3/23
 * @description 消息发送注入
 */

/**
 * 消息生产者
 *
 * @author liaokailin
 * @version $Id: Send.java, v 0.1 2015年11月01日 下午4:22:25 liaokailin Exp $
 */
@Component
@Profile(value = "rabbitMQ")
public class SendMessage implements RabbitTemplate.ConfirmCallback {

    private static final Logger LOGGER = LoggerFactory.getLogger(SendMessage.class);


    private RabbitTemplate rabbitTemplate;

    /**
     * 构造方法注入
     */
    @Autowired
    public SendMessage(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
        rabbitTemplate.setConfirmCallback(this); //rabbitTemplate如果为单例的话，那回调就是最后设置的内容
    }


    /**
     *
     * @param message 消息
     * @param dest 发送消息路由key
     * @description 向消息中间件发送消息处理结果的消息
     */
    public void sendDirectMsg(String message,String dest) {
        String exchangeDirect = AppConfig.getProperty("supervise.rabbitmq.exchange");
        CorrelationData correlationId = new CorrelationData(UUID.randomUUID().toString());
        rabbitTemplate.convertAndSend(exchangeDirect, dest, message, correlationId);
    }


    /**
     *
     * @param correlationData
     * @param ack
     * @param cause
     * @description 消息回调确认消息是否成功接收
     */
    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        LOGGER.info(" client :" + correlationData);
        if (ack) {
            LOGGER.info("消息发送成功");
        } else {
            LOGGER.info("消息发送失败:"+cause);
        }
    }

    @Override
    public void confirm(CorrelationData correlationData, boolean ack) {

    }
}