package cn.gtmap.realestate.supervise.server.rabbitmq;

import cn.gtmap.realestate.supervise.server.model.RabbitMqNodeInfo;
import cn.gtmap.realestate.supervise.server.model.RabbitMqOverView;
import cn.gtmap.realestate.supervise.server.model.RabbitmqClientQueueInfo;
import cn.gtmap.realestate.supervise.server.model.RabbitmqQueueInfo;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;

/**
 * @author <a href="mailto:Administrator@gtmap.cn">Administrator</a>
 * @version 1.0, 2017/8/3
 * @description
 */
@Service
public class RabbitServerInfo {


    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitServerInfo.class);


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 客户端信息
     */
    @Autowired
    HttpClient httpClient;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param rabbitServerConfig rabbitmq服务器配置信息
     * @param queueName 队列名称
     * @return 消息队列信息
     * @description 获取的消息队列信息封装类
     */
    public RabbitmqQueueInfo getRabbitMqInfo(RabbitServerConfig rabbitServerConfig, String queueName) throws IOException {

        String info = new HttpClientUtils().getConnect(rabbitServerConfig.getQueueInfo(queueName), rabbitServerConfig.getName(), rabbitServerConfig.getPassword());
        LOGGER.info("RabbitmqQueueInfo.getRabbitMqInfo:",info);
        return RabbitmqQueueInfo.getRabbitmqQueueInfo(info);

    }

    /**
     * 监控客户端队列信息
     * @param rabbitServerConfig
     * @param queueName
     * @return
     * @throws IOException
     */
    public RabbitmqClientQueueInfo getRabbitMqClientQueueInfo(RabbitServerConfig rabbitServerConfig, String queueName) throws IOException {
        String info = new HttpClientUtils().getConnect(rabbitServerConfig.getQueueInfo(queueName), rabbitServerConfig.getName(), rabbitServerConfig.getPassword());
        return RabbitmqQueueInfo.getRabbitmqClientQueueInfo(info);
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param rabbitServerConfig rabbitmq配置信息
     * @return 概览数据对象
     * @description 按照配置信息获取概览信息对象
     */
    public RabbitMqOverView getRabbitMqOverView(RabbitServerConfig rabbitServerConfig) throws IOException {

        String info = new HttpClientUtils().getConnect(rabbitServerConfig.getOvrrideInfo(), rabbitServerConfig.getName(), rabbitServerConfig.getPassword());

        return RabbitMqOverView.getRabbitMqOverView(info);

    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param rabbitServerConfig rabbitmq配置信息
     * @param nodeName 节点名称
     * @return 节点信息
     * @description 按照配置信息获取节点信息对象
     */
    public RabbitMqNodeInfo getRabbitMqNodeInfo(RabbitServerConfig rabbitServerConfig, String nodeName) throws IOException {

        String info = new HttpClientUtils().getConnect(rabbitServerConfig.getNodeInfo(nodeName), rabbitServerConfig.getName(), rabbitServerConfig.getPassword());

        return RabbitMqNodeInfo.getRabbitMqNodeInfo(info);

    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param
     * @return rabbtimq 服务器返回信息
     * @description http通信 获取服务器信息
     */
    public class HttpClientUtils {


        private static final String AUTHENKEY = "Authorization";

        private static final String BASICKEY = "Basic ";

        /**
         * 获取链接
         * @param url
         * @param username
         * @param password
         * @return
         * @throws IOException
         */
        public  String  getConnect(String url,String username,String password) throws IOException {

            HttpResponse response = null;
            HttpGet httpGet = new HttpGet(url);
            Base64 token = new Base64();
            String temp = username + ":" + password;
            String authenticationEncoding = token.encodeAsString(temp.getBytes("UTF-8"));

            httpGet.setHeader(AUTHENKEY, BASICKEY + authenticationEncoding);

            String responseContent = "";

            try {
                response = httpClient.execute(httpGet);
            } catch (IOException e) {
                LOGGER.error("--------------------RabbitServerInfo.HttpClientUtils error in!{}", e);
            }

            if (null!=response ) {
                HttpEntity entity = response.getEntity();
                responseContent = EntityUtils.toString(entity, "UTF-8");
            }
            return responseContent;
        }
    }


    /**
     * 获取队列数量和信息
     * @param rabbitServerConfig
     * @param name
     * @param password
     * @return
     */
    public String getQueues(RabbitServerConfig rabbitServerConfig,String name ,String password){

        String info = null;
        try {
            info = new HttpClientUtils().getConnect(rabbitServerConfig.getQueueInfos(), name, password);
        } catch (IOException e) {
            LOGGER.error("IOException:{}", e);
        }
        return info;
    }
}
