package cn.gtmap.realestate.supervise.server.rabbitmq;

/**
 * @author <a href="mailto:Administrator@gtmap.cn">Administrator</a>
 * @version 1.0, 2017/8/15
 * @description
 */
public class RabbitServerConfig {

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 用户名称
     */
    private String name;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 用户密码
     */
    private String password;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 用户IP，HOST信息
     */
    private String address;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 空间信息
     */
    private String virtualHost;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getVirtualHost() {
        return virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param queue 队列名称
     * @return 拼接的url
     * @description 获取拼接的url
     */
    public String getQueueInfo(String queue) {

        StringBuilder url = new StringBuilder("http://");

        if(virtualHost.equals("/")) {
            virtualHost = "%2F";
        }

        url.append(address + "/api/queues/" + virtualHost + "/" + queue );

        String info = url.toString().replace("5672", "15672");

        return info;
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param
     * @return 拼接的url
     * @description 获取拼接的url
     */
    public String getOvrrideInfo() {

        return ("http://" + address + "/api/overview").replace("5672", "15672");

    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param nodeName 节点名称
     * @return 拼接的url
     * @description 获取拼接的url
     */
    public String getNodeInfo(String nodeName) {

        return ("http://" + address + "/api/nodes/" + nodeName).replace("5672", "15672");

    }


    /**
     * 获取队列json串
     * @return
     */
    public String getQueueInfos() {

        return ("http://" + address + "/api/queues").replace("5672", "15672");
    }


}
