package cn.gtmap.realestate.supervise.server.rabbitmq;

import cn.gtmap.realestate.supervise.server.model.RabbitMqNodeInfo;
import cn.gtmap.realestate.supervise.server.model.RabbitMqOverView;
import cn.gtmap.realestate.supervise.server.model.RabbitmqClientQueueInfo;
import cn.gtmap.realestate.supervise.server.model.RabbitmqQueueInfo;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/8/16
 * @description
 */
@Service
public class RabbitMqInfoContain {

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 容器中节点信息
     */
    RabbitMqNodeInfo rabbitMqNodeInfo;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 容器中全局变量信息
     */
    RabbitMqOverView rabbitMqOverView;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 队列信息
     */
    RabbitmqQueueInfo rabbitmqQueueInfo;


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 获取信息将其改成true，防止冲突
     */
    boolean isRead = false;

    public RabbitMqNodeInfo getRabbitMqNodeInfo() {
        return rabbitMqNodeInfo;
    }

    public void setRabbitMqNodeInfo(RabbitMqNodeInfo rabbitMqNodeInfo) {
        this.rabbitMqNodeInfo = rabbitMqNodeInfo;
    }

    public RabbitMqOverView getRabbitMqOverView() {
        return rabbitMqOverView;
    }

    public void setRabbitMqOverView(RabbitMqOverView rabbitMqOverView) {
        this.rabbitMqOverView = rabbitMqOverView;
    }

    public RabbitmqQueueInfo getRabbitmqQueueInfo() {
        return rabbitmqQueueInfo;
    }

    public void setRabbitmqQueueInfo(RabbitmqQueueInfo rabbitmqQueueInfo) {
        this.rabbitmqQueueInfo = rabbitmqQueueInfo;
    }

    public boolean isRead() {
        return isRead;
    }

    public void setRead(boolean read) {
        isRead = read;
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param
     * @return 现在已有的服务器信息数据
     * @description
     */
    public  List<Object> getContainsData() {

        isRead = true;

        List<Object> objects = new ArrayList<Object>();

        objects.add(rabbitMqNodeInfo);

        objects.add(rabbitMqOverView);

        objects.add(rabbitmqQueueInfo);

        isRead = false;

        return objects;

    }
}
