package cn.gtmap.realestate.supervise.server.rabbitmq;

import cn.gtmap.realestate.supervise.server.common.impl.ServerRecMessageServiceImpl;
import com.gtis.config.AppConfig;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/3/23
 * @description 队列配置
 */
@Configuration
@Import(Connection.class)
@Profile(value = "rabbitMQ")
public class QueueConfig {

    @Autowired
    ConnectionFactory connectionFactory;


    /**
     * 针对消费者配置
     * 1. 设置交换机类型
     * 2. 将队列绑定到交换机
     * FanoutExchange: 将消息分发到所有的绑定队列，无routingkey的概念
     * HeadersExchange ：通过添加属性key-value匹配
     * DirectExchange:按照routingkey分发到指定队列
     * TopicExchange:多关键字匹配
     */

    /**
     * @return
     */
    @Bean
    public ServerRecMessageServiceImpl getMyMessageContainer() {
        return new ServerRecMessageServiceImpl();
    }

    /**
     * @return
     */
    @Bean
    public DirectExchange directExchange() {
        String exchangeDirect = AppConfig.getProperty("supervise.rabbitmq.exchange");
        return new DirectExchange(exchangeDirect);
    }

    /**
     * @return
     */
    @Bean
    public Queue direct() {
        String queueServerKey = AppConfig.getProperty("supervise.rabbitmq.queue");
        return new Queue(queueServerKey, true); //队列持久
    }

    /**
     * @return
     */
    @Bean
    public Binding directBinding() {
        String exchangeDirect = AppConfig.getProperty("supervise.rabbitmq.exchange");
        return BindingBuilder.bind(direct()).to(directExchange()).with(exchangeDirect);
    }

    /**
     * @return
     */
    @Bean
    public SimpleMessageListenerContainer messageContainer() {
        MessageListenerContainer container = new MessageListenerContainer(connectionFactory);
        container.setQueues(direct());
        container.setListener(getMyMessageContainer());
        return container;
    }


}